// media/mojo/mojom/webrtc_video_perf.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/webrtc_video_perf.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace media::mojom {
class WebrtcPredictionFeaturesDataView;

class WebrtcVideoStatsDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::WebrtcPredictionFeaturesDataView> {
  using Data = ::media::mojom::internal::WebrtcPredictionFeatures_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::WebrtcVideoStatsDataView> {
  using Data = ::media::mojom::internal::WebrtcVideoStats_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {
// Interface base classes. They are used for type safety check.
class WebrtcVideoPerfRecorderInterfaceBase {};

using WebrtcVideoPerfRecorderPtrDataView =
    mojo::InterfacePtrDataView<WebrtcVideoPerfRecorderInterfaceBase>;
using WebrtcVideoPerfRecorderRequestDataView =
    mojo::InterfaceRequestDataView<WebrtcVideoPerfRecorderInterfaceBase>;
using WebrtcVideoPerfRecorderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebrtcVideoPerfRecorderInterfaceBase>;
using WebrtcVideoPerfRecorderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebrtcVideoPerfRecorderInterfaceBase>;
class WebrtcVideoPerfHistoryInterfaceBase {};

using WebrtcVideoPerfHistoryPtrDataView =
    mojo::InterfacePtrDataView<WebrtcVideoPerfHistoryInterfaceBase>;
using WebrtcVideoPerfHistoryRequestDataView =
    mojo::InterfaceRequestDataView<WebrtcVideoPerfHistoryInterfaceBase>;
using WebrtcVideoPerfHistoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebrtcVideoPerfHistoryInterfaceBase>;
using WebrtcVideoPerfHistoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebrtcVideoPerfHistoryInterfaceBase>;


class WebrtcPredictionFeaturesDataView {
 public:
  WebrtcPredictionFeaturesDataView() = default;

  WebrtcPredictionFeaturesDataView(
      internal::WebrtcPredictionFeatures_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_decode_stats() const {
    return data_->is_decode_stats;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProfile(UserType* output) const {
    auto data_value = data_->profile;
    return mojo::internal::Deserialize<::media::mojom::VideoCodecProfile>(
        data_value, output);
  }
  ::media::mojom::VideoCodecProfile profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCodecProfile>(data_->profile));
  }
  int32_t video_pixels() const {
    return data_->video_pixels;
  }
  bool hardware_accelerated() const {
    return data_->hardware_accelerated;
  }
 private:
  internal::WebrtcPredictionFeatures_Data* data_ = nullptr;
};


class WebrtcVideoStatsDataView {
 public:
  WebrtcVideoStatsDataView() = default;

  WebrtcVideoStatsDataView(
      internal::WebrtcVideoStats_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t frames_processed() const {
    return data_->frames_processed;
  }
  uint32_t key_frames_processed() const {
    return data_->key_frames_processed;
  }
  float p99_processing_time_ms() const {
    return data_->p99_processing_time_ms;
  }
 private:
  internal::WebrtcVideoStats_Data* data_ = nullptr;
};


}  // media::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::WebrtcPredictionFeaturesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::WebrtcPredictionFeaturesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::WebrtcPredictionFeatures_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->is_decode_stats = Traits::is_decode_stats(input);
    mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
        Traits::profile(input), &fragment->profile);
    fragment->video_pixels = Traits::video_pixels(input);
    fragment->hardware_accelerated = Traits::hardware_accelerated(input);
  }

  static bool Deserialize(::media::mojom::internal::WebrtcPredictionFeatures_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::WebrtcPredictionFeaturesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::WebrtcVideoStatsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::WebrtcVideoStatsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::WebrtcVideoStats_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->frames_processed = Traits::frames_processed(input);
    fragment->key_frames_processed = Traits::key_frames_processed(input);
    fragment->p99_processing_time_ms = Traits::p99_processing_time_ms(input);
  }

  static bool Deserialize(::media::mojom::internal::WebrtcVideoStats_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::WebrtcVideoStatsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {






}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_SHARED_H_