// media/mojo/mojom/speech_recognition.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/speech_recognition.mojom-shared-internal.h"
#include "media/mojo/mojom/audio_data.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_audio_forwarder.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_recognition_context.mojom-shared.h"
#include "media/mojo/mojom/speech_recognizer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace media::mojom {
class HypothesisPartsDataView;

class TimingInformationDataView;

class SpeechRecognitionResultDataView;

class LanguageIdentificationEventDataView;

class SpeechRecognitionOptionsDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::HypothesisPartsDataView> {
  using Data = ::media::mojom::internal::HypothesisParts_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::TimingInformationDataView> {
  using Data = ::media::mojom::internal::TimingInformation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::SpeechRecognitionResultDataView> {
  using Data = ::media::mojom::internal::SpeechRecognitionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::LanguageIdentificationEventDataView> {
  using Data = ::media::mojom::internal::LanguageIdentificationEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::SpeechRecognitionOptionsDataView> {
  using Data = ::media::mojom::internal::SpeechRecognitionOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class ConfidenceLevel : int32_t {
  
  kUnknown = 0,
  
  kNotConfident = 1,
  
  kConfident = 2,
  
  kHighlyConfident = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ConfidenceLevel value);
inline bool IsKnownEnumValue(ConfidenceLevel value) {
  return internal::ConfidenceLevel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ConfidenceLevel ToKnownEnumValue(ConfidenceLevel value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ConfidenceLevel::kDefaultValue;
}


enum class AsrSwitchResult : int32_t {
  
  kDefaultNoSwitch = 0,
  
  kSwitchSucceeded = 1,
  
  kSwitchFailed = 2,
  
  kSwitchSkipedNoLp = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, AsrSwitchResult value);
inline bool IsKnownEnumValue(AsrSwitchResult value) {
  return internal::AsrSwitchResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline AsrSwitchResult ToKnownEnumValue(AsrSwitchResult value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return AsrSwitchResult::kDefaultValue;
}


enum class SpeechRecognitionMode : int32_t {
  
  kUnknown = 0,
  
  kIme = 1,
  
  kCaption = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, SpeechRecognitionMode value);
inline bool IsKnownEnumValue(SpeechRecognitionMode value) {
  return internal::SpeechRecognitionMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline SpeechRecognitionMode ToKnownEnumValue(SpeechRecognitionMode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return SpeechRecognitionMode::kDefaultValue;
}


enum class RecognizerClientType : int32_t {
  
  kUnknown = 0,
  
  kDictation = 1,
  
  kLiveCaption = 2,
  
  kProjector = 3,
  
  kCastModerator = 4,
  kMinValue = 0,
  kMaxValue = 4,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, RecognizerClientType value);
inline bool IsKnownEnumValue(RecognizerClientType value) {
  return internal::RecognizerClientType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline RecognizerClientType ToKnownEnumValue(RecognizerClientType value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return RecognizerClientType::kDefaultValue;
}
// Interface base classes. They are used for type safety check.
class SpeechRecognitionContextInterfaceBase {};

using SpeechRecognitionContextPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionContextInterfaceBase>;
using SpeechRecognitionContextRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionContextInterfaceBase>;
using SpeechRecognitionContextAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionContextInterfaceBase>;
using SpeechRecognitionContextAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionContextInterfaceBase>;
class SpeechRecognitionRecognizerInterfaceBase {};

using SpeechRecognitionRecognizerPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionRecognizerInterfaceBase>;
using SpeechRecognitionRecognizerRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionRecognizerInterfaceBase>;
using SpeechRecognitionRecognizerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionRecognizerInterfaceBase>;
using SpeechRecognitionRecognizerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionRecognizerInterfaceBase>;
class SpeechRecognitionRecognizerClientInterfaceBase {};

using SpeechRecognitionRecognizerClientPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionRecognizerClientInterfaceBase>;
using SpeechRecognitionRecognizerClientRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionRecognizerClientInterfaceBase>;
using SpeechRecognitionRecognizerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionRecognizerClientInterfaceBase>;
using SpeechRecognitionRecognizerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionRecognizerClientInterfaceBase>;
class SpeechRecognitionBrowserObserverInterfaceBase {};

using SpeechRecognitionBrowserObserverPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionBrowserObserverInterfaceBase>;
using SpeechRecognitionBrowserObserverRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionBrowserObserverInterfaceBase>;
using SpeechRecognitionBrowserObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionBrowserObserverInterfaceBase>;
using SpeechRecognitionBrowserObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionBrowserObserverInterfaceBase>;
class SpeechRecognitionSurfaceInterfaceBase {};

using SpeechRecognitionSurfacePtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionSurfaceInterfaceBase>;
using SpeechRecognitionSurfaceRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionSurfaceInterfaceBase>;
using SpeechRecognitionSurfaceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionSurfaceInterfaceBase>;
using SpeechRecognitionSurfaceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionSurfaceInterfaceBase>;
class SpeechRecognitionSurfaceClientInterfaceBase {};

using SpeechRecognitionSurfaceClientPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionSurfaceClientInterfaceBase>;
using SpeechRecognitionSurfaceClientRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionSurfaceClientInterfaceBase>;
using SpeechRecognitionSurfaceClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionSurfaceClientInterfaceBase>;
using SpeechRecognitionSurfaceClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionSurfaceClientInterfaceBase>;
class SpeechRecognitionClientBrowserInterfaceInterfaceBase {};

using SpeechRecognitionClientBrowserInterfacePtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionClientBrowserInterfaceInterfaceBase>;
using SpeechRecognitionClientBrowserInterfaceRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionClientBrowserInterfaceInterfaceBase>;
using SpeechRecognitionClientBrowserInterfaceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionClientBrowserInterfaceInterfaceBase>;
using SpeechRecognitionClientBrowserInterfaceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionClientBrowserInterfaceInterfaceBase>;


class HypothesisPartsDataView {
 public:
  HypothesisPartsDataView() = default;

  HypothesisPartsDataView(
      internal::HypothesisParts_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetHypothesisPartOffsetDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHypothesisPartOffset(UserType* output) {
    
    auto* pointer = data_->hypothesis_part_offset.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::HypothesisParts_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TimingInformationDataView {
 public:
  TimingInformationDataView() = default;

  TimingInformationDataView(
      internal::TimingInformation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAudioStartTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioStartTime(UserType* output) {
    
    auto* pointer = data_->audio_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetAudioEndTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioEndTime(UserType* output) {
    
    auto* pointer = data_->audio_end_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetHypothesisPartsDataView(
      mojo::ArrayDataView<HypothesisPartsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHypothesisParts(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::media::mojom::HypothesisPartsDataView>, UserType>(),
    "Attempting to read the optional `hypothesis_parts` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHypothesisParts` instead "
    "of `ReadHypothesisParts if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hypothesis_parts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::HypothesisPartsDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TimingInformation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SpeechRecognitionResultDataView {
 public:
  SpeechRecognitionResultDataView() = default;

  SpeechRecognitionResultDataView(
      internal::SpeechRecognitionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTranscriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTranscription(UserType* output) {
    
    auto* pointer = data_->transcription.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_final() const {
    return data_->is_final;
  }
  inline void GetTimingInformationDataView(
      TimingInformationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimingInformation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::TimingInformationDataView, UserType>(),
    "Attempting to read the optional `timing_information` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimingInformation` instead "
    "of `ReadTimingInformation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->timing_information.Get();
    return mojo::internal::Deserialize<::media::mojom::TimingInformationDataView>(
        pointer, output, message_);
  }
 private:
  internal::SpeechRecognitionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LanguageIdentificationEventDataView {
 public:
  LanguageIdentificationEventDataView() = default;

  LanguageIdentificationEventDataView(
      internal::LanguageIdentificationEvent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage(UserType* output) {
    
    auto* pointer = data_->language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadConfidenceLevel(UserType* output) const {
    auto data_value = data_->confidence_level;
    return mojo::internal::Deserialize<::media::mojom::ConfidenceLevel>(
        data_value, output);
  }
  ConfidenceLevel confidence_level() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::ConfidenceLevel>(data_->confidence_level));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAsrSwitchResult(UserType* output) const {
    if (data_->header_.version < 1) {
      *output = std::nullopt;
      return true;
    }
    if (!data_->asr_switch_result_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::media::mojom::AsrSwitchResult>(
        data_->asr_switch_result_$value, &output->emplace());
  }
  std::optional<AsrSwitchResult> asr_switch_result() const {
    if (data_->header_.version < 1) {
      return std::nullopt;
    }
    if (!data_->asr_switch_result_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AsrSwitchResult>(data_->asr_switch_result_$value));
  }
 private:
  internal::LanguageIdentificationEvent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SpeechRecognitionOptionsDataView {
 public:
  SpeechRecognitionOptionsDataView() = default;

  SpeechRecognitionOptionsDataView(
      internal::SpeechRecognitionOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadRecognitionMode(UserType* output) const {
    auto data_value = data_->recognition_mode;
    return mojo::internal::Deserialize<::media::mojom::SpeechRecognitionMode>(
        data_value, output);
  }
  SpeechRecognitionMode recognition_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::SpeechRecognitionMode>(data_->recognition_mode));
  }
  bool enable_formatting() const {
    return data_->enable_formatting;
  }
  inline void GetLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `language` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLanguage` instead "
    "of `ReadLanguage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_server_based() const {
    if (data_->header_.version < 1)
      return bool{};
    return data_->is_server_based;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRecognizerClientType(UserType* output) const {
    auto data_value = data_->header_.version >= 1
                      ? data_->recognizer_client_type : 0;
    return mojo::internal::Deserialize<::media::mojom::RecognizerClientType>(
        data_value, output);
  }
  RecognizerClientType recognizer_client_type() const {
    if (data_->header_.version < 1)
      return RecognizerClientType{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::RecognizerClientType>(data_->recognizer_client_type));
  }
  bool skip_continuously_empty_audio() const {
    if (data_->header_.version < 4)
      return bool{};
    return data_->skip_continuously_empty_audio;
  }
  inline void GetExperimentRecognizerRoutingKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExperimentRecognizerRoutingKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `experiment_recognizer_routing_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExperimentRecognizerRoutingKey` instead "
    "of `ReadExperimentRecognizerRoutingKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 5
                    ? data_->experiment_recognizer_routing_key.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t channel_count() const {
    if (data_->header_.version < 6)
      return int32_t{};
    return data_->channel_count;
  }
  int32_t sample_rate() const {
    if (data_->header_.version < 6)
      return int32_t{};
    return data_->sample_rate;
  }
  inline void GetRecognitionContextDataView(
      ::media::mojom::SpeechRecognitionRecognitionContextDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecognitionContext(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::SpeechRecognitionRecognitionContextDataView, UserType>(),
    "Attempting to read the optional `recognition_context` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRecognitionContext` instead "
    "of `ReadRecognitionContext if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 8
                    ? data_->recognition_context.Get() : nullptr;
    return mojo::internal::Deserialize<::media::mojom::SpeechRecognitionRecognitionContextDataView>(
        pointer, output, message_);
  }
 private:
  internal::SpeechRecognitionOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

namespace std {

template <>
struct hash<::media::mojom::ConfidenceLevel>
    : public mojo::internal::EnumHashImpl<::media::mojom::ConfidenceLevel> {};

template <>
struct hash<::media::mojom::AsrSwitchResult>
    : public mojo::internal::EnumHashImpl<::media::mojom::AsrSwitchResult> {};

template <>
struct hash<::media::mojom::SpeechRecognitionMode>
    : public mojo::internal::EnumHashImpl<::media::mojom::SpeechRecognitionMode> {};

template <>
struct hash<::media::mojom::RecognizerClientType>
    : public mojo::internal::EnumHashImpl<::media::mojom::RecognizerClientType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::ConfidenceLevel, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::ConfidenceLevel, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::ConfidenceLevel>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AsrSwitchResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::AsrSwitchResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::AsrSwitchResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SpeechRecognitionMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::SpeechRecognitionMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::SpeechRecognitionMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::RecognizerClientType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::RecognizerClientType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::RecognizerClientType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::HypothesisPartsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::HypothesisPartsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::HypothesisParts_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType>
        text_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_text, text_fragment, &text_validate_params);
    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text in HypothesisParts struct");
    decltype(Traits::hypothesis_part_offset(input)) in_hypothesis_part_offset = Traits::hypothesis_part_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hypothesis_part_offset)::BaseType> hypothesis_part_offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_hypothesis_part_offset, hypothesis_part_offset_fragment);
    fragment->hypothesis_part_offset.Set(
        hypothesis_part_offset_fragment.is_null() ? nullptr : hypothesis_part_offset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->hypothesis_part_offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hypothesis_part_offset in HypothesisParts struct");
  }

  static bool Deserialize(::media::mojom::internal::HypothesisParts_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::HypothesisPartsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::TimingInformationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::TimingInformationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::TimingInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::audio_start_time(input)) in_audio_start_time = Traits::audio_start_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->audio_start_time)::BaseType> audio_start_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_audio_start_time, audio_start_time_fragment);
    fragment->audio_start_time.Set(
        audio_start_time_fragment.is_null() ? nullptr : audio_start_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->audio_start_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null audio_start_time in TimingInformation struct");
    decltype(Traits::audio_end_time(input)) in_audio_end_time = Traits::audio_end_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->audio_end_time)::BaseType> audio_end_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_audio_end_time, audio_end_time_fragment);
    fragment->audio_end_time.Set(
        audio_end_time_fragment.is_null() ? nullptr : audio_end_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->audio_end_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null audio_end_time in TimingInformation struct");
    decltype(Traits::hypothesis_parts(input)) in_hypothesis_parts = Traits::hypothesis_parts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hypothesis_parts)::BaseType>
        hypothesis_parts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& hypothesis_parts_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::HypothesisPartsDataView>>(
        in_hypothesis_parts, hypothesis_parts_fragment, &hypothesis_parts_validate_params);
    fragment->hypothesis_parts.Set(
        hypothesis_parts_fragment.is_null() ? nullptr : hypothesis_parts_fragment.data());
  }

  static bool Deserialize(::media::mojom::internal::TimingInformation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::TimingInformationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SpeechRecognitionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SpeechRecognitionResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SpeechRecognitionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::transcription(input)) in_transcription = Traits::transcription(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transcription)::BaseType> transcription_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_transcription, transcription_fragment);
    fragment->transcription.Set(
        transcription_fragment.is_null() ? nullptr : transcription_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->transcription.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transcription in SpeechRecognitionResult struct");
    fragment->is_final = Traits::is_final(input);
    decltype(Traits::timing_information(input)) in_timing_information = Traits::timing_information(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timing_information)::BaseType> timing_information_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::TimingInformationDataView>(
        in_timing_information, timing_information_fragment);
    fragment->timing_information.Set(
        timing_information_fragment.is_null() ? nullptr : timing_information_fragment.data());
  }

  static bool Deserialize(::media::mojom::internal::SpeechRecognitionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::SpeechRecognitionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::LanguageIdentificationEventDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::LanguageIdentificationEventDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::LanguageIdentificationEvent_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::language(input)) in_language = Traits::language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->language)::BaseType> language_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_language, language_fragment);
    fragment->language.Set(
        language_fragment.is_null() ? nullptr : language_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->language.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null language in LanguageIdentificationEvent struct");
    mojo::internal::Serialize<::media::mojom::ConfidenceLevel>(
        Traits::confidence_level(input), &fragment->confidence_level);
    fragment->asr_switch_result_$flag = Traits::asr_switch_result(input).has_value();
    if (Traits::asr_switch_result(input).has_value()) {
      mojo::internal::Serialize<::media::mojom::AsrSwitchResult>(
          Traits::asr_switch_result(input).value(), &fragment->asr_switch_result_$value);
    } else {
      fragment->asr_switch_result_$value =
          static_cast<int32_t>(::media::mojom::AsrSwitchResult::kMinValue);
    }
  }

  static bool Deserialize(::media::mojom::internal::LanguageIdentificationEvent_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::LanguageIdentificationEventDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SpeechRecognitionOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SpeechRecognitionOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SpeechRecognitionOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::media::mojom::SpeechRecognitionMode>(
        Traits::recognition_mode(input), &fragment->recognition_mode);
    fragment->enable_formatting = Traits::enable_formatting(input);
    decltype(Traits::language(input)) in_language = Traits::language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->language)::BaseType> language_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_language, language_fragment);
    fragment->language.Set(
        language_fragment.is_null() ? nullptr : language_fragment.data());
    fragment->is_server_based = Traits::is_server_based(input);
    mojo::internal::Serialize<::media::mojom::RecognizerClientType>(
        Traits::recognizer_client_type(input), &fragment->recognizer_client_type);
    fragment->skip_continuously_empty_audio = Traits::skip_continuously_empty_audio(input);
    decltype(Traits::experiment_recognizer_routing_key(input)) in_experiment_recognizer_routing_key = Traits::experiment_recognizer_routing_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->experiment_recognizer_routing_key)::BaseType> experiment_recognizer_routing_key_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_experiment_recognizer_routing_key, experiment_recognizer_routing_key_fragment);
    fragment->experiment_recognizer_routing_key.Set(
        experiment_recognizer_routing_key_fragment.is_null() ? nullptr : experiment_recognizer_routing_key_fragment.data());
    fragment->channel_count = Traits::channel_count(input);
    fragment->sample_rate = Traits::sample_rate(input);
    decltype(Traits::recognition_context(input)) in_recognition_context = Traits::recognition_context(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recognition_context)::BaseType> recognition_context_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::SpeechRecognitionRecognitionContextDataView>(
        in_recognition_context, recognition_context_fragment);
    fragment->recognition_context.Set(
        recognition_context_fragment.is_null() ? nullptr : recognition_context_fragment.data());
  }

  static bool Deserialize(::media::mojom::internal::SpeechRecognitionOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::SpeechRecognitionOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {

inline void HypothesisPartsDataView::GetTextDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->text.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void HypothesisPartsDataView::GetHypothesisPartOffsetDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->hypothesis_part_offset.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void TimingInformationDataView::GetAudioStartTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->audio_start_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void TimingInformationDataView::GetAudioEndTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->audio_end_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void TimingInformationDataView::GetHypothesisPartsDataView(
    mojo::ArrayDataView<HypothesisPartsDataView>* output) {
  auto pointer = data_->hypothesis_parts.Get();
  *output = mojo::ArrayDataView<HypothesisPartsDataView>(pointer, message_);
}


inline void SpeechRecognitionResultDataView::GetTranscriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->transcription.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SpeechRecognitionResultDataView::GetTimingInformationDataView(
    TimingInformationDataView* output) {
  auto pointer = data_->timing_information.Get();
  *output = TimingInformationDataView(pointer, message_);
}


inline void LanguageIdentificationEventDataView::GetLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->language.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SpeechRecognitionOptionsDataView::GetLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->language.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SpeechRecognitionOptionsDataView::GetExperimentRecognizerRoutingKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->header_.version >= 5
                 ? data_->experiment_recognizer_routing_key.Get() : nullptr;
  *output = mojo::StringDataView(pointer, message_);
}
inline void SpeechRecognitionOptionsDataView::GetRecognitionContextDataView(
    ::media::mojom::SpeechRecognitionRecognitionContextDataView* output) {
  auto pointer = data_->header_.version >= 8
                 ? data_->recognition_context.Get() : nullptr;
  *output = ::media::mojom::SpeechRecognitionRecognitionContextDataView(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::ConfidenceLevel> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::ConfidenceLevel value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::AsrSwitchResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::AsrSwitchResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::SpeechRecognitionMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::SpeechRecognitionMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::RecognizerClientType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::RecognizerClientType value);
};

} // namespace perfetto

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_MOJOM_SHARED_H_