// media/mojo/mojom/frame_interface_factory.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/frame_interface_factory.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/frame_interface_factory.mojom-params-data.h"
#include "media/mojo/mojom/frame_interface_factory.mojom-shared-message-ids.h"

#include "media/mojo/mojom/frame_interface_factory.mojom-blink-import-headers.h"
#include "media/mojo/mojom/frame_interface_factory.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
const char FrameInterfaceFactory::Name_[] = "media.mojom.FrameInterfaceFactory";

FrameInterfaceFactory::IPCStableHashFunction FrameInterfaceFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameInterfaceFactory>(message.name())) {
    case messages::FrameInterfaceFactory::kCreateProvisionFetcher: {
      return &FrameInterfaceFactory::CreateProvisionFetcher_Sym::IPCStableHash;
    }
    case messages::FrameInterfaceFactory::kCreateCdmStorage: {
      return &FrameInterfaceFactory::CreateCdmStorage_Sym::IPCStableHash;
    }
    case messages::FrameInterfaceFactory::kGetCdmOrigin: {
      return &FrameInterfaceFactory::GetCdmOrigin_Sym::IPCStableHash;
    }
    case messages::FrameInterfaceFactory::kGetPageUkmSourceId: {
      return &FrameInterfaceFactory::GetPageUkmSourceId_Sym::IPCStableHash;
    }
    case messages::FrameInterfaceFactory::kBindEmbedderReceiver: {
      return &FrameInterfaceFactory::BindEmbedderReceiver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameInterfaceFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameInterfaceFactory>(message.name())) {
      case messages::FrameInterfaceFactory::kCreateProvisionFetcher:
            return "Receive media::mojom::FrameInterfaceFactory::CreateProvisionFetcher";
      case messages::FrameInterfaceFactory::kCreateCdmStorage:
            return "Receive media::mojom::FrameInterfaceFactory::CreateCdmStorage";
      case messages::FrameInterfaceFactory::kGetCdmOrigin:
            return "Receive media::mojom::FrameInterfaceFactory::GetCdmOrigin";
      case messages::FrameInterfaceFactory::kGetPageUkmSourceId:
            return "Receive media::mojom::FrameInterfaceFactory::GetPageUkmSourceId";
      case messages::FrameInterfaceFactory::kBindEmbedderReceiver:
            return "Receive media::mojom::FrameInterfaceFactory::BindEmbedderReceiver";
    }
  } else {
    switch (static_cast<messages::FrameInterfaceFactory>(message.name())) {
      case messages::FrameInterfaceFactory::kCreateProvisionFetcher:
            return "Receive reply media::mojom::FrameInterfaceFactory::CreateProvisionFetcher";
      case messages::FrameInterfaceFactory::kCreateCdmStorage:
            return "Receive reply media::mojom::FrameInterfaceFactory::CreateCdmStorage";
      case messages::FrameInterfaceFactory::kGetCdmOrigin:
            return "Receive reply media::mojom::FrameInterfaceFactory::GetCdmOrigin";
      case messages::FrameInterfaceFactory::kGetPageUkmSourceId:
            return "Receive reply media::mojom::FrameInterfaceFactory::GetPageUkmSourceId";
      case messages::FrameInterfaceFactory::kBindEmbedderReceiver:
            return "Receive reply media::mojom::FrameInterfaceFactory::BindEmbedderReceiver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameInterfaceFactory::CreateProvisionFetcher_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::FrameInterfaceFactory::CreateProvisionFetcher");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameInterfaceFactory::CreateCdmStorage_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::FrameInterfaceFactory::CreateCdmStorage");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameInterfaceFactory::GetCdmOrigin_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::FrameInterfaceFactory::GetCdmOrigin");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameInterfaceFactory::GetPageUkmSourceId_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::FrameInterfaceFactory::GetPageUkmSourceId");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameInterfaceFactory::BindEmbedderReceiver_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::FrameInterfaceFactory::BindEmbedderReceiver");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool FrameInterfaceFactory::GetCdmOrigin(::scoped_refptr<const ::blink::SecurityOrigin>* out_cdm_origin) {
  NOTREACHED();
}
bool FrameInterfaceFactory::GetPageUkmSourceId(int64_t* out_ukm_source_id) {
  NOTREACHED();
}
class FrameInterfaceFactory_GetCdmOrigin_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameInterfaceFactory_GetCdmOrigin_HandleSyncResponse(
      bool* result, ::scoped_refptr<const ::blink::SecurityOrigin>* out_cdm_origin)
      : result_(result), out_cdm_origin_(out_cdm_origin) {
    DCHECK(!*result_);
  }

  FrameInterfaceFactory_GetCdmOrigin_HandleSyncResponse(const FrameInterfaceFactory_GetCdmOrigin_HandleSyncResponse&) = delete;
  FrameInterfaceFactory_GetCdmOrigin_HandleSyncResponse& operator=(const FrameInterfaceFactory_GetCdmOrigin_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::scoped_refptr<const ::blink::SecurityOrigin>* out_cdm_origin_;};

class FrameInterfaceFactory_GetCdmOrigin_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameInterfaceFactory_GetCdmOrigin_ForwardToCallback(
      FrameInterfaceFactory::GetCdmOriginCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameInterfaceFactory_GetCdmOrigin_ForwardToCallback(const FrameInterfaceFactory_GetCdmOrigin_ForwardToCallback&) = delete;
  FrameInterfaceFactory_GetCdmOrigin_ForwardToCallback& operator=(const FrameInterfaceFactory_GetCdmOrigin_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameInterfaceFactory::GetCdmOriginCallback callback_;
};
class FrameInterfaceFactory_GetPageUkmSourceId_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameInterfaceFactory_GetPageUkmSourceId_HandleSyncResponse(
      bool* result, int64_t* out_ukm_source_id)
      : result_(result), out_ukm_source_id_(out_ukm_source_id) {
    DCHECK(!*result_);
  }

  FrameInterfaceFactory_GetPageUkmSourceId_HandleSyncResponse(const FrameInterfaceFactory_GetPageUkmSourceId_HandleSyncResponse&) = delete;
  FrameInterfaceFactory_GetPageUkmSourceId_HandleSyncResponse& operator=(const FrameInterfaceFactory_GetPageUkmSourceId_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int64_t* out_ukm_source_id_;};

class FrameInterfaceFactory_GetPageUkmSourceId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameInterfaceFactory_GetPageUkmSourceId_ForwardToCallback(
      FrameInterfaceFactory::GetPageUkmSourceIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameInterfaceFactory_GetPageUkmSourceId_ForwardToCallback(const FrameInterfaceFactory_GetPageUkmSourceId_ForwardToCallback&) = delete;
  FrameInterfaceFactory_GetPageUkmSourceId_ForwardToCallback& operator=(const FrameInterfaceFactory_GetPageUkmSourceId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameInterfaceFactory::GetPageUkmSourceIdCallback callback_;
};

FrameInterfaceFactoryProxy::FrameInterfaceFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameInterfaceFactoryProxy::CreateProvisionFetcher(
    ::mojo::PendingReceiver<::media::mojom::blink::ProvisionFetcher> in_provision_fetcher) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::FrameInterfaceFactory::CreateProvisionFetcher", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("provision_fetcher"), in_provision_fetcher,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::blink::ProvisionFetcher>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameInterfaceFactory::kCreateProvisionFetcher), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::FrameInterfaceFactory_CreateProvisionFetcher_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::ProvisionFetcherInterfaceBase>>(
      in_provision_fetcher, &params->provision_fetcher, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->provision_fetcher),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid provision_fetcher in FrameInterfaceFactory.CreateProvisionFetcher request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("CreateProvisionFetcher");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameInterfaceFactoryProxy::CreateCdmStorage(
    ::mojo::PendingReceiver<::media::mojom::blink::CdmStorage> in_cdm_storage) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::FrameInterfaceFactory::CreateCdmStorage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_storage"), in_cdm_storage,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::blink::CdmStorage>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameInterfaceFactory::kCreateCdmStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::FrameInterfaceFactory_CreateCdmStorage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::CdmStorageInterfaceBase>>(
      in_cdm_storage, &params->cdm_storage, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->cdm_storage),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid cdm_storage in FrameInterfaceFactory.CreateCdmStorage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("CreateCdmStorage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool FrameInterfaceFactoryProxy::GetCdmOrigin(
    ::scoped_refptr<const ::blink::SecurityOrigin>* out_param_cdm_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call media::mojom::FrameInterfaceFactory::GetCdmOrigin (sync)");
#else
  TRACE_EVENT0("mojom", "FrameInterfaceFactory::GetCdmOrigin");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameInterfaceFactory::kGetCdmOrigin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::FrameInterfaceFactory_GetCdmOrigin_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("GetCdmOrigin");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameInterfaceFactory_GetCdmOrigin_HandleSyncResponse(
          &result, out_param_cdm_origin));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FrameInterfaceFactory::GetCdmOrigin", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_origin"), out_param_cdm_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
   });
#endif
  return result;
}

void FrameInterfaceFactoryProxy::GetCdmOrigin(
    GetCdmOriginCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::FrameInterfaceFactory::GetCdmOrigin");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameInterfaceFactory::kGetCdmOrigin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::FrameInterfaceFactory_GetCdmOrigin_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("GetCdmOrigin");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameInterfaceFactory_GetCdmOrigin_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FrameInterfaceFactoryProxy::GetPageUkmSourceId(
    int64_t* out_param_ukm_source_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call media::mojom::FrameInterfaceFactory::GetPageUkmSourceId (sync)");
#else
  TRACE_EVENT0("mojom", "FrameInterfaceFactory::GetPageUkmSourceId");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameInterfaceFactory::kGetPageUkmSourceId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::FrameInterfaceFactory_GetPageUkmSourceId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("GetPageUkmSourceId");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameInterfaceFactory_GetPageUkmSourceId_HandleSyncResponse(
          &result, out_param_ukm_source_id));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FrameInterfaceFactory::GetPageUkmSourceId", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ukm_source_id"), out_param_ukm_source_id,
                        "<value of type int64_t>");
   });
#endif
  return result;
}

void FrameInterfaceFactoryProxy::GetPageUkmSourceId(
    GetPageUkmSourceIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::FrameInterfaceFactory::GetPageUkmSourceId");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameInterfaceFactory::kGetPageUkmSourceId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::FrameInterfaceFactory_GetPageUkmSourceId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("GetPageUkmSourceId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameInterfaceFactory_GetPageUkmSourceId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameInterfaceFactoryProxy::BindEmbedderReceiver(
    ::mojo::GenericPendingReceiver in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::FrameInterfaceFactory::BindEmbedderReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::GenericPendingReceiver>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameInterfaceFactory::kBindEmbedderReceiver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::FrameInterfaceFactory_BindEmbedderReceiver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->receiver)::BaseType> receiver_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::GenericPendingReceiverDataView>(
      in_receiver, receiver_fragment);
  params->receiver.Set(
      receiver_fragment.is_null() ? nullptr : receiver_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->receiver.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null receiver in FrameInterfaceFactory.BindEmbedderReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("BindEmbedderReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameInterfaceFactory::GetCdmOriginCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder> proxy(
        new FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameInterfaceFactory::GetCdmOriginCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& in_cdm_origin);
};

bool FrameInterfaceFactory_GetCdmOrigin_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameInterfaceFactory_GetCdmOrigin_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameInterfaceFactory_GetCdmOrigin_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for FrameInterfaceFactory.2
  bool success = true;
  ::scoped_refptr<const ::blink::SecurityOrigin> p_cdm_origin{};
  FrameInterfaceFactory_GetCdmOrigin_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCdmOrigin(&p_cdm_origin))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameInterfaceFactory::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cdm_origin));
  return true;
}

void FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder::Run(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_cdm_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::FrameInterfaceFactory::GetCdmOrigin", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_origin"), in_cdm_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameInterfaceFactory::kGetCdmOrigin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::FrameInterfaceFactory_GetCdmOrigin_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_origin)::BaseType> cdm_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_cdm_origin, cdm_origin_fragment);
  params->cdm_origin.Set(
      cdm_origin_fragment.is_null() ? nullptr : cdm_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cdm_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cdm_origin in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("GetCdmOrigin");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameInterfaceFactory_GetCdmOrigin_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameInterfaceFactory_GetCdmOrigin_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameInterfaceFactory_GetCdmOrigin_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for FrameInterfaceFactory.2
  bool success = true;
  ::scoped_refptr<const ::blink::SecurityOrigin> p_cdm_origin{};
  FrameInterfaceFactory_GetCdmOrigin_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCdmOrigin(&p_cdm_origin))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameInterfaceFactory::Name_, 2, true);
    return false;
  }
  *out_cdm_origin_ = std::move(p_cdm_origin);
  *result_ = true;
  return true;
}
class FrameInterfaceFactory_GetPageUkmSourceId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameInterfaceFactory::GetPageUkmSourceIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameInterfaceFactory_GetPageUkmSourceId_ProxyToResponder> proxy(
        new FrameInterfaceFactory_GetPageUkmSourceId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameInterfaceFactory_GetPageUkmSourceId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameInterfaceFactory_GetPageUkmSourceId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameInterfaceFactory_GetPageUkmSourceId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameInterfaceFactory::GetPageUkmSourceIdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_ukm_source_id);
};

bool FrameInterfaceFactory_GetPageUkmSourceId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameInterfaceFactory_GetPageUkmSourceId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameInterfaceFactory_GetPageUkmSourceId_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for FrameInterfaceFactory.3
  bool success = true;
  int64_t p_ukm_source_id{};
  FrameInterfaceFactory_GetPageUkmSourceId_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_ukm_source_id = input_data_view.ukm_source_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameInterfaceFactory::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_ukm_source_id));
  return true;
}

void FrameInterfaceFactory_GetPageUkmSourceId_ProxyToResponder::Run(
    int64_t in_ukm_source_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::FrameInterfaceFactory::GetPageUkmSourceId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ukm_source_id"), in_ukm_source_id,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameInterfaceFactory::kGetPageUkmSourceId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::FrameInterfaceFactory_GetPageUkmSourceId_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->ukm_source_id = in_ukm_source_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("GetPageUkmSourceId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameInterfaceFactory_GetPageUkmSourceId_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameInterfaceFactory_GetPageUkmSourceId_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameInterfaceFactory_GetPageUkmSourceId_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for FrameInterfaceFactory.3
  bool success = true;
  int64_t p_ukm_source_id{};
  FrameInterfaceFactory_GetPageUkmSourceId_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_ukm_source_id = input_data_view.ukm_source_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameInterfaceFactory::Name_, 3, true);
    return false;
  }
  *out_ukm_source_id_ = std::move(p_ukm_source_id);
  *result_ = true;
  return true;
}

// static
bool FrameInterfaceFactoryStubDispatch::Accept(
    FrameInterfaceFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameInterfaceFactory>(message->header()->name)) {
    case messages::FrameInterfaceFactory::kCreateProvisionFetcher: {
      DCHECK(message->is_serialized());
      internal::FrameInterfaceFactory_CreateProvisionFetcher_Params_Data* params =
          reinterpret_cast<internal::FrameInterfaceFactory_CreateProvisionFetcher_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameInterfaceFactory.0
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::blink::ProvisionFetcher> p_provision_fetcher{};
      FrameInterfaceFactory_CreateProvisionFetcher_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_provision_fetcher =
            input_data_view.TakeProvisionFetcher<decltype(p_provision_fetcher)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameInterfaceFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateProvisionFetcher(        
        std::move(p_provision_fetcher));
      return true;
    }
    case messages::FrameInterfaceFactory::kCreateCdmStorage: {
      DCHECK(message->is_serialized());
      internal::FrameInterfaceFactory_CreateCdmStorage_Params_Data* params =
          reinterpret_cast<internal::FrameInterfaceFactory_CreateCdmStorage_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameInterfaceFactory.1
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::blink::CdmStorage> p_cdm_storage{};
      FrameInterfaceFactory_CreateCdmStorage_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_cdm_storage =
            input_data_view.TakeCdmStorage<decltype(p_cdm_storage)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameInterfaceFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCdmStorage(        
        std::move(p_cdm_storage));
      return true;
    }
    case messages::FrameInterfaceFactory::kGetCdmOrigin: {
      break;
    }
    case messages::FrameInterfaceFactory::kGetPageUkmSourceId: {
      break;
    }
    case messages::FrameInterfaceFactory::kBindEmbedderReceiver: {
      DCHECK(message->is_serialized());
      internal::FrameInterfaceFactory_BindEmbedderReceiver_Params_Data* params =
          reinterpret_cast<internal::FrameInterfaceFactory_BindEmbedderReceiver_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameInterfaceFactory.4
      bool success = true;
      ::mojo::GenericPendingReceiver p_receiver{};
      FrameInterfaceFactory_BindEmbedderReceiver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReceiver(&p_receiver))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameInterfaceFactory::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindEmbedderReceiver(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool FrameInterfaceFactoryStubDispatch::AcceptWithResponder(
    FrameInterfaceFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameInterfaceFactory>(message->header()->name)) {
    case messages::FrameInterfaceFactory::kCreateProvisionFetcher: {
      break;
    }
    case messages::FrameInterfaceFactory::kCreateCdmStorage: {
      break;
    }
    case messages::FrameInterfaceFactory::kGetCdmOrigin: {
      internal::FrameInterfaceFactory_GetCdmOrigin_Params_Data* params =
          reinterpret_cast<
              internal::FrameInterfaceFactory_GetCdmOrigin_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for FrameInterfaceFactory.2
      bool success = true;
      FrameInterfaceFactory_GetCdmOrigin_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameInterfaceFactory::Name_, 2, false);
        return false;
      }
      FrameInterfaceFactory::GetCdmOriginCallback callback =
          FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCdmOrigin(std::move(callback));
      return true;
    }
    case messages::FrameInterfaceFactory::kGetPageUkmSourceId: {
      internal::FrameInterfaceFactory_GetPageUkmSourceId_Params_Data* params =
          reinterpret_cast<
              internal::FrameInterfaceFactory_GetPageUkmSourceId_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for FrameInterfaceFactory.3
      bool success = true;
      FrameInterfaceFactory_GetPageUkmSourceId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameInterfaceFactory::Name_, 3, false);
        return false;
      }
      FrameInterfaceFactory::GetPageUkmSourceIdCallback callback =
          FrameInterfaceFactory_GetPageUkmSourceId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPageUkmSourceId(std::move(callback));
      return true;
    }
    case messages::FrameInterfaceFactory::kBindEmbedderReceiver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameInterfaceFactoryValidationInfo[] = {
    {base::to_underlying(messages::FrameInterfaceFactory::kCreateProvisionFetcher),
     { &internal::FrameInterfaceFactory_CreateProvisionFetcher_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameInterfaceFactory::kCreateCdmStorage),
     { &internal::FrameInterfaceFactory_CreateCdmStorage_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameInterfaceFactory::kGetCdmOrigin),
     { &internal::FrameInterfaceFactory_GetCdmOrigin_Params_Data::Validate,
      &internal::FrameInterfaceFactory_GetCdmOrigin_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::FrameInterfaceFactory::kGetPageUkmSourceId),
     { &internal::FrameInterfaceFactory_GetPageUkmSourceId_Params_Data::Validate,
      &internal::FrameInterfaceFactory_GetPageUkmSourceId_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::FrameInterfaceFactory::kBindEmbedderReceiver),
     { &internal::FrameInterfaceFactory_BindEmbedderReceiver_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameInterfaceFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::FrameInterfaceFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameInterfaceFactoryValidationInfo);
}

bool FrameInterfaceFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::FrameInterfaceFactory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kFrameInterfaceFactoryValidationInfo);

}


}  // media::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void FrameInterfaceFactoryInterceptorForTesting::CreateProvisionFetcher(::mojo::PendingReceiver<::media::mojom::blink::ProvisionFetcher> provision_fetcher) {
  GetForwardingInterface()->CreateProvisionFetcher(
    std::move(provision_fetcher)
    );
}
void FrameInterfaceFactoryInterceptorForTesting::CreateCdmStorage(::mojo::PendingReceiver<::media::mojom::blink::CdmStorage> cdm_storage) {
  GetForwardingInterface()->CreateCdmStorage(
    std::move(cdm_storage)
    );
}
void FrameInterfaceFactoryInterceptorForTesting::GetCdmOrigin(GetCdmOriginCallback callback) {
  GetForwardingInterface()->GetCdmOrigin(std::move(callback));
}
void FrameInterfaceFactoryInterceptorForTesting::GetPageUkmSourceId(GetPageUkmSourceIdCallback callback) {
  GetForwardingInterface()->GetPageUkmSourceId(std::move(callback));
}
void FrameInterfaceFactoryInterceptorForTesting::BindEmbedderReceiver(::mojo::GenericPendingReceiver receiver) {
  GetForwardingInterface()->BindEmbedderReceiver(
    std::move(receiver)
    );
}
FrameInterfaceFactoryAsyncWaiter::FrameInterfaceFactoryAsyncWaiter(
    FrameInterfaceFactory* proxy) : proxy_(proxy) {}

FrameInterfaceFactoryAsyncWaiter::~FrameInterfaceFactoryAsyncWaiter() = default;

void FrameInterfaceFactoryAsyncWaiter::GetCdmOrigin(
    ::scoped_refptr<const ::blink::SecurityOrigin>* out_cdm_origin) {
  base::RunLoop loop;
  proxy_->GetCdmOrigin(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::scoped_refptr<const ::blink::SecurityOrigin>* out_cdm_origin
,
             const ::scoped_refptr<const ::blink::SecurityOrigin>& cdm_origin) {*out_cdm_origin = std::move(cdm_origin);
            loop->Quit();
          },
          &loop,
          out_cdm_origin));
  loop.Run();
}

::scoped_refptr<const ::blink::SecurityOrigin> FrameInterfaceFactoryAsyncWaiter::GetCdmOrigin(
    ) {
  ::scoped_refptr<const ::blink::SecurityOrigin> async_wait_result;
  GetCdmOrigin(&async_wait_result);
  return async_wait_result;
}

void FrameInterfaceFactoryAsyncWaiter::GetPageUkmSourceId(
    int64_t* out_ukm_source_id) {
  base::RunLoop loop;
  proxy_->GetPageUkmSourceId(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_ukm_source_id
,
             int64_t ukm_source_id) {*out_ukm_source_id = std::move(ukm_source_id);
            loop->Quit();
          },
          &loop,
          out_ukm_source_id));
  loop.Run();
}

int64_t FrameInterfaceFactoryAsyncWaiter::GetPageUkmSourceId(
    ) {
  int64_t async_wait_result;
  GetPageUkmSourceId(&async_wait_result);
  return async_wait_result;
}






}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif