// media/mojo/mojom/encryption_pattern.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_ENCRYPTION_PATTERN_MOJOM_H_
#define MEDIA_MOJO_MOJOM_ENCRYPTION_PATTERN_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/encryption_pattern.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/encryption_pattern.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/encryption_pattern.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "media/mojo/mojom/encryption_pattern_mojom_traits.h"




namespace media::mojom {





class  EncryptionPattern {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EncryptionPattern, T>::value>;
  using DataView = EncryptionPatternDataView;
  using Data_ = internal::EncryptionPattern_Data;

  template <typename... Args>
  static EncryptionPatternPtr New(Args&&... args) {
    return EncryptionPatternPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EncryptionPatternPtr From(const U& u) {
    return mojo::TypeConverter<EncryptionPatternPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EncryptionPattern>::Convert(*this);
  }


  EncryptionPattern();

  EncryptionPattern(
      uint32_t crypt_byte_block,
      uint32_t skip_byte_block);


  ~EncryptionPattern();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EncryptionPatternPtr>
  EncryptionPatternPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EncryptionPattern::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EncryptionPattern::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EncryptionPattern::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EncryptionPattern::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EncryptionPattern::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EncryptionPattern_UnserializedMessageContext<
            UserType, EncryptionPattern::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EncryptionPattern::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EncryptionPattern::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EncryptionPattern_UnserializedMessageContext<
            UserType, EncryptionPattern::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EncryptionPattern::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t crypt_byte_block;
  
  uint32_t skip_byte_block;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EncryptionPattern::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EncryptionPattern::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EncryptionPattern::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EncryptionPattern::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
EncryptionPatternPtr EncryptionPattern::Clone() const {
  return New(
      mojo::Clone(crypt_byte_block),
      mojo::Clone(skip_byte_block)
  );
}

template <typename T, EncryptionPattern::EnableIfSame<T>*>
bool EncryptionPattern::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->crypt_byte_block, other_struct.crypt_byte_block))
    return false;
  if (!mojo::Equals(this->skip_byte_block, other_struct.skip_byte_block))
    return false;
  return true;
}

template <typename T, EncryptionPattern::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.crypt_byte_block < rhs.crypt_byte_block)
    return true;
  if (rhs.crypt_byte_block < lhs.crypt_byte_block)
    return false;
  if (lhs.skip_byte_block < rhs.skip_byte_block)
    return true;
  if (rhs.skip_byte_block < lhs.skip_byte_block)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::EncryptionPattern::DataView,
                                         ::media::mojom::EncryptionPatternPtr> {
  static bool IsNull(const ::media::mojom::EncryptionPatternPtr& input) { return !input; }
  static void SetToNull(::media::mojom::EncryptionPatternPtr* output) { output->reset(); }

  static decltype(::media::mojom::EncryptionPattern::crypt_byte_block) crypt_byte_block(
      const ::media::mojom::EncryptionPatternPtr& input) {
    return input->crypt_byte_block;
  }

  static decltype(::media::mojom::EncryptionPattern::skip_byte_block) skip_byte_block(
      const ::media::mojom::EncryptionPatternPtr& input) {
    return input->skip_byte_block;
  }

  static bool Read(::media::mojom::EncryptionPattern::DataView input, ::media::mojom::EncryptionPatternPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_ENCRYPTION_PATTERN_MOJOM_H_