// media/mojo/mojom/audio_logging.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/audio_logging.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/audio_logging.mojom-params-data.h"
#include "media/mojo/mojom/audio_logging.mojom-shared-message-ids.h"

#include "media/mojo/mojom/audio_logging.mojom-blink-import-headers.h"
#include "media/mojo/mojom/audio_logging.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
const char AudioLog::Name_[] = "media.mojom.AudioLog";

AudioLog::IPCStableHashFunction AudioLog::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioLog>(message.name())) {
    case messages::AudioLog::kOnCreated: {
      return &AudioLog::OnCreated_Sym::IPCStableHash;
    }
    case messages::AudioLog::kOnStarted: {
      return &AudioLog::OnStarted_Sym::IPCStableHash;
    }
    case messages::AudioLog::kOnStopped: {
      return &AudioLog::OnStopped_Sym::IPCStableHash;
    }
    case messages::AudioLog::kOnClosed: {
      return &AudioLog::OnClosed_Sym::IPCStableHash;
    }
    case messages::AudioLog::kOnError: {
      return &AudioLog::OnError_Sym::IPCStableHash;
    }
    case messages::AudioLog::kOnSetVolume: {
      return &AudioLog::OnSetVolume_Sym::IPCStableHash;
    }
    case messages::AudioLog::kOnProcessingStateChanged: {
      return &AudioLog::OnProcessingStateChanged_Sym::IPCStableHash;
    }
    case messages::AudioLog::kOnLogMessage: {
      return &AudioLog::OnLogMessage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioLog::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioLog>(message.name())) {
      case messages::AudioLog::kOnCreated:
            return "Receive media::mojom::AudioLog::OnCreated";
      case messages::AudioLog::kOnStarted:
            return "Receive media::mojom::AudioLog::OnStarted";
      case messages::AudioLog::kOnStopped:
            return "Receive media::mojom::AudioLog::OnStopped";
      case messages::AudioLog::kOnClosed:
            return "Receive media::mojom::AudioLog::OnClosed";
      case messages::AudioLog::kOnError:
            return "Receive media::mojom::AudioLog::OnError";
      case messages::AudioLog::kOnSetVolume:
            return "Receive media::mojom::AudioLog::OnSetVolume";
      case messages::AudioLog::kOnProcessingStateChanged:
            return "Receive media::mojom::AudioLog::OnProcessingStateChanged";
      case messages::AudioLog::kOnLogMessage:
            return "Receive media::mojom::AudioLog::OnLogMessage";
    }
  } else {
    switch (static_cast<messages::AudioLog>(message.name())) {
      case messages::AudioLog::kOnCreated:
            return "Receive reply media::mojom::AudioLog::OnCreated";
      case messages::AudioLog::kOnStarted:
            return "Receive reply media::mojom::AudioLog::OnStarted";
      case messages::AudioLog::kOnStopped:
            return "Receive reply media::mojom::AudioLog::OnStopped";
      case messages::AudioLog::kOnClosed:
            return "Receive reply media::mojom::AudioLog::OnClosed";
      case messages::AudioLog::kOnError:
            return "Receive reply media::mojom::AudioLog::OnError";
      case messages::AudioLog::kOnSetVolume:
            return "Receive reply media::mojom::AudioLog::OnSetVolume";
      case messages::AudioLog::kOnProcessingStateChanged:
            return "Receive reply media::mojom::AudioLog::OnProcessingStateChanged";
      case messages::AudioLog::kOnLogMessage:
            return "Receive reply media::mojom::AudioLog::OnLogMessage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioLog::OnCreated_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::AudioLog::OnCreated");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioLog::OnStarted_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::AudioLog::OnStarted");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioLog::OnStopped_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::AudioLog::OnStopped");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioLog::OnClosed_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::AudioLog::OnClosed");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioLog::OnError_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::AudioLog::OnError");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioLog::OnSetVolume_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::AudioLog::OnSetVolume");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioLog::OnProcessingStateChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::AudioLog::OnProcessingStateChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioLog::OnLogMessage_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::AudioLog::OnLogMessage");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioLogProxy::AudioLogProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioLogProxy::OnCreated(
    const ::media::AudioParameters& in_params, const WTF::String& in_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioLog::OnCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const ::media::AudioParameters&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const WTF::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioLog::kOnCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioLog_OnCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in AudioLog.OnCreated request");
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in AudioLog.OnCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioLog::Name_);
  message.set_method_name("OnCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioLogProxy::OnStarted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioLog::OnStarted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioLog::kOnStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioLog_OnStarted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioLog::Name_);
  message.set_method_name("OnStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioLogProxy::OnStopped(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioLog::OnStopped");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioLog::kOnStopped), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioLog_OnStopped_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioLog::Name_);
  message.set_method_name("OnStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioLogProxy::OnClosed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioLog::OnClosed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioLog::kOnClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioLog_OnClosed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioLog::Name_);
  message.set_method_name("OnClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioLogProxy::OnError(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioLog::OnError");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioLog::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioLog_OnError_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioLog::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioLogProxy::OnSetVolume(
    double in_volume) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioLog::OnSetVolume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("volume"), in_volume,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioLog::kOnSetVolume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioLog_OnSetVolume_Params_Data> params(
          message);
  params.Allocate();
  params->volume = in_volume;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioLog::Name_);
  message.set_method_name("OnSetVolume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioLogProxy::OnProcessingStateChanged(
    const WTF::String& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioLog::OnProcessingStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const WTF::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioLog::kOnProcessingStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioLog_OnProcessingStateChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in AudioLog.OnProcessingStateChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioLog::Name_);
  message.set_method_name("OnProcessingStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioLogProxy::OnLogMessage(
    const WTF::String& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioLog::OnLogMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const WTF::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioLog::kOnLogMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioLog_OnLogMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in AudioLog.OnLogMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioLog::Name_);
  message.set_method_name("OnLogMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioLogStubDispatch::Accept(
    AudioLog* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioLog>(message->header()->name)) {
    case messages::AudioLog::kOnCreated: {
      DCHECK(message->is_serialized());
      internal::AudioLog_OnCreated_Params_Data* params =
          reinterpret_cast<internal::AudioLog_OnCreated_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AudioLog.0
      bool success = true;
      ::media::AudioParameters p_params{};
      WTF::String p_device_id{};
      AudioLog_OnCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioLog::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCreated(        
        std::move(p_params), 
        std::move(p_device_id));
      return true;
    }
    case messages::AudioLog::kOnStarted: {
      DCHECK(message->is_serialized());
      internal::AudioLog_OnStarted_Params_Data* params =
          reinterpret_cast<internal::AudioLog_OnStarted_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AudioLog.1
      bool success = true;
      AudioLog_OnStarted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioLog::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStarted(        );
      return true;
    }
    case messages::AudioLog::kOnStopped: {
      DCHECK(message->is_serialized());
      internal::AudioLog_OnStopped_Params_Data* params =
          reinterpret_cast<internal::AudioLog_OnStopped_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AudioLog.2
      bool success = true;
      AudioLog_OnStopped_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioLog::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStopped(        );
      return true;
    }
    case messages::AudioLog::kOnClosed: {
      DCHECK(message->is_serialized());
      internal::AudioLog_OnClosed_Params_Data* params =
          reinterpret_cast<internal::AudioLog_OnClosed_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AudioLog.3
      bool success = true;
      AudioLog_OnClosed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioLog::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClosed(        );
      return true;
    }
    case messages::AudioLog::kOnError: {
      DCHECK(message->is_serialized());
      internal::AudioLog_OnError_Params_Data* params =
          reinterpret_cast<internal::AudioLog_OnError_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AudioLog.4
      bool success = true;
      AudioLog_OnError_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioLog::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        );
      return true;
    }
    case messages::AudioLog::kOnSetVolume: {
      DCHECK(message->is_serialized());
      internal::AudioLog_OnSetVolume_Params_Data* params =
          reinterpret_cast<internal::AudioLog_OnSetVolume_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AudioLog.5
      bool success = true;
      double p_volume{};
      AudioLog_OnSetVolume_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_volume = input_data_view.volume();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioLog::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSetVolume(        
        std::move(p_volume));
      return true;
    }
    case messages::AudioLog::kOnProcessingStateChanged: {
      DCHECK(message->is_serialized());
      internal::AudioLog_OnProcessingStateChanged_Params_Data* params =
          reinterpret_cast<internal::AudioLog_OnProcessingStateChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AudioLog.6
      bool success = true;
      WTF::String p_message{};
      AudioLog_OnProcessingStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioLog::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnProcessingStateChanged(        
        std::move(p_message));
      return true;
    }
    case messages::AudioLog::kOnLogMessage: {
      DCHECK(message->is_serialized());
      internal::AudioLog_OnLogMessage_Params_Data* params =
          reinterpret_cast<internal::AudioLog_OnLogMessage_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AudioLog.7
      bool success = true;
      WTF::String p_message{};
      AudioLog_OnLogMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioLog::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLogMessage(        
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool AudioLogStubDispatch::AcceptWithResponder(
    AudioLog* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioLog>(message->header()->name)) {
    case messages::AudioLog::kOnCreated: {
      break;
    }
    case messages::AudioLog::kOnStarted: {
      break;
    }
    case messages::AudioLog::kOnStopped: {
      break;
    }
    case messages::AudioLog::kOnClosed: {
      break;
    }
    case messages::AudioLog::kOnError: {
      break;
    }
    case messages::AudioLog::kOnSetVolume: {
      break;
    }
    case messages::AudioLog::kOnProcessingStateChanged: {
      break;
    }
    case messages::AudioLog::kOnLogMessage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioLogValidationInfo[] = {
    {base::to_underlying(messages::AudioLog::kOnCreated),
     { &internal::AudioLog_OnCreated_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AudioLog::kOnStarted),
     { &internal::AudioLog_OnStarted_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AudioLog::kOnStopped),
     { &internal::AudioLog_OnStopped_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AudioLog::kOnClosed),
     { &internal::AudioLog_OnClosed_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AudioLog::kOnError),
     { &internal::AudioLog_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AudioLog::kOnSetVolume),
     { &internal::AudioLog_OnSetVolume_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AudioLog::kOnProcessingStateChanged),
     { &internal::AudioLog_OnProcessingStateChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AudioLog::kOnLogMessage),
     { &internal::AudioLog_OnLogMessage_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioLogRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::AudioLog::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAudioLogValidationInfo);
}

const char AudioLogFactory::Name_[] = "media.mojom.AudioLogFactory";

AudioLogFactory::IPCStableHashFunction AudioLogFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioLogFactory>(message.name())) {
    case messages::AudioLogFactory::kCreateAudioLog: {
      return &AudioLogFactory::CreateAudioLog_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioLogFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioLogFactory>(message.name())) {
      case messages::AudioLogFactory::kCreateAudioLog:
            return "Receive media::mojom::AudioLogFactory::CreateAudioLog";
    }
  } else {
    switch (static_cast<messages::AudioLogFactory>(message.name())) {
      case messages::AudioLogFactory::kCreateAudioLog:
            return "Receive reply media::mojom::AudioLogFactory::CreateAudioLog";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioLogFactory::CreateAudioLog_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::AudioLogFactory::CreateAudioLog");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioLogFactoryProxy::AudioLogFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioLogFactoryProxy::CreateAudioLog(
    AudioLogComponent in_component, int32_t in_component_id, ::mojo::PendingReceiver<AudioLog> in_audio_log_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioLogFactory::CreateAudioLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("component"), in_component,
                        "<value of type AudioLogComponent>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("component_id"), in_component_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_log_receiver"), in_audio_log_receiver,
                        "<value of type ::mojo::PendingReceiver<AudioLog>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioLogFactory::kCreateAudioLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioLogFactory_CreateAudioLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::AudioLogComponent>(
      in_component, &params->component);
  params->component_id = in_component_id;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioLogInterfaceBase>>(
      in_audio_log_receiver, &params->audio_log_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->audio_log_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid audio_log_receiver in AudioLogFactory.CreateAudioLog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioLogFactory::Name_);
  message.set_method_name("CreateAudioLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioLogFactoryStubDispatch::Accept(
    AudioLogFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioLogFactory>(message->header()->name)) {
    case messages::AudioLogFactory::kCreateAudioLog: {
      DCHECK(message->is_serialized());
      internal::AudioLogFactory_CreateAudioLog_Params_Data* params =
          reinterpret_cast<internal::AudioLogFactory_CreateAudioLog_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AudioLogFactory.0
      bool success = true;
      AudioLogComponent p_component{};
      int32_t p_component_id{};
      ::mojo::PendingReceiver<AudioLog> p_audio_log_receiver{};
      AudioLogFactory_CreateAudioLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadComponent(&p_component))
        success = false;
      if (success)
        p_component_id = input_data_view.component_id();
      if (success) {
        p_audio_log_receiver =
            input_data_view.TakeAudioLogReceiver<decltype(p_audio_log_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioLogFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAudioLog(        
        std::move(p_component), 
        std::move(p_component_id), 
        std::move(p_audio_log_receiver));
      return true;
    }
  }
  return false;
}

// static
bool AudioLogFactoryStubDispatch::AcceptWithResponder(
    AudioLogFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioLogFactory>(message->header()->name)) {
    case messages::AudioLogFactory::kCreateAudioLog: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioLogFactoryValidationInfo[] = {
    {base::to_underlying(messages::AudioLogFactory::kCreateAudioLog),
     { &internal::AudioLogFactory_CreateAudioLog_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioLogFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::AudioLogFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAudioLogFactoryValidationInfo);
}



}  // media::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void AudioLogInterceptorForTesting::OnCreated(const ::media::AudioParameters& params, const WTF::String& device_id) {
  GetForwardingInterface()->OnCreated(
    std::move(params)
    , 
    std::move(device_id)
    );
}
void AudioLogInterceptorForTesting::OnStarted() {
  GetForwardingInterface()->OnStarted();
}
void AudioLogInterceptorForTesting::OnStopped() {
  GetForwardingInterface()->OnStopped();
}
void AudioLogInterceptorForTesting::OnClosed() {
  GetForwardingInterface()->OnClosed();
}
void AudioLogInterceptorForTesting::OnError() {
  GetForwardingInterface()->OnError();
}
void AudioLogInterceptorForTesting::OnSetVolume(double volume) {
  GetForwardingInterface()->OnSetVolume(
    std::move(volume)
    );
}
void AudioLogInterceptorForTesting::OnProcessingStateChanged(const WTF::String& message) {
  GetForwardingInterface()->OnProcessingStateChanged(
    std::move(message)
    );
}
void AudioLogInterceptorForTesting::OnLogMessage(const WTF::String& message) {
  GetForwardingInterface()->OnLogMessage(
    std::move(message)
    );
}
AudioLogAsyncWaiter::AudioLogAsyncWaiter(
    AudioLog* proxy) : proxy_(proxy) {}

AudioLogAsyncWaiter::~AudioLogAsyncWaiter() = default;




void AudioLogFactoryInterceptorForTesting::CreateAudioLog(AudioLogComponent component, int32_t component_id, ::mojo::PendingReceiver<AudioLog> audio_log_receiver) {
  GetForwardingInterface()->CreateAudioLog(
    std::move(component)
    , 
    std::move(component_id)
    , 
    std::move(audio_log_receiver)
    );
}
AudioLogFactoryAsyncWaiter::AudioLogFactoryAsyncWaiter(
    AudioLogFactory* proxy) : proxy_(proxy) {}

AudioLogFactoryAsyncWaiter::~AudioLogFactoryAsyncWaiter() = default;






}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif