// content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom-params-data.h"
#include "content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom-shared-message-ids.h"

#include "content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom-import-headers.h"
#include "content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom-test-utils.h"


namespace auction_worklet::mojom {
const char AuctionSharedStorageHost::Name_[] = "auction_worklet.mojom.AuctionSharedStorageHost";

AuctionSharedStorageHost::IPCStableHashFunction AuctionSharedStorageHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AuctionSharedStorageHost>(message.name())) {
    case messages::AuctionSharedStorageHost::kSharedStorageUpdate: {
      return &AuctionSharedStorageHost::SharedStorageUpdate_Sym::IPCStableHash;
    }
    case messages::AuctionSharedStorageHost::kSharedStorageBatchUpdate: {
      return &AuctionSharedStorageHost::SharedStorageBatchUpdate_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AuctionSharedStorageHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AuctionSharedStorageHost>(message.name())) {
      case messages::AuctionSharedStorageHost::kSharedStorageUpdate:
            return "Receive auction_worklet::mojom::AuctionSharedStorageHost::SharedStorageUpdate";
      case messages::AuctionSharedStorageHost::kSharedStorageBatchUpdate:
            return "Receive auction_worklet::mojom::AuctionSharedStorageHost::SharedStorageBatchUpdate";
    }
  } else {
    switch (static_cast<messages::AuctionSharedStorageHost>(message.name())) {
      case messages::AuctionSharedStorageHost::kSharedStorageUpdate:
            return "Receive reply auction_worklet::mojom::AuctionSharedStorageHost::SharedStorageUpdate";
      case messages::AuctionSharedStorageHost::kSharedStorageBatchUpdate:
            return "Receive reply auction_worklet::mojom::AuctionSharedStorageHost::SharedStorageBatchUpdate";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AuctionSharedStorageHost::SharedStorageUpdate_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)auction_worklet::mojom::AuctionSharedStorageHost::SharedStorageUpdate");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AuctionSharedStorageHost::SharedStorageBatchUpdate_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)auction_worklet::mojom::AuctionSharedStorageHost::SharedStorageBatchUpdate");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AuctionSharedStorageHostProxy::AuctionSharedStorageHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AuctionSharedStorageHostProxy::SharedStorageUpdate(
    ::network::mojom::SharedStorageModifierMethodWithOptionsPtr in_method_with_options, AuctionWorkletFunction in_source_auction_worklet_function) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::AuctionSharedStorageHost::SharedStorageUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method_with_options"), in_method_with_options,
                        "<value of type ::network::mojom::SharedStorageModifierMethodWithOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_auction_worklet_function"), in_source_auction_worklet_function,
                        "<value of type AuctionWorkletFunction>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AuctionSharedStorageHost::kSharedStorageUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::AuctionSharedStorageHost_SharedStorageUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->method_with_options)::BaseType> method_with_options_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SharedStorageModifierMethodWithOptionsDataView>(
      in_method_with_options, method_with_options_fragment);
  params->method_with_options.Set(
      method_with_options_fragment.is_null() ? nullptr : method_with_options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->method_with_options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_with_options in AuctionSharedStorageHost.SharedStorageUpdate request");
  mojo::internal::Serialize<::auction_worklet::mojom::AuctionWorkletFunction>(
      in_source_auction_worklet_function, &params->source_auction_worklet_function);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuctionSharedStorageHost::Name_);
  message.set_method_name("SharedStorageUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AuctionSharedStorageHostProxy::SharedStorageBatchUpdate(
    std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> in_methods_with_options, const std::optional<::std::string>& in_with_lock, AuctionWorkletFunction in_source_auction_worklet_function) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::AuctionSharedStorageHost::SharedStorageBatchUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("methods_with_options"), in_methods_with_options,
                        "<value of type std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("with_lock"), in_with_lock,
                        "<value of type const std::optional<::std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_auction_worklet_function"), in_source_auction_worklet_function,
                        "<value of type AuctionWorkletFunction>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AuctionSharedStorageHost::kSharedStorageBatchUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::AuctionSharedStorageHost_SharedStorageBatchUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->methods_with_options)::BaseType>
      methods_with_options_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& methods_with_options_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SharedStorageModifierMethodWithOptionsDataView>>(
      in_methods_with_options, methods_with_options_fragment, &methods_with_options_validate_params);
  params->methods_with_options.Set(
      methods_with_options_fragment.is_null() ? nullptr : methods_with_options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->methods_with_options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null methods_with_options in AuctionSharedStorageHost.SharedStorageBatchUpdate request");
  mojo::internal::MessageFragment<
      typename decltype(params->with_lock)::BaseType> with_lock_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::LockNameDataView>(
      in_with_lock, with_lock_fragment);
  params->with_lock.Set(
      with_lock_fragment.is_null() ? nullptr : with_lock_fragment.data());
  mojo::internal::Serialize<::auction_worklet::mojom::AuctionWorkletFunction>(
      in_source_auction_worklet_function, &params->source_auction_worklet_function);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuctionSharedStorageHost::Name_);
  message.set_method_name("SharedStorageBatchUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AuctionSharedStorageHostStubDispatch::Accept(
    AuctionSharedStorageHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AuctionSharedStorageHost>(message->header()->name)) {
    case messages::AuctionSharedStorageHost::kSharedStorageUpdate: {
      DCHECK(message->is_serialized());
      internal::AuctionSharedStorageHost_SharedStorageUpdate_Params_Data* params =
          reinterpret_cast<internal::AuctionSharedStorageHost_SharedStorageUpdate_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AuctionSharedStorageHost.0
      bool success = true;
      ::network::mojom::SharedStorageModifierMethodWithOptionsPtr p_method_with_options{};
      AuctionWorkletFunction p_source_auction_worklet_function{};
      AuctionSharedStorageHost_SharedStorageUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMethodWithOptions(&p_method_with_options))
        success = false;
      if (success && !input_data_view.ReadSourceAuctionWorkletFunction(&p_source_auction_worklet_function))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuctionSharedStorageHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SharedStorageUpdate(        
        std::move(p_method_with_options), 
        std::move(p_source_auction_worklet_function));
      return true;
    }
    case messages::AuctionSharedStorageHost::kSharedStorageBatchUpdate: {
      DCHECK(message->is_serialized());
      internal::AuctionSharedStorageHost_SharedStorageBatchUpdate_Params_Data* params =
          reinterpret_cast<internal::AuctionSharedStorageHost_SharedStorageBatchUpdate_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for AuctionSharedStorageHost.1
      bool success = true;
      std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> p_methods_with_options{};
      std::optional<::std::string> p_with_lock{};
      AuctionWorkletFunction p_source_auction_worklet_function{};
      AuctionSharedStorageHost_SharedStorageBatchUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMethodsWithOptions(&p_methods_with_options))
        success = false;
      if (success && !input_data_view.ReadWithLock(&p_with_lock))
        success = false;
      if (success && !input_data_view.ReadSourceAuctionWorkletFunction(&p_source_auction_worklet_function))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuctionSharedStorageHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SharedStorageBatchUpdate(        
        std::move(p_methods_with_options), 
        std::move(p_with_lock), 
        std::move(p_source_auction_worklet_function));
      return true;
    }
  }
  return false;
}

// static
bool AuctionSharedStorageHostStubDispatch::AcceptWithResponder(
    AuctionSharedStorageHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AuctionSharedStorageHost>(message->header()->name)) {
    case messages::AuctionSharedStorageHost::kSharedStorageUpdate: {
      break;
    }
    case messages::AuctionSharedStorageHost::kSharedStorageBatchUpdate: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAuctionSharedStorageHostValidationInfo[] = {
    {base::to_underlying(messages::AuctionSharedStorageHost::kSharedStorageUpdate),
     { &internal::AuctionSharedStorageHost_SharedStorageUpdate_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AuctionSharedStorageHost::kSharedStorageBatchUpdate),
     { &internal::AuctionSharedStorageHost_SharedStorageBatchUpdate_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AuctionSharedStorageHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::auction_worklet::mojom::AuctionSharedStorageHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAuctionSharedStorageHostValidationInfo);
}



}  // auction_worklet::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace auction_worklet::mojom {


void AuctionSharedStorageHostInterceptorForTesting::SharedStorageUpdate(::network::mojom::SharedStorageModifierMethodWithOptionsPtr method_with_options, AuctionWorkletFunction source_auction_worklet_function) {
  GetForwardingInterface()->SharedStorageUpdate(
    std::move(method_with_options)
    , 
    std::move(source_auction_worklet_function)
    );
}
void AuctionSharedStorageHostInterceptorForTesting::SharedStorageBatchUpdate(std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::std::string>& with_lock, AuctionWorkletFunction source_auction_worklet_function) {
  GetForwardingInterface()->SharedStorageBatchUpdate(
    std::move(methods_with_options)
    , 
    std::move(with_lock)
    , 
    std::move(source_auction_worklet_function)
    );
}
AuctionSharedStorageHostAsyncWaiter::AuctionSharedStorageHostAsyncWaiter(
    AuctionSharedStorageHost* proxy) : proxy_(proxy) {}

AuctionSharedStorageHostAsyncWaiter::~AuctionSharedStorageHostAsyncWaiter() = default;






}  // auction_worklet::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif