// content/common/pepper_plugin.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/pepper_plugin.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/pepper_plugin.mojom-params-data.h"
#include "content/common/pepper_plugin.mojom-shared-message-ids.h"

#include "content/common/pepper_plugin.mojom-import-headers.h"
#include "content/common/pepper_plugin.mojom-test-utils.h"
#include "content/public/common/webplugininfo_param_traits.h"


namespace content::mojom {
const char PepperHost::Name_[] = "content.mojom.PepperHost";

PepperHost::IPCStableHashFunction PepperHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PepperHost>(message.name())) {
    case messages::PepperHost::kInstanceCreated: {
      return &PepperHost::InstanceCreated_Sym::IPCStableHash;
    }
    case messages::PepperHost::kBindHungDetectorHost: {
      return &PepperHost::BindHungDetectorHost_Sym::IPCStableHash;
    }
    case messages::PepperHost::kGetPluginInfo: {
      return &PepperHost::GetPluginInfo_Sym::IPCStableHash;
    }
    case messages::PepperHost::kDidCreateInProcessInstance: {
      return &PepperHost::DidCreateInProcessInstance_Sym::IPCStableHash;
    }
    case messages::PepperHost::kDidDeleteInProcessInstance: {
      return &PepperHost::DidDeleteInProcessInstance_Sym::IPCStableHash;
    }
    case messages::PepperHost::kDidCreateOutOfProcessPepperInstance: {
      return &PepperHost::DidCreateOutOfProcessPepperInstance_Sym::IPCStableHash;
    }
    case messages::PepperHost::kDidDeleteOutOfProcessPepperInstance: {
      return &PepperHost::DidDeleteOutOfProcessPepperInstance_Sym::IPCStableHash;
    }
    case messages::PepperHost::kOpenChannelToPepperPlugin: {
      return &PepperHost::OpenChannelToPepperPlugin_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PepperHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PepperHost>(message.name())) {
      case messages::PepperHost::kInstanceCreated:
            return "Receive content::mojom::PepperHost::InstanceCreated";
      case messages::PepperHost::kBindHungDetectorHost:
            return "Receive content::mojom::PepperHost::BindHungDetectorHost";
      case messages::PepperHost::kGetPluginInfo:
            return "Receive content::mojom::PepperHost::GetPluginInfo";
      case messages::PepperHost::kDidCreateInProcessInstance:
            return "Receive content::mojom::PepperHost::DidCreateInProcessInstance";
      case messages::PepperHost::kDidDeleteInProcessInstance:
            return "Receive content::mojom::PepperHost::DidDeleteInProcessInstance";
      case messages::PepperHost::kDidCreateOutOfProcessPepperInstance:
            return "Receive content::mojom::PepperHost::DidCreateOutOfProcessPepperInstance";
      case messages::PepperHost::kDidDeleteOutOfProcessPepperInstance:
            return "Receive content::mojom::PepperHost::DidDeleteOutOfProcessPepperInstance";
      case messages::PepperHost::kOpenChannelToPepperPlugin:
            return "Receive content::mojom::PepperHost::OpenChannelToPepperPlugin";
    }
  } else {
    switch (static_cast<messages::PepperHost>(message.name())) {
      case messages::PepperHost::kInstanceCreated:
            return "Receive reply content::mojom::PepperHost::InstanceCreated";
      case messages::PepperHost::kBindHungDetectorHost:
            return "Receive reply content::mojom::PepperHost::BindHungDetectorHost";
      case messages::PepperHost::kGetPluginInfo:
            return "Receive reply content::mojom::PepperHost::GetPluginInfo";
      case messages::PepperHost::kDidCreateInProcessInstance:
            return "Receive reply content::mojom::PepperHost::DidCreateInProcessInstance";
      case messages::PepperHost::kDidDeleteInProcessInstance:
            return "Receive reply content::mojom::PepperHost::DidDeleteInProcessInstance";
      case messages::PepperHost::kDidCreateOutOfProcessPepperInstance:
            return "Receive reply content::mojom::PepperHost::DidCreateOutOfProcessPepperInstance";
      case messages::PepperHost::kDidDeleteOutOfProcessPepperInstance:
            return "Receive reply content::mojom::PepperHost::DidDeleteOutOfProcessPepperInstance";
      case messages::PepperHost::kOpenChannelToPepperPlugin:
            return "Receive reply content::mojom::PepperHost::OpenChannelToPepperPlugin";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PepperHost::InstanceCreated_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::PepperHost::InstanceCreated");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PepperHost::BindHungDetectorHost_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::PepperHost::BindHungDetectorHost");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PepperHost::GetPluginInfo_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::PepperHost::GetPluginInfo");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PepperHost::DidCreateInProcessInstance_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::PepperHost::DidCreateInProcessInstance");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PepperHost::DidDeleteInProcessInstance_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::PepperHost::DidDeleteInProcessInstance");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PepperHost::DidCreateOutOfProcessPepperInstance_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::PepperHost::DidCreateOutOfProcessPepperInstance");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PepperHost::DidDeleteOutOfProcessPepperInstance_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::PepperHost::DidDeleteOutOfProcessPepperInstance");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PepperHost::OpenChannelToPepperPlugin_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::PepperHost::OpenChannelToPepperPlugin");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool PepperHost::GetPluginInfo(const ::GURL& url, const std::string& mime_type, bool* out_found, ::content::WebPluginInfo* out_plugin_info, std::string* out_actual_mime_type) {
  NOTREACHED();
}
bool PepperHost::DidCreateOutOfProcessPepperInstance(int32_t plugin_child_id, int32_t pp_instance, bool is_external, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url, bool is_privileged_context) {
  NOTREACHED();
}
bool PepperHost::OpenChannelToPepperPlugin(const ::url::Origin& embedder_origin, const ::base::FilePath& path, const std::optional<::url::Origin>& origin_lock, ::mojo::ScopedMessagePipeHandle* out_handle_to_channel, ::base::ProcessId* out_plugin_pid, int32_t* out_plugin_child_id) {
  NOTREACHED();
}
class PepperHost_GetPluginInfo_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PepperHost_GetPluginInfo_HandleSyncResponse(
      bool* result, bool* out_found, ::content::WebPluginInfo* out_plugin_info, std::string* out_actual_mime_type)
      : result_(result), out_found_(out_found), out_plugin_info_(out_plugin_info), out_actual_mime_type_(out_actual_mime_type) {
    DCHECK(!*result_);
  }

  PepperHost_GetPluginInfo_HandleSyncResponse(const PepperHost_GetPluginInfo_HandleSyncResponse&) = delete;
  PepperHost_GetPluginInfo_HandleSyncResponse& operator=(const PepperHost_GetPluginInfo_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_found_;
  ::content::WebPluginInfo* out_plugin_info_;
  std::string* out_actual_mime_type_;};

class PepperHost_GetPluginInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PepperHost_GetPluginInfo_ForwardToCallback(
      PepperHost::GetPluginInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  PepperHost_GetPluginInfo_ForwardToCallback(const PepperHost_GetPluginInfo_ForwardToCallback&) = delete;
  PepperHost_GetPluginInfo_ForwardToCallback& operator=(const PepperHost_GetPluginInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PepperHost::GetPluginInfoCallback callback_;
};
class PepperHost_DidCreateOutOfProcessPepperInstance_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PepperHost_DidCreateOutOfProcessPepperInstance_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  PepperHost_DidCreateOutOfProcessPepperInstance_HandleSyncResponse(const PepperHost_DidCreateOutOfProcessPepperInstance_HandleSyncResponse&) = delete;
  PepperHost_DidCreateOutOfProcessPepperInstance_HandleSyncResponse& operator=(const PepperHost_DidCreateOutOfProcessPepperInstance_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class PepperHost_DidCreateOutOfProcessPepperInstance_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PepperHost_DidCreateOutOfProcessPepperInstance_ForwardToCallback(
      PepperHost::DidCreateOutOfProcessPepperInstanceCallback callback
      ) : callback_(std::move(callback)) {
  }

  PepperHost_DidCreateOutOfProcessPepperInstance_ForwardToCallback(const PepperHost_DidCreateOutOfProcessPepperInstance_ForwardToCallback&) = delete;
  PepperHost_DidCreateOutOfProcessPepperInstance_ForwardToCallback& operator=(const PepperHost_DidCreateOutOfProcessPepperInstance_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PepperHost::DidCreateOutOfProcessPepperInstanceCallback callback_;
};
class PepperHost_OpenChannelToPepperPlugin_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PepperHost_OpenChannelToPepperPlugin_HandleSyncResponse(
      bool* result, ::mojo::ScopedMessagePipeHandle* out_handle_to_channel, ::base::ProcessId* out_plugin_pid, int32_t* out_plugin_child_id)
      : result_(result), out_handle_to_channel_(out_handle_to_channel), out_plugin_pid_(out_plugin_pid), out_plugin_child_id_(out_plugin_child_id) {
    DCHECK(!*result_);
  }

  PepperHost_OpenChannelToPepperPlugin_HandleSyncResponse(const PepperHost_OpenChannelToPepperPlugin_HandleSyncResponse&) = delete;
  PepperHost_OpenChannelToPepperPlugin_HandleSyncResponse& operator=(const PepperHost_OpenChannelToPepperPlugin_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::mojo::ScopedMessagePipeHandle* out_handle_to_channel_;
  ::base::ProcessId* out_plugin_pid_;
  int32_t* out_plugin_child_id_;};

class PepperHost_OpenChannelToPepperPlugin_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PepperHost_OpenChannelToPepperPlugin_ForwardToCallback(
      PepperHost::OpenChannelToPepperPluginCallback callback
      ) : callback_(std::move(callback)) {
  }

  PepperHost_OpenChannelToPepperPlugin_ForwardToCallback(const PepperHost_OpenChannelToPepperPlugin_ForwardToCallback&) = delete;
  PepperHost_OpenChannelToPepperPlugin_ForwardToCallback& operator=(const PepperHost_OpenChannelToPepperPlugin_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PepperHost::OpenChannelToPepperPluginCallback callback_;
};

PepperHostProxy::PepperHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PepperHostProxy::InstanceCreated(
    int32_t in_instance_id, ::mojo::PendingAssociatedRemote<PepperPluginInstance> in_instance, ::mojo::PendingAssociatedReceiver<PepperPluginInstanceHost> in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::PepperHost::InstanceCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instance_id"), in_instance_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instance"), in_instance,
                        "<value of type ::mojo::PendingAssociatedRemote<PepperPluginInstance>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingAssociatedReceiver<PepperPluginInstanceHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHost::kInstanceCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_InstanceCreated_Params_Data> params(
          message);
  params.Allocate();
  params->instance_id = in_instance_id;
  mojo::internal::Serialize<::content::mojom::PepperPluginInstanceAssociatedPtrInfoDataView>(
      in_instance, &params->instance, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->instance),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid instance in PepperHost.InstanceCreated request");
  mojo::internal::Serialize<::content::mojom::PepperPluginInstanceHostAssociatedRequestDataView>(
      in_host, &params->host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid host in PepperHost.InstanceCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("InstanceCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PepperHostProxy::BindHungDetectorHost(
    ::mojo::PendingReceiver<PepperHungDetectorHost> in_host, int32_t in_plugin_child_id, const ::base::FilePath& in_plugin_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::PepperHost::BindHungDetectorHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingReceiver<PepperHungDetectorHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_child_id"), in_plugin_child_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_path"), in_plugin_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHost::kBindHungDetectorHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_BindHungDetectorHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::content::mojom::PepperHungDetectorHostInterfaceBase>>(
      in_host, &params->host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid host in PepperHost.BindHungDetectorHost request");
  params->plugin_child_id = in_plugin_child_id;
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_path)::BaseType> plugin_path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_plugin_path, plugin_path_fragment);
  params->plugin_path.Set(
      plugin_path_fragment.is_null() ? nullptr : plugin_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_path in PepperHost.BindHungDetectorHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("BindHungDetectorHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool PepperHostProxy::GetPluginInfo(
    const ::GURL& param_url, const std::string& param_mime_type, bool* out_param_found, ::content::WebPluginInfo* out_param_plugin_info, std::string* out_param_actual_mime_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call content::mojom::PepperHost::GetPluginInfo (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), param_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_type"), param_mime_type,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "PepperHost::GetPluginInfo");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHost::kGetPluginInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_GetPluginInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PepperHost.GetPluginInfo request");
  mojo::internal::MessageFragment<
      typename decltype(params->mime_type)::BaseType> mime_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_mime_type, mime_type_fragment);
  params->mime_type.Set(
      mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mime_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in PepperHost.GetPluginInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("GetPluginInfo");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PepperHost_GetPluginInfo_HandleSyncResponse(
          &result, out_param_found, out_param_plugin_info, out_param_actual_mime_type));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "PepperHost::GetPluginInfo", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("found"), out_param_found,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_info"), out_param_plugin_info,
                        "<value of type const ::content::WebPluginInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("actual_mime_type"), out_param_actual_mime_type,
                        "<value of type const std::string&>");
   });
#endif
  return result;
}

void PepperHostProxy::GetPluginInfo(
    const ::GURL& in_url, const std::string& in_mime_type, GetPluginInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::PepperHost::GetPluginInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_type"), in_mime_type,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHost::kGetPluginInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_GetPluginInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PepperHost.GetPluginInfo request");
  mojo::internal::MessageFragment<
      typename decltype(params->mime_type)::BaseType> mime_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_mime_type, mime_type_fragment);
  params->mime_type.Set(
      mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mime_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in PepperHost.GetPluginInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("GetPluginInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PepperHost_GetPluginInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PepperHostProxy::DidCreateInProcessInstance(
    int32_t in_instance_id, int32_t in_frame_routing_id, const ::GURL& in_document_url, const ::GURL& in_plugin_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::PepperHost::DidCreateInProcessInstance", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instance_id"), in_instance_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_routing_id"), in_frame_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_url"), in_document_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_url"), in_plugin_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHost::kDidCreateInProcessInstance), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_DidCreateInProcessInstance_Params_Data> params(
          message);
  params.Allocate();
  params->instance_id = in_instance_id;
  params->frame_routing_id = in_frame_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->document_url)::BaseType> document_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_document_url, document_url_fragment);
  params->document_url.Set(
      document_url_fragment.is_null() ? nullptr : document_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->document_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_url in PepperHost.DidCreateInProcessInstance request");
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_url)::BaseType> plugin_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_plugin_url, plugin_url_fragment);
  params->plugin_url.Set(
      plugin_url_fragment.is_null() ? nullptr : plugin_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_url in PepperHost.DidCreateInProcessInstance request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("DidCreateInProcessInstance");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PepperHostProxy::DidDeleteInProcessInstance(
    int32_t in_instance_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::PepperHost::DidDeleteInProcessInstance", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instance_id"), in_instance_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHost::kDidDeleteInProcessInstance), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_DidDeleteInProcessInstance_Params_Data> params(
          message);
  params.Allocate();
  params->instance_id = in_instance_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("DidDeleteInProcessInstance");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool PepperHostProxy::DidCreateOutOfProcessPepperInstance(
    int32_t param_plugin_child_id, int32_t param_pp_instance, bool param_is_external, int32_t param_frame_routing_id, const ::GURL& param_document_url, const ::GURL& param_plugin_url, bool param_is_privileged_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call content::mojom::PepperHost::DidCreateOutOfProcessPepperInstance (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_child_id"), param_plugin_child_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pp_instance"), param_pp_instance,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_external"), param_is_external,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_routing_id"), param_frame_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_url"), param_document_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_url"), param_plugin_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_privileged_context"), param_is_privileged_context,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "PepperHost::DidCreateOutOfProcessPepperInstance");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHost::kDidCreateOutOfProcessPepperInstance), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_DidCreateOutOfProcessPepperInstance_Params_Data> params(
          message);
  params.Allocate();
  params->plugin_child_id = param_plugin_child_id;
  params->pp_instance = param_pp_instance;
  params->is_external = param_is_external;
  params->frame_routing_id = param_frame_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->document_url)::BaseType> document_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_document_url, document_url_fragment);
  params->document_url.Set(
      document_url_fragment.is_null() ? nullptr : document_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->document_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_url in PepperHost.DidCreateOutOfProcessPepperInstance request");
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_url)::BaseType> plugin_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_plugin_url, plugin_url_fragment);
  params->plugin_url.Set(
      plugin_url_fragment.is_null() ? nullptr : plugin_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_url in PepperHost.DidCreateOutOfProcessPepperInstance request");
  params->is_privileged_context = param_is_privileged_context;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("DidCreateOutOfProcessPepperInstance");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PepperHost_DidCreateOutOfProcessPepperInstance_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "PepperHost::DidCreateOutOfProcessPepperInstance");
#endif
  return result;
}

void PepperHostProxy::DidCreateOutOfProcessPepperInstance(
    int32_t in_plugin_child_id, int32_t in_pp_instance, bool in_is_external, int32_t in_frame_routing_id, const ::GURL& in_document_url, const ::GURL& in_plugin_url, bool in_is_privileged_context, DidCreateOutOfProcessPepperInstanceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::PepperHost::DidCreateOutOfProcessPepperInstance", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_child_id"), in_plugin_child_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pp_instance"), in_pp_instance,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_external"), in_is_external,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_routing_id"), in_frame_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_url"), in_document_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_url"), in_plugin_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_privileged_context"), in_is_privileged_context,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHost::kDidCreateOutOfProcessPepperInstance), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_DidCreateOutOfProcessPepperInstance_Params_Data> params(
          message);
  params.Allocate();
  params->plugin_child_id = in_plugin_child_id;
  params->pp_instance = in_pp_instance;
  params->is_external = in_is_external;
  params->frame_routing_id = in_frame_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->document_url)::BaseType> document_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_document_url, document_url_fragment);
  params->document_url.Set(
      document_url_fragment.is_null() ? nullptr : document_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->document_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_url in PepperHost.DidCreateOutOfProcessPepperInstance request");
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_url)::BaseType> plugin_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_plugin_url, plugin_url_fragment);
  params->plugin_url.Set(
      plugin_url_fragment.is_null() ? nullptr : plugin_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_url in PepperHost.DidCreateOutOfProcessPepperInstance request");
  params->is_privileged_context = in_is_privileged_context;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("DidCreateOutOfProcessPepperInstance");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PepperHost_DidCreateOutOfProcessPepperInstance_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PepperHostProxy::DidDeleteOutOfProcessPepperInstance(
    int32_t in_plugin_child_id, int32_t in_pp_instance, bool in_is_external) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::PepperHost::DidDeleteOutOfProcessPepperInstance", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_child_id"), in_plugin_child_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pp_instance"), in_pp_instance,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_external"), in_is_external,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHost::kDidDeleteOutOfProcessPepperInstance), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_DidDeleteOutOfProcessPepperInstance_Params_Data> params(
          message);
  params.Allocate();
  params->plugin_child_id = in_plugin_child_id;
  params->pp_instance = in_pp_instance;
  params->is_external = in_is_external;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("DidDeleteOutOfProcessPepperInstance");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool PepperHostProxy::OpenChannelToPepperPlugin(
    const ::url::Origin& param_embedder_origin, const ::base::FilePath& param_path, const std::optional<::url::Origin>& param_origin_lock, ::mojo::ScopedMessagePipeHandle* out_param_handle_to_channel, ::base::ProcessId* out_param_plugin_pid, int32_t* out_param_plugin_child_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call content::mojom::PepperHost::OpenChannelToPepperPlugin (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedder_origin"), param_embedder_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin_lock"), param_origin_lock,
                        "<value of type const std::optional<::url::Origin>&>");
   });
#else
  TRACE_EVENT0("mojom", "PepperHost::OpenChannelToPepperPlugin");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHost::kOpenChannelToPepperPlugin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_OpenChannelToPepperPlugin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->embedder_origin)::BaseType> embedder_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      param_embedder_origin, embedder_origin_fragment);
  params->embedder_origin.Set(
      embedder_origin_fragment.is_null() ? nullptr : embedder_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->embedder_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null embedder_origin in PepperHost.OpenChannelToPepperPlugin request");
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in PepperHost.OpenChannelToPepperPlugin request");
  mojo::internal::MessageFragment<
      typename decltype(params->origin_lock)::BaseType> origin_lock_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      param_origin_lock, origin_lock_fragment);
  params->origin_lock.Set(
      origin_lock_fragment.is_null() ? nullptr : origin_lock_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("OpenChannelToPepperPlugin");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PepperHost_OpenChannelToPepperPlugin_HandleSyncResponse(
          &result, out_param_handle_to_channel, out_param_plugin_pid, out_param_plugin_child_id));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "PepperHost::OpenChannelToPepperPlugin", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handle_to_channel"), out_param_handle_to_channel,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_pid"), out_param_plugin_pid,
                        "<value of type ::base::ProcessId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_child_id"), out_param_plugin_child_id,
                        "<value of type int32_t>");
   });
#endif
  return result;
}

void PepperHostProxy::OpenChannelToPepperPlugin(
    const ::url::Origin& in_embedder_origin, const ::base::FilePath& in_path, const std::optional<::url::Origin>& in_origin_lock, OpenChannelToPepperPluginCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::PepperHost::OpenChannelToPepperPlugin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedder_origin"), in_embedder_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin_lock"), in_origin_lock,
                        "<value of type const std::optional<::url::Origin>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHost::kOpenChannelToPepperPlugin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_OpenChannelToPepperPlugin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->embedder_origin)::BaseType> embedder_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_embedder_origin, embedder_origin_fragment);
  params->embedder_origin.Set(
      embedder_origin_fragment.is_null() ? nullptr : embedder_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->embedder_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null embedder_origin in PepperHost.OpenChannelToPepperPlugin request");
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in PepperHost.OpenChannelToPepperPlugin request");
  mojo::internal::MessageFragment<
      typename decltype(params->origin_lock)::BaseType> origin_lock_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin_lock, origin_lock_fragment);
  params->origin_lock.Set(
      origin_lock_fragment.is_null() ? nullptr : origin_lock_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("OpenChannelToPepperPlugin");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PepperHost_OpenChannelToPepperPlugin_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PepperHost_GetPluginInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PepperHost::GetPluginInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PepperHost_GetPluginInfo_ProxyToResponder> proxy(
        new PepperHost_GetPluginInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PepperHost_GetPluginInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PepperHost_GetPluginInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PepperHost_GetPluginInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PepperHost::GetPluginInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_found, const ::content::WebPluginInfo& in_plugin_info, const std::string& in_actual_mime_type);
};

bool PepperHost_GetPluginInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PepperHost_GetPluginInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PepperHost_GetPluginInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PepperHost.2
  bool success = true;
  bool p_found{};
  ::content::WebPluginInfo p_plugin_info{};
  std::string p_actual_mime_type{};
  PepperHost_GetPluginInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_found = input_data_view.found();
  if (success && !input_data_view.ReadPluginInfo(&p_plugin_info))
    success = false;
  if (success && !input_data_view.ReadActualMimeType(&p_actual_mime_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PepperHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_found), 
std::move(p_plugin_info), 
std::move(p_actual_mime_type));
  return true;
}

void PepperHost_GetPluginInfo_ProxyToResponder::Run(
    bool in_found, const ::content::WebPluginInfo& in_plugin_info, const std::string& in_actual_mime_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply content::mojom::PepperHost::GetPluginInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("found"), in_found,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_info"), in_plugin_info,
                        "<value of type const ::content::WebPluginInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("actual_mime_type"), in_actual_mime_type,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHost::kGetPluginInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_GetPluginInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->found = in_found;
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_info)::BaseType> plugin_info_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::WebPluginInfoDataView>(
      in_plugin_info, plugin_info_fragment);
  params->plugin_info.Set(
      plugin_info_fragment.is_null() ? nullptr : plugin_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_info in ");
  mojo::internal::MessageFragment<
      typename decltype(params->actual_mime_type)::BaseType> actual_mime_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_actual_mime_type, actual_mime_type_fragment);
  params->actual_mime_type.Set(
      actual_mime_type_fragment.is_null() ? nullptr : actual_mime_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->actual_mime_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null actual_mime_type in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("GetPluginInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PepperHost_GetPluginInfo_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PepperHost_GetPluginInfo_ResponseParams_Data* params =
      reinterpret_cast<internal::PepperHost_GetPluginInfo_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for PepperHost.2
  bool success = true;
  bool p_found{};
  ::content::WebPluginInfo p_plugin_info{};
  std::string p_actual_mime_type{};
  PepperHost_GetPluginInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_found = input_data_view.found();
  if (success && !input_data_view.ReadPluginInfo(&p_plugin_info))
    success = false;
  if (success && !input_data_view.ReadActualMimeType(&p_actual_mime_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PepperHost::Name_, 2, true);
    return false;
  }
  *out_found_ = std::move(p_found);
  *out_plugin_info_ = std::move(p_plugin_info);
  *out_actual_mime_type_ = std::move(p_actual_mime_type);
  *result_ = true;
  return true;
}
class PepperHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PepperHost::DidCreateOutOfProcessPepperInstanceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PepperHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder> proxy(
        new PepperHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PepperHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PepperHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PepperHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PepperHost::DidCreateOutOfProcessPepperInstanceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PepperHost_DidCreateOutOfProcessPepperInstance_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PepperHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PepperHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PepperHost.5
  bool success = true;
  PepperHost_DidCreateOutOfProcessPepperInstance_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PepperHost::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PepperHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply content::mojom::PepperHost::DidCreateOutOfProcessPepperInstance");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHost::kDidCreateOutOfProcessPepperInstance), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("DidCreateOutOfProcessPepperInstance");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PepperHost_DidCreateOutOfProcessPepperInstance_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PepperHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data* params =
      reinterpret_cast<internal::PepperHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for PepperHost.5
  bool success = true;
  PepperHost_DidCreateOutOfProcessPepperInstance_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PepperHost::Name_, 5, true);
    return false;
  }
  *result_ = true;
  return true;
}
class PepperHost_OpenChannelToPepperPlugin_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PepperHost::OpenChannelToPepperPluginCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PepperHost_OpenChannelToPepperPlugin_ProxyToResponder> proxy(
        new PepperHost_OpenChannelToPepperPlugin_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PepperHost_OpenChannelToPepperPlugin_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PepperHost_OpenChannelToPepperPlugin_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PepperHost_OpenChannelToPepperPlugin_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PepperHost::OpenChannelToPepperPluginCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::ScopedMessagePipeHandle in_handle_to_channel, ::base::ProcessId in_plugin_pid, int32_t in_plugin_child_id);
};

bool PepperHost_OpenChannelToPepperPlugin_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PepperHost_OpenChannelToPepperPlugin_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PepperHost_OpenChannelToPepperPlugin_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PepperHost.7
  bool success = true;
  ::mojo::ScopedMessagePipeHandle p_handle_to_channel{};
  ::base::ProcessId p_plugin_pid{};
  int32_t p_plugin_child_id{};
  PepperHost_OpenChannelToPepperPlugin_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_handle_to_channel = input_data_view.TakeHandleToChannel();
  if (success && !input_data_view.ReadPluginPid(&p_plugin_pid))
    success = false;
  if (success)
    p_plugin_child_id = input_data_view.plugin_child_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PepperHost::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_handle_to_channel), 
std::move(p_plugin_pid), 
std::move(p_plugin_child_id));
  return true;
}

void PepperHost_OpenChannelToPepperPlugin_ProxyToResponder::Run(
    ::mojo::ScopedMessagePipeHandle in_handle_to_channel, ::base::ProcessId in_plugin_pid, int32_t in_plugin_child_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply content::mojom::PepperHost::OpenChannelToPepperPlugin", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handle_to_channel"), in_handle_to_channel,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_pid"), in_plugin_pid,
                        "<value of type ::base::ProcessId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_child_id"), in_plugin_child_id,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHost::kOpenChannelToPepperPlugin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHost_OpenChannelToPepperPlugin_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
      in_handle_to_channel, &params->handle_to_channel, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_pid)::BaseType> plugin_pid_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
      in_plugin_pid, plugin_pid_fragment);
  params->plugin_pid.Set(
      plugin_pid_fragment.is_null() ? nullptr : plugin_pid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_pid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_pid in ");
  params->plugin_child_id = in_plugin_child_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHost::Name_);
  message.set_method_name("OpenChannelToPepperPlugin");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PepperHost_OpenChannelToPepperPlugin_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PepperHost_OpenChannelToPepperPlugin_ResponseParams_Data* params =
      reinterpret_cast<internal::PepperHost_OpenChannelToPepperPlugin_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for PepperHost.7
  bool success = true;
  ::mojo::ScopedMessagePipeHandle p_handle_to_channel{};
  ::base::ProcessId p_plugin_pid{};
  int32_t p_plugin_child_id{};
  PepperHost_OpenChannelToPepperPlugin_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_handle_to_channel = input_data_view.TakeHandleToChannel();
  if (success && !input_data_view.ReadPluginPid(&p_plugin_pid))
    success = false;
  if (success)
    p_plugin_child_id = input_data_view.plugin_child_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PepperHost::Name_, 7, true);
    return false;
  }
  *out_handle_to_channel_ = std::move(p_handle_to_channel);
  *out_plugin_pid_ = std::move(p_plugin_pid);
  *out_plugin_child_id_ = std::move(p_plugin_child_id);
  *result_ = true;
  return true;
}

// static
bool PepperHostStubDispatch::Accept(
    PepperHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PepperHost>(message->header()->name)) {
    case messages::PepperHost::kInstanceCreated: {
      DCHECK(message->is_serialized());
      internal::PepperHost_InstanceCreated_Params_Data* params =
          reinterpret_cast<internal::PepperHost_InstanceCreated_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PepperHost.0
      bool success = true;
      int32_t p_instance_id{};
      ::mojo::PendingAssociatedRemote<PepperPluginInstance> p_instance{};
      ::mojo::PendingAssociatedReceiver<PepperPluginInstanceHost> p_host{};
      PepperHost_InstanceCreated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_instance_id = input_data_view.instance_id();
      if (success) {
        p_instance =
            input_data_view.TakeInstance<decltype(p_instance)>();
      }
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InstanceCreated(        
        std::move(p_instance_id), 
        std::move(p_instance), 
        std::move(p_host));
      return true;
    }
    case messages::PepperHost::kBindHungDetectorHost: {
      DCHECK(message->is_serialized());
      internal::PepperHost_BindHungDetectorHost_Params_Data* params =
          reinterpret_cast<internal::PepperHost_BindHungDetectorHost_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PepperHost.1
      bool success = true;
      ::mojo::PendingReceiver<PepperHungDetectorHost> p_host{};
      int32_t p_plugin_child_id{};
      ::base::FilePath p_plugin_path{};
      PepperHost_BindHungDetectorHost_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (success)
        p_plugin_child_id = input_data_view.plugin_child_id();
      if (success && !input_data_view.ReadPluginPath(&p_plugin_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindHungDetectorHost(        
        std::move(p_host), 
        std::move(p_plugin_child_id), 
        std::move(p_plugin_path));
      return true;
    }
    case messages::PepperHost::kGetPluginInfo: {
      break;
    }
    case messages::PepperHost::kDidCreateInProcessInstance: {
      DCHECK(message->is_serialized());
      internal::PepperHost_DidCreateInProcessInstance_Params_Data* params =
          reinterpret_cast<internal::PepperHost_DidCreateInProcessInstance_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PepperHost.3
      bool success = true;
      int32_t p_instance_id{};
      int32_t p_frame_routing_id{};
      ::GURL p_document_url{};
      ::GURL p_plugin_url{};
      PepperHost_DidCreateInProcessInstance_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_instance_id = input_data_view.instance_id();
      if (success)
        p_frame_routing_id = input_data_view.frame_routing_id();
      if (success && !input_data_view.ReadDocumentUrl(&p_document_url))
        success = false;
      if (success && !input_data_view.ReadPluginUrl(&p_plugin_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCreateInProcessInstance(        
        std::move(p_instance_id), 
        std::move(p_frame_routing_id), 
        std::move(p_document_url), 
        std::move(p_plugin_url));
      return true;
    }
    case messages::PepperHost::kDidDeleteInProcessInstance: {
      DCHECK(message->is_serialized());
      internal::PepperHost_DidDeleteInProcessInstance_Params_Data* params =
          reinterpret_cast<internal::PepperHost_DidDeleteInProcessInstance_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PepperHost.4
      bool success = true;
      int32_t p_instance_id{};
      PepperHost_DidDeleteInProcessInstance_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_instance_id = input_data_view.instance_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDeleteInProcessInstance(        
        std::move(p_instance_id));
      return true;
    }
    case messages::PepperHost::kDidCreateOutOfProcessPepperInstance: {
      break;
    }
    case messages::PepperHost::kDidDeleteOutOfProcessPepperInstance: {
      DCHECK(message->is_serialized());
      internal::PepperHost_DidDeleteOutOfProcessPepperInstance_Params_Data* params =
          reinterpret_cast<internal::PepperHost_DidDeleteOutOfProcessPepperInstance_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PepperHost.6
      bool success = true;
      int32_t p_plugin_child_id{};
      int32_t p_pp_instance{};
      bool p_is_external{};
      PepperHost_DidDeleteOutOfProcessPepperInstance_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_plugin_child_id = input_data_view.plugin_child_id();
      if (success)
        p_pp_instance = input_data_view.pp_instance();
      if (success)
        p_is_external = input_data_view.is_external();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDeleteOutOfProcessPepperInstance(        
        std::move(p_plugin_child_id), 
        std::move(p_pp_instance), 
        std::move(p_is_external));
      return true;
    }
    case messages::PepperHost::kOpenChannelToPepperPlugin: {
      break;
    }
  }
  return false;
}

// static
bool PepperHostStubDispatch::AcceptWithResponder(
    PepperHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PepperHost>(message->header()->name)) {
    case messages::PepperHost::kInstanceCreated: {
      break;
    }
    case messages::PepperHost::kBindHungDetectorHost: {
      break;
    }
    case messages::PepperHost::kGetPluginInfo: {
      internal::PepperHost_GetPluginInfo_Params_Data* params =
          reinterpret_cast<
              internal::PepperHost_GetPluginInfo_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PepperHost.2
      bool success = true;
      ::GURL p_url{};
      std::string p_mime_type{};
      PepperHost_GetPluginInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadMimeType(&p_mime_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperHost::Name_, 2, false);
        return false;
      }
      PepperHost::GetPluginInfoCallback callback =
          PepperHost_GetPluginInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPluginInfo(        
        std::move(p_url), 
        std::move(p_mime_type), std::move(callback));
      return true;
    }
    case messages::PepperHost::kDidCreateInProcessInstance: {
      break;
    }
    case messages::PepperHost::kDidDeleteInProcessInstance: {
      break;
    }
    case messages::PepperHost::kDidCreateOutOfProcessPepperInstance: {
      internal::PepperHost_DidCreateOutOfProcessPepperInstance_Params_Data* params =
          reinterpret_cast<
              internal::PepperHost_DidCreateOutOfProcessPepperInstance_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PepperHost.5
      bool success = true;
      int32_t p_plugin_child_id{};
      int32_t p_pp_instance{};
      bool p_is_external{};
      int32_t p_frame_routing_id{};
      ::GURL p_document_url{};
      ::GURL p_plugin_url{};
      bool p_is_privileged_context{};
      PepperHost_DidCreateOutOfProcessPepperInstance_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_plugin_child_id = input_data_view.plugin_child_id();
      if (success)
        p_pp_instance = input_data_view.pp_instance();
      if (success)
        p_is_external = input_data_view.is_external();
      if (success)
        p_frame_routing_id = input_data_view.frame_routing_id();
      if (success && !input_data_view.ReadDocumentUrl(&p_document_url))
        success = false;
      if (success && !input_data_view.ReadPluginUrl(&p_plugin_url))
        success = false;
      if (success)
        p_is_privileged_context = input_data_view.is_privileged_context();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperHost::Name_, 5, false);
        return false;
      }
      PepperHost::DidCreateOutOfProcessPepperInstanceCallback callback =
          PepperHost_DidCreateOutOfProcessPepperInstance_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCreateOutOfProcessPepperInstance(        
        std::move(p_plugin_child_id), 
        std::move(p_pp_instance), 
        std::move(p_is_external), 
        std::move(p_frame_routing_id), 
        std::move(p_document_url), 
        std::move(p_plugin_url), 
        std::move(p_is_privileged_context), std::move(callback));
      return true;
    }
    case messages::PepperHost::kDidDeleteOutOfProcessPepperInstance: {
      break;
    }
    case messages::PepperHost::kOpenChannelToPepperPlugin: {
      internal::PepperHost_OpenChannelToPepperPlugin_Params_Data* params =
          reinterpret_cast<
              internal::PepperHost_OpenChannelToPepperPlugin_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PepperHost.7
      bool success = true;
      ::url::Origin p_embedder_origin{};
      ::base::FilePath p_path{};
      std::optional<::url::Origin> p_origin_lock{};
      PepperHost_OpenChannelToPepperPlugin_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEmbedderOrigin(&p_embedder_origin))
        success = false;
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadOriginLock(&p_origin_lock))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperHost::Name_, 7, false);
        return false;
      }
      PepperHost::OpenChannelToPepperPluginCallback callback =
          PepperHost_OpenChannelToPepperPlugin_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenChannelToPepperPlugin(        
        std::move(p_embedder_origin), 
        std::move(p_path), 
        std::move(p_origin_lock), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPepperHostValidationInfo[] = {
    {base::to_underlying(messages::PepperHost::kInstanceCreated),
     { &internal::PepperHost_InstanceCreated_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PepperHost::kBindHungDetectorHost),
     { &internal::PepperHost_BindHungDetectorHost_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PepperHost::kGetPluginInfo),
     { &internal::PepperHost_GetPluginInfo_Params_Data::Validate,
      &internal::PepperHost_GetPluginInfo_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PepperHost::kDidCreateInProcessInstance),
     { &internal::PepperHost_DidCreateInProcessInstance_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PepperHost::kDidDeleteInProcessInstance),
     { &internal::PepperHost_DidDeleteInProcessInstance_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PepperHost::kDidCreateOutOfProcessPepperInstance),
     { &internal::PepperHost_DidCreateOutOfProcessPepperInstance_Params_Data::Validate,
      &internal::PepperHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PepperHost::kDidDeleteOutOfProcessPepperInstance),
     { &internal::PepperHost_DidDeleteOutOfProcessPepperInstance_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PepperHost::kOpenChannelToPepperPlugin),
     { &internal::PepperHost_OpenChannelToPepperPlugin_Params_Data::Validate,
      &internal::PepperHost_OpenChannelToPepperPlugin_ResponseParams_Data::Validate}},
};

bool PepperHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::PepperHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPepperHostValidationInfo);
}

bool PepperHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::PepperHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPepperHostValidationInfo);

}
const char PepperHungDetectorHost::Name_[] = "content.mojom.PepperHungDetectorHost";

PepperHungDetectorHost::IPCStableHashFunction PepperHungDetectorHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PepperHungDetectorHost>(message.name())) {
    case messages::PepperHungDetectorHost::kPluginHung: {
      return &PepperHungDetectorHost::PluginHung_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PepperHungDetectorHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PepperHungDetectorHost>(message.name())) {
      case messages::PepperHungDetectorHost::kPluginHung:
            return "Receive content::mojom::PepperHungDetectorHost::PluginHung";
    }
  } else {
    switch (static_cast<messages::PepperHungDetectorHost>(message.name())) {
      case messages::PepperHungDetectorHost::kPluginHung:
            return "Receive reply content::mojom::PepperHungDetectorHost::PluginHung";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PepperHungDetectorHost::PluginHung_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::PepperHungDetectorHost::PluginHung");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PepperHungDetectorHostProxy::PepperHungDetectorHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PepperHungDetectorHostProxy::PluginHung(
    bool in_is_hung) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::PepperHungDetectorHost::PluginHung", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_hung"), in_is_hung,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperHungDetectorHost::kPluginHung), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperHungDetectorHost_PluginHung_Params_Data> params(
          message);
  params.Allocate();
  params->is_hung = in_is_hung;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperHungDetectorHost::Name_);
  message.set_method_name("PluginHung");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PepperHungDetectorHostStubDispatch::Accept(
    PepperHungDetectorHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PepperHungDetectorHost>(message->header()->name)) {
    case messages::PepperHungDetectorHost::kPluginHung: {
      DCHECK(message->is_serialized());
      internal::PepperHungDetectorHost_PluginHung_Params_Data* params =
          reinterpret_cast<internal::PepperHungDetectorHost_PluginHung_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PepperHungDetectorHost.0
      bool success = true;
      bool p_is_hung{};
      PepperHungDetectorHost_PluginHung_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_hung = input_data_view.is_hung();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperHungDetectorHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PluginHung(        
        std::move(p_is_hung));
      return true;
    }
  }
  return false;
}

// static
bool PepperHungDetectorHostStubDispatch::AcceptWithResponder(
    PepperHungDetectorHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PepperHungDetectorHost>(message->header()->name)) {
    case messages::PepperHungDetectorHost::kPluginHung: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPepperHungDetectorHostValidationInfo[] = {
    {base::to_underlying(messages::PepperHungDetectorHost::kPluginHung),
     { &internal::PepperHungDetectorHost_PluginHung_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PepperHungDetectorHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::PepperHungDetectorHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPepperHungDetectorHostValidationInfo);
}

const char PepperPluginInstanceHost::Name_[] = "content.mojom.PepperPluginInstanceHost";

PepperPluginInstanceHost::IPCStableHashFunction PepperPluginInstanceHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PepperPluginInstanceHost>(message.name())) {
    case messages::PepperPluginInstanceHost::kStartsPlayback: {
      return &PepperPluginInstanceHost::StartsPlayback_Sym::IPCStableHash;
    }
    case messages::PepperPluginInstanceHost::kStopsPlayback: {
      return &PepperPluginInstanceHost::StopsPlayback_Sym::IPCStableHash;
    }
    case messages::PepperPluginInstanceHost::kInstanceCrashed: {
      return &PepperPluginInstanceHost::InstanceCrashed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PepperPluginInstanceHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PepperPluginInstanceHost>(message.name())) {
      case messages::PepperPluginInstanceHost::kStartsPlayback:
            return "Receive content::mojom::PepperPluginInstanceHost::StartsPlayback";
      case messages::PepperPluginInstanceHost::kStopsPlayback:
            return "Receive content::mojom::PepperPluginInstanceHost::StopsPlayback";
      case messages::PepperPluginInstanceHost::kInstanceCrashed:
            return "Receive content::mojom::PepperPluginInstanceHost::InstanceCrashed";
    }
  } else {
    switch (static_cast<messages::PepperPluginInstanceHost>(message.name())) {
      case messages::PepperPluginInstanceHost::kStartsPlayback:
            return "Receive reply content::mojom::PepperPluginInstanceHost::StartsPlayback";
      case messages::PepperPluginInstanceHost::kStopsPlayback:
            return "Receive reply content::mojom::PepperPluginInstanceHost::StopsPlayback";
      case messages::PepperPluginInstanceHost::kInstanceCrashed:
            return "Receive reply content::mojom::PepperPluginInstanceHost::InstanceCrashed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PepperPluginInstanceHost::StartsPlayback_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::PepperPluginInstanceHost::StartsPlayback");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PepperPluginInstanceHost::StopsPlayback_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::PepperPluginInstanceHost::StopsPlayback");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PepperPluginInstanceHost::InstanceCrashed_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::PepperPluginInstanceHost::InstanceCrashed");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PepperPluginInstanceHostProxy::PepperPluginInstanceHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PepperPluginInstanceHostProxy::StartsPlayback(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::PepperPluginInstanceHost::StartsPlayback");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperPluginInstanceHost::kStartsPlayback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperPluginInstanceHost_StartsPlayback_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperPluginInstanceHost::Name_);
  message.set_method_name("StartsPlayback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PepperPluginInstanceHostProxy::StopsPlayback(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::PepperPluginInstanceHost::StopsPlayback");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperPluginInstanceHost::kStopsPlayback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperPluginInstanceHost_StopsPlayback_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperPluginInstanceHost::Name_);
  message.set_method_name("StopsPlayback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PepperPluginInstanceHostProxy::InstanceCrashed(
    const ::base::FilePath& in_plugin_path, ::base::ProcessId in_plugin_pid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::PepperPluginInstanceHost::InstanceCrashed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_path"), in_plugin_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_pid"), in_plugin_pid,
                        "<value of type ::base::ProcessId>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperPluginInstanceHost::kInstanceCrashed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperPluginInstanceHost_InstanceCrashed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_path)::BaseType> plugin_path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_plugin_path, plugin_path_fragment);
  params->plugin_path.Set(
      plugin_path_fragment.is_null() ? nullptr : plugin_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_path in PepperPluginInstanceHost.InstanceCrashed request");
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_pid)::BaseType> plugin_pid_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
      in_plugin_pid, plugin_pid_fragment);
  params->plugin_pid.Set(
      plugin_pid_fragment.is_null() ? nullptr : plugin_pid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_pid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_pid in PepperPluginInstanceHost.InstanceCrashed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperPluginInstanceHost::Name_);
  message.set_method_name("InstanceCrashed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PepperPluginInstanceHostStubDispatch::Accept(
    PepperPluginInstanceHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PepperPluginInstanceHost>(message->header()->name)) {
    case messages::PepperPluginInstanceHost::kStartsPlayback: {
      DCHECK(message->is_serialized());
      internal::PepperPluginInstanceHost_StartsPlayback_Params_Data* params =
          reinterpret_cast<internal::PepperPluginInstanceHost_StartsPlayback_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PepperPluginInstanceHost.0
      bool success = true;
      PepperPluginInstanceHost_StartsPlayback_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperPluginInstanceHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartsPlayback(        );
      return true;
    }
    case messages::PepperPluginInstanceHost::kStopsPlayback: {
      DCHECK(message->is_serialized());
      internal::PepperPluginInstanceHost_StopsPlayback_Params_Data* params =
          reinterpret_cast<internal::PepperPluginInstanceHost_StopsPlayback_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PepperPluginInstanceHost.1
      bool success = true;
      PepperPluginInstanceHost_StopsPlayback_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperPluginInstanceHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopsPlayback(        );
      return true;
    }
    case messages::PepperPluginInstanceHost::kInstanceCrashed: {
      DCHECK(message->is_serialized());
      internal::PepperPluginInstanceHost_InstanceCrashed_Params_Data* params =
          reinterpret_cast<internal::PepperPluginInstanceHost_InstanceCrashed_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PepperPluginInstanceHost.2
      bool success = true;
      ::base::FilePath p_plugin_path{};
      ::base::ProcessId p_plugin_pid{};
      PepperPluginInstanceHost_InstanceCrashed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPluginPath(&p_plugin_path))
        success = false;
      if (success && !input_data_view.ReadPluginPid(&p_plugin_pid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperPluginInstanceHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InstanceCrashed(        
        std::move(p_plugin_path), 
        std::move(p_plugin_pid));
      return true;
    }
  }
  return false;
}

// static
bool PepperPluginInstanceHostStubDispatch::AcceptWithResponder(
    PepperPluginInstanceHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PepperPluginInstanceHost>(message->header()->name)) {
    case messages::PepperPluginInstanceHost::kStartsPlayback: {
      break;
    }
    case messages::PepperPluginInstanceHost::kStopsPlayback: {
      break;
    }
    case messages::PepperPluginInstanceHost::kInstanceCrashed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPepperPluginInstanceHostValidationInfo[] = {
    {base::to_underlying(messages::PepperPluginInstanceHost::kStartsPlayback),
     { &internal::PepperPluginInstanceHost_StartsPlayback_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PepperPluginInstanceHost::kStopsPlayback),
     { &internal::PepperPluginInstanceHost_StopsPlayback_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PepperPluginInstanceHost::kInstanceCrashed),
     { &internal::PepperPluginInstanceHost_InstanceCrashed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PepperPluginInstanceHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::PepperPluginInstanceHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPepperPluginInstanceHostValidationInfo);
}

const char PepperPluginInstance::Name_[] = "content.mojom.PepperPluginInstance";

PepperPluginInstance::IPCStableHashFunction PepperPluginInstance::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PepperPluginInstance>(message.name())) {
    case messages::PepperPluginInstance::kSetVolume: {
      return &PepperPluginInstance::SetVolume_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PepperPluginInstance::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PepperPluginInstance>(message.name())) {
      case messages::PepperPluginInstance::kSetVolume:
            return "Receive content::mojom::PepperPluginInstance::SetVolume";
    }
  } else {
    switch (static_cast<messages::PepperPluginInstance>(message.name())) {
      case messages::PepperPluginInstance::kSetVolume:
            return "Receive reply content::mojom::PepperPluginInstance::SetVolume";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PepperPluginInstance::SetVolume_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::PepperPluginInstance::SetVolume");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PepperPluginInstanceProxy::PepperPluginInstanceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PepperPluginInstanceProxy::SetVolume(
    double in_volume) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::PepperPluginInstance::SetVolume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("volume"), in_volume,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PepperPluginInstance::kSetVolume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::PepperPluginInstance_SetVolume_Params_Data> params(
          message);
  params.Allocate();
  params->volume = in_volume;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PepperPluginInstance::Name_);
  message.set_method_name("SetVolume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PepperPluginInstanceStubDispatch::Accept(
    PepperPluginInstance* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PepperPluginInstance>(message->header()->name)) {
    case messages::PepperPluginInstance::kSetVolume: {
      DCHECK(message->is_serialized());
      internal::PepperPluginInstance_SetVolume_Params_Data* params =
          reinterpret_cast<internal::PepperPluginInstance_SetVolume_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PepperPluginInstance.0
      bool success = true;
      double p_volume{};
      PepperPluginInstance_SetVolume_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_volume = input_data_view.volume();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PepperPluginInstance::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVolume(        
        std::move(p_volume));
      return true;
    }
  }
  return false;
}

// static
bool PepperPluginInstanceStubDispatch::AcceptWithResponder(
    PepperPluginInstance* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PepperPluginInstance>(message->header()->name)) {
    case messages::PepperPluginInstance::kSetVolume: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPepperPluginInstanceValidationInfo[] = {
    {base::to_underlying(messages::PepperPluginInstance::kSetVolume),
     { &internal::PepperPluginInstance_SetVolume_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PepperPluginInstanceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::PepperPluginInstance::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPepperPluginInstanceValidationInfo);
}



}  // content::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void PepperHostInterceptorForTesting::InstanceCreated(int32_t instance_id, ::mojo::PendingAssociatedRemote<PepperPluginInstance> instance, ::mojo::PendingAssociatedReceiver<PepperPluginInstanceHost> host) {
  GetForwardingInterface()->InstanceCreated(
    std::move(instance_id)
    , 
    std::move(instance)
    , 
    std::move(host)
    );
}
void PepperHostInterceptorForTesting::BindHungDetectorHost(::mojo::PendingReceiver<PepperHungDetectorHost> host, int32_t plugin_child_id, const ::base::FilePath& plugin_path) {
  GetForwardingInterface()->BindHungDetectorHost(
    std::move(host)
    , 
    std::move(plugin_child_id)
    , 
    std::move(plugin_path)
    );
}
void PepperHostInterceptorForTesting::GetPluginInfo(const ::GURL& url, const std::string& mime_type, GetPluginInfoCallback callback) {
  GetForwardingInterface()->GetPluginInfo(
    std::move(url)
    , 
    std::move(mime_type)
    , std::move(callback));
}
void PepperHostInterceptorForTesting::DidCreateInProcessInstance(int32_t instance_id, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url) {
  GetForwardingInterface()->DidCreateInProcessInstance(
    std::move(instance_id)
    , 
    std::move(frame_routing_id)
    , 
    std::move(document_url)
    , 
    std::move(plugin_url)
    );
}
void PepperHostInterceptorForTesting::DidDeleteInProcessInstance(int32_t instance_id) {
  GetForwardingInterface()->DidDeleteInProcessInstance(
    std::move(instance_id)
    );
}
void PepperHostInterceptorForTesting::DidCreateOutOfProcessPepperInstance(int32_t plugin_child_id, int32_t pp_instance, bool is_external, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url, bool is_privileged_context, DidCreateOutOfProcessPepperInstanceCallback callback) {
  GetForwardingInterface()->DidCreateOutOfProcessPepperInstance(
    std::move(plugin_child_id)
    , 
    std::move(pp_instance)
    , 
    std::move(is_external)
    , 
    std::move(frame_routing_id)
    , 
    std::move(document_url)
    , 
    std::move(plugin_url)
    , 
    std::move(is_privileged_context)
    , std::move(callback));
}
void PepperHostInterceptorForTesting::DidDeleteOutOfProcessPepperInstance(int32_t plugin_child_id, int32_t pp_instance, bool is_external) {
  GetForwardingInterface()->DidDeleteOutOfProcessPepperInstance(
    std::move(plugin_child_id)
    , 
    std::move(pp_instance)
    , 
    std::move(is_external)
    );
}
void PepperHostInterceptorForTesting::OpenChannelToPepperPlugin(const ::url::Origin& embedder_origin, const ::base::FilePath& path, const std::optional<::url::Origin>& origin_lock, OpenChannelToPepperPluginCallback callback) {
  GetForwardingInterface()->OpenChannelToPepperPlugin(
    std::move(embedder_origin)
    , 
    std::move(path)
    , 
    std::move(origin_lock)
    , std::move(callback));
}
PepperHostAsyncWaiter::PepperHostAsyncWaiter(
    PepperHost* proxy) : proxy_(proxy) {}

PepperHostAsyncWaiter::~PepperHostAsyncWaiter() = default;

void PepperHostAsyncWaiter::GetPluginInfo(
    const ::GURL& url, const std::string& mime_type, bool* out_found, ::content::WebPluginInfo* out_plugin_info, std::string* out_actual_mime_type) {
  base::RunLoop loop;
  proxy_->GetPluginInfo(
      std::move(url),
      std::move(mime_type),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_found
,
             ::content::WebPluginInfo* out_plugin_info
,
             std::string* out_actual_mime_type
,
             bool found,
             const ::content::WebPluginInfo& plugin_info,
             const std::string& actual_mime_type) {*out_found = std::move(found);*out_plugin_info = std::move(plugin_info);*out_actual_mime_type = std::move(actual_mime_type);
            loop->Quit();
          },
          &loop,
          out_found,
          out_plugin_info,
          out_actual_mime_type));
  loop.Run();
}



void PepperHostAsyncWaiter::DidCreateOutOfProcessPepperInstance(
    int32_t plugin_child_id, int32_t pp_instance, bool is_external, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url, bool is_privileged_context) {
  base::RunLoop loop;
  proxy_->DidCreateOutOfProcessPepperInstance(
      std::move(plugin_child_id),
      std::move(pp_instance),
      std::move(is_external),
      std::move(frame_routing_id),
      std::move(document_url),
      std::move(plugin_url),
      std::move(is_privileged_context),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void PepperHostAsyncWaiter::OpenChannelToPepperPlugin(
    const ::url::Origin& embedder_origin, const ::base::FilePath& path, const std::optional<::url::Origin>& origin_lock, ::mojo::ScopedMessagePipeHandle* out_handle_to_channel, ::base::ProcessId* out_plugin_pid, int32_t* out_plugin_child_id) {
  base::RunLoop loop;
  proxy_->OpenChannelToPepperPlugin(
      std::move(embedder_origin),
      std::move(path),
      std::move(origin_lock),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::ScopedMessagePipeHandle* out_handle_to_channel
,
             ::base::ProcessId* out_plugin_pid
,
             int32_t* out_plugin_child_id
,
             ::mojo::ScopedMessagePipeHandle handle_to_channel,
             ::base::ProcessId plugin_pid,
             int32_t plugin_child_id) {*out_handle_to_channel = std::move(handle_to_channel);*out_plugin_pid = std::move(plugin_pid);*out_plugin_child_id = std::move(plugin_child_id);
            loop->Quit();
          },
          &loop,
          out_handle_to_channel,
          out_plugin_pid,
          out_plugin_child_id));
  loop.Run();
}






void PepperHungDetectorHostInterceptorForTesting::PluginHung(bool is_hung) {
  GetForwardingInterface()->PluginHung(
    std::move(is_hung)
    );
}
PepperHungDetectorHostAsyncWaiter::PepperHungDetectorHostAsyncWaiter(
    PepperHungDetectorHost* proxy) : proxy_(proxy) {}

PepperHungDetectorHostAsyncWaiter::~PepperHungDetectorHostAsyncWaiter() = default;




void PepperPluginInstanceHostInterceptorForTesting::StartsPlayback() {
  GetForwardingInterface()->StartsPlayback();
}
void PepperPluginInstanceHostInterceptorForTesting::StopsPlayback() {
  GetForwardingInterface()->StopsPlayback();
}
void PepperPluginInstanceHostInterceptorForTesting::InstanceCrashed(const ::base::FilePath& plugin_path, ::base::ProcessId plugin_pid) {
  GetForwardingInterface()->InstanceCrashed(
    std::move(plugin_path)
    , 
    std::move(plugin_pid)
    );
}
PepperPluginInstanceHostAsyncWaiter::PepperPluginInstanceHostAsyncWaiter(
    PepperPluginInstanceHost* proxy) : proxy_(proxy) {}

PepperPluginInstanceHostAsyncWaiter::~PepperPluginInstanceHostAsyncWaiter() = default;




void PepperPluginInstanceInterceptorForTesting::SetVolume(double volume) {
  GetForwardingInterface()->SetVolume(
    std::move(volume)
    );
}
PepperPluginInstanceAsyncWaiter::PepperPluginInstanceAsyncWaiter(
    PepperPluginInstance* proxy) : proxy_(proxy) {}

PepperPluginInstanceAsyncWaiter::~PepperPluginInstanceAsyncWaiter() = default;






}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif