// content/common/pepper_plugin.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/common/pepper_plugin.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/pepper_plugin.mojom-params-data.h"
namespace content {
namespace mojom {

namespace internal {


// static
bool PepperHost_InstanceCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperHost_InstanceCreated_Params_Data* object =
      static_cast<const PepperHost_InstanceCreated_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->instance, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->instance,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PepperHost_InstanceCreated_Params_Data::PepperHost_InstanceCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperHost_BindHungDetectorHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperHost_BindHungDetectorHost_Params_Data* object =
      static_cast<const PepperHost_BindHungDetectorHost_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->plugin_path, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->plugin_path, validation_context))
    return false;

  return true;
}

PepperHost_BindHungDetectorHost_Params_Data::PepperHost_BindHungDetectorHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperHost_GetPluginInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperHost_GetPluginInfo_Params_Data* object =
      static_cast<const PepperHost_GetPluginInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  return true;
}

PepperHost_GetPluginInfo_Params_Data::PepperHost_GetPluginInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperHost_GetPluginInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperHost_GetPluginInfo_ResponseParams_Data* object =
      static_cast<const PepperHost_GetPluginInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->plugin_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->plugin_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->actual_mime_type, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& actual_mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->actual_mime_type, validation_context,
                                         &actual_mime_type_validate_params)) {
    return false;
  }

  return true;
}

PepperHost_GetPluginInfo_ResponseParams_Data::PepperHost_GetPluginInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperHost_DidCreateInProcessInstance_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperHost_DidCreateInProcessInstance_Params_Data* object =
      static_cast<const PepperHost_DidCreateInProcessInstance_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->document_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->plugin_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->plugin_url, validation_context))
    return false;

  return true;
}

PepperHost_DidCreateInProcessInstance_Params_Data::PepperHost_DidCreateInProcessInstance_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperHost_DidDeleteInProcessInstance_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperHost_DidDeleteInProcessInstance_Params_Data* object =
      static_cast<const PepperHost_DidDeleteInProcessInstance_Params_Data*>(data);

  return true;
}

PepperHost_DidDeleteInProcessInstance_Params_Data::PepperHost_DidDeleteInProcessInstance_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperHost_DidCreateOutOfProcessPepperInstance_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperHost_DidCreateOutOfProcessPepperInstance_Params_Data* object =
      static_cast<const PepperHost_DidCreateOutOfProcessPepperInstance_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->document_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->plugin_url, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->plugin_url, validation_context))
    return false;

  return true;
}

PepperHost_DidCreateOutOfProcessPepperInstance_Params_Data::PepperHost_DidCreateOutOfProcessPepperInstance_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data* object =
      static_cast<const PepperHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data*>(data);

  return true;
}

PepperHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data::PepperHost_DidCreateOutOfProcessPepperInstance_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperHost_DidDeleteOutOfProcessPepperInstance_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperHost_DidDeleteOutOfProcessPepperInstance_Params_Data* object =
      static_cast<const PepperHost_DidDeleteOutOfProcessPepperInstance_Params_Data*>(data);

  return true;
}

PepperHost_DidDeleteOutOfProcessPepperInstance_Params_Data::PepperHost_DidDeleteOutOfProcessPepperInstance_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperHost_OpenChannelToPepperPlugin_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperHost_OpenChannelToPepperPlugin_Params_Data* object =
      static_cast<const PepperHost_OpenChannelToPepperPlugin_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->embedder_origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->embedder_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->origin_lock, validation_context))
    return false;

  return true;
}

PepperHost_OpenChannelToPepperPlugin_Params_Data::PepperHost_OpenChannelToPepperPlugin_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperHost_OpenChannelToPepperPlugin_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperHost_OpenChannelToPepperPlugin_ResponseParams_Data* object =
      static_cast<const PepperHost_OpenChannelToPepperPlugin_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->handle_to_channel,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->plugin_pid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->plugin_pid, validation_context))
    return false;

  return true;
}

PepperHost_OpenChannelToPepperPlugin_ResponseParams_Data::PepperHost_OpenChannelToPepperPlugin_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperHungDetectorHost_PluginHung_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperHungDetectorHost_PluginHung_Params_Data* object =
      static_cast<const PepperHungDetectorHost_PluginHung_Params_Data*>(data);

  return true;
}

PepperHungDetectorHost_PluginHung_Params_Data::PepperHungDetectorHost_PluginHung_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperPluginInstanceHost_StartsPlayback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperPluginInstanceHost_StartsPlayback_Params_Data* object =
      static_cast<const PepperPluginInstanceHost_StartsPlayback_Params_Data*>(data);

  return true;
}

PepperPluginInstanceHost_StartsPlayback_Params_Data::PepperPluginInstanceHost_StartsPlayback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperPluginInstanceHost_StopsPlayback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperPluginInstanceHost_StopsPlayback_Params_Data* object =
      static_cast<const PepperPluginInstanceHost_StopsPlayback_Params_Data*>(data);

  return true;
}

PepperPluginInstanceHost_StopsPlayback_Params_Data::PepperPluginInstanceHost_StopsPlayback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperPluginInstanceHost_InstanceCrashed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperPluginInstanceHost_InstanceCrashed_Params_Data* object =
      static_cast<const PepperPluginInstanceHost_InstanceCrashed_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->plugin_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->plugin_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->plugin_pid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->plugin_pid, validation_context))
    return false;

  return true;
}

PepperPluginInstanceHost_InstanceCrashed_Params_Data::PepperPluginInstanceHost_InstanceCrashed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PepperPluginInstance_SetVolume_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PepperPluginInstance_SetVolume_Params_Data* object =
      static_cast<const PepperPluginInstance_SetVolume_Params_Data*>(data);

  return true;
}

PepperPluginInstance_SetVolume_Params_Data::PepperPluginInstance_SetVolume_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content