// content/common/download/mhtml_file_writer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/download/mhtml_file_writer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/download/mhtml_file_writer.mojom-params-data.h"
#include "content/common/download/mhtml_file_writer.mojom-shared-message-ids.h"

#include "content/common/download/mhtml_file_writer.mojom-import-headers.h"
#include "content/common/download/mhtml_file_writer.mojom-test-utils.h"


namespace content::mojom {
SerializeAsMHTMLParams::SerializeAsMHTMLParams()
    : mhtml_boundary_marker(),
      mhtml_binary_encoding(),
      mhtml_popup_overlay_removal(),
      digests_of_uris_to_skip(),
      salt(),
      output_handle() {}

SerializeAsMHTMLParams::SerializeAsMHTMLParams(
    const std::string& mhtml_boundary_marker_in,
    bool mhtml_binary_encoding_in,
    bool mhtml_popup_overlay_removal_in,
    std::vector<std::string> digests_of_uris_to_skip_in,
    const std::string& salt_in,
    MhtmlOutputHandlePtr output_handle_in)
    : mhtml_boundary_marker(std::move(mhtml_boundary_marker_in)),
      mhtml_binary_encoding(std::move(mhtml_binary_encoding_in)),
      mhtml_popup_overlay_removal(std::move(mhtml_popup_overlay_removal_in)),
      digests_of_uris_to_skip(std::move(digests_of_uris_to_skip_in)),
      salt(std::move(salt_in)),
      output_handle(std::move(output_handle_in)) {}

SerializeAsMHTMLParams::~SerializeAsMHTMLParams() = default;

void SerializeAsMHTMLParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mhtml_boundary_marker"), this->mhtml_boundary_marker,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mhtml_binary_encoding"), this->mhtml_binary_encoding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mhtml_popup_overlay_removal"), this->mhtml_popup_overlay_removal,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "digests_of_uris_to_skip"), this->digests_of_uris_to_skip,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "salt"), this->salt,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_handle"), this->output_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MhtmlOutputHandlePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SerializeAsMHTMLParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MhtmlOutputHandle::MhtmlOutputHandle() : tag_(Tag::kFileHandle) {
  data_.file_handle = new ::base::File;
}

MhtmlOutputHandle::~MhtmlOutputHandle() {
  DestroyActive();
}


void MhtmlOutputHandle::set_file_handle(
    ::base::File file_handle) {
  if (tag_ == Tag::kFileHandle) {
    *(data_.file_handle) = std::move(file_handle);
  } else {
    DestroyActive();
    tag_ = Tag::kFileHandle;
    data_.file_handle = new ::base::File(
        std::move(file_handle));
  }
}
void MhtmlOutputHandle::set_producer_handle(
    ::mojo::ScopedDataPipeProducerHandle producer_handle) {
  if (tag_ == Tag::kProducerHandle) {
    *(data_.producer_handle) = std::move(producer_handle);
  } else {
    DestroyActive();
    tag_ = Tag::kProducerHandle;
    data_.producer_handle = new ::mojo::ScopedDataPipeProducerHandle(
        std::move(producer_handle));
  }
}

void MhtmlOutputHandle::DestroyActive() {
  switch (tag_) {

    case Tag::kFileHandle:

      delete data_.file_handle;
      break;
    case Tag::kProducerHandle:

      delete data_.producer_handle;
      break;
  }
}

bool MhtmlOutputHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char MhtmlFileWriter::Name_[] = "content.mojom.MhtmlFileWriter";

MhtmlFileWriter::IPCStableHashFunction MhtmlFileWriter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MhtmlFileWriter>(message.name())) {
    case messages::MhtmlFileWriter::kSerializeAsMHTML: {
      return &MhtmlFileWriter::SerializeAsMHTML_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MhtmlFileWriter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MhtmlFileWriter>(message.name())) {
      case messages::MhtmlFileWriter::kSerializeAsMHTML:
            return "Receive content::mojom::MhtmlFileWriter::SerializeAsMHTML";
    }
  } else {
    switch (static_cast<messages::MhtmlFileWriter>(message.name())) {
      case messages::MhtmlFileWriter::kSerializeAsMHTML:
            return "Receive reply content::mojom::MhtmlFileWriter::SerializeAsMHTML";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MhtmlFileWriter::SerializeAsMHTML_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::MhtmlFileWriter::SerializeAsMHTML");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MhtmlFileWriter_SerializeAsMHTML_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MhtmlFileWriter_SerializeAsMHTML_ForwardToCallback(
      MhtmlFileWriter::SerializeAsMHTMLCallback callback
      ) : callback_(std::move(callback)) {
  }

  MhtmlFileWriter_SerializeAsMHTML_ForwardToCallback(const MhtmlFileWriter_SerializeAsMHTML_ForwardToCallback&) = delete;
  MhtmlFileWriter_SerializeAsMHTML_ForwardToCallback& operator=(const MhtmlFileWriter_SerializeAsMHTML_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MhtmlFileWriter::SerializeAsMHTMLCallback callback_;
};

MhtmlFileWriterProxy::MhtmlFileWriterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MhtmlFileWriterProxy::SerializeAsMHTML(
    SerializeAsMHTMLParamsPtr in_params, SerializeAsMHTMLCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::MhtmlFileWriter::SerializeAsMHTML", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type SerializeAsMHTMLParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MhtmlFileWriter::kSerializeAsMHTML), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::MhtmlFileWriter_SerializeAsMHTML_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::SerializeAsMHTMLParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in MhtmlFileWriter.SerializeAsMHTML request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MhtmlFileWriter::Name_);
  message.set_method_name("SerializeAsMHTML");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MhtmlFileWriter_SerializeAsMHTML_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MhtmlFileWriter_SerializeAsMHTML_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MhtmlFileWriter::SerializeAsMHTMLCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MhtmlFileWriter_SerializeAsMHTML_ProxyToResponder> proxy(
        new MhtmlFileWriter_SerializeAsMHTML_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MhtmlFileWriter_SerializeAsMHTML_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MhtmlFileWriter_SerializeAsMHTML_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MhtmlFileWriter_SerializeAsMHTML_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MhtmlFileWriter::SerializeAsMHTMLCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      MhtmlSaveStatus in_status, const std::vector<std::string>& in_digests_of_uris_to_skip);
};

bool MhtmlFileWriter_SerializeAsMHTML_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for MhtmlFileWriter.0
  bool success = true;
  MhtmlSaveStatus p_status{};
  std::vector<std::string> p_digests_of_uris_to_skip{};
  MhtmlFileWriter_SerializeAsMHTML_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadDigestsOfUrisToSkip(&p_digests_of_uris_to_skip))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MhtmlFileWriter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_digests_of_uris_to_skip));
  return true;
}

void MhtmlFileWriter_SerializeAsMHTML_ProxyToResponder::Run(
    MhtmlSaveStatus in_status, const std::vector<std::string>& in_digests_of_uris_to_skip) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply content::mojom::MhtmlFileWriter::SerializeAsMHTML", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type MhtmlSaveStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("digests_of_uris_to_skip"), in_digests_of_uris_to_skip,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MhtmlFileWriter::kSerializeAsMHTML), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::content::mojom::MhtmlSaveStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->digests_of_uris_to_skip)::BaseType>
      digests_of_uris_to_skip_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& digests_of_uris_to_skip_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>>(
      in_digests_of_uris_to_skip, digests_of_uris_to_skip_fragment, &digests_of_uris_to_skip_validate_params);
  params->digests_of_uris_to_skip.Set(
      digests_of_uris_to_skip_fragment.is_null() ? nullptr : digests_of_uris_to_skip_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->digests_of_uris_to_skip.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null digests_of_uris_to_skip in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MhtmlFileWriter::Name_);
  message.set_method_name("SerializeAsMHTML");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MhtmlFileWriterStubDispatch::Accept(
    MhtmlFileWriter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MhtmlFileWriter>(message->header()->name)) {
    case messages::MhtmlFileWriter::kSerializeAsMHTML: {
      break;
    }
  }
  return false;
}

// static
bool MhtmlFileWriterStubDispatch::AcceptWithResponder(
    MhtmlFileWriter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MhtmlFileWriter>(message->header()->name)) {
    case messages::MhtmlFileWriter::kSerializeAsMHTML: {
      internal::MhtmlFileWriter_SerializeAsMHTML_Params_Data* params =
          reinterpret_cast<
              internal::MhtmlFileWriter_SerializeAsMHTML_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for MhtmlFileWriter.0
      bool success = true;
      SerializeAsMHTMLParamsPtr p_params{};
      MhtmlFileWriter_SerializeAsMHTML_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MhtmlFileWriter::Name_, 0, false);
        return false;
      }
      MhtmlFileWriter::SerializeAsMHTMLCallback callback =
          MhtmlFileWriter_SerializeAsMHTML_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SerializeAsMHTML(        
        std::move(p_params), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMhtmlFileWriterValidationInfo[] = {
    {base::to_underlying(messages::MhtmlFileWriter::kSerializeAsMHTML),
     { &internal::MhtmlFileWriter_SerializeAsMHTML_Params_Data::Validate,
      &internal::MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data::Validate}},
};

bool MhtmlFileWriterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::MhtmlFileWriter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMhtmlFileWriterValidationInfo);
}

bool MhtmlFileWriterResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::MhtmlFileWriter::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kMhtmlFileWriterValidationInfo);

}


}  // content::mojom


namespace mojo {


// static
bool StructTraits<::content::mojom::SerializeAsMHTMLParams::DataView, ::content::mojom::SerializeAsMHTMLParamsPtr>::Read(
    ::content::mojom::SerializeAsMHTMLParams::DataView input,
    ::content::mojom::SerializeAsMHTMLParamsPtr* output) {
  bool success = true;
  ::content::mojom::SerializeAsMHTMLParamsPtr result(::content::mojom::SerializeAsMHTMLParams::New());
  
      if (success && !input.ReadMhtmlBoundaryMarker(&result->mhtml_boundary_marker))
        success = false;
      if (success)
        result->mhtml_binary_encoding = input.mhtml_binary_encoding();
      if (success)
        result->mhtml_popup_overlay_removal = input.mhtml_popup_overlay_removal();
      if (success && !input.ReadDigestsOfUrisToSkip(&result->digests_of_uris_to_skip))
        success = false;
      if (success && !input.ReadSalt(&result->salt))
        success = false;
      if (success && !input.ReadOutputHandle(&result->output_handle))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::content::mojom::MhtmlOutputHandle::DataView, ::content::mojom::MhtmlOutputHandlePtr>::Read(
    ::content::mojom::MhtmlOutputHandle::DataView input,
    ::content::mojom::MhtmlOutputHandlePtr* output) {
  using UnionType = ::content::mojom::MhtmlOutputHandle;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kFileHandle: {
      ::base::File result_file_handle;
      if (!input.ReadFileHandle(&result_file_handle))
        return false;

      *output = UnionType::NewFileHandle(
          std::move(result_file_handle));
      break;
    }
    case Tag::kProducerHandle: {
      *output = UnionType::NewProducerHandle(
          input.TakeProducerHandle());
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void MhtmlFileWriterInterceptorForTesting::SerializeAsMHTML(SerializeAsMHTMLParamsPtr params, SerializeAsMHTMLCallback callback) {
  GetForwardingInterface()->SerializeAsMHTML(
    std::move(params)
    , std::move(callback));
}
MhtmlFileWriterAsyncWaiter::MhtmlFileWriterAsyncWaiter(
    MhtmlFileWriter* proxy) : proxy_(proxy) {}

MhtmlFileWriterAsyncWaiter::~MhtmlFileWriterAsyncWaiter() = default;

void MhtmlFileWriterAsyncWaiter::SerializeAsMHTML(
    SerializeAsMHTMLParamsPtr params, MhtmlSaveStatus* out_status, std::vector<std::string>* out_digests_of_uris_to_skip) {
  base::RunLoop loop;
  proxy_->SerializeAsMHTML(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             MhtmlSaveStatus* out_status
,
             std::vector<std::string>* out_digests_of_uris_to_skip
,
             MhtmlSaveStatus status,
             const std::vector<std::string>& digests_of_uris_to_skip) {*out_status = std::move(status);*out_digests_of_uris_to_skip = std::move(digests_of_uris_to_skip);
            loop->Quit();
          },
          &loop,
          out_status,
          out_digests_of_uris_to_skip));
  loop.Run();
}








}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif