// components/visitedlink/common/visitedlink.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/visitedlink/common/visitedlink.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/visitedlink/common/visitedlink.mojom-params-data.h"
#include "components/visitedlink/common/visitedlink.mojom-shared-message-ids.h"

#include "components/visitedlink/common/visitedlink.mojom-import-headers.h"
#include "components/visitedlink/common/visitedlink.mojom-test-utils.h"


namespace visitedlink::mojom {
const char VisitedLinkNotificationSink::Name_[] = "visitedlink.mojom.VisitedLinkNotificationSink";

VisitedLinkNotificationSink::IPCStableHashFunction VisitedLinkNotificationSink::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VisitedLinkNotificationSink>(message.name())) {
    case messages::VisitedLinkNotificationSink::kUpdateVisitedLinks: {
      return &VisitedLinkNotificationSink::UpdateVisitedLinks_Sym::IPCStableHash;
    }
    case messages::VisitedLinkNotificationSink::kAddVisitedLinks: {
      return &VisitedLinkNotificationSink::AddVisitedLinks_Sym::IPCStableHash;
    }
    case messages::VisitedLinkNotificationSink::kResetVisitedLinks: {
      return &VisitedLinkNotificationSink::ResetVisitedLinks_Sym::IPCStableHash;
    }
    case messages::VisitedLinkNotificationSink::kUpdateOriginSalts: {
      return &VisitedLinkNotificationSink::UpdateOriginSalts_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VisitedLinkNotificationSink::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VisitedLinkNotificationSink>(message.name())) {
      case messages::VisitedLinkNotificationSink::kUpdateVisitedLinks:
            return "Receive visitedlink::mojom::VisitedLinkNotificationSink::UpdateVisitedLinks";
      case messages::VisitedLinkNotificationSink::kAddVisitedLinks:
            return "Receive visitedlink::mojom::VisitedLinkNotificationSink::AddVisitedLinks";
      case messages::VisitedLinkNotificationSink::kResetVisitedLinks:
            return "Receive visitedlink::mojom::VisitedLinkNotificationSink::ResetVisitedLinks";
      case messages::VisitedLinkNotificationSink::kUpdateOriginSalts:
            return "Receive visitedlink::mojom::VisitedLinkNotificationSink::UpdateOriginSalts";
    }
  } else {
    switch (static_cast<messages::VisitedLinkNotificationSink>(message.name())) {
      case messages::VisitedLinkNotificationSink::kUpdateVisitedLinks:
            return "Receive reply visitedlink::mojom::VisitedLinkNotificationSink::UpdateVisitedLinks";
      case messages::VisitedLinkNotificationSink::kAddVisitedLinks:
            return "Receive reply visitedlink::mojom::VisitedLinkNotificationSink::AddVisitedLinks";
      case messages::VisitedLinkNotificationSink::kResetVisitedLinks:
            return "Receive reply visitedlink::mojom::VisitedLinkNotificationSink::ResetVisitedLinks";
      case messages::VisitedLinkNotificationSink::kUpdateOriginSalts:
            return "Receive reply visitedlink::mojom::VisitedLinkNotificationSink::UpdateOriginSalts";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VisitedLinkNotificationSink::UpdateVisitedLinks_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)visitedlink::mojom::VisitedLinkNotificationSink::UpdateVisitedLinks");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VisitedLinkNotificationSink::AddVisitedLinks_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)visitedlink::mojom::VisitedLinkNotificationSink::AddVisitedLinks");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VisitedLinkNotificationSink::ResetVisitedLinks_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)visitedlink::mojom::VisitedLinkNotificationSink::ResetVisitedLinks");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VisitedLinkNotificationSink::UpdateOriginSalts_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)visitedlink::mojom::VisitedLinkNotificationSink::UpdateOriginSalts");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VisitedLinkNotificationSinkProxy::VisitedLinkNotificationSinkProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VisitedLinkNotificationSinkProxy::UpdateVisitedLinks(
    ::base::ReadOnlySharedMemoryRegion in_table_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send visitedlink::mojom::VisitedLinkNotificationSink::UpdateVisitedLinks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("table_region"), in_table_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VisitedLinkNotificationSink::kUpdateVisitedLinks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::visitedlink::mojom::internal::VisitedLinkNotificationSink_UpdateVisitedLinks_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->table_region)::BaseType> table_region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_table_region, table_region_fragment);
  params->table_region.Set(
      table_region_fragment.is_null() ? nullptr : table_region_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->table_region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null table_region in VisitedLinkNotificationSink.UpdateVisitedLinks request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VisitedLinkNotificationSink::Name_);
  message.set_method_name("UpdateVisitedLinks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VisitedLinkNotificationSinkProxy::AddVisitedLinks(
    const std::vector<uint64_t>& in_link_hashes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send visitedlink::mojom::VisitedLinkNotificationSink::AddVisitedLinks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("link_hashes"), in_link_hashes,
                        "<value of type const std::vector<uint64_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VisitedLinkNotificationSink::kAddVisitedLinks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::visitedlink::mojom::internal::VisitedLinkNotificationSink_AddVisitedLinks_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->link_hashes)::BaseType>
      link_hashes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& link_hashes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>>(
      in_link_hashes, link_hashes_fragment, &link_hashes_validate_params);
  params->link_hashes.Set(
      link_hashes_fragment.is_null() ? nullptr : link_hashes_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->link_hashes.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null link_hashes in VisitedLinkNotificationSink.AddVisitedLinks request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VisitedLinkNotificationSink::Name_);
  message.set_method_name("AddVisitedLinks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VisitedLinkNotificationSinkProxy::ResetVisitedLinks(
    bool in_invalidate_cached_hashes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send visitedlink::mojom::VisitedLinkNotificationSink::ResetVisitedLinks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("invalidate_cached_hashes"), in_invalidate_cached_hashes,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VisitedLinkNotificationSink::kResetVisitedLinks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::visitedlink::mojom::internal::VisitedLinkNotificationSink_ResetVisitedLinks_Params_Data> params(
          message);
  params.Allocate();
  params->invalidate_cached_hashes = in_invalidate_cached_hashes;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VisitedLinkNotificationSink::Name_);
  message.set_method_name("ResetVisitedLinks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VisitedLinkNotificationSinkProxy::UpdateOriginSalts(
    const base::flat_map<::url::Origin, uint64_t>& in_origin_salts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send visitedlink::mojom::VisitedLinkNotificationSink::UpdateOriginSalts", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin_salts"), in_origin_salts,
                        "<value of type const base::flat_map<::url::Origin, uint64_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VisitedLinkNotificationSink::kUpdateOriginSalts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::visitedlink::mojom::internal::VisitedLinkNotificationSink_UpdateOriginSalts_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin_salts)::BaseType>
      origin_salts_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& origin_salts_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, uint64_t>>(
      in_origin_salts, origin_salts_fragment, &origin_salts_validate_params);
  params->origin_salts.Set(
      origin_salts_fragment.is_null() ? nullptr : origin_salts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin_salts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin_salts in VisitedLinkNotificationSink.UpdateOriginSalts request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VisitedLinkNotificationSink::Name_);
  message.set_method_name("UpdateOriginSalts");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VisitedLinkNotificationSinkStubDispatch::Accept(
    VisitedLinkNotificationSink* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VisitedLinkNotificationSink>(message->header()->name)) {
    case messages::VisitedLinkNotificationSink::kUpdateVisitedLinks: {
      DCHECK(message->is_serialized());
      internal::VisitedLinkNotificationSink_UpdateVisitedLinks_Params_Data* params =
          reinterpret_cast<internal::VisitedLinkNotificationSink_UpdateVisitedLinks_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VisitedLinkNotificationSink.0
      bool success = true;
      ::base::ReadOnlySharedMemoryRegion p_table_region{};
      VisitedLinkNotificationSink_UpdateVisitedLinks_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTableRegion(&p_table_region))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VisitedLinkNotificationSink::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateVisitedLinks(        
        std::move(p_table_region));
      return true;
    }
    case messages::VisitedLinkNotificationSink::kAddVisitedLinks: {
      DCHECK(message->is_serialized());
      internal::VisitedLinkNotificationSink_AddVisitedLinks_Params_Data* params =
          reinterpret_cast<internal::VisitedLinkNotificationSink_AddVisitedLinks_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VisitedLinkNotificationSink.1
      bool success = true;
      std::vector<uint64_t> p_link_hashes{};
      VisitedLinkNotificationSink_AddVisitedLinks_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLinkHashes(&p_link_hashes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VisitedLinkNotificationSink::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddVisitedLinks(        
        std::move(p_link_hashes));
      return true;
    }
    case messages::VisitedLinkNotificationSink::kResetVisitedLinks: {
      DCHECK(message->is_serialized());
      internal::VisitedLinkNotificationSink_ResetVisitedLinks_Params_Data* params =
          reinterpret_cast<internal::VisitedLinkNotificationSink_ResetVisitedLinks_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VisitedLinkNotificationSink.2
      bool success = true;
      bool p_invalidate_cached_hashes{};
      VisitedLinkNotificationSink_ResetVisitedLinks_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_invalidate_cached_hashes = input_data_view.invalidate_cached_hashes();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VisitedLinkNotificationSink::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetVisitedLinks(        
        std::move(p_invalidate_cached_hashes));
      return true;
    }
    case messages::VisitedLinkNotificationSink::kUpdateOriginSalts: {
      DCHECK(message->is_serialized());
      internal::VisitedLinkNotificationSink_UpdateOriginSalts_Params_Data* params =
          reinterpret_cast<internal::VisitedLinkNotificationSink_UpdateOriginSalts_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VisitedLinkNotificationSink.3
      bool success = true;
      base::flat_map<::url::Origin, uint64_t> p_origin_salts{};
      VisitedLinkNotificationSink_UpdateOriginSalts_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOriginSalts(&p_origin_salts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VisitedLinkNotificationSink::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateOriginSalts(        
        std::move(p_origin_salts));
      return true;
    }
  }
  return false;
}

// static
bool VisitedLinkNotificationSinkStubDispatch::AcceptWithResponder(
    VisitedLinkNotificationSink* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VisitedLinkNotificationSink>(message->header()->name)) {
    case messages::VisitedLinkNotificationSink::kUpdateVisitedLinks: {
      break;
    }
    case messages::VisitedLinkNotificationSink::kAddVisitedLinks: {
      break;
    }
    case messages::VisitedLinkNotificationSink::kResetVisitedLinks: {
      break;
    }
    case messages::VisitedLinkNotificationSink::kUpdateOriginSalts: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVisitedLinkNotificationSinkValidationInfo[] = {
    {base::to_underlying(messages::VisitedLinkNotificationSink::kUpdateVisitedLinks),
     { &internal::VisitedLinkNotificationSink_UpdateVisitedLinks_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VisitedLinkNotificationSink::kAddVisitedLinks),
     { &internal::VisitedLinkNotificationSink_AddVisitedLinks_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VisitedLinkNotificationSink::kResetVisitedLinks),
     { &internal::VisitedLinkNotificationSink_ResetVisitedLinks_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VisitedLinkNotificationSink::kUpdateOriginSalts),
     { &internal::VisitedLinkNotificationSink_UpdateOriginSalts_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VisitedLinkNotificationSinkRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::visitedlink::mojom::VisitedLinkNotificationSink::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVisitedLinkNotificationSinkValidationInfo);
}



}  // visitedlink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace visitedlink::mojom {


void VisitedLinkNotificationSinkInterceptorForTesting::UpdateVisitedLinks(::base::ReadOnlySharedMemoryRegion table_region) {
  GetForwardingInterface()->UpdateVisitedLinks(
    std::move(table_region)
    );
}
void VisitedLinkNotificationSinkInterceptorForTesting::AddVisitedLinks(const std::vector<uint64_t>& link_hashes) {
  GetForwardingInterface()->AddVisitedLinks(
    std::move(link_hashes)
    );
}
void VisitedLinkNotificationSinkInterceptorForTesting::ResetVisitedLinks(bool invalidate_cached_hashes) {
  GetForwardingInterface()->ResetVisitedLinks(
    std::move(invalidate_cached_hashes)
    );
}
void VisitedLinkNotificationSinkInterceptorForTesting::UpdateOriginSalts(const base::flat_map<::url::Origin, uint64_t>& origin_salts) {
  GetForwardingInterface()->UpdateOriginSalts(
    std::move(origin_salts)
    );
}
VisitedLinkNotificationSinkAsyncWaiter::VisitedLinkNotificationSinkAsyncWaiter(
    VisitedLinkNotificationSink* proxy) : proxy_(proxy) {}

VisitedLinkNotificationSinkAsyncWaiter::~VisitedLinkNotificationSinkAsyncWaiter() = default;






}  // visitedlink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif