// components/input/render_input_router.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace input::mojom {
namespace internal {
class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM_SHARED) RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::TouchTransferState_Data> state;

 private:
  friend class mojo::internal::MessageFragment<RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data>;

  RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data();
  ~RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data() = delete;
};
static_assert(sizeof(RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data) == 16,
              "Bad sizeof(RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data)");
class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM_SHARED) RenderInputRouterDelegate_NotifySiteIsMobileOptimized_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_mobile_optimized : 1;
  uint8_t pad0_[7];
  mojo::internal::Pointer<::viz::mojom::internal::FrameSinkId_Data> frame_sink_id;

 private:
  friend class mojo::internal::MessageFragment<RenderInputRouterDelegate_NotifySiteIsMobileOptimized_Params_Data>;

  RenderInputRouterDelegate_NotifySiteIsMobileOptimized_Params_Data();
  ~RenderInputRouterDelegate_NotifySiteIsMobileOptimized_Params_Data() = delete;
};
static_assert(sizeof(RenderInputRouterDelegate_NotifySiteIsMobileOptimized_Params_Data) == 24,
              "Bad sizeof(RenderInputRouterDelegate_NotifySiteIsMobileOptimized_Params_Data)");
class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM_SHARED) RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t force_enable_zoom : 1;
  uint8_t pad0_[7];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::viz::mojom::internal::FrameSinkId_Data>>> frame_sink_ids;

 private:
  friend class mojo::internal::MessageFragment<RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data>;

  RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data();
  ~RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data() = delete;
};
static_assert(sizeof(RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data) == 24,
              "Bad sizeof(RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data)");
class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM_SHARED) RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::viz::mojom::internal::FrameSinkId_Data> id;
  mojo::internal::Pointer<::blink::mojom::internal::Event_Data> event;
  uint8_t dispatched_to_renderer : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data>;

  RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data();
  ~RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data() = delete;
};
static_assert(sizeof(RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data) == 32,
              "Bad sizeof(RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data)");
class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM_SHARED) RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::viz::mojom::internal::FrameSinkId_Data> id;
  int32_t ack_source;
  int32_t ack_result;
  mojo::internal::Pointer<::blink::mojom::internal::Event_Data> event;

 private:
  friend class mojo::internal::MessageFragment<RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data>;

  RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data();
  ~RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data() = delete;
};
static_assert(sizeof(RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data) == 32,
              "Bad sizeof(RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data)");
class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM_SHARED) RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::viz::mojom::internal::FrameSinkId_Data> id;

 private:
  friend class mojo::internal::MessageFragment<RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data>;

  RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data();
  ~RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data() = delete;
};
static_assert(sizeof(RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data) == 16,
              "Bad sizeof(RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data)");

}  // namespace internal


class RenderInputRouterDelegate_StateOnTouchTransfer_ParamsDataView {
 public:
  RenderInputRouterDelegate_StateOnTouchTransfer_ParamsDataView() = default;

  RenderInputRouterDelegate_StateOnTouchTransfer_ParamsDataView(
      internal::RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStateDataView(
      TouchTransferStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) {
    
    auto* pointer = data_->state.Get();
    return mojo::internal::Deserialize<::input::mojom::TouchTransferStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RenderInputRouterDelegate_NotifySiteIsMobileOptimized_ParamsDataView {
 public:
  RenderInputRouterDelegate_NotifySiteIsMobileOptimized_ParamsDataView() = default;

  RenderInputRouterDelegate_NotifySiteIsMobileOptimized_ParamsDataView(
      internal::RenderInputRouterDelegate_NotifySiteIsMobileOptimized_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_mobile_optimized() const {
    return data_->is_mobile_optimized;
  }
  inline void GetFrameSinkIdDataView(
      ::viz::mojom::FrameSinkIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameSinkId(UserType* output) {
    
    auto* pointer = data_->frame_sink_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameSinkIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::RenderInputRouterDelegate_NotifySiteIsMobileOptimized_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RenderInputRouterDelegate_ForceEnableZoomStateChanged_ParamsDataView {
 public:
  RenderInputRouterDelegate_ForceEnableZoomStateChanged_ParamsDataView() = default;

  RenderInputRouterDelegate_ForceEnableZoomStateChanged_ParamsDataView(
      internal::RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool force_enable_zoom() const {
    return data_->force_enable_zoom;
  }
  inline void GetFrameSinkIdsDataView(
      mojo::ArrayDataView<::viz::mojom::FrameSinkIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameSinkIds(UserType* output) {
    
    auto* pointer = data_->frame_sink_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::FrameSinkIdDataView>>(
        pointer, output, message_);
  }
 private:
  internal::RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_ParamsDataView {
 public:
  RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_ParamsDataView() = default;

  RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_ParamsDataView(
      internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::viz::mojom::FrameSinkIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameSinkIdDataView>(
        pointer, output, message_);
  }
  inline void GetEventDataView(
      ::blink::mojom::EventDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEvent(UserType* output) {
    
    auto* pointer = data_->event.Get();
    return mojo::internal::Deserialize<::blink::mojom::EventDataView>(
        pointer, output, message_);
  }
  bool dispatched_to_renderer() const {
    return data_->dispatched_to_renderer;
  }
 private:
  internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_ParamsDataView {
 public:
  RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_ParamsDataView() = default;

  RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_ParamsDataView(
      internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::viz::mojom::FrameSinkIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameSinkIdDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAckSource(UserType* output) const {
    auto data_value = data_->ack_source;
    return mojo::internal::Deserialize<::blink::mojom::InputEventResultSource>(
        data_value, output);
  }
  ::blink::mojom::InputEventResultSource ack_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InputEventResultSource>(data_->ack_source));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAckResult(UserType* output) const {
    auto data_value = data_->ack_result;
    return mojo::internal::Deserialize<::blink::mojom::InputEventResultState>(
        data_value, output);
  }
  ::blink::mojom::InputEventResultState ack_result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InputEventResultState>(data_->ack_result));
  }
  inline void GetEventDataView(
      ::blink::mojom::EventDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEvent(UserType* output) {
    
    auto* pointer = data_->event.Get();
    return mojo::internal::Deserialize<::blink::mojom::EventDataView>(
        pointer, output, message_);
  }
 private:
  internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RenderInputRouterDelegateClient_OnInvalidInputEventSource_ParamsDataView {
 public:
  RenderInputRouterDelegateClient_OnInvalidInputEventSource_ParamsDataView() = default;

  RenderInputRouterDelegateClient_OnInvalidInputEventSource_ParamsDataView(
      internal::RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::viz::mojom::FrameSinkIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameSinkIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void RenderInputRouterDelegate_StateOnTouchTransfer_ParamsDataView::GetStateDataView(
    TouchTransferStateDataView* output) {
  auto pointer = data_->state.Get();
  *output = TouchTransferStateDataView(pointer, message_);
}


inline void RenderInputRouterDelegate_NotifySiteIsMobileOptimized_ParamsDataView::GetFrameSinkIdDataView(
    ::viz::mojom::FrameSinkIdDataView* output) {
  auto pointer = data_->frame_sink_id.Get();
  *output = ::viz::mojom::FrameSinkIdDataView(pointer, message_);
}


inline void RenderInputRouterDelegate_ForceEnableZoomStateChanged_ParamsDataView::GetFrameSinkIdsDataView(
    mojo::ArrayDataView<::viz::mojom::FrameSinkIdDataView>* output) {
  auto pointer = data_->frame_sink_ids.Get();
  *output = mojo::ArrayDataView<::viz::mojom::FrameSinkIdDataView>(pointer, message_);
}


inline void RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_ParamsDataView::GetIdDataView(
    ::viz::mojom::FrameSinkIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::viz::mojom::FrameSinkIdDataView(pointer, message_);
}
inline void RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_ParamsDataView::GetEventDataView(
    ::blink::mojom::EventDataView* output) {
  auto pointer = data_->event.Get();
  *output = ::blink::mojom::EventDataView(pointer, message_);
}


inline void RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_ParamsDataView::GetIdDataView(
    ::viz::mojom::FrameSinkIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::viz::mojom::FrameSinkIdDataView(pointer, message_);
}
inline void RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_ParamsDataView::GetEventDataView(
    ::blink::mojom::EventDataView* output) {
  auto pointer = data_->event.Get();
  *output = ::blink::mojom::EventDataView(pointer, message_);
}


inline void RenderInputRouterDelegateClient_OnInvalidInputEventSource_ParamsDataView::GetIdDataView(
    ::viz::mojom::FrameSinkIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::viz::mojom::FrameSinkIdDataView(pointer, message_);
}



}  // input::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_PARAMS_DATA_H_