// components/attribution_reporting/registration_header_error.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_SHARED_H_
#define COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/attribution_reporting/registration_header_error.mojom-shared-internal.h"
#include "components/attribution_reporting/os_registration_error.mojom-shared.h"
#include "components/attribution_reporting/source_registration_error.mojom-shared.h"
#include "components/attribution_reporting/trigger_registration_error.mojom-shared.h"







namespace attribution_reporting::mojom {
class RegistrationHeaderErrorDataView;

class RegistrationHeaderErrorDetailsDataView;


}  // attribution_reporting::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::RegistrationHeaderErrorDataView> {
  using Data = ::attribution_reporting::mojom::internal::RegistrationHeaderError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView> {
  using Data = ::attribution_reporting::mojom::internal::RegistrationHeaderErrorDetails_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace attribution_reporting::mojom {


class RegistrationHeaderErrorDataView {
 public:
  RegistrationHeaderErrorDataView() = default;

  RegistrationHeaderErrorDataView(
      internal::RegistrationHeaderError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHeaderValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaderValue(UserType* output) {
    
    auto* pointer = data_->header_value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetErrorDetailsDataView(
      RegistrationHeaderErrorDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorDetails(UserType* output) {
    
    auto* pointer = !data_->error_details.is_null() ? &data_->error_details : nullptr;
    return mojo::internal::Deserialize<::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView>(
        pointer, output, message_);
  }
 private:
  internal::RegistrationHeaderError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RegistrationHeaderErrorDetailsDataView {
 public:
  using Tag = internal::RegistrationHeaderErrorDetails_Data::RegistrationHeaderErrorDetails_Tag;

  RegistrationHeaderErrorDetailsDataView() = default;

  RegistrationHeaderErrorDetailsDataView(
      internal::RegistrationHeaderErrorDetails_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_source_error() const { return data_->tag == Tag::kSourceError; }
  template <typename UserType>
  [[nodiscard]] bool ReadSourceError(UserType* output) const {
    CHECK(is_source_error());
    return mojo::internal::Deserialize<::attribution_reporting::mojom::SourceRegistrationError>(
        data_->data.f_source_error, output);
  }
  ::attribution_reporting::mojom::SourceRegistrationError source_error() const {
    CHECK(is_source_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::attribution_reporting::mojom::SourceRegistrationError>(data_->data.f_source_error));
  }
  bool is_trigger_error() const { return data_->tag == Tag::kTriggerError; }
  template <typename UserType>
  [[nodiscard]] bool ReadTriggerError(UserType* output) const {
    CHECK(is_trigger_error());
    return mojo::internal::Deserialize<::attribution_reporting::mojom::TriggerRegistrationError>(
        data_->data.f_trigger_error, output);
  }
  ::attribution_reporting::mojom::TriggerRegistrationError trigger_error() const {
    CHECK(is_trigger_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::attribution_reporting::mojom::TriggerRegistrationError>(data_->data.f_trigger_error));
  }
  bool is_os_source_error() const { return data_->tag == Tag::kOsSourceError; }
  template <typename UserType>
  [[nodiscard]] bool ReadOsSourceError(UserType* output) const {
    CHECK(is_os_source_error());
    return mojo::internal::Deserialize<::attribution_reporting::mojom::OsRegistrationError>(
        data_->data.f_os_source_error, output);
  }
  ::attribution_reporting::mojom::OsRegistrationError os_source_error() const {
    CHECK(is_os_source_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::attribution_reporting::mojom::OsRegistrationError>(data_->data.f_os_source_error));
  }
  bool is_os_trigger_error() const { return data_->tag == Tag::kOsTriggerError; }
  template <typename UserType>
  [[nodiscard]] bool ReadOsTriggerError(UserType* output) const {
    CHECK(is_os_trigger_error());
    return mojo::internal::Deserialize<::attribution_reporting::mojom::OsRegistrationError>(
        data_->data.f_os_trigger_error, output);
  }
  ::attribution_reporting::mojom::OsRegistrationError os_trigger_error() const {
    CHECK(is_os_trigger_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::attribution_reporting::mojom::OsRegistrationError>(data_->data.f_os_trigger_error));
  }

 private:
  internal::RegistrationHeaderErrorDetails_Data* data_ = nullptr;
};



}  // attribution_reporting::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::attribution_reporting::mojom::RegistrationHeaderErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::RegistrationHeaderErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::RegistrationHeaderError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::header_value(input)) in_header_value = Traits::header_value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->header_value)::BaseType> header_value_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_header_value, header_value_fragment);
    fragment->header_value.Set(
        header_value_fragment.is_null() ? nullptr : header_value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->header_value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null header_value in RegistrationHeaderError struct");
    decltype(Traits::error_details(input)) in_error_details = Traits::error_details(input);
    mojo::internal::MessageFragment<decltype(fragment->error_details)>
        error_details_fragment(fragment.message());
    error_details_fragment.Claim(&fragment->error_details);
    mojo::internal::Serialize<::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView>(
        in_error_details, error_details_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->error_details.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null error_details in RegistrationHeaderError struct");
  }

  static bool Deserialize(::attribution_reporting::mojom::internal::RegistrationHeaderError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::attribution_reporting::mojom::RegistrationHeaderErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::attribution_reporting::mojom::internal::RegistrationHeaderErrorDetails_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView::Tag::kSourceError: {
        decltype(Traits::source_error(input))
            in_source_error = Traits::source_error(input);
        mojo::internal::Serialize<::attribution_reporting::mojom::SourceRegistrationError>(
            in_source_error, &fragment->data.f_source_error);
        break;
      }
      case ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView::Tag::kTriggerError: {
        decltype(Traits::trigger_error(input))
            in_trigger_error = Traits::trigger_error(input);
        mojo::internal::Serialize<::attribution_reporting::mojom::TriggerRegistrationError>(
            in_trigger_error, &fragment->data.f_trigger_error);
        break;
      }
      case ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView::Tag::kOsSourceError: {
        decltype(Traits::os_source_error(input))
            in_os_source_error = Traits::os_source_error(input);
        mojo::internal::Serialize<::attribution_reporting::mojom::OsRegistrationError>(
            in_os_source_error, &fragment->data.f_os_source_error);
        break;
      }
      case ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView::Tag::kOsTriggerError: {
        decltype(Traits::os_trigger_error(input))
            in_os_trigger_error = Traits::os_trigger_error(input);
        mojo::internal::Serialize<::attribution_reporting::mojom::OsRegistrationError>(
            in_os_trigger_error, &fragment->data.f_os_trigger_error);
        break;
      }
    }
  }

  static bool Deserialize(::attribution_reporting::mojom::internal::RegistrationHeaderErrorDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace attribution_reporting::mojom {

inline void RegistrationHeaderErrorDataView::GetHeaderValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->header_value.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RegistrationHeaderErrorDataView::GetErrorDetailsDataView(
    RegistrationHeaderErrorDetailsDataView* output) {
  auto pointer = &data_->error_details;
  *output = RegistrationHeaderErrorDetailsDataView(pointer, message_);
}




}  // attribution_reporting::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_SHARED_H_