// python wrapper for vtkPythonView
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPythonView.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPythonView(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPythonView_ClassNew(); }


static PyObject *
PyvtkPythonView_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPythonView::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPythonView::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPythonView *tempr = vtkPythonView::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPythonView *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPythonView::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPythonView::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPythonView::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_REQUEST_DELIVER_DATA_TO_CLIENT(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "REQUEST_DELIVER_DATA_TO_CLIENT");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationRequestKey *tempr = vtkPythonView::REQUEST_DELIVER_DATA_TO_CLIENT();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_Update(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Update");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Update();
    }
    else
    {
      op->vtkPythonView::Update();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_GetRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderer *tempr = (ap.IsBound() ?
      op->GetRenderer() :
      op->vtkPythonView::GetRenderer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_SetRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    if (ap.IsBound())
    {
      op->SetRenderer(temp0);
    }
    else
    {
      op->vtkPythonView::SetRenderer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_SetScript(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScript");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScript(temp0);
    }
    else
    {
      op->vtkPythonView::SetScript(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_GetScript(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetScript");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetScript() :
      op->vtkPythonView::GetScript());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_SetMagnification_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMagnification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetMagnification(temp0, temp1);
    }
    else
    {
      op->vtkPythonView::SetMagnification(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPythonView_SetMagnification_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMagnification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetMagnification(temp0);
    }
    else
    {
      op->vtkPythonView::SetMagnification(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPythonView_SetMagnification(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPythonView_SetMagnification_s1(self, args);
    case 1:
      return PyvtkPythonView_SetMagnification_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetMagnification");
  return nullptr;
}


static PyObject *
PyvtkPythonView_GetMagnification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMagnification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetMagnification() :
      op->vtkPythonView::GetMagnification());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_GetNumberOfVisibleDataObjects(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfVisibleDataObjects");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfVisibleDataObjects() :
      op->vtkPythonView::GetNumberOfVisibleDataObjects());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_GetVisibleRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVisibleRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPythonRepresentation *tempr = (ap.IsBound() ?
      op->GetVisibleRepresentation(temp0) :
      op->vtkPythonView::GetVisibleRepresentation(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_GetVisibleDataObjectForSetup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVisibleDataObjectForSetup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkDataObject *tempr = (ap.IsBound() ?
      op->GetVisibleDataObjectForSetup(temp0) :
      op->vtkPythonView::GetVisibleDataObjectForSetup(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_GetVisibleDataObjectForRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVisibleDataObjectForRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkDataObject *tempr = (ap.IsBound() ?
      op->GetVisibleDataObjectForRendering(temp0) :
      op->vtkPythonView::GetVisibleDataObjectForRendering(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_GetNumberOfAttributeArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfAttributeArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfAttributeArrays(temp0, temp1) :
      op->vtkPythonView::GetNumberOfAttributeArrays(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_GetAttributeArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAttributeArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  int temp0;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetAttributeArrayName(temp0, temp1, temp2) :
      op->vtkPythonView::GetAttributeArrayName(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_SetAttributeArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAttributeArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  int temp0;
  int temp1;
  const char *temp2 = nullptr;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetAttributeArrayStatus(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPythonView::SetAttributeArrayStatus(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_GetAttributeArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAttributeArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  int temp0;
  int temp1;
  const char *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    int tempr = (ap.IsBound() ?
      op->GetAttributeArrayStatus(temp0, temp1, temp2) :
      op->vtkPythonView::GetAttributeArrayStatus(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_EnableAllAttributeArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableAllAttributeArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableAllAttributeArrays();
    }
    else
    {
      op->vtkPythonView::EnableAllAttributeArrays();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_DisableAllAttributeArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DisableAllAttributeArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DisableAllAttributeArrays();
    }
    else
    {
      op->vtkPythonView::DisableAllAttributeArrays();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_StillRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StillRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->StillRender();
    }
    else
    {
      op->vtkPythonView::StillRender();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_InteractiveRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InteractiveRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InteractiveRender();
    }
    else
    {
      op->vtkPythonView::InteractiveRender();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonView_SetImageData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImageData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonView *op = static_cast<vtkPythonView *>(vp);

  vtkImageData *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkImageData"))
  {
    if (ap.IsBound())
    {
      op->SetImageData(temp0);
    }
    else
    {
      op->vtkPythonView::SetImageData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPythonView_Methods[] = {
  {"IsTypeOf", PyvtkPythonView_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPythonView_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPythonView_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPythonView\nC++: static vtkPythonView *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPythonView_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPythonView\nC++: vtkPythonView *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPythonView_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPythonView_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"REQUEST_DELIVER_DATA_TO_CLIENT", PyvtkPythonView_REQUEST_DELIVER_DATA_TO_CLIENT, METH_VARARGS,
   "REQUEST_DELIVER_DATA_TO_CLIENT() -> vtkInformationRequestKey\nC++: static vtkInformationRequestKey *REQUEST_DELIVER_DATA_TO_CLIENT(\n    )\n\nThis is a pass for delivering data from the server nodes to the\nclient.\n"},
  {"Update", PyvtkPythonView_Update, METH_VARARGS,
   "Update(self) -> None\nC++: void Update() override;\n\nOverrides the base class method to request an addition pass that\nmoves data from the server to the client.\n"},
  {"GetRenderer", PyvtkPythonView_GetRenderer, METH_VARARGS,
   "GetRenderer(self) -> vtkRenderer\nC++: virtual vtkRenderer *GetRenderer()\n\nGets the renderer for this view.\n"},
  {"SetRenderer", PyvtkPythonView_SetRenderer, METH_VARARGS,
   "SetRenderer(self, ren:vtkRenderer) -> None\nC++: virtual void SetRenderer(vtkRenderer *ren)\n\n"},
  {"SetScript", PyvtkPythonView_SetScript, METH_VARARGS,
   "SetScript(self, _arg:str) -> None\nC++: virtual void SetScript(const char *_arg)\n\nGet/Set the Python script.\n"},
  {"GetScript", PyvtkPythonView_GetScript, METH_VARARGS,
   "GetScript(self) -> str\nC++: virtual char *GetScript()\n\n"},
  {"SetMagnification", PyvtkPythonView_SetMagnification, METH_VARARGS,
   "SetMagnification(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetMagnification(int _arg1, int _arg2)\nSetMagnification(self, _arg:(int, int)) -> None\nC++: void SetMagnification(const int _arg[2])\n\nMagnification is needed to inform Python of the requested size of\nthe plot\n"},
  {"GetMagnification", PyvtkPythonView_GetMagnification, METH_VARARGS,
   "GetMagnification(self) -> (int, int)\nC++: virtual int *GetMagnification()\n\n"},
  {"GetNumberOfVisibleDataObjects", PyvtkPythonView_GetNumberOfVisibleDataObjects, METH_VARARGS,
   "GetNumberOfVisibleDataObjects(self) -> int\nC++: int GetNumberOfVisibleDataObjects()\n\nGets the number of visible data objects in the view.\n"},
  {"GetVisibleRepresentation", PyvtkPythonView_GetVisibleRepresentation, METH_VARARGS,
   "GetVisibleRepresentation(self, visibleObjectIndex:int)\n    -> vtkPythonRepresentation\nC++: vtkPythonRepresentation *GetVisibleRepresentation(\n    int visibleObjectIndex)\n\nGet the representation for the visible data object at the given\nindex.\n"},
  {"GetVisibleDataObjectForSetup", PyvtkPythonView_GetVisibleDataObjectForSetup, METH_VARARGS,
   "GetVisibleDataObjectForSetup(self, visibleObjectIndex:int)\n    -> vtkDataObject\nC++: vtkDataObject *GetVisibleDataObjectForSetup(\n    int visibleObjectIndex)\n\nGet a local copy of the visible data object at an index. The\nindex must be between 0 and\nthis->GetNumberOfVisibleDataObjects(). If outside this range,\nreturns nullptr. This will return a shallow copy of the data\nobject input to the representation.\n\n* WARNING: this method is intended to be called only from within\n* the setup_data() function in the Python Script set for this\n  instance.\n"},
  {"GetVisibleDataObjectForRendering", PyvtkPythonView_GetVisibleDataObjectForRendering, METH_VARARGS,
   "GetVisibleDataObjectForRendering(self, visibleObjectIndex:int)\n    -> vtkDataObject\nC++: vtkDataObject *GetVisibleDataObjectForRendering(\n    int visibleObjectIndex)\n\nGet the client's copy of the visible data object at an index. The\nindex must be between 0 and\nthis->GetNumberOfVisibleDataObjects(). If outside this range,\nreturns nullptr.\n\n* WARNING: this method should be called only from within the\n  render()\n* function in the Python Script set for this instance.\n"},
  {"GetNumberOfAttributeArrays", PyvtkPythonView_GetNumberOfAttributeArrays, METH_VARARGS,
   "GetNumberOfAttributeArrays(self, visibleObjectIndex:int,\n    attributeType:int) -> int\nC++: int GetNumberOfAttributeArrays(int visibleObjectIndex,\n    int attributeType)\n\nGet number of arrays in an attribute (e.g., vtkDataObject::POINT,\nvtkDataObject::CELL, vtkDataObject::ROW,\nvtkDataObject::FIELD_DATA) for the visible object at the given\nindex.\n"},
  {"GetAttributeArrayName", PyvtkPythonView_GetAttributeArrayName, METH_VARARGS,
   "GetAttributeArrayName(self, visibleObjectIndex:int,\n    attributeType:int, arrayIndex:int) -> str\nC++: const char *GetAttributeArrayName(int visibleObjectIndex,\n    int attributeType, int arrayIndex)\n\nFrom the visible object at the given index, get the name of\nattribute array at index for the given attribute type.\n"},
  {"SetAttributeArrayStatus", PyvtkPythonView_SetAttributeArrayStatus, METH_VARARGS,
   "SetAttributeArrayStatus(self, visibleObjectIndex:int,\n    attributeType:int, name:str, status:int) -> None\nC++: void SetAttributeArrayStatus(int visibleObjectIndex,\n    int attributeType, const char *name, int status)\n\nSet the array status for the visible object at the given index. A\nstatus of 1 means that the array with the given name for the\ngiven attribute will be copied to the client. A status of 0 means\nthe array will not be copied to the client. The status is 0 by\ndefault.\n"},
  {"GetAttributeArrayStatus", PyvtkPythonView_GetAttributeArrayStatus, METH_VARARGS,
   "GetAttributeArrayStatus(self, visibleObjectIndex:int,\n    attributeType:int, name:str) -> int\nC++: int GetAttributeArrayStatus(int visibleObjectIndex,\n    int attributeType, const char *name)\n\nGet the status indicating whether the array with the given name\nand attribute type in the visible object will be copied to the\nclient. Status is 0 by default.\n"},
  {"EnableAllAttributeArrays", PyvtkPythonView_EnableAllAttributeArrays, METH_VARARGS,
   "EnableAllAttributeArrays(self) -> None\nC++: void EnableAllAttributeArrays()\n\nEnable all attribute arrays.\n"},
  {"DisableAllAttributeArrays", PyvtkPythonView_DisableAllAttributeArrays, METH_VARARGS,
   "DisableAllAttributeArrays(self) -> None\nC++: void DisableAllAttributeArrays()\n\nDisable all attribute arrays.\n"},
  {"StillRender", PyvtkPythonView_StillRender, METH_VARARGS,
   "StillRender(self) -> None\nC++: void StillRender() override;\n\nTriggers a high-resolution render.\n\note CallOnAllProcesses\n"},
  {"InteractiveRender", PyvtkPythonView_InteractiveRender, METH_VARARGS,
   "InteractiveRender(self) -> None\nC++: void InteractiveRender() override;\n\nTriggers a interactive render. Based on the settings on the view,\nthis may result in a low-resolution rendering or a simplified\ngeometry rendering.\n\note CallOnAllProcesses\n"},
  {"SetImageData", PyvtkPythonView_SetImageData, METH_VARARGS,
   "SetImageData(self, _arg:vtkImageData) -> None\nC++: virtual void SetImageData(vtkImageData *_arg)\n\nSet the vtkImageData that will be displayed. This is an internal\nmethod meant only to be called from the python side, but must be\nexposed to be wrapped.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPythonView_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("renderer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonView_GetRenderer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPythonView_SetRenderer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPythonView_SetRenderer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRenderer/SetRenderer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("script"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonView_GetScript(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPythonView_SetScript(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPythonView_SetScript(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetScript/SetScript\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("magnification"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonView_GetMagnification(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPythonView_SetMagnification(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPythonView_SetMagnification(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMagnification/SetMagnification\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("image_data"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPythonView_SetImageData(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPythonView_SetImageData(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetImageData\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_visible_data_objects"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonView_GetNumberOfVisibleDataObjects(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfVisibleDataObjects\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPythonView_Doc =
  "vtkPythonView - vtkPythonView is a view for displaying data via a\nPython script that uses matplotlib to generate a plot.\n\n"
  "Superclass: vtkPVView\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPythonView_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViewsPython.vtkPythonView", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPythonView_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPythonView_StaticNew()
{
  return vtkPythonView::New();
}

PyObject *PyvtkPythonView_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPythonView_Type, PyvtkPythonView_Methods,
    "vtkPythonView",
 &PyvtkPythonView_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPVView");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPythonView_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPythonView(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPythonView_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPythonView", o) != 0)
  {
    Py_DECREF(o);
  }

}

