// python wrapper for vtkSMStateLoader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMStateLoader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMStateLoader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMStateLoader_ClassNew(); }

#ifndef DECLARED_PyvtkSMDeserializerXML_ClassNew
extern "C" { PyObject *PyvtkSMDeserializerXML_ClassNew(); }
#define DECLARED_PyvtkSMDeserializerXML_ClassNew
#endif

static PyObject *
PyvtkSMStateLoader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMStateLoader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStateLoader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStateLoader *op = static_cast<vtkSMStateLoader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMStateLoader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStateLoader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMStateLoader *tempr = vtkSMStateLoader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStateLoader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStateLoader *op = static_cast<vtkSMStateLoader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMStateLoader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMStateLoader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStateLoader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMStateLoader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStateLoader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStateLoader *op = static_cast<vtkSMStateLoader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMStateLoader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStateLoader_LoadState(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStateLoader *op = static_cast<vtkSMStateLoader *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    int tempr = (ap.IsBound() ?
      op->LoadState(temp0, temp1) :
      op->vtkSMStateLoader::LoadState(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStateLoader_SetProxyLocator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetProxyLocator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStateLoader *op = static_cast<vtkSMStateLoader *>(vp);

  vtkSMProxyLocator *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxyLocator"))
  {
    if (ap.IsBound())
    {
      op->SetProxyLocator(temp0);
    }
    else
    {
      op->vtkSMStateLoader::SetProxyLocator(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMStateLoader_GetProxyLocator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProxyLocator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStateLoader *op = static_cast<vtkSMStateLoader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMProxyLocator *tempr = (ap.IsBound() ?
      op->GetProxyLocator() :
      op->vtkSMStateLoader::GetProxyLocator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStateLoader_SetKeepIdMapping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKeepIdMapping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStateLoader *op = static_cast<vtkSMStateLoader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKeepIdMapping(temp0);
    }
    else
    {
      op->vtkSMStateLoader::SetKeepIdMapping(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMStateLoader_GetKeepIdMapping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetKeepIdMapping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStateLoader *op = static_cast<vtkSMStateLoader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetKeepIdMapping() :
      op->vtkSMStateLoader::GetKeepIdMapping());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMStateLoader_KeepIdMappingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "KeepIdMappingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStateLoader *op = static_cast<vtkSMStateLoader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->KeepIdMappingOn();
    }
    else
    {
      op->vtkSMStateLoader::KeepIdMappingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMStateLoader_KeepIdMappingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "KeepIdMappingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStateLoader *op = static_cast<vtkSMStateLoader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->KeepIdMappingOff();
    }
    else
    {
      op->vtkSMStateLoader::KeepIdMappingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMStateLoader_GetMappingArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMappingArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMStateLoader *op = static_cast<vtkSMStateLoader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned int *tempr = (ap.IsBound() ?
      op->GetMappingArray(temp0) :
      op->vtkSMStateLoader::GetMappingArray(temp0));

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(0, temp0);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMStateLoader_Methods[] = {
  {"IsTypeOf", PyvtkSMStateLoader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMStateLoader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMStateLoader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMStateLoader\nC++: static vtkSMStateLoader *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMStateLoader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMStateLoader\nC++: vtkSMStateLoader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMStateLoader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMStateLoader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"LoadState", PyvtkSMStateLoader_LoadState, METH_VARARGS,
   "LoadState(self, rootElement:vtkPVXMLElement,\n    keepOriginalId:bool=False) -> int\nC++: int LoadState(vtkPVXMLElement *rootElement,\n    bool keepOriginalId=false)\n\nLoad the state from the given root element.\n"},
  {"SetProxyLocator", PyvtkSMStateLoader_SetProxyLocator, METH_VARARGS,
   "SetProxyLocator(self, loc:vtkSMProxyLocator) -> None\nC++: void SetProxyLocator(vtkSMProxyLocator *loc)\n\nGet/Set the proxy locator to use. Default is vtkSMProxyLocator\nwill be used.\n"},
  {"GetProxyLocator", PyvtkSMStateLoader_GetProxyLocator, METH_VARARGS,
   "GetProxyLocator(self) -> vtkSMProxyLocator\nC++: virtual vtkSMProxyLocator *GetProxyLocator()\n\n"},
  {"SetKeepIdMapping", PyvtkSMStateLoader_SetKeepIdMapping, METH_VARARGS,
   "SetKeepIdMapping(self, _arg:int) -> None\nC++: virtual void SetKeepIdMapping(int _arg)\n\nAllow the loader to keep the mapping between the id from the\nloaded state to the current proxy attributed id.\n"},
  {"GetKeepIdMapping", PyvtkSMStateLoader_GetKeepIdMapping, METH_VARARGS,
   "GetKeepIdMapping(self) -> int\nC++: virtual int GetKeepIdMapping()\n\n"},
  {"KeepIdMappingOn", PyvtkSMStateLoader_KeepIdMappingOn, METH_VARARGS,
   "KeepIdMappingOn(self) -> None\nC++: virtual void KeepIdMappingOn()\n\n"},
  {"KeepIdMappingOff", PyvtkSMStateLoader_KeepIdMappingOff, METH_VARARGS,
   "KeepIdMappingOff(self) -> None\nC++: virtual void KeepIdMappingOff()\n\n"},
  {"GetMappingArray", PyvtkSMStateLoader_GetMappingArray, METH_VARARGS,
   "GetMappingArray(self, size:int) -> Pointer\nC++: vtkTypeUInt32 *GetMappingArray(int &size)\n\nReturn an array of ids. The ids are stored in the following order\nand the size of the array is provided as argument. [key, value,\nkey, value, ...] The array is kept internally using a std::vector\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMStateLoader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("proxy_locator"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMStateLoader_GetProxyLocator(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMStateLoader_SetProxyLocator(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMStateLoader_SetProxyLocator(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetProxyLocator/SetProxyLocator\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("keep_id_mapping"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMStateLoader_GetKeepIdMapping(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMStateLoader_SetKeepIdMapping(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMStateLoader_SetKeepIdMapping(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetKeepIdMapping/SetKeepIdMapping\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMStateLoader_Doc =
  "vtkSMStateLoader - Utility class to load state from XML\n\n"
  "Superclass: vtkSMDeserializerXML\n\n"
  "vtkSMStateLoader can load server manager state from a given\n"
  "vtkPVXMLElement. This element is usually populated by a\n"
  "vtkPVXMLParser.\n"
  "@sa\n"
  "vtkPVXMLParser vtkPVXMLElement\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMStateLoader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMStateLoader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMStateLoader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMStateLoader_StaticNew()
{
  return vtkSMStateLoader::New();
}

PyObject *PyvtkSMStateLoader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMStateLoader_Type, PyvtkSMStateLoader_Methods,
    "vtkSMStateLoader",
 &PyvtkSMStateLoader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMDeserializerXML_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMStateLoader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMStateLoader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMStateLoader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMStateLoader", o) != 0)
  {
    Py_DECREF(o);
  }

}

