/******************************************************************************
 * Author:   Laurent Kneip                                                    *
 * Contact:  kneip.laurent@gmail.com                                          *
 * License:  Copyright (c) 2013 Laurent Kneip, ANU. All rights reserved.      *
 *                                                                            *
 * Redistribution and use in source and binary forms, with or without         *
 * modification, are permitted provided that the following conditions         *
 * are met:                                                                   *
 * * Redistributions of source code must retain the above copyright           *
 *   notice, this list of conditions and the following disclaimer.            *
 * * Redistributions in binary form must reproduce the above copyright        *
 *   notice, this list of conditions and the following disclaimer in the      *
 *   documentation and/or other materials provided with the distribution.     *
 * * Neither the name of ANU nor the names of its contributors may be         *
 *   used to endorse or promote products derived from this software without   *
 *   specific prior written permission.                                       *
 *                                                                            *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"*
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE *
 * ARE DISCLAIMED. IN NO EVENT SHALL ANU OR THE CONTRIBUTORS BE LIABLE        *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR *
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER *
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT         *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY  *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF     *
 * SUCH DAMAGE.                                                               *
 ******************************************************************************/

#include <opengv/absolute_pose/modules/upnp4.hpp>
#include <opengv/math/gauss_jordan.hpp>
#include <opengv/math/roots.hpp>


void
opengv::absolute_pose::modules::upnp::setupAction_sym_gj(
    const Eigen::Matrix<double,10,10> & M,
    const Eigen::Matrix<double,1,10> & C,
    double gamma,
    Eigen::Matrix<double,8,8> & Action )
{
  Eigen::Matrix<double,8,24> M1 = Eigen::Matrix<double,8,24>::Zero();
  M1(0,0) = 4*M(0,0); M1(0,1) = 4*M(4,0)+2*M(0,4); M1(0,2) = 2*M(4,4)+4*M(1,0); M1(0,3) = 2*M(1,4); M1(0,4) = 4*M(5,0)+2*M(0,5); M1(0,5) = 4*M(7,0)+2*M(5,4)+2*M(4,5); M1(0,6) = 2*M(7,4)+2*M(1,5); M1(0,7) = 2*M(5,5)+4*M(2,0); M1(0,8) = 2*M(7,5)+2*M(2,4); M1(0,9) = 2*M(2,5); M1(0,10) = 4*M(6,0)+2*M(0,6); M1(0,11) = 4*M(8,0)+2*M(6,4)+2*M(4,6); M1(0,12) = 2*M(8,4)+2*M(1,6); M1(0,13) = 4*M(9,0)+2*M(6,5)+2*M(5,6); M1(0,14) = 2*M(9,4)+2*M(8,5)+2*M(7,6); M1(0,15) = 2*M(9,5)+2*M(2,6); M1(0,16) = 2*M(6,6)+4*M(3,0); M1(0,17) = 2*M(8,6)+2*M(3,4); M1(0,18) = 2*M(9,6)+2*M(3,5); M1(0,19) = 2*M(3,6); M1(0,20) = 4*C(0,0); M1(0,21) = 2*C(0,4); M1(0,22) = 2*C(0,5); M1(0,23) = 2*C(0,6); 
  M1(1,0) = 2*M(0,4); M1(1,1) = 2*M(4,4)+4*M(0,1); M1(1,2) = 4*M(4,1)+2*M(1,4); M1(1,3) = 4*M(1,1); M1(1,4) = 2*M(5,4)+2*M(0,7); M1(1,5) = 2*M(7,4)+4*M(5,1)+2*M(4,7); M1(1,6) = 4*M(7,1)+2*M(1,7); M1(1,7) = 2*M(5,7)+2*M(2,4); M1(1,8) = 2*M(7,7)+4*M(2,1); M1(1,9) = 2*M(2,7); M1(1,10) = 2*M(6,4)+2*M(0,8); M1(1,11) = 2*M(8,4)+4*M(6,1)+2*M(4,8); M1(1,12) = 4*M(8,1)+2*M(1,8); M1(1,13) = 2*M(9,4)+2*M(6,7)+2*M(5,8); M1(1,14) = 4*M(9,1)+2*M(8,7)+2*M(7,8); M1(1,15) = 2*M(9,7)+2*M(2,8); M1(1,16) = 2*M(6,8)+2*M(3,4); M1(1,17) = 2*M(8,8)+4*M(3,1); M1(1,18) = 2*M(9,8)+2*M(3,7); M1(1,19) = 2*M(3,8); M1(1,20) = 2*C(0,4); M1(1,21) = 4*C(0,1); M1(1,22) = 2*C(0,7); M1(1,23) = 2*C(0,8); 
  M1(2,0) = 2*M(0,5); M1(2,1) = 2*M(4,5)+2*M(0,7); M1(2,2) = 2*M(4,7)+2*M(1,5); M1(2,3) = 2*M(1,7); M1(2,4) = 2*M(5,5)+4*M(0,2); M1(2,5) = 2*M(7,5)+2*M(5,7)+4*M(4,2); M1(2,6) = 2*M(7,7)+4*M(1,2); M1(2,7) = 4*M(5,2)+2*M(2,5); M1(2,8) = 4*M(7,2)+2*M(2,7); M1(2,9) = 4*M(2,2); M1(2,10) = 2*M(6,5)+2*M(0,9); M1(2,11) = 2*M(8,5)+2*M(6,7)+2*M(4,9); M1(2,12) = 2*M(8,7)+2*M(1,9); M1(2,13) = 2*M(9,5)+4*M(6,2)+2*M(5,9); M1(2,14) = 2*M(9,7)+4*M(8,2)+2*M(7,9); M1(2,15) = 4*M(9,2)+2*M(2,9); M1(2,16) = 2*M(6,9)+2*M(3,5); M1(2,17) = 2*M(8,9)+2*M(3,7); M1(2,18) = 2*M(9,9)+4*M(3,2); M1(2,19) = 2*M(3,9); M1(2,20) = 2*C(0,5); M1(2,21) = 2*C(0,7); M1(2,22) = 4*C(0,2); M1(2,23) = 2*C(0,9); 
  M1(3,0) = 2*M(0,6); M1(3,1) = 2*M(4,6)+2*M(0,8); M1(3,2) = 2*M(4,8)+2*M(1,6); M1(3,3) = 2*M(1,8); M1(3,4) = 2*M(5,6)+2*M(0,9); M1(3,5) = 2*M(7,6)+2*M(5,8)+2*M(4,9); M1(3,6) = 2*M(7,8)+2*M(1,9); M1(3,7) = 2*M(5,9)+2*M(2,6); M1(3,8) = 2*M(7,9)+2*M(2,8); M1(3,9) = 2*M(2,9); M1(3,10) = 2*M(6,6)+4*M(0,3); M1(3,11) = 2*M(8,6)+2*M(6,8)+4*M(4,3); M1(3,12) = 2*M(8,8)+4*M(1,3); M1(3,13) = 2*M(9,6)+2*M(6,9)+4*M(5,3); M1(3,14) = 2*M(9,8)+2*M(8,9)+4*M(7,3); M1(3,15) = 2*M(9,9)+4*M(2,3); M1(3,16) = 4*M(6,3)+2*M(3,6); M1(3,17) = 4*M(8,3)+2*M(3,8); M1(3,18) = 4*M(9,3)+2*M(3,9); M1(3,19) = 4*M(3,3); M1(3,20) = 2*C(0,6); M1(3,21) = 2*C(0,8); M1(3,22) = 2*C(0,9); M1(3,23) = 4*C(0,3); 
  M1(4,0) = 1; M1(4,2) = 1; M1(4,7) = 1; M1(4,16) = 1; M1(4,20) = -1; 
  M1(5,1) = 1; M1(5,3) = 1; M1(5,8) = 1; M1(5,17) = 1; M1(5,21) = -1; 
  M1(6,4) = 1; M1(6,6) = 1; M1(6,9) = 1; M1(6,18) = 1; M1(6,22) = -1; 
  M1(7,10) = 1; M1(7,12) = 1; M1(7,15) = 1; M1(7,19) = 1; M1(7,23) = -1; 
  
  Eigen::Matrix<double,7,7> M1_part1 = M1.block<7,7>(0,0);
  Eigen::Matrix<double,7,24> M1_part2 = M1_part1.inverse() * M1.block<7,24>(0,0);
  M1.block<7,24>(0,0) = M1_part2;
  //Some more cancellation in column 10
  for( int i = 6; i >= 0; i-- )
  {
    double factor = M1(i,10)/M1(7,10);
    M1.row(i) -= factor * M1.row(7);
  }
  
  std::vector<std::vector<double>*> M2;
  for( int r = 0; r < 141; r++ )
  {
    std::vector<double> * row = new std::vector<double>();
    for( int c = 0; c < 149; c++ )
      row->push_back(0.0);
    M2.push_back(row);
  }
  (*(M2[0]))[32] = M1(3,3); (*(M2[0]))[38] = M1(3,7); (*(M2[0]))[39] = M1(3,8); (*(M2[0]))[41] = M1(3,9); (*(M2[0]))[49] = M1(3,11); (*(M2[0]))[50] = M1(3,12); (*(M2[0]))[52] = M1(3,13); (*(M2[0]))[53] = M1(3,14); (*(M2[0]))[55] = M1(3,15); (*(M2[0]))[61] = M1(3,16); (*(M2[0]))[62] = M1(3,17); (*(M2[0]))[64] = M1(3,18); (*(M2[0]))[69] = M1(3,19); (*(M2[0]))[96] = M1(3,20); (*(M2[0]))[97] = M1(3,21); (*(M2[0]))[100] = M1(3,22); (*(M2[0]))[110] = M1(3,23); 
  (*(M2[1]))[35] = M1(5,5); (*(M2[1]))[38] = M1(5,7); (*(M2[1]))[39] = M1(5,8); (*(M2[1]))[41] = M1(5,9); (*(M2[1]))[49] = M1(5,11); (*(M2[1]))[50] = M1(5,12); (*(M2[1]))[52] = M1(5,13); (*(M2[1]))[53] = M1(5,14); (*(M2[1]))[55] = M1(5,15); (*(M2[1]))[61] = M1(5,16); (*(M2[1]))[62] = M1(5,17); (*(M2[1]))[64] = M1(5,18); (*(M2[1]))[69] = M1(5,19); (*(M2[1]))[96] = M1(5,20); (*(M2[1]))[97] = M1(5,21); (*(M2[1]))[100] = M1(5,22); (*(M2[1]))[110] = M1(5,23); 
  (*(M2[2]))[36] = M1(6,6); (*(M2[2]))[38] = M1(6,7); (*(M2[2]))[39] = M1(6,8); (*(M2[2]))[41] = M1(6,9); (*(M2[2]))[49] = M1(6,11); (*(M2[2]))[50] = M1(6,12); (*(M2[2]))[52] = M1(6,13); (*(M2[2]))[53] = M1(6,14); (*(M2[2]))[55] = M1(6,15); (*(M2[2]))[61] = M1(6,16); (*(M2[2]))[62] = M1(6,17); (*(M2[2]))[64] = M1(6,18); (*(M2[2]))[69] = M1(6,19); (*(M2[2]))[96] = M1(6,20); (*(M2[2]))[97] = M1(6,21); (*(M2[2]))[100] = M1(6,22); (*(M2[2]))[110] = M1(6,23); 
  (*(M2[3]))[48] = M1(7,10); (*(M2[3]))[50] = M1(7,12); (*(M2[3]))[55] = M1(7,15); (*(M2[3]))[69] = M1(7,19); (*(M2[3]))[110] = M1(7,23); 
  (*(M2[4]))[12] = M1(2,2); (*(M2[4]))[19] = M1(2,7); (*(M2[4]))[20] = M1(2,8); (*(M2[4]))[22] = M1(2,9); (*(M2[4]))[35] = M1(2,11); (*(M2[4]))[36] = M1(2,12); (*(M2[4]))[38] = M1(2,13); (*(M2[4]))[39] = M1(2,14); (*(M2[4]))[41] = M1(2,15); (*(M2[4]))[52] = M1(2,16); (*(M2[4]))[53] = M1(2,17); (*(M2[4]))[55] = M1(2,18); (*(M2[4]))[64] = M1(2,19); (*(M2[4]))[81] = M1(2,20); (*(M2[4]))[82] = M1(2,21); (*(M2[4]))[85] = M1(2,22); (*(M2[4]))[100] = M1(2,23); 
  (*(M2[5]))[13] = M1(3,3); (*(M2[5]))[19] = M1(3,7); (*(M2[5]))[20] = M1(3,8); (*(M2[5]))[22] = M1(3,9); (*(M2[5]))[35] = M1(3,11); (*(M2[5]))[36] = M1(3,12); (*(M2[5]))[38] = M1(3,13); (*(M2[5]))[39] = M1(3,14); (*(M2[5]))[41] = M1(3,15); (*(M2[5]))[52] = M1(3,16); (*(M2[5]))[53] = M1(3,17); (*(M2[5]))[55] = M1(3,18); (*(M2[5]))[64] = M1(3,19); (*(M2[5]))[81] = M1(3,20); (*(M2[5]))[82] = M1(3,21); (*(M2[5]))[85] = M1(3,22); (*(M2[5]))[100] = M1(3,23); 
  (*(M2[6]))[15] = M1(4,4); (*(M2[6]))[19] = M1(4,7); (*(M2[6]))[20] = M1(4,8); (*(M2[6]))[22] = M1(4,9); (*(M2[6]))[35] = M1(4,11); (*(M2[6]))[36] = M1(4,12); (*(M2[6]))[38] = M1(4,13); (*(M2[6]))[39] = M1(4,14); (*(M2[6]))[41] = M1(4,15); (*(M2[6]))[52] = M1(4,16); (*(M2[6]))[53] = M1(4,17); (*(M2[6]))[55] = M1(4,18); (*(M2[6]))[64] = M1(4,19); (*(M2[6]))[81] = M1(4,20); (*(M2[6]))[82] = M1(4,21); (*(M2[6]))[85] = M1(4,22); (*(M2[6]))[100] = M1(4,23); 
  (*(M2[7]))[16] = M1(5,5); (*(M2[7]))[19] = M1(5,7); (*(M2[7]))[20] = M1(5,8); (*(M2[7]))[22] = M1(5,9); (*(M2[7]))[35] = M1(5,11); (*(M2[7]))[36] = M1(5,12); (*(M2[7]))[38] = M1(5,13); (*(M2[7]))[39] = M1(5,14); (*(M2[7]))[41] = M1(5,15); (*(M2[7]))[52] = M1(5,16); (*(M2[7]))[53] = M1(5,17); (*(M2[7]))[55] = M1(5,18); (*(M2[7]))[64] = M1(5,19); (*(M2[7]))[81] = M1(5,20); (*(M2[7]))[82] = M1(5,21); (*(M2[7]))[85] = M1(5,22); (*(M2[7]))[100] = M1(5,23); 
  (*(M2[8]))[17] = M1(6,6); (*(M2[8]))[19] = M1(6,7); (*(M2[8]))[20] = M1(6,8); (*(M2[8]))[22] = M1(6,9); (*(M2[8]))[35] = M1(6,11); (*(M2[8]))[36] = M1(6,12); (*(M2[8]))[38] = M1(6,13); (*(M2[8]))[39] = M1(6,14); (*(M2[8]))[41] = M1(6,15); (*(M2[8]))[52] = M1(6,16); (*(M2[8]))[53] = M1(6,17); (*(M2[8]))[55] = M1(6,18); (*(M2[8]))[64] = M1(6,19); (*(M2[8]))[81] = M1(6,20); (*(M2[8]))[82] = M1(6,21); (*(M2[8]))[85] = M1(6,22); (*(M2[8]))[100] = M1(6,23); 
  (*(M2[9]))[34] = M1(7,10); (*(M2[9]))[36] = M1(7,12); (*(M2[9]))[41] = M1(7,15); (*(M2[9]))[64] = M1(7,19); (*(M2[9]))[100] = M1(7,23); 
  (*(M2[10]))[26] = M1(2,2); (*(M2[10]))[35] = M1(2,7); (*(M2[10]))[36] = M1(2,8); (*(M2[10]))[39] = M1(2,9); (*(M2[10]))[45] = M1(2,11); (*(M2[10]))[46] = M1(2,12); (*(M2[10]))[49] = M1(2,13); (*(M2[10]))[50] = M1(2,14); (*(M2[10]))[53] = M1(2,15); (*(M2[10]))[58] = M1(2,16); (*(M2[10]))[59] = M1(2,17); (*(M2[10]))[62] = M1(2,18); (*(M2[10]))[67] = M1(2,19); (*(M2[10]))[92] = M1(2,20); (*(M2[10]))[93] = M1(2,21); (*(M2[10]))[97] = M1(2,22); (*(M2[10]))[107] = M1(2,23); 
  (*(M2[11]))[27] = M1(3,3); (*(M2[11]))[35] = M1(3,7); (*(M2[11]))[36] = M1(3,8); (*(M2[11]))[39] = M1(3,9); (*(M2[11]))[45] = M1(3,11); (*(M2[11]))[46] = M1(3,12); (*(M2[11]))[49] = M1(3,13); (*(M2[11]))[50] = M1(3,14); (*(M2[11]))[53] = M1(3,15); (*(M2[11]))[58] = M1(3,16); (*(M2[11]))[59] = M1(3,17); (*(M2[11]))[62] = M1(3,18); (*(M2[11]))[67] = M1(3,19); (*(M2[11]))[92] = M1(3,20); (*(M2[11]))[93] = M1(3,21); (*(M2[11]))[97] = M1(3,22); (*(M2[11]))[107] = M1(3,23); 
  (*(M2[12]))[31] = M1(5,5); (*(M2[12]))[35] = M1(5,7); (*(M2[12]))[36] = M1(5,8); (*(M2[12]))[39] = M1(5,9); (*(M2[12]))[45] = M1(5,11); (*(M2[12]))[46] = M1(5,12); (*(M2[12]))[49] = M1(5,13); (*(M2[12]))[50] = M1(5,14); (*(M2[12]))[53] = M1(5,15); (*(M2[12]))[58] = M1(5,16); (*(M2[12]))[59] = M1(5,17); (*(M2[12]))[62] = M1(5,18); (*(M2[12]))[67] = M1(5,19); (*(M2[12]))[92] = M1(5,20); (*(M2[12]))[93] = M1(5,21); (*(M2[12]))[97] = M1(5,22); (*(M2[12]))[107] = M1(5,23); 
  (*(M2[13]))[32] = M1(6,6); (*(M2[13]))[35] = M1(6,7); (*(M2[13]))[36] = M1(6,8); (*(M2[13]))[39] = M1(6,9); (*(M2[13]))[45] = M1(6,11); (*(M2[13]))[46] = M1(6,12); (*(M2[13]))[49] = M1(6,13); (*(M2[13]))[50] = M1(6,14); (*(M2[13]))[53] = M1(6,15); (*(M2[13]))[58] = M1(6,16); (*(M2[13]))[59] = M1(6,17); (*(M2[13]))[62] = M1(6,18); (*(M2[13]))[67] = M1(6,19); (*(M2[13]))[92] = M1(6,20); (*(M2[13]))[93] = M1(6,21); (*(M2[13]))[97] = M1(6,22); (*(M2[13]))[107] = M1(6,23); 
  (*(M2[14]))[44] = M1(7,10); (*(M2[14]))[46] = M1(7,12); (*(M2[14]))[53] = M1(7,15); (*(M2[14]))[67] = M1(7,19); (*(M2[14]))[107] = M1(7,23); 
  (*(M2[15]))[7] = M1(2,2); (*(M2[15]))[16] = M1(2,7); (*(M2[15]))[17] = M1(2,8); (*(M2[15]))[20] = M1(2,9); (*(M2[15]))[31] = M1(2,11); (*(M2[15]))[32] = M1(2,12); (*(M2[15]))[35] = M1(2,13); (*(M2[15]))[36] = M1(2,14); (*(M2[15]))[39] = M1(2,15); (*(M2[15]))[49] = M1(2,16); (*(M2[15]))[50] = M1(2,17); (*(M2[15]))[53] = M1(2,18); (*(M2[15]))[62] = M1(2,19); (*(M2[15]))[77] = M1(2,20); (*(M2[15]))[78] = M1(2,21); (*(M2[15]))[82] = M1(2,22); (*(M2[15]))[97] = M1(2,23); 
  (*(M2[16]))[8] = M1(3,3); (*(M2[16]))[16] = M1(3,7); (*(M2[16]))[17] = M1(3,8); (*(M2[16]))[20] = M1(3,9); (*(M2[16]))[31] = M1(3,11); (*(M2[16]))[32] = M1(3,12); (*(M2[16]))[35] = M1(3,13); (*(M2[16]))[36] = M1(3,14); (*(M2[16]))[39] = M1(3,15); (*(M2[16]))[49] = M1(3,16); (*(M2[16]))[50] = M1(3,17); (*(M2[16]))[53] = M1(3,18); (*(M2[16]))[62] = M1(3,19); (*(M2[16]))[77] = M1(3,20); (*(M2[16]))[78] = M1(3,21); (*(M2[16]))[82] = M1(3,22); (*(M2[16]))[97] = M1(3,23); 
  (*(M2[17]))[11] = M1(4,4); (*(M2[17]))[16] = M1(4,7); (*(M2[17]))[17] = M1(4,8); (*(M2[17]))[20] = M1(4,9); (*(M2[17]))[31] = M1(4,11); (*(M2[17]))[32] = M1(4,12); (*(M2[17]))[35] = M1(4,13); (*(M2[17]))[36] = M1(4,14); (*(M2[17]))[39] = M1(4,15); (*(M2[17]))[49] = M1(4,16); (*(M2[17]))[50] = M1(4,17); (*(M2[17]))[53] = M1(4,18); (*(M2[17]))[62] = M1(4,19); (*(M2[17]))[77] = M1(4,20); (*(M2[17]))[78] = M1(4,21); (*(M2[17]))[82] = M1(4,22); (*(M2[17]))[97] = M1(4,23); 
  (*(M2[18]))[12] = M1(5,5); (*(M2[18]))[16] = M1(5,7); (*(M2[18]))[17] = M1(5,8); (*(M2[18]))[20] = M1(5,9); (*(M2[18]))[31] = M1(5,11); (*(M2[18]))[32] = M1(5,12); (*(M2[18]))[35] = M1(5,13); (*(M2[18]))[36] = M1(5,14); (*(M2[18]))[39] = M1(5,15); (*(M2[18]))[49] = M1(5,16); (*(M2[18]))[50] = M1(5,17); (*(M2[18]))[53] = M1(5,18); (*(M2[18]))[62] = M1(5,19); (*(M2[18]))[77] = M1(5,20); (*(M2[18]))[78] = M1(5,21); (*(M2[18]))[82] = M1(5,22); (*(M2[18]))[97] = M1(5,23); 
  (*(M2[19]))[13] = M1(6,6); (*(M2[19]))[16] = M1(6,7); (*(M2[19]))[17] = M1(6,8); (*(M2[19]))[20] = M1(6,9); (*(M2[19]))[31] = M1(6,11); (*(M2[19]))[32] = M1(6,12); (*(M2[19]))[35] = M1(6,13); (*(M2[19]))[36] = M1(6,14); (*(M2[19]))[39] = M1(6,15); (*(M2[19]))[49] = M1(6,16); (*(M2[19]))[50] = M1(6,17); (*(M2[19]))[53] = M1(6,18); (*(M2[19]))[62] = M1(6,19); (*(M2[19]))[77] = M1(6,20); (*(M2[19]))[78] = M1(6,21); (*(M2[19]))[82] = M1(6,22); (*(M2[19]))[97] = M1(6,23); 
  (*(M2[20]))[30] = M1(7,10); (*(M2[20]))[32] = M1(7,12); (*(M2[20]))[39] = M1(7,15); (*(M2[20]))[62] = M1(7,19); (*(M2[20]))[97] = M1(7,23); 
  (*(M2[21]))[2] = M1(1,1); (*(M2[21]))[12] = M1(1,7); (*(M2[21]))[13] = M1(1,8); (*(M2[21]))[17] = M1(1,9); (*(M2[21]))[26] = M1(1,11); (*(M2[21]))[27] = M1(1,12); (*(M2[21]))[31] = M1(1,13); (*(M2[21]))[32] = M1(1,14); (*(M2[21]))[36] = M1(1,15); (*(M2[21]))[45] = M1(1,16); (*(M2[21]))[46] = M1(1,17); (*(M2[21]))[50] = M1(1,18); (*(M2[21]))[59] = M1(1,19); (*(M2[21]))[73] = M1(1,20); (*(M2[21]))[74] = M1(1,21); (*(M2[21]))[78] = M1(1,22); (*(M2[21]))[93] = M1(1,23); 
  (*(M2[22]))[3] = M1(2,2); (*(M2[22]))[12] = M1(2,7); (*(M2[22]))[13] = M1(2,8); (*(M2[22]))[17] = M1(2,9); (*(M2[22]))[26] = M1(2,11); (*(M2[22]))[27] = M1(2,12); (*(M2[22]))[31] = M1(2,13); (*(M2[22]))[32] = M1(2,14); (*(M2[22]))[36] = M1(2,15); (*(M2[22]))[45] = M1(2,16); (*(M2[22]))[46] = M1(2,17); (*(M2[22]))[50] = M1(2,18); (*(M2[22]))[59] = M1(2,19); (*(M2[22]))[73] = M1(2,20); (*(M2[22]))[74] = M1(2,21); (*(M2[22]))[78] = M1(2,22); (*(M2[22]))[93] = M1(2,23); 
  (*(M2[23]))[6] = M1(4,4); (*(M2[23]))[12] = M1(4,7); (*(M2[23]))[13] = M1(4,8); (*(M2[23]))[17] = M1(4,9); (*(M2[23]))[26] = M1(4,11); (*(M2[23]))[27] = M1(4,12); (*(M2[23]))[31] = M1(4,13); (*(M2[23]))[32] = M1(4,14); (*(M2[23]))[36] = M1(4,15); (*(M2[23]))[45] = M1(4,16); (*(M2[23]))[46] = M1(4,17); (*(M2[23]))[50] = M1(4,18); (*(M2[23]))[59] = M1(4,19); (*(M2[23]))[73] = M1(4,20); (*(M2[23]))[74] = M1(4,21); (*(M2[23]))[78] = M1(4,22); (*(M2[23]))[93] = M1(4,23); 
  (*(M2[24]))[7] = M1(5,5); (*(M2[24]))[12] = M1(5,7); (*(M2[24]))[13] = M1(5,8); (*(M2[24]))[17] = M1(5,9); (*(M2[24]))[26] = M1(5,11); (*(M2[24]))[27] = M1(5,12); (*(M2[24]))[31] = M1(5,13); (*(M2[24]))[32] = M1(5,14); (*(M2[24]))[36] = M1(5,15); (*(M2[24]))[45] = M1(5,16); (*(M2[24]))[46] = M1(5,17); (*(M2[24]))[50] = M1(5,18); (*(M2[24]))[59] = M1(5,19); (*(M2[24]))[73] = M1(5,20); (*(M2[24]))[74] = M1(5,21); (*(M2[24]))[78] = M1(5,22); (*(M2[24]))[93] = M1(5,23); 
  (*(M2[25]))[8] = M1(6,6); (*(M2[25]))[12] = M1(6,7); (*(M2[25]))[13] = M1(6,8); (*(M2[25]))[17] = M1(6,9); (*(M2[25]))[26] = M1(6,11); (*(M2[25]))[27] = M1(6,12); (*(M2[25]))[31] = M1(6,13); (*(M2[25]))[32] = M1(6,14); (*(M2[25]))[36] = M1(6,15); (*(M2[25]))[45] = M1(6,16); (*(M2[25]))[46] = M1(6,17); (*(M2[25]))[50] = M1(6,18); (*(M2[25]))[59] = M1(6,19); (*(M2[25]))[73] = M1(6,20); (*(M2[25]))[74] = M1(6,21); (*(M2[25]))[78] = M1(6,22); (*(M2[25]))[93] = M1(6,23); 
  (*(M2[26]))[25] = M1(7,10); (*(M2[26]))[27] = M1(7,12); (*(M2[26]))[36] = M1(7,15); (*(M2[26]))[59] = M1(7,19); (*(M2[26]))[93] = M1(7,23); 
  (*(M2[27]))[30] = M1(2,2); (*(M2[27]))[37] = M1(2,7); (*(M2[27]))[38] = M1(2,8); (*(M2[27]))[40] = M1(2,9); (*(M2[27]))[48] = M1(2,11); (*(M2[27]))[49] = M1(2,12); (*(M2[27]))[51] = M1(2,13); (*(M2[27]))[52] = M1(2,14); (*(M2[27]))[54] = M1(2,15); (*(M2[27]))[60] = M1(2,16); (*(M2[27]))[61] = M1(2,17); (*(M2[27]))[63] = M1(2,18); (*(M2[27]))[68] = M1(2,19); (*(M2[27]))[95] = M1(2,20); (*(M2[27]))[96] = M1(2,21); (*(M2[27]))[99] = M1(2,22); (*(M2[27]))[109] = M1(2,23); 
  (*(M2[28]))[31] = M1(3,3); (*(M2[28]))[37] = M1(3,7); (*(M2[28]))[38] = M1(3,8); (*(M2[28]))[40] = M1(3,9); (*(M2[28]))[48] = M1(3,11); (*(M2[28]))[49] = M1(3,12); (*(M2[28]))[51] = M1(3,13); (*(M2[28]))[52] = M1(3,14); (*(M2[28]))[54] = M1(3,15); (*(M2[28]))[60] = M1(3,16); (*(M2[28]))[61] = M1(3,17); (*(M2[28]))[63] = M1(3,18); (*(M2[28]))[68] = M1(3,19); (*(M2[28]))[95] = M1(3,20); (*(M2[28]))[96] = M1(3,21); (*(M2[28]))[99] = M1(3,22); (*(M2[28]))[109] = M1(3,23); 
  (*(M2[29]))[34] = M1(5,5); (*(M2[29]))[37] = M1(5,7); (*(M2[29]))[38] = M1(5,8); (*(M2[29]))[40] = M1(5,9); (*(M2[29]))[48] = M1(5,11); (*(M2[29]))[49] = M1(5,12); (*(M2[29]))[51] = M1(5,13); (*(M2[29]))[52] = M1(5,14); (*(M2[29]))[54] = M1(5,15); (*(M2[29]))[60] = M1(5,16); (*(M2[29]))[61] = M1(5,17); (*(M2[29]))[63] = M1(5,18); (*(M2[29]))[68] = M1(5,19); (*(M2[29]))[95] = M1(5,20); (*(M2[29]))[96] = M1(5,21); (*(M2[29]))[99] = M1(5,22); (*(M2[29]))[109] = M1(5,23); 
  (*(M2[30]))[35] = M1(6,6); (*(M2[30]))[37] = M1(6,7); (*(M2[30]))[38] = M1(6,8); (*(M2[30]))[40] = M1(6,9); (*(M2[30]))[48] = M1(6,11); (*(M2[30]))[49] = M1(6,12); (*(M2[30]))[51] = M1(6,13); (*(M2[30]))[52] = M1(6,14); (*(M2[30]))[54] = M1(6,15); (*(M2[30]))[60] = M1(6,16); (*(M2[30]))[61] = M1(6,17); (*(M2[30]))[63] = M1(6,18); (*(M2[30]))[68] = M1(6,19); (*(M2[30]))[95] = M1(6,20); (*(M2[30]))[96] = M1(6,21); (*(M2[30]))[99] = M1(6,22); (*(M2[30]))[109] = M1(6,23); 
  (*(M2[31]))[47] = M1(7,10); (*(M2[31]))[49] = M1(7,12); (*(M2[31]))[54] = M1(7,15); (*(M2[31]))[68] = M1(7,19); (*(M2[31]))[109] = M1(7,23); 
  (*(M2[32]))[11] = M1(2,2); (*(M2[32]))[18] = M1(2,7); (*(M2[32]))[19] = M1(2,8); (*(M2[32]))[21] = M1(2,9); (*(M2[32]))[34] = M1(2,11); (*(M2[32]))[35] = M1(2,12); (*(M2[32]))[37] = M1(2,13); (*(M2[32]))[38] = M1(2,14); (*(M2[32]))[40] = M1(2,15); (*(M2[32]))[51] = M1(2,16); (*(M2[32]))[52] = M1(2,17); (*(M2[32]))[54] = M1(2,18); (*(M2[32]))[63] = M1(2,19); (*(M2[32]))[80] = M1(2,20); (*(M2[32]))[81] = M1(2,21); (*(M2[32]))[84] = M1(2,22); (*(M2[32]))[99] = M1(2,23); 
  (*(M2[33]))[12] = M1(3,3); (*(M2[33]))[18] = M1(3,7); (*(M2[33]))[19] = M1(3,8); (*(M2[33]))[21] = M1(3,9); (*(M2[33]))[34] = M1(3,11); (*(M2[33]))[35] = M1(3,12); (*(M2[33]))[37] = M1(3,13); (*(M2[33]))[38] = M1(3,14); (*(M2[33]))[40] = M1(3,15); (*(M2[33]))[51] = M1(3,16); (*(M2[33]))[52] = M1(3,17); (*(M2[33]))[54] = M1(3,18); (*(M2[33]))[63] = M1(3,19); (*(M2[33]))[80] = M1(3,20); (*(M2[33]))[81] = M1(3,21); (*(M2[33]))[84] = M1(3,22); (*(M2[33]))[99] = M1(3,23); 
  (*(M2[34]))[14] = M1(4,4); (*(M2[34]))[18] = M1(4,7); (*(M2[34]))[19] = M1(4,8); (*(M2[34]))[21] = M1(4,9); (*(M2[34]))[34] = M1(4,11); (*(M2[34]))[35] = M1(4,12); (*(M2[34]))[37] = M1(4,13); (*(M2[34]))[38] = M1(4,14); (*(M2[34]))[40] = M1(4,15); (*(M2[34]))[51] = M1(4,16); (*(M2[34]))[52] = M1(4,17); (*(M2[34]))[54] = M1(4,18); (*(M2[34]))[63] = M1(4,19); (*(M2[34]))[80] = M1(4,20); (*(M2[34]))[81] = M1(4,21); (*(M2[34]))[84] = M1(4,22); (*(M2[34]))[99] = M1(4,23); 
  (*(M2[35]))[15] = M1(5,5); (*(M2[35]))[18] = M1(5,7); (*(M2[35]))[19] = M1(5,8); (*(M2[35]))[21] = M1(5,9); (*(M2[35]))[34] = M1(5,11); (*(M2[35]))[35] = M1(5,12); (*(M2[35]))[37] = M1(5,13); (*(M2[35]))[38] = M1(5,14); (*(M2[35]))[40] = M1(5,15); (*(M2[35]))[51] = M1(5,16); (*(M2[35]))[52] = M1(5,17); (*(M2[35]))[54] = M1(5,18); (*(M2[35]))[63] = M1(5,19); (*(M2[35]))[80] = M1(5,20); (*(M2[35]))[81] = M1(5,21); (*(M2[35]))[84] = M1(5,22); (*(M2[35]))[99] = M1(5,23); 
  (*(M2[36]))[16] = M1(6,6); (*(M2[36]))[18] = M1(6,7); (*(M2[36]))[19] = M1(6,8); (*(M2[36]))[21] = M1(6,9); (*(M2[36]))[34] = M1(6,11); (*(M2[36]))[35] = M1(6,12); (*(M2[36]))[37] = M1(6,13); (*(M2[36]))[38] = M1(6,14); (*(M2[36]))[40] = M1(6,15); (*(M2[36]))[51] = M1(6,16); (*(M2[36]))[52] = M1(6,17); (*(M2[36]))[54] = M1(6,18); (*(M2[36]))[63] = M1(6,19); (*(M2[36]))[80] = M1(6,20); (*(M2[36]))[81] = M1(6,21); (*(M2[36]))[84] = M1(6,22); (*(M2[36]))[99] = M1(6,23); 
  (*(M2[37]))[33] = M1(7,10); (*(M2[37]))[35] = M1(7,12); (*(M2[37]))[40] = M1(7,15); (*(M2[37]))[63] = M1(7,19); (*(M2[37]))[99] = M1(7,23); 
  (*(M2[38]))[25] = M1(2,2); (*(M2[38]))[34] = M1(2,7); (*(M2[38]))[35] = M1(2,8); (*(M2[38]))[38] = M1(2,9); (*(M2[38]))[44] = M1(2,11); (*(M2[38]))[45] = M1(2,12); (*(M2[38]))[48] = M1(2,13); (*(M2[38]))[49] = M1(2,14); (*(M2[38]))[52] = M1(2,15); (*(M2[38]))[57] = M1(2,16); (*(M2[38]))[58] = M1(2,17); (*(M2[38]))[61] = M1(2,18); (*(M2[38]))[66] = M1(2,19); (*(M2[38]))[91] = M1(2,20); (*(M2[38]))[92] = M1(2,21); (*(M2[38]))[96] = M1(2,22); (*(M2[38]))[106] = M1(2,23); 
  (*(M2[39]))[26] = M1(3,3); (*(M2[39]))[34] = M1(3,7); (*(M2[39]))[35] = M1(3,8); (*(M2[39]))[38] = M1(3,9); (*(M2[39]))[44] = M1(3,11); (*(M2[39]))[45] = M1(3,12); (*(M2[39]))[48] = M1(3,13); (*(M2[39]))[49] = M1(3,14); (*(M2[39]))[52] = M1(3,15); (*(M2[39]))[57] = M1(3,16); (*(M2[39]))[58] = M1(3,17); (*(M2[39]))[61] = M1(3,18); (*(M2[39]))[66] = M1(3,19); (*(M2[39]))[91] = M1(3,20); (*(M2[39]))[92] = M1(3,21); (*(M2[39]))[96] = M1(3,22); (*(M2[39]))[106] = M1(3,23); 
  (*(M2[40]))[30] = M1(5,5); (*(M2[40]))[34] = M1(5,7); (*(M2[40]))[35] = M1(5,8); (*(M2[40]))[38] = M1(5,9); (*(M2[40]))[44] = M1(5,11); (*(M2[40]))[45] = M1(5,12); (*(M2[40]))[48] = M1(5,13); (*(M2[40]))[49] = M1(5,14); (*(M2[40]))[52] = M1(5,15); (*(M2[40]))[57] = M1(5,16); (*(M2[40]))[58] = M1(5,17); (*(M2[40]))[61] = M1(5,18); (*(M2[40]))[66] = M1(5,19); (*(M2[40]))[91] = M1(5,20); (*(M2[40]))[92] = M1(5,21); (*(M2[40]))[96] = M1(5,22); (*(M2[40]))[106] = M1(5,23); 
  (*(M2[41]))[31] = M1(6,6); (*(M2[41]))[34] = M1(6,7); (*(M2[41]))[35] = M1(6,8); (*(M2[41]))[38] = M1(6,9); (*(M2[41]))[44] = M1(6,11); (*(M2[41]))[45] = M1(6,12); (*(M2[41]))[48] = M1(6,13); (*(M2[41]))[49] = M1(6,14); (*(M2[41]))[52] = M1(6,15); (*(M2[41]))[57] = M1(6,16); (*(M2[41]))[58] = M1(6,17); (*(M2[41]))[61] = M1(6,18); (*(M2[41]))[66] = M1(6,19); (*(M2[41]))[91] = M1(6,20); (*(M2[41]))[92] = M1(6,21); (*(M2[41]))[96] = M1(6,22); (*(M2[41]))[106] = M1(6,23); 
  (*(M2[42]))[43] = M1(7,10); (*(M2[42]))[45] = M1(7,12); (*(M2[42]))[52] = M1(7,15); (*(M2[42]))[66] = M1(7,19); (*(M2[42]))[106] = M1(7,23); 
  (*(M2[43]))[6] = M1(2,2); (*(M2[43]))[15] = M1(2,7); (*(M2[43]))[16] = M1(2,8); (*(M2[43]))[19] = M1(2,9); (*(M2[43]))[30] = M1(2,11); (*(M2[43]))[31] = M1(2,12); (*(M2[43]))[34] = M1(2,13); (*(M2[43]))[35] = M1(2,14); (*(M2[43]))[38] = M1(2,15); (*(M2[43]))[48] = M1(2,16); (*(M2[43]))[49] = M1(2,17); (*(M2[43]))[52] = M1(2,18); (*(M2[43]))[61] = M1(2,19); (*(M2[43]))[76] = M1(2,20); (*(M2[43]))[77] = M1(2,21); (*(M2[43]))[81] = M1(2,22); (*(M2[43]))[96] = M1(2,23); 
  (*(M2[44]))[7] = M1(3,3); (*(M2[44]))[15] = M1(3,7); (*(M2[44]))[16] = M1(3,8); (*(M2[44]))[19] = M1(3,9); (*(M2[44]))[30] = M1(3,11); (*(M2[44]))[31] = M1(3,12); (*(M2[44]))[34] = M1(3,13); (*(M2[44]))[35] = M1(3,14); (*(M2[44]))[38] = M1(3,15); (*(M2[44]))[48] = M1(3,16); (*(M2[44]))[49] = M1(3,17); (*(M2[44]))[52] = M1(3,18); (*(M2[44]))[61] = M1(3,19); (*(M2[44]))[76] = M1(3,20); (*(M2[44]))[77] = M1(3,21); (*(M2[44]))[81] = M1(3,22); (*(M2[44]))[96] = M1(3,23); 
  (*(M2[45]))[10] = M1(4,4); (*(M2[45]))[15] = M1(4,7); (*(M2[45]))[16] = M1(4,8); (*(M2[45]))[19] = M1(4,9); (*(M2[45]))[30] = M1(4,11); (*(M2[45]))[31] = M1(4,12); (*(M2[45]))[34] = M1(4,13); (*(M2[45]))[35] = M1(4,14); (*(M2[45]))[38] = M1(4,15); (*(M2[45]))[48] = M1(4,16); (*(M2[45]))[49] = M1(4,17); (*(M2[45]))[52] = M1(4,18); (*(M2[45]))[61] = M1(4,19); (*(M2[45]))[76] = M1(4,20); (*(M2[45]))[77] = M1(4,21); (*(M2[45]))[81] = M1(4,22); (*(M2[45]))[96] = M1(4,23); 
  (*(M2[46]))[11] = M1(5,5); (*(M2[46]))[15] = M1(5,7); (*(M2[46]))[16] = M1(5,8); (*(M2[46]))[19] = M1(5,9); (*(M2[46]))[30] = M1(5,11); (*(M2[46]))[31] = M1(5,12); (*(M2[46]))[34] = M1(5,13); (*(M2[46]))[35] = M1(5,14); (*(M2[46]))[38] = M1(5,15); (*(M2[46]))[48] = M1(5,16); (*(M2[46]))[49] = M1(5,17); (*(M2[46]))[52] = M1(5,18); (*(M2[46]))[61] = M1(5,19); (*(M2[46]))[76] = M1(5,20); (*(M2[46]))[77] = M1(5,21); (*(M2[46]))[81] = M1(5,22); (*(M2[46]))[96] = M1(5,23); 
  (*(M2[47]))[12] = M1(6,6); (*(M2[47]))[15] = M1(6,7); (*(M2[47]))[16] = M1(6,8); (*(M2[47]))[19] = M1(6,9); (*(M2[47]))[30] = M1(6,11); (*(M2[47]))[31] = M1(6,12); (*(M2[47]))[34] = M1(6,13); (*(M2[47]))[35] = M1(6,14); (*(M2[47]))[38] = M1(6,15); (*(M2[47]))[48] = M1(6,16); (*(M2[47]))[49] = M1(6,17); (*(M2[47]))[52] = M1(6,18); (*(M2[47]))[61] = M1(6,19); (*(M2[47]))[76] = M1(6,20); (*(M2[47]))[77] = M1(6,21); (*(M2[47]))[81] = M1(6,22); (*(M2[47]))[96] = M1(6,23); 
  (*(M2[48]))[29] = M1(7,10); (*(M2[48]))[31] = M1(7,12); (*(M2[48]))[38] = M1(7,15); (*(M2[48]))[61] = M1(7,19); (*(M2[48]))[96] = M1(7,23); 
  (*(M2[49]))[1] = M1(1,1); (*(M2[49]))[11] = M1(1,7); (*(M2[49]))[12] = M1(1,8); (*(M2[49]))[16] = M1(1,9); (*(M2[49]))[25] = M1(1,11); (*(M2[49]))[26] = M1(1,12); (*(M2[49]))[30] = M1(1,13); (*(M2[49]))[31] = M1(1,14); (*(M2[49]))[35] = M1(1,15); (*(M2[49]))[44] = M1(1,16); (*(M2[49]))[45] = M1(1,17); (*(M2[49]))[49] = M1(1,18); (*(M2[49]))[58] = M1(1,19); (*(M2[49]))[72] = M1(1,20); (*(M2[49]))[73] = M1(1,21); (*(M2[49]))[77] = M1(1,22); (*(M2[49]))[92] = M1(1,23); 
  (*(M2[50]))[2] = M1(2,2); (*(M2[50]))[11] = M1(2,7); (*(M2[50]))[12] = M1(2,8); (*(M2[50]))[16] = M1(2,9); (*(M2[50]))[25] = M1(2,11); (*(M2[50]))[26] = M1(2,12); (*(M2[50]))[30] = M1(2,13); (*(M2[50]))[31] = M1(2,14); (*(M2[50]))[35] = M1(2,15); (*(M2[50]))[44] = M1(2,16); (*(M2[50]))[45] = M1(2,17); (*(M2[50]))[49] = M1(2,18); (*(M2[50]))[58] = M1(2,19); (*(M2[50]))[72] = M1(2,20); (*(M2[50]))[73] = M1(2,21); (*(M2[50]))[77] = M1(2,22); (*(M2[50]))[92] = M1(2,23); 
  (*(M2[51]))[3] = M1(3,3); (*(M2[51]))[11] = M1(3,7); (*(M2[51]))[12] = M1(3,8); (*(M2[51]))[16] = M1(3,9); (*(M2[51]))[25] = M1(3,11); (*(M2[51]))[26] = M1(3,12); (*(M2[51]))[30] = M1(3,13); (*(M2[51]))[31] = M1(3,14); (*(M2[51]))[35] = M1(3,15); (*(M2[51]))[44] = M1(3,16); (*(M2[51]))[45] = M1(3,17); (*(M2[51]))[49] = M1(3,18); (*(M2[51]))[58] = M1(3,19); (*(M2[51]))[72] = M1(3,20); (*(M2[51]))[73] = M1(3,21); (*(M2[51]))[77] = M1(3,22); (*(M2[51]))[92] = M1(3,23); 
  (*(M2[52]))[5] = M1(4,4); (*(M2[52]))[11] = M1(4,7); (*(M2[52]))[12] = M1(4,8); (*(M2[52]))[16] = M1(4,9); (*(M2[52]))[25] = M1(4,11); (*(M2[52]))[26] = M1(4,12); (*(M2[52]))[30] = M1(4,13); (*(M2[52]))[31] = M1(4,14); (*(M2[52]))[35] = M1(4,15); (*(M2[52]))[44] = M1(4,16); (*(M2[52]))[45] = M1(4,17); (*(M2[52]))[49] = M1(4,18); (*(M2[52]))[58] = M1(4,19); (*(M2[52]))[72] = M1(4,20); (*(M2[52]))[73] = M1(4,21); (*(M2[52]))[77] = M1(4,22); (*(M2[52]))[92] = M1(4,23); 
  (*(M2[53]))[6] = M1(5,5); (*(M2[53]))[11] = M1(5,7); (*(M2[53]))[12] = M1(5,8); (*(M2[53]))[16] = M1(5,9); (*(M2[53]))[25] = M1(5,11); (*(M2[53]))[26] = M1(5,12); (*(M2[53]))[30] = M1(5,13); (*(M2[53]))[31] = M1(5,14); (*(M2[53]))[35] = M1(5,15); (*(M2[53]))[44] = M1(5,16); (*(M2[53]))[45] = M1(5,17); (*(M2[53]))[49] = M1(5,18); (*(M2[53]))[58] = M1(5,19); (*(M2[53]))[72] = M1(5,20); (*(M2[53]))[73] = M1(5,21); (*(M2[53]))[77] = M1(5,22); (*(M2[53]))[92] = M1(5,23); 
  (*(M2[54]))[7] = M1(6,6); (*(M2[54]))[11] = M1(6,7); (*(M2[54]))[12] = M1(6,8); (*(M2[54]))[16] = M1(6,9); (*(M2[54]))[25] = M1(6,11); (*(M2[54]))[26] = M1(6,12); (*(M2[54]))[30] = M1(6,13); (*(M2[54]))[31] = M1(6,14); (*(M2[54]))[35] = M1(6,15); (*(M2[54]))[44] = M1(6,16); (*(M2[54]))[45] = M1(6,17); (*(M2[54]))[49] = M1(6,18); (*(M2[54]))[58] = M1(6,19); (*(M2[54]))[72] = M1(6,20); (*(M2[54]))[73] = M1(6,21); (*(M2[54]))[77] = M1(6,22); (*(M2[54]))[92] = M1(6,23); 
  (*(M2[55]))[24] = M1(7,10); (*(M2[55]))[26] = M1(7,12); (*(M2[55]))[35] = M1(7,15); (*(M2[55]))[58] = M1(7,19); (*(M2[55]))[92] = M1(7,23); 
  (*(M2[56]))[24] = M1(2,2); (*(M2[56]))[33] = M1(2,7); (*(M2[56]))[34] = M1(2,8); (*(M2[56]))[37] = M1(2,9); (*(M2[56]))[43] = M1(2,11); (*(M2[56]))[44] = M1(2,12); (*(M2[56]))[47] = M1(2,13); (*(M2[56]))[48] = M1(2,14); (*(M2[56]))[51] = M1(2,15); (*(M2[56]))[56] = M1(2,16); (*(M2[56]))[57] = M1(2,17); (*(M2[56]))[60] = M1(2,18); (*(M2[56]))[65] = M1(2,19); (*(M2[56]))[90] = M1(2,20); (*(M2[56]))[91] = M1(2,21); (*(M2[56]))[95] = M1(2,22); (*(M2[56]))[105] = M1(2,23); 
  (*(M2[57]))[25] = M1(3,3); (*(M2[57]))[33] = M1(3,7); (*(M2[57]))[34] = M1(3,8); (*(M2[57]))[37] = M1(3,9); (*(M2[57]))[43] = M1(3,11); (*(M2[57]))[44] = M1(3,12); (*(M2[57]))[47] = M1(3,13); (*(M2[57]))[48] = M1(3,14); (*(M2[57]))[51] = M1(3,15); (*(M2[57]))[56] = M1(3,16); (*(M2[57]))[57] = M1(3,17); (*(M2[57]))[60] = M1(3,18); (*(M2[57]))[65] = M1(3,19); (*(M2[57]))[90] = M1(3,20); (*(M2[57]))[91] = M1(3,21); (*(M2[57]))[95] = M1(3,22); (*(M2[57]))[105] = M1(3,23); 
  (*(M2[58]))[29] = M1(5,5); (*(M2[58]))[33] = M1(5,7); (*(M2[58]))[34] = M1(5,8); (*(M2[58]))[37] = M1(5,9); (*(M2[58]))[43] = M1(5,11); (*(M2[58]))[44] = M1(5,12); (*(M2[58]))[47] = M1(5,13); (*(M2[58]))[48] = M1(5,14); (*(M2[58]))[51] = M1(5,15); (*(M2[58]))[56] = M1(5,16); (*(M2[58]))[57] = M1(5,17); (*(M2[58]))[60] = M1(5,18); (*(M2[58]))[65] = M1(5,19); (*(M2[58]))[90] = M1(5,20); (*(M2[58]))[91] = M1(5,21); (*(M2[58]))[95] = M1(5,22); (*(M2[58]))[105] = M1(5,23); 
  (*(M2[59]))[30] = M1(6,6); (*(M2[59]))[33] = M1(6,7); (*(M2[59]))[34] = M1(6,8); (*(M2[59]))[37] = M1(6,9); (*(M2[59]))[43] = M1(6,11); (*(M2[59]))[44] = M1(6,12); (*(M2[59]))[47] = M1(6,13); (*(M2[59]))[48] = M1(6,14); (*(M2[59]))[51] = M1(6,15); (*(M2[59]))[56] = M1(6,16); (*(M2[59]))[57] = M1(6,17); (*(M2[59]))[60] = M1(6,18); (*(M2[59]))[65] = M1(6,19); (*(M2[59]))[90] = M1(6,20); (*(M2[59]))[91] = M1(6,21); (*(M2[59]))[95] = M1(6,22); (*(M2[59]))[105] = M1(6,23); 
  (*(M2[60]))[42] = M1(7,10); (*(M2[60]))[44] = M1(7,12); (*(M2[60]))[51] = M1(7,15); (*(M2[60]))[65] = M1(7,19); (*(M2[60]))[105] = M1(7,23); 
  (*(M2[61]))[5] = M1(2,2); (*(M2[61]))[14] = M1(2,7); (*(M2[61]))[15] = M1(2,8); (*(M2[61]))[18] = M1(2,9); (*(M2[61]))[29] = M1(2,11); (*(M2[61]))[30] = M1(2,12); (*(M2[61]))[33] = M1(2,13); (*(M2[61]))[34] = M1(2,14); (*(M2[61]))[37] = M1(2,15); (*(M2[61]))[47] = M1(2,16); (*(M2[61]))[48] = M1(2,17); (*(M2[61]))[51] = M1(2,18); (*(M2[61]))[60] = M1(2,19); (*(M2[61]))[75] = M1(2,20); (*(M2[61]))[76] = M1(2,21); (*(M2[61]))[80] = M1(2,22); (*(M2[61]))[95] = M1(2,23); 
  (*(M2[62]))[6] = M1(3,3); (*(M2[62]))[14] = M1(3,7); (*(M2[62]))[15] = M1(3,8); (*(M2[62]))[18] = M1(3,9); (*(M2[62]))[29] = M1(3,11); (*(M2[62]))[30] = M1(3,12); (*(M2[62]))[33] = M1(3,13); (*(M2[62]))[34] = M1(3,14); (*(M2[62]))[37] = M1(3,15); (*(M2[62]))[47] = M1(3,16); (*(M2[62]))[48] = M1(3,17); (*(M2[62]))[51] = M1(3,18); (*(M2[62]))[60] = M1(3,19); (*(M2[62]))[75] = M1(3,20); (*(M2[62]))[76] = M1(3,21); (*(M2[62]))[80] = M1(3,22); (*(M2[62]))[95] = M1(3,23); 
  (*(M2[63]))[9] = M1(4,4); (*(M2[63]))[14] = M1(4,7); (*(M2[63]))[15] = M1(4,8); (*(M2[63]))[18] = M1(4,9); (*(M2[63]))[29] = M1(4,11); (*(M2[63]))[30] = M1(4,12); (*(M2[63]))[33] = M1(4,13); (*(M2[63]))[34] = M1(4,14); (*(M2[63]))[37] = M1(4,15); (*(M2[63]))[47] = M1(4,16); (*(M2[63]))[48] = M1(4,17); (*(M2[63]))[51] = M1(4,18); (*(M2[63]))[60] = M1(4,19); (*(M2[63]))[75] = M1(4,20); (*(M2[63]))[76] = M1(4,21); (*(M2[63]))[80] = M1(4,22); (*(M2[63]))[95] = M1(4,23); 
  (*(M2[64]))[10] = M1(5,5); (*(M2[64]))[14] = M1(5,7); (*(M2[64]))[15] = M1(5,8); (*(M2[64]))[18] = M1(5,9); (*(M2[64]))[29] = M1(5,11); (*(M2[64]))[30] = M1(5,12); (*(M2[64]))[33] = M1(5,13); (*(M2[64]))[34] = M1(5,14); (*(M2[64]))[37] = M1(5,15); (*(M2[64]))[47] = M1(5,16); (*(M2[64]))[48] = M1(5,17); (*(M2[64]))[51] = M1(5,18); (*(M2[64]))[60] = M1(5,19); (*(M2[64]))[75] = M1(5,20); (*(M2[64]))[76] = M1(5,21); (*(M2[64]))[80] = M1(5,22); (*(M2[64]))[95] = M1(5,23); 
  (*(M2[65]))[11] = M1(6,6); (*(M2[65]))[14] = M1(6,7); (*(M2[65]))[15] = M1(6,8); (*(M2[65]))[18] = M1(6,9); (*(M2[65]))[29] = M1(6,11); (*(M2[65]))[30] = M1(6,12); (*(M2[65]))[33] = M1(6,13); (*(M2[65]))[34] = M1(6,14); (*(M2[65]))[37] = M1(6,15); (*(M2[65]))[47] = M1(6,16); (*(M2[65]))[48] = M1(6,17); (*(M2[65]))[51] = M1(6,18); (*(M2[65]))[60] = M1(6,19); (*(M2[65]))[75] = M1(6,20); (*(M2[65]))[76] = M1(6,21); (*(M2[65]))[80] = M1(6,22); (*(M2[65]))[95] = M1(6,23); 
  (*(M2[66]))[28] = M1(7,10); (*(M2[66]))[30] = M1(7,12); (*(M2[66]))[37] = M1(7,15); (*(M2[66]))[60] = M1(7,19); (*(M2[66]))[95] = M1(7,23); 
  (*(M2[67]))[0] = M1(1,1); (*(M2[67]))[10] = M1(1,7); (*(M2[67]))[11] = M1(1,8); (*(M2[67]))[15] = M1(1,9); (*(M2[67]))[24] = M1(1,11); (*(M2[67]))[25] = M1(1,12); (*(M2[67]))[29] = M1(1,13); (*(M2[67]))[30] = M1(1,14); (*(M2[67]))[34] = M1(1,15); (*(M2[67]))[43] = M1(1,16); (*(M2[67]))[44] = M1(1,17); (*(M2[67]))[48] = M1(1,18); (*(M2[67]))[57] = M1(1,19); (*(M2[67]))[71] = M1(1,20); (*(M2[67]))[72] = M1(1,21); (*(M2[67]))[76] = M1(1,22); (*(M2[67]))[91] = M1(1,23); 
  (*(M2[68]))[1] = M1(2,2); (*(M2[68]))[10] = M1(2,7); (*(M2[68]))[11] = M1(2,8); (*(M2[68]))[15] = M1(2,9); (*(M2[68]))[24] = M1(2,11); (*(M2[68]))[25] = M1(2,12); (*(M2[68]))[29] = M1(2,13); (*(M2[68]))[30] = M1(2,14); (*(M2[68]))[34] = M1(2,15); (*(M2[68]))[43] = M1(2,16); (*(M2[68]))[44] = M1(2,17); (*(M2[68]))[48] = M1(2,18); (*(M2[68]))[57] = M1(2,19); (*(M2[68]))[71] = M1(2,20); (*(M2[68]))[72] = M1(2,21); (*(M2[68]))[76] = M1(2,22); (*(M2[68]))[91] = M1(2,23); 
  (*(M2[69]))[2] = M1(3,3); (*(M2[69]))[10] = M1(3,7); (*(M2[69]))[11] = M1(3,8); (*(M2[69]))[15] = M1(3,9); (*(M2[69]))[24] = M1(3,11); (*(M2[69]))[25] = M1(3,12); (*(M2[69]))[29] = M1(3,13); (*(M2[69]))[30] = M1(3,14); (*(M2[69]))[34] = M1(3,15); (*(M2[69]))[43] = M1(3,16); (*(M2[69]))[44] = M1(3,17); (*(M2[69]))[48] = M1(3,18); (*(M2[69]))[57] = M1(3,19); (*(M2[69]))[71] = M1(3,20); (*(M2[69]))[72] = M1(3,21); (*(M2[69]))[76] = M1(3,22); (*(M2[69]))[91] = M1(3,23); 
  (*(M2[70]))[4] = M1(4,4); (*(M2[70]))[10] = M1(4,7); (*(M2[70]))[11] = M1(4,8); (*(M2[70]))[15] = M1(4,9); (*(M2[70]))[24] = M1(4,11); (*(M2[70]))[25] = M1(4,12); (*(M2[70]))[29] = M1(4,13); (*(M2[70]))[30] = M1(4,14); (*(M2[70]))[34] = M1(4,15); (*(M2[70]))[43] = M1(4,16); (*(M2[70]))[44] = M1(4,17); (*(M2[70]))[48] = M1(4,18); (*(M2[70]))[57] = M1(4,19); (*(M2[70]))[71] = M1(4,20); (*(M2[70]))[72] = M1(4,21); (*(M2[70]))[76] = M1(4,22); (*(M2[70]))[91] = M1(4,23); 
  (*(M2[71]))[5] = M1(5,5); (*(M2[71]))[10] = M1(5,7); (*(M2[71]))[11] = M1(5,8); (*(M2[71]))[15] = M1(5,9); (*(M2[71]))[24] = M1(5,11); (*(M2[71]))[25] = M1(5,12); (*(M2[71]))[29] = M1(5,13); (*(M2[71]))[30] = M1(5,14); (*(M2[71]))[34] = M1(5,15); (*(M2[71]))[43] = M1(5,16); (*(M2[71]))[44] = M1(5,17); (*(M2[71]))[48] = M1(5,18); (*(M2[71]))[57] = M1(5,19); (*(M2[71]))[71] = M1(5,20); (*(M2[71]))[72] = M1(5,21); (*(M2[71]))[76] = M1(5,22); (*(M2[71]))[91] = M1(5,23); 
  (*(M2[72]))[6] = M1(6,6); (*(M2[72]))[10] = M1(6,7); (*(M2[72]))[11] = M1(6,8); (*(M2[72]))[15] = M1(6,9); (*(M2[72]))[24] = M1(6,11); (*(M2[72]))[25] = M1(6,12); (*(M2[72]))[29] = M1(6,13); (*(M2[72]))[30] = M1(6,14); (*(M2[72]))[34] = M1(6,15); (*(M2[72]))[43] = M1(6,16); (*(M2[72]))[44] = M1(6,17); (*(M2[72]))[48] = M1(6,18); (*(M2[72]))[57] = M1(6,19); (*(M2[72]))[71] = M1(6,20); (*(M2[72]))[72] = M1(6,21); (*(M2[72]))[76] = M1(6,22); (*(M2[72]))[91] = M1(6,23); 
  (*(M2[73]))[23] = M1(7,10); (*(M2[73]))[25] = M1(7,12); (*(M2[73]))[34] = M1(7,15); (*(M2[73]))[57] = M1(7,19); (*(M2[73]))[91] = M1(7,23); 
  (*(M2[74]))[0] = M1(2,2); (*(M2[74]))[9] = M1(2,7); (*(M2[74]))[10] = M1(2,8); (*(M2[74]))[14] = M1(2,9); (*(M2[74]))[23] = M1(2,11); (*(M2[74]))[24] = M1(2,12); (*(M2[74]))[28] = M1(2,13); (*(M2[74]))[29] = M1(2,14); (*(M2[74]))[33] = M1(2,15); (*(M2[74]))[42] = M1(2,16); (*(M2[74]))[43] = M1(2,17); (*(M2[74]))[47] = M1(2,18); (*(M2[74]))[56] = M1(2,19); (*(M2[74]))[70] = M1(2,20); (*(M2[74]))[71] = M1(2,21); (*(M2[74]))[75] = M1(2,22); (*(M2[74]))[90] = M1(2,23); 
  (*(M2[75]))[1] = M1(3,3); (*(M2[75]))[9] = M1(3,7); (*(M2[75]))[10] = M1(3,8); (*(M2[75]))[14] = M1(3,9); (*(M2[75]))[23] = M1(3,11); (*(M2[75]))[24] = M1(3,12); (*(M2[75]))[28] = M1(3,13); (*(M2[75]))[29] = M1(3,14); (*(M2[75]))[33] = M1(3,15); (*(M2[75]))[42] = M1(3,16); (*(M2[75]))[43] = M1(3,17); (*(M2[75]))[47] = M1(3,18); (*(M2[75]))[56] = M1(3,19); (*(M2[75]))[70] = M1(3,20); (*(M2[75]))[71] = M1(3,21); (*(M2[75]))[75] = M1(3,22); (*(M2[75]))[90] = M1(3,23); 
  (*(M2[76]))[4] = M1(5,5); (*(M2[76]))[9] = M1(5,7); (*(M2[76]))[10] = M1(5,8); (*(M2[76]))[14] = M1(5,9); (*(M2[76]))[23] = M1(5,11); (*(M2[76]))[24] = M1(5,12); (*(M2[76]))[28] = M1(5,13); (*(M2[76]))[29] = M1(5,14); (*(M2[76]))[33] = M1(5,15); (*(M2[76]))[42] = M1(5,16); (*(M2[76]))[43] = M1(5,17); (*(M2[76]))[47] = M1(5,18); (*(M2[76]))[56] = M1(5,19); (*(M2[76]))[70] = M1(5,20); (*(M2[76]))[71] = M1(5,21); (*(M2[76]))[75] = M1(5,22); (*(M2[76]))[90] = M1(5,23); 
  (*(M2[77]))[5] = M1(6,6); (*(M2[77]))[9] = M1(6,7); (*(M2[77]))[10] = M1(6,8); (*(M2[77]))[14] = M1(6,9); (*(M2[77]))[23] = M1(6,11); (*(M2[77]))[24] = M1(6,12); (*(M2[77]))[28] = M1(6,13); (*(M2[77]))[29] = M1(6,14); (*(M2[77]))[33] = M1(6,15); (*(M2[77]))[42] = M1(6,16); (*(M2[77]))[43] = M1(6,17); (*(M2[77]))[47] = M1(6,18); (*(M2[77]))[56] = M1(6,19); (*(M2[77]))[70] = M1(6,20); (*(M2[77]))[71] = M1(6,21); (*(M2[77]))[75] = M1(6,22); (*(M2[77]))[90] = M1(6,23); 
  (*(M2[78]))[115] = M1(7,10); (*(M2[78]))[117] = M1(7,12); (*(M2[78]))[120] = M1(7,15); (*(M2[78]))[124] = M1(7,19); (*(M2[78]))[144] = M1(7,23); 
  (*(M2[79]))[97] = M1(2,2); (*(M2[79]))[102] = M1(2,7); (*(M2[79]))[103] = M1(2,8); (*(M2[79]))[104] = M1(2,9); (*(M2[79]))[110] = M1(2,11); (*(M2[79]))[111] = M1(2,12); (*(M2[79]))[112] = M1(2,13); (*(M2[79]))[113] = M1(2,14); (*(M2[79]))[114] = M1(2,15); (*(M2[79]))[118] = M1(2,16); (*(M2[79]))[119] = M1(2,17); (*(M2[79]))[120] = M1(2,18); (*(M2[79]))[123] = M1(2,19); (*(M2[79]))[138] = M1(2,20); (*(M2[79]))[139] = M1(2,21); (*(M2[79]))[140] = M1(2,22); (*(M2[79]))[143] = M1(2,23); 
  (*(M2[80]))[98] = M1(3,3); (*(M2[80]))[102] = M1(3,7); (*(M2[80]))[103] = M1(3,8); (*(M2[80]))[104] = M1(3,9); (*(M2[80]))[110] = M1(3,11); (*(M2[80]))[111] = M1(3,12); (*(M2[80]))[112] = M1(3,13); (*(M2[80]))[113] = M1(3,14); (*(M2[80]))[114] = M1(3,15); (*(M2[80]))[118] = M1(3,16); (*(M2[80]))[119] = M1(3,17); (*(M2[80]))[120] = M1(3,18); (*(M2[80]))[123] = M1(3,19); (*(M2[80]))[138] = M1(3,20); (*(M2[80]))[139] = M1(3,21); (*(M2[80]))[140] = M1(3,22); (*(M2[80]))[143] = M1(3,23); 
  (*(M2[81]))[100] = M1(5,5); (*(M2[81]))[102] = M1(5,7); (*(M2[81]))[103] = M1(5,8); (*(M2[81]))[104] = M1(5,9); (*(M2[81]))[110] = M1(5,11); (*(M2[81]))[111] = M1(5,12); (*(M2[81]))[112] = M1(5,13); (*(M2[81]))[113] = M1(5,14); (*(M2[81]))[114] = M1(5,15); (*(M2[81]))[118] = M1(5,16); (*(M2[81]))[119] = M1(5,17); (*(M2[81]))[120] = M1(5,18); (*(M2[81]))[123] = M1(5,19); (*(M2[81]))[138] = M1(5,20); (*(M2[81]))[139] = M1(5,21); (*(M2[81]))[140] = M1(5,22); (*(M2[81]))[143] = M1(5,23); 
  (*(M2[82]))[101] = M1(6,6); (*(M2[82]))[102] = M1(6,7); (*(M2[82]))[103] = M1(6,8); (*(M2[82]))[104] = M1(6,9); (*(M2[82]))[110] = M1(6,11); (*(M2[82]))[111] = M1(6,12); (*(M2[82]))[112] = M1(6,13); (*(M2[82]))[113] = M1(6,14); (*(M2[82]))[114] = M1(6,15); (*(M2[82]))[118] = M1(6,16); (*(M2[82]))[119] = M1(6,17); (*(M2[82]))[120] = M1(6,18); (*(M2[82]))[123] = M1(6,19); (*(M2[82]))[138] = M1(6,20); (*(M2[82]))[139] = M1(6,21); (*(M2[82]))[140] = M1(6,22); (*(M2[82]))[143] = M1(6,23); 
  (*(M2[83]))[109] = M1(7,10); (*(M2[83]))[111] = M1(7,12); (*(M2[83]))[114] = M1(7,15); (*(M2[83]))[123] = M1(7,19); (*(M2[83]))[143] = M1(7,23); 
  (*(M2[84]))[82] = M1(2,2); (*(M2[84]))[87] = M1(2,7); (*(M2[84]))[88] = M1(2,8); (*(M2[84]))[89] = M1(2,9); (*(M2[84]))[100] = M1(2,11); (*(M2[84]))[101] = M1(2,12); (*(M2[84]))[102] = M1(2,13); (*(M2[84]))[103] = M1(2,14); (*(M2[84]))[104] = M1(2,15); (*(M2[84]))[112] = M1(2,16); (*(M2[84]))[113] = M1(2,17); (*(M2[84]))[114] = M1(2,18); (*(M2[84]))[120] = M1(2,19); (*(M2[84]))[132] = M1(2,20); (*(M2[84]))[133] = M1(2,21); (*(M2[84]))[134] = M1(2,22); (*(M2[84]))[140] = M1(2,23); 
  (*(M2[85]))[83] = M1(3,3); (*(M2[85]))[87] = M1(3,7); (*(M2[85]))[88] = M1(3,8); (*(M2[85]))[89] = M1(3,9); (*(M2[85]))[100] = M1(3,11); (*(M2[85]))[101] = M1(3,12); (*(M2[85]))[102] = M1(3,13); (*(M2[85]))[103] = M1(3,14); (*(M2[85]))[104] = M1(3,15); (*(M2[85]))[112] = M1(3,16); (*(M2[85]))[113] = M1(3,17); (*(M2[85]))[114] = M1(3,18); (*(M2[85]))[120] = M1(3,19); (*(M2[85]))[132] = M1(3,20); (*(M2[85]))[133] = M1(3,21); (*(M2[85]))[134] = M1(3,22); (*(M2[85]))[140] = M1(3,23); 
  (*(M2[86]))[84] = M1(4,4); (*(M2[86]))[87] = M1(4,7); (*(M2[86]))[88] = M1(4,8); (*(M2[86]))[89] = M1(4,9); (*(M2[86]))[100] = M1(4,11); (*(M2[86]))[101] = M1(4,12); (*(M2[86]))[102] = M1(4,13); (*(M2[86]))[103] = M1(4,14); (*(M2[86]))[104] = M1(4,15); (*(M2[86]))[112] = M1(4,16); (*(M2[86]))[113] = M1(4,17); (*(M2[86]))[114] = M1(4,18); (*(M2[86]))[120] = M1(4,19); (*(M2[86]))[132] = M1(4,20); (*(M2[86]))[133] = M1(4,21); (*(M2[86]))[134] = M1(4,22); (*(M2[86]))[140] = M1(4,23); 
  (*(M2[87]))[85] = M1(5,5); (*(M2[87]))[87] = M1(5,7); (*(M2[87]))[88] = M1(5,8); (*(M2[87]))[89] = M1(5,9); (*(M2[87]))[100] = M1(5,11); (*(M2[87]))[101] = M1(5,12); (*(M2[87]))[102] = M1(5,13); (*(M2[87]))[103] = M1(5,14); (*(M2[87]))[104] = M1(5,15); (*(M2[87]))[112] = M1(5,16); (*(M2[87]))[113] = M1(5,17); (*(M2[87]))[114] = M1(5,18); (*(M2[87]))[120] = M1(5,19); (*(M2[87]))[132] = M1(5,20); (*(M2[87]))[133] = M1(5,21); (*(M2[87]))[134] = M1(5,22); (*(M2[87]))[140] = M1(5,23); 
  (*(M2[88]))[86] = M1(6,6); (*(M2[88]))[87] = M1(6,7); (*(M2[88]))[88] = M1(6,8); (*(M2[88]))[89] = M1(6,9); (*(M2[88]))[100] = M1(6,11); (*(M2[88]))[101] = M1(6,12); (*(M2[88]))[102] = M1(6,13); (*(M2[88]))[103] = M1(6,14); (*(M2[88]))[104] = M1(6,15); (*(M2[88]))[112] = M1(6,16); (*(M2[88]))[113] = M1(6,17); (*(M2[88]))[114] = M1(6,18); (*(M2[88]))[120] = M1(6,19); (*(M2[88]))[132] = M1(6,20); (*(M2[88]))[133] = M1(6,21); (*(M2[88]))[134] = M1(6,22); (*(M2[88]))[140] = M1(6,23); 
  (*(M2[89]))[99] = M1(7,10); (*(M2[89]))[101] = M1(7,12); (*(M2[89]))[104] = M1(7,15); (*(M2[89]))[120] = M1(7,19); (*(M2[89]))[140] = M1(7,23); 
  (*(M2[90]))[93] = M1(2,2); (*(M2[90]))[100] = M1(2,7); (*(M2[90]))[101] = M1(2,8); (*(M2[90]))[103] = M1(2,9); (*(M2[90]))[107] = M1(2,11); (*(M2[90]))[108] = M1(2,12); (*(M2[90]))[110] = M1(2,13); (*(M2[90]))[111] = M1(2,14); (*(M2[90]))[113] = M1(2,15); (*(M2[90]))[116] = M1(2,16); (*(M2[90]))[117] = M1(2,17); (*(M2[90]))[119] = M1(2,18); (*(M2[90]))[122] = M1(2,19); (*(M2[90]))[136] = M1(2,20); (*(M2[90]))[137] = M1(2,21); (*(M2[90]))[139] = M1(2,22); (*(M2[90]))[142] = M1(2,23); 
  (*(M2[91]))[94] = M1(3,3); (*(M2[91]))[100] = M1(3,7); (*(M2[91]))[101] = M1(3,8); (*(M2[91]))[103] = M1(3,9); (*(M2[91]))[107] = M1(3,11); (*(M2[91]))[108] = M1(3,12); (*(M2[91]))[110] = M1(3,13); (*(M2[91]))[111] = M1(3,14); (*(M2[91]))[113] = M1(3,15); (*(M2[91]))[116] = M1(3,16); (*(M2[91]))[117] = M1(3,17); (*(M2[91]))[119] = M1(3,18); (*(M2[91]))[122] = M1(3,19); (*(M2[91]))[136] = M1(3,20); (*(M2[91]))[137] = M1(3,21); (*(M2[91]))[139] = M1(3,22); (*(M2[91]))[142] = M1(3,23); 
  (*(M2[92]))[97] = M1(5,5); (*(M2[92]))[100] = M1(5,7); (*(M2[92]))[101] = M1(5,8); (*(M2[92]))[103] = M1(5,9); (*(M2[92]))[107] = M1(5,11); (*(M2[92]))[108] = M1(5,12); (*(M2[92]))[110] = M1(5,13); (*(M2[92]))[111] = M1(5,14); (*(M2[92]))[113] = M1(5,15); (*(M2[92]))[116] = M1(5,16); (*(M2[92]))[117] = M1(5,17); (*(M2[92]))[119] = M1(5,18); (*(M2[92]))[122] = M1(5,19); (*(M2[92]))[136] = M1(5,20); (*(M2[92]))[137] = M1(5,21); (*(M2[92]))[139] = M1(5,22); (*(M2[92]))[142] = M1(5,23); 
  (*(M2[93]))[98] = M1(6,6); (*(M2[93]))[100] = M1(6,7); (*(M2[93]))[101] = M1(6,8); (*(M2[93]))[103] = M1(6,9); (*(M2[93]))[107] = M1(6,11); (*(M2[93]))[108] = M1(6,12); (*(M2[93]))[110] = M1(6,13); (*(M2[93]))[111] = M1(6,14); (*(M2[93]))[113] = M1(6,15); (*(M2[93]))[116] = M1(6,16); (*(M2[93]))[117] = M1(6,17); (*(M2[93]))[119] = M1(6,18); (*(M2[93]))[122] = M1(6,19); (*(M2[93]))[136] = M1(6,20); (*(M2[93]))[137] = M1(6,21); (*(M2[93]))[139] = M1(6,22); (*(M2[93]))[142] = M1(6,23); 
  (*(M2[94]))[106] = M1(7,10); (*(M2[94]))[108] = M1(7,12); (*(M2[94]))[113] = M1(7,15); (*(M2[94]))[122] = M1(7,19); (*(M2[94]))[142] = M1(7,23); 
  (*(M2[95]))[78] = M1(2,2); (*(M2[95]))[85] = M1(2,7); (*(M2[95]))[86] = M1(2,8); (*(M2[95]))[88] = M1(2,9); (*(M2[95]))[97] = M1(2,11); (*(M2[95]))[98] = M1(2,12); (*(M2[95]))[100] = M1(2,13); (*(M2[95]))[101] = M1(2,14); (*(M2[95]))[103] = M1(2,15); (*(M2[95]))[110] = M1(2,16); (*(M2[95]))[111] = M1(2,17); (*(M2[95]))[113] = M1(2,18); (*(M2[95]))[119] = M1(2,19); (*(M2[95]))[130] = M1(2,20); (*(M2[95]))[131] = M1(2,21); (*(M2[95]))[133] = M1(2,22); (*(M2[95]))[139] = M1(2,23); 
  (*(M2[96]))[79] = M1(3,3); (*(M2[96]))[85] = M1(3,7); (*(M2[96]))[86] = M1(3,8); (*(M2[96]))[88] = M1(3,9); (*(M2[96]))[97] = M1(3,11); (*(M2[96]))[98] = M1(3,12); (*(M2[96]))[100] = M1(3,13); (*(M2[96]))[101] = M1(3,14); (*(M2[96]))[103] = M1(3,15); (*(M2[96]))[110] = M1(3,16); (*(M2[96]))[111] = M1(3,17); (*(M2[96]))[113] = M1(3,18); (*(M2[96]))[119] = M1(3,19); (*(M2[96]))[130] = M1(3,20); (*(M2[96]))[131] = M1(3,21); (*(M2[96]))[133] = M1(3,22); (*(M2[96]))[139] = M1(3,23); 
  (*(M2[97]))[81] = M1(4,4); (*(M2[97]))[85] = M1(4,7); (*(M2[97]))[86] = M1(4,8); (*(M2[97]))[88] = M1(4,9); (*(M2[97]))[97] = M1(4,11); (*(M2[97]))[98] = M1(4,12); (*(M2[97]))[100] = M1(4,13); (*(M2[97]))[101] = M1(4,14); (*(M2[97]))[103] = M1(4,15); (*(M2[97]))[110] = M1(4,16); (*(M2[97]))[111] = M1(4,17); (*(M2[97]))[113] = M1(4,18); (*(M2[97]))[119] = M1(4,19); (*(M2[97]))[130] = M1(4,20); (*(M2[97]))[131] = M1(4,21); (*(M2[97]))[133] = M1(4,22); (*(M2[97]))[139] = M1(4,23); 
  (*(M2[98]))[82] = M1(5,5); (*(M2[98]))[85] = M1(5,7); (*(M2[98]))[86] = M1(5,8); (*(M2[98]))[88] = M1(5,9); (*(M2[98]))[97] = M1(5,11); (*(M2[98]))[98] = M1(5,12); (*(M2[98]))[100] = M1(5,13); (*(M2[98]))[101] = M1(5,14); (*(M2[98]))[103] = M1(5,15); (*(M2[98]))[110] = M1(5,16); (*(M2[98]))[111] = M1(5,17); (*(M2[98]))[113] = M1(5,18); (*(M2[98]))[119] = M1(5,19); (*(M2[98]))[130] = M1(5,20); (*(M2[98]))[131] = M1(5,21); (*(M2[98]))[133] = M1(5,22); (*(M2[98]))[139] = M1(5,23); 
  (*(M2[99]))[83] = M1(6,6); (*(M2[99]))[85] = M1(6,7); (*(M2[99]))[86] = M1(6,8); (*(M2[99]))[88] = M1(6,9); (*(M2[99]))[97] = M1(6,11); (*(M2[99]))[98] = M1(6,12); (*(M2[99]))[100] = M1(6,13); (*(M2[99]))[101] = M1(6,14); (*(M2[99]))[103] = M1(6,15); (*(M2[99]))[110] = M1(6,16); (*(M2[99]))[111] = M1(6,17); (*(M2[99]))[113] = M1(6,18); (*(M2[99]))[119] = M1(6,19); (*(M2[99]))[130] = M1(6,20); (*(M2[99]))[131] = M1(6,21); (*(M2[99]))[133] = M1(6,22); (*(M2[99]))[139] = M1(6,23); 
  (*(M2[100]))[96] = M1(7,10); (*(M2[100]))[98] = M1(7,12); (*(M2[100]))[103] = M1(7,15); (*(M2[100]))[119] = M1(7,19); (*(M2[100]))[139] = M1(7,23); 
  (*(M2[101]))[73] = M1(1,1); (*(M2[101]))[82] = M1(1,7); (*(M2[101]))[83] = M1(1,8); (*(M2[101]))[86] = M1(1,9); (*(M2[101]))[93] = M1(1,11); (*(M2[101]))[94] = M1(1,12); (*(M2[101]))[97] = M1(1,13); (*(M2[101]))[98] = M1(1,14); (*(M2[101]))[101] = M1(1,15); (*(M2[101]))[107] = M1(1,16); (*(M2[101]))[108] = M1(1,17); (*(M2[101]))[111] = M1(1,18); (*(M2[101]))[117] = M1(1,19); (*(M2[101]))[127] = M1(1,20); (*(M2[101]))[128] = M1(1,21); (*(M2[101]))[131] = M1(1,22); (*(M2[101]))[137] = M1(1,23); 
  (*(M2[102]))[74] = M1(2,2); (*(M2[102]))[82] = M1(2,7); (*(M2[102]))[83] = M1(2,8); (*(M2[102]))[86] = M1(2,9); (*(M2[102]))[93] = M1(2,11); (*(M2[102]))[94] = M1(2,12); (*(M2[102]))[97] = M1(2,13); (*(M2[102]))[98] = M1(2,14); (*(M2[102]))[101] = M1(2,15); (*(M2[102]))[107] = M1(2,16); (*(M2[102]))[108] = M1(2,17); (*(M2[102]))[111] = M1(2,18); (*(M2[102]))[117] = M1(2,19); (*(M2[102]))[127] = M1(2,20); (*(M2[102]))[128] = M1(2,21); (*(M2[102]))[131] = M1(2,22); (*(M2[102]))[137] = M1(2,23); 
  (*(M2[103]))[77] = M1(4,4); (*(M2[103]))[82] = M1(4,7); (*(M2[103]))[83] = M1(4,8); (*(M2[103]))[86] = M1(4,9); (*(M2[103]))[93] = M1(4,11); (*(M2[103]))[94] = M1(4,12); (*(M2[103]))[97] = M1(4,13); (*(M2[103]))[98] = M1(4,14); (*(M2[103]))[101] = M1(4,15); (*(M2[103]))[107] = M1(4,16); (*(M2[103]))[108] = M1(4,17); (*(M2[103]))[111] = M1(4,18); (*(M2[103]))[117] = M1(4,19); (*(M2[103]))[127] = M1(4,20); (*(M2[103]))[128] = M1(4,21); (*(M2[103]))[131] = M1(4,22); (*(M2[103]))[137] = M1(4,23); 
  (*(M2[104]))[78] = M1(5,5); (*(M2[104]))[82] = M1(5,7); (*(M2[104]))[83] = M1(5,8); (*(M2[104]))[86] = M1(5,9); (*(M2[104]))[93] = M1(5,11); (*(M2[104]))[94] = M1(5,12); (*(M2[104]))[97] = M1(5,13); (*(M2[104]))[98] = M1(5,14); (*(M2[104]))[101] = M1(5,15); (*(M2[104]))[107] = M1(5,16); (*(M2[104]))[108] = M1(5,17); (*(M2[104]))[111] = M1(5,18); (*(M2[104]))[117] = M1(5,19); (*(M2[104]))[127] = M1(5,20); (*(M2[104]))[128] = M1(5,21); (*(M2[104]))[131] = M1(5,22); (*(M2[104]))[137] = M1(5,23); 
  (*(M2[105]))[79] = M1(6,6); (*(M2[105]))[82] = M1(6,7); (*(M2[105]))[83] = M1(6,8); (*(M2[105]))[86] = M1(6,9); (*(M2[105]))[93] = M1(6,11); (*(M2[105]))[94] = M1(6,12); (*(M2[105]))[97] = M1(6,13); (*(M2[105]))[98] = M1(6,14); (*(M2[105]))[101] = M1(6,15); (*(M2[105]))[107] = M1(6,16); (*(M2[105]))[108] = M1(6,17); (*(M2[105]))[111] = M1(6,18); (*(M2[105]))[117] = M1(6,19); (*(M2[105]))[127] = M1(6,20); (*(M2[105]))[128] = M1(6,21); (*(M2[105]))[131] = M1(6,22); (*(M2[105]))[137] = M1(6,23); 
  (*(M2[106]))[92] = M1(7,10); (*(M2[106]))[94] = M1(7,12); (*(M2[106]))[101] = M1(7,15); (*(M2[106]))[117] = M1(7,19); (*(M2[106]))[137] = M1(7,23); 
  (*(M2[107]))[92] = M1(2,2); (*(M2[107]))[99] = M1(2,7); (*(M2[107]))[100] = M1(2,8); (*(M2[107]))[102] = M1(2,9); (*(M2[107]))[106] = M1(2,11); (*(M2[107]))[107] = M1(2,12); (*(M2[107]))[109] = M1(2,13); (*(M2[107]))[110] = M1(2,14); (*(M2[107]))[112] = M1(2,15); (*(M2[107]))[115] = M1(2,16); (*(M2[107]))[116] = M1(2,17); (*(M2[107]))[118] = M1(2,18); (*(M2[107]))[121] = M1(2,19); (*(M2[107]))[135] = M1(2,20); (*(M2[107]))[136] = M1(2,21); (*(M2[107]))[138] = M1(2,22); (*(M2[107]))[141] = M1(2,23); 
  (*(M2[108]))[93] = M1(3,3); (*(M2[108]))[99] = M1(3,7); (*(M2[108]))[100] = M1(3,8); (*(M2[108]))[102] = M1(3,9); (*(M2[108]))[106] = M1(3,11); (*(M2[108]))[107] = M1(3,12); (*(M2[108]))[109] = M1(3,13); (*(M2[108]))[110] = M1(3,14); (*(M2[108]))[112] = M1(3,15); (*(M2[108]))[115] = M1(3,16); (*(M2[108]))[116] = M1(3,17); (*(M2[108]))[118] = M1(3,18); (*(M2[108]))[121] = M1(3,19); (*(M2[108]))[135] = M1(3,20); (*(M2[108]))[136] = M1(3,21); (*(M2[108]))[138] = M1(3,22); (*(M2[108]))[141] = M1(3,23); 
  (*(M2[109]))[96] = M1(5,5); (*(M2[109]))[99] = M1(5,7); (*(M2[109]))[100] = M1(5,8); (*(M2[109]))[102] = M1(5,9); (*(M2[109]))[106] = M1(5,11); (*(M2[109]))[107] = M1(5,12); (*(M2[109]))[109] = M1(5,13); (*(M2[109]))[110] = M1(5,14); (*(M2[109]))[112] = M1(5,15); (*(M2[109]))[115] = M1(5,16); (*(M2[109]))[116] = M1(5,17); (*(M2[109]))[118] = M1(5,18); (*(M2[109]))[121] = M1(5,19); (*(M2[109]))[135] = M1(5,20); (*(M2[109]))[136] = M1(5,21); (*(M2[109]))[138] = M1(5,22); (*(M2[109]))[141] = M1(5,23); 
  (*(M2[110]))[97] = M1(6,6); (*(M2[110]))[99] = M1(6,7); (*(M2[110]))[100] = M1(6,8); (*(M2[110]))[102] = M1(6,9); (*(M2[110]))[106] = M1(6,11); (*(M2[110]))[107] = M1(6,12); (*(M2[110]))[109] = M1(6,13); (*(M2[110]))[110] = M1(6,14); (*(M2[110]))[112] = M1(6,15); (*(M2[110]))[115] = M1(6,16); (*(M2[110]))[116] = M1(6,17); (*(M2[110]))[118] = M1(6,18); (*(M2[110]))[121] = M1(6,19); (*(M2[110]))[135] = M1(6,20); (*(M2[110]))[136] = M1(6,21); (*(M2[110]))[138] = M1(6,22); (*(M2[110]))[141] = M1(6,23); 
  (*(M2[111]))[105] = M1(7,10); (*(M2[111]))[107] = M1(7,12); (*(M2[111]))[112] = M1(7,15); (*(M2[111]))[121] = M1(7,19); (*(M2[111]))[141] = M1(7,23); 
  (*(M2[112]))[77] = M1(2,2); (*(M2[112]))[84] = M1(2,7); (*(M2[112]))[85] = M1(2,8); (*(M2[112]))[87] = M1(2,9); (*(M2[112]))[96] = M1(2,11); (*(M2[112]))[97] = M1(2,12); (*(M2[112]))[99] = M1(2,13); (*(M2[112]))[100] = M1(2,14); (*(M2[112]))[102] = M1(2,15); (*(M2[112]))[109] = M1(2,16); (*(M2[112]))[110] = M1(2,17); (*(M2[112]))[112] = M1(2,18); (*(M2[112]))[118] = M1(2,19); (*(M2[112]))[129] = M1(2,20); (*(M2[112]))[130] = M1(2,21); (*(M2[112]))[132] = M1(2,22); (*(M2[112]))[138] = M1(2,23); 
  (*(M2[113]))[78] = M1(3,3); (*(M2[113]))[84] = M1(3,7); (*(M2[113]))[85] = M1(3,8); (*(M2[113]))[87] = M1(3,9); (*(M2[113]))[96] = M1(3,11); (*(M2[113]))[97] = M1(3,12); (*(M2[113]))[99] = M1(3,13); (*(M2[113]))[100] = M1(3,14); (*(M2[113]))[102] = M1(3,15); (*(M2[113]))[109] = M1(3,16); (*(M2[113]))[110] = M1(3,17); (*(M2[113]))[112] = M1(3,18); (*(M2[113]))[118] = M1(3,19); (*(M2[113]))[129] = M1(3,20); (*(M2[113]))[130] = M1(3,21); (*(M2[113]))[132] = M1(3,22); (*(M2[113]))[138] = M1(3,23); 
  (*(M2[114]))[80] = M1(4,4); (*(M2[114]))[84] = M1(4,7); (*(M2[114]))[85] = M1(4,8); (*(M2[114]))[87] = M1(4,9); (*(M2[114]))[96] = M1(4,11); (*(M2[114]))[97] = M1(4,12); (*(M2[114]))[99] = M1(4,13); (*(M2[114]))[100] = M1(4,14); (*(M2[114]))[102] = M1(4,15); (*(M2[114]))[109] = M1(4,16); (*(M2[114]))[110] = M1(4,17); (*(M2[114]))[112] = M1(4,18); (*(M2[114]))[118] = M1(4,19); (*(M2[114]))[129] = M1(4,20); (*(M2[114]))[130] = M1(4,21); (*(M2[114]))[132] = M1(4,22); (*(M2[114]))[138] = M1(4,23); 
  (*(M2[115]))[81] = M1(5,5); (*(M2[115]))[84] = M1(5,7); (*(M2[115]))[85] = M1(5,8); (*(M2[115]))[87] = M1(5,9); (*(M2[115]))[96] = M1(5,11); (*(M2[115]))[97] = M1(5,12); (*(M2[115]))[99] = M1(5,13); (*(M2[115]))[100] = M1(5,14); (*(M2[115]))[102] = M1(5,15); (*(M2[115]))[109] = M1(5,16); (*(M2[115]))[110] = M1(5,17); (*(M2[115]))[112] = M1(5,18); (*(M2[115]))[118] = M1(5,19); (*(M2[115]))[129] = M1(5,20); (*(M2[115]))[130] = M1(5,21); (*(M2[115]))[132] = M1(5,22); (*(M2[115]))[138] = M1(5,23); 
  (*(M2[116]))[82] = M1(6,6); (*(M2[116]))[84] = M1(6,7); (*(M2[116]))[85] = M1(6,8); (*(M2[116]))[87] = M1(6,9); (*(M2[116]))[96] = M1(6,11); (*(M2[116]))[97] = M1(6,12); (*(M2[116]))[99] = M1(6,13); (*(M2[116]))[100] = M1(6,14); (*(M2[116]))[102] = M1(6,15); (*(M2[116]))[109] = M1(6,16); (*(M2[116]))[110] = M1(6,17); (*(M2[116]))[112] = M1(6,18); (*(M2[116]))[118] = M1(6,19); (*(M2[116]))[129] = M1(6,20); (*(M2[116]))[130] = M1(6,21); (*(M2[116]))[132] = M1(6,22); (*(M2[116]))[138] = M1(6,23); 
  (*(M2[117]))[95] = M1(7,10); (*(M2[117]))[97] = M1(7,12); (*(M2[117]))[102] = M1(7,15); (*(M2[117]))[118] = M1(7,19); (*(M2[117]))[138] = M1(7,23); 
  (*(M2[118]))[72] = M1(1,1); (*(M2[118]))[81] = M1(1,7); (*(M2[118]))[82] = M1(1,8); (*(M2[118]))[85] = M1(1,9); (*(M2[118]))[92] = M1(1,11); (*(M2[118]))[93] = M1(1,12); (*(M2[118]))[96] = M1(1,13); (*(M2[118]))[97] = M1(1,14); (*(M2[118]))[100] = M1(1,15); (*(M2[118]))[106] = M1(1,16); (*(M2[118]))[107] = M1(1,17); (*(M2[118]))[110] = M1(1,18); (*(M2[118]))[116] = M1(1,19); (*(M2[118]))[126] = M1(1,20); (*(M2[118]))[127] = M1(1,21); (*(M2[118]))[130] = M1(1,22); (*(M2[118]))[136] = M1(1,23); 
  (*(M2[119]))[73] = M1(2,2); (*(M2[119]))[81] = M1(2,7); (*(M2[119]))[82] = M1(2,8); (*(M2[119]))[85] = M1(2,9); (*(M2[119]))[92] = M1(2,11); (*(M2[119]))[93] = M1(2,12); (*(M2[119]))[96] = M1(2,13); (*(M2[119]))[97] = M1(2,14); (*(M2[119]))[100] = M1(2,15); (*(M2[119]))[106] = M1(2,16); (*(M2[119]))[107] = M1(2,17); (*(M2[119]))[110] = M1(2,18); (*(M2[119]))[116] = M1(2,19); (*(M2[119]))[126] = M1(2,20); (*(M2[119]))[127] = M1(2,21); (*(M2[119]))[130] = M1(2,22); (*(M2[119]))[136] = M1(2,23); 
  (*(M2[120]))[74] = M1(3,3); (*(M2[120]))[81] = M1(3,7); (*(M2[120]))[82] = M1(3,8); (*(M2[120]))[85] = M1(3,9); (*(M2[120]))[92] = M1(3,11); (*(M2[120]))[93] = M1(3,12); (*(M2[120]))[96] = M1(3,13); (*(M2[120]))[97] = M1(3,14); (*(M2[120]))[100] = M1(3,15); (*(M2[120]))[106] = M1(3,16); (*(M2[120]))[107] = M1(3,17); (*(M2[120]))[110] = M1(3,18); (*(M2[120]))[116] = M1(3,19); (*(M2[120]))[126] = M1(3,20); (*(M2[120]))[127] = M1(3,21); (*(M2[120]))[130] = M1(3,22); (*(M2[120]))[136] = M1(3,23); 
  (*(M2[121]))[76] = M1(4,4); (*(M2[121]))[81] = M1(4,7); (*(M2[121]))[82] = M1(4,8); (*(M2[121]))[85] = M1(4,9); (*(M2[121]))[92] = M1(4,11); (*(M2[121]))[93] = M1(4,12); (*(M2[121]))[96] = M1(4,13); (*(M2[121]))[97] = M1(4,14); (*(M2[121]))[100] = M1(4,15); (*(M2[121]))[106] = M1(4,16); (*(M2[121]))[107] = M1(4,17); (*(M2[121]))[110] = M1(4,18); (*(M2[121]))[116] = M1(4,19); (*(M2[121]))[126] = M1(4,20); (*(M2[121]))[127] = M1(4,21); (*(M2[121]))[130] = M1(4,22); (*(M2[121]))[136] = M1(4,23); 
  (*(M2[122]))[77] = M1(5,5); (*(M2[122]))[81] = M1(5,7); (*(M2[122]))[82] = M1(5,8); (*(M2[122]))[85] = M1(5,9); (*(M2[122]))[92] = M1(5,11); (*(M2[122]))[93] = M1(5,12); (*(M2[122]))[96] = M1(5,13); (*(M2[122]))[97] = M1(5,14); (*(M2[122]))[100] = M1(5,15); (*(M2[122]))[106] = M1(5,16); (*(M2[122]))[107] = M1(5,17); (*(M2[122]))[110] = M1(5,18); (*(M2[122]))[116] = M1(5,19); (*(M2[122]))[126] = M1(5,20); (*(M2[122]))[127] = M1(5,21); (*(M2[122]))[130] = M1(5,22); (*(M2[122]))[136] = M1(5,23); 
  (*(M2[123]))[78] = M1(6,6); (*(M2[123]))[81] = M1(6,7); (*(M2[123]))[82] = M1(6,8); (*(M2[123]))[85] = M1(6,9); (*(M2[123]))[92] = M1(6,11); (*(M2[123]))[93] = M1(6,12); (*(M2[123]))[96] = M1(6,13); (*(M2[123]))[97] = M1(6,14); (*(M2[123]))[100] = M1(6,15); (*(M2[123]))[106] = M1(6,16); (*(M2[123]))[107] = M1(6,17); (*(M2[123]))[110] = M1(6,18); (*(M2[123]))[116] = M1(6,19); (*(M2[123]))[126] = M1(6,20); (*(M2[123]))[127] = M1(6,21); (*(M2[123]))[130] = M1(6,22); (*(M2[123]))[136] = M1(6,23); 
  (*(M2[124]))[91] = M1(7,10); (*(M2[124]))[93] = M1(7,12); (*(M2[124]))[100] = M1(7,15); (*(M2[124]))[116] = M1(7,19); (*(M2[124]))[136] = M1(7,23); 
  (*(M2[125]))[70] = M1(0,0); (*(M2[125]))[80] = M1(0,7); (*(M2[125]))[81] = M1(0,8); (*(M2[125]))[84] = M1(0,9); (*(M2[125]))[91] = M1(0,11); (*(M2[125]))[92] = M1(0,12); (*(M2[125]))[95] = M1(0,13); (*(M2[125]))[96] = M1(0,14); (*(M2[125]))[99] = M1(0,15); (*(M2[125]))[105] = M1(0,16); (*(M2[125]))[106] = M1(0,17); (*(M2[125]))[109] = M1(0,18); (*(M2[125]))[115] = M1(0,19); (*(M2[125]))[125] = M1(0,20); (*(M2[125]))[126] = M1(0,21); (*(M2[125]))[129] = M1(0,22); (*(M2[125]))[135] = M1(0,23); 
  (*(M2[126]))[71] = M1(1,1); (*(M2[126]))[80] = M1(1,7); (*(M2[126]))[81] = M1(1,8); (*(M2[126]))[84] = M1(1,9); (*(M2[126]))[91] = M1(1,11); (*(M2[126]))[92] = M1(1,12); (*(M2[126]))[95] = M1(1,13); (*(M2[126]))[96] = M1(1,14); (*(M2[126]))[99] = M1(1,15); (*(M2[126]))[105] = M1(1,16); (*(M2[126]))[106] = M1(1,17); (*(M2[126]))[109] = M1(1,18); (*(M2[126]))[115] = M1(1,19); (*(M2[126]))[125] = M1(1,20); (*(M2[126]))[126] = M1(1,21); (*(M2[126]))[129] = M1(1,22); (*(M2[126]))[135] = M1(1,23); 
  (*(M2[127]))[72] = M1(2,2); (*(M2[127]))[80] = M1(2,7); (*(M2[127]))[81] = M1(2,8); (*(M2[127]))[84] = M1(2,9); (*(M2[127]))[91] = M1(2,11); (*(M2[127]))[92] = M1(2,12); (*(M2[127]))[95] = M1(2,13); (*(M2[127]))[96] = M1(2,14); (*(M2[127]))[99] = M1(2,15); (*(M2[127]))[105] = M1(2,16); (*(M2[127]))[106] = M1(2,17); (*(M2[127]))[109] = M1(2,18); (*(M2[127]))[115] = M1(2,19); (*(M2[127]))[125] = M1(2,20); (*(M2[127]))[126] = M1(2,21); (*(M2[127]))[129] = M1(2,22); (*(M2[127]))[135] = M1(2,23); 
  (*(M2[128]))[73] = M1(3,3); (*(M2[128]))[80] = M1(3,7); (*(M2[128]))[81] = M1(3,8); (*(M2[128]))[84] = M1(3,9); (*(M2[128]))[91] = M1(3,11); (*(M2[128]))[92] = M1(3,12); (*(M2[128]))[95] = M1(3,13); (*(M2[128]))[96] = M1(3,14); (*(M2[128]))[99] = M1(3,15); (*(M2[128]))[105] = M1(3,16); (*(M2[128]))[106] = M1(3,17); (*(M2[128]))[109] = M1(3,18); (*(M2[128]))[115] = M1(3,19); (*(M2[128]))[125] = M1(3,20); (*(M2[128]))[126] = M1(3,21); (*(M2[128]))[129] = M1(3,22); (*(M2[128]))[135] = M1(3,23); 
  (*(M2[129]))[75] = M1(4,4); (*(M2[129]))[80] = M1(4,7); (*(M2[129]))[81] = M1(4,8); (*(M2[129]))[84] = M1(4,9); (*(M2[129]))[91] = M1(4,11); (*(M2[129]))[92] = M1(4,12); (*(M2[129]))[95] = M1(4,13); (*(M2[129]))[96] = M1(4,14); (*(M2[129]))[99] = M1(4,15); (*(M2[129]))[105] = M1(4,16); (*(M2[129]))[106] = M1(4,17); (*(M2[129]))[109] = M1(4,18); (*(M2[129]))[115] = M1(4,19); (*(M2[129]))[125] = M1(4,20); (*(M2[129]))[126] = M1(4,21); (*(M2[129]))[129] = M1(4,22); (*(M2[129]))[135] = M1(4,23); 
  (*(M2[130]))[76] = M1(5,5); (*(M2[130]))[80] = M1(5,7); (*(M2[130]))[81] = M1(5,8); (*(M2[130]))[84] = M1(5,9); (*(M2[130]))[91] = M1(5,11); (*(M2[130]))[92] = M1(5,12); (*(M2[130]))[95] = M1(5,13); (*(M2[130]))[96] = M1(5,14); (*(M2[130]))[99] = M1(5,15); (*(M2[130]))[105] = M1(5,16); (*(M2[130]))[106] = M1(5,17); (*(M2[130]))[109] = M1(5,18); (*(M2[130]))[115] = M1(5,19); (*(M2[130]))[125] = M1(5,20); (*(M2[130]))[126] = M1(5,21); (*(M2[130]))[129] = M1(5,22); (*(M2[130]))[135] = M1(5,23); 
  (*(M2[131]))[77] = M1(6,6); (*(M2[131]))[80] = M1(6,7); (*(M2[131]))[81] = M1(6,8); (*(M2[131]))[84] = M1(6,9); (*(M2[131]))[91] = M1(6,11); (*(M2[131]))[92] = M1(6,12); (*(M2[131]))[95] = M1(6,13); (*(M2[131]))[96] = M1(6,14); (*(M2[131]))[99] = M1(6,15); (*(M2[131]))[105] = M1(6,16); (*(M2[131]))[106] = M1(6,17); (*(M2[131]))[109] = M1(6,18); (*(M2[131]))[115] = M1(6,19); (*(M2[131]))[125] = M1(6,20); (*(M2[131]))[126] = M1(6,21); (*(M2[131]))[129] = M1(6,22); (*(M2[131]))[135] = M1(6,23); 
  (*(M2[132]))[90] = M1(7,10); (*(M2[132]))[92] = M1(7,12); (*(M2[132]))[99] = M1(7,15); (*(M2[132]))[115] = M1(7,19); (*(M2[132]))[135] = M1(7,23); 
  (*(M2[133]))[125] = M1(0,0); (*(M2[133]))[132] = M1(0,7); (*(M2[133]))[133] = M1(0,8); (*(M2[133]))[134] = M1(0,9); (*(M2[133]))[136] = M1(0,11); (*(M2[133]))[137] = M1(0,12); (*(M2[133]))[138] = M1(0,13); (*(M2[133]))[139] = M1(0,14); (*(M2[133]))[140] = M1(0,15); (*(M2[133]))[141] = M1(0,16); (*(M2[133]))[142] = M1(0,17); (*(M2[133]))[143] = M1(0,18); (*(M2[133]))[144] = M1(0,19); (*(M2[133]))[145] = M1(0,20); (*(M2[133]))[146] = M1(0,21); (*(M2[133]))[147] = M1(0,22); (*(M2[133]))[148] = M1(0,23); 
  (*(M2[134]))[126] = M1(1,1); (*(M2[134]))[132] = M1(1,7); (*(M2[134]))[133] = M1(1,8); (*(M2[134]))[134] = M1(1,9); (*(M2[134]))[136] = M1(1,11); (*(M2[134]))[137] = M1(1,12); (*(M2[134]))[138] = M1(1,13); (*(M2[134]))[139] = M1(1,14); (*(M2[134]))[140] = M1(1,15); (*(M2[134]))[141] = M1(1,16); (*(M2[134]))[142] = M1(1,17); (*(M2[134]))[143] = M1(1,18); (*(M2[134]))[144] = M1(1,19); (*(M2[134]))[145] = M1(1,20); (*(M2[134]))[146] = M1(1,21); (*(M2[134]))[147] = M1(1,22); (*(M2[134]))[148] = M1(1,23); 
  (*(M2[135]))[127] = M1(2,2); (*(M2[135]))[132] = M1(2,7); (*(M2[135]))[133] = M1(2,8); (*(M2[135]))[134] = M1(2,9); (*(M2[135]))[136] = M1(2,11); (*(M2[135]))[137] = M1(2,12); (*(M2[135]))[138] = M1(2,13); (*(M2[135]))[139] = M1(2,14); (*(M2[135]))[140] = M1(2,15); (*(M2[135]))[141] = M1(2,16); (*(M2[135]))[142] = M1(2,17); (*(M2[135]))[143] = M1(2,18); (*(M2[135]))[144] = M1(2,19); (*(M2[135]))[145] = M1(2,20); (*(M2[135]))[146] = M1(2,21); (*(M2[135]))[147] = M1(2,22); (*(M2[135]))[148] = M1(2,23); 
  (*(M2[136]))[128] = M1(3,3); (*(M2[136]))[132] = M1(3,7); (*(M2[136]))[133] = M1(3,8); (*(M2[136]))[134] = M1(3,9); (*(M2[136]))[136] = M1(3,11); (*(M2[136]))[137] = M1(3,12); (*(M2[136]))[138] = M1(3,13); (*(M2[136]))[139] = M1(3,14); (*(M2[136]))[140] = M1(3,15); (*(M2[136]))[141] = M1(3,16); (*(M2[136]))[142] = M1(3,17); (*(M2[136]))[143] = M1(3,18); (*(M2[136]))[144] = M1(3,19); (*(M2[136]))[145] = M1(3,20); (*(M2[136]))[146] = M1(3,21); (*(M2[136]))[147] = M1(3,22); (*(M2[136]))[148] = M1(3,23); 
  (*(M2[137]))[129] = M1(4,4); (*(M2[137]))[132] = M1(4,7); (*(M2[137]))[133] = M1(4,8); (*(M2[137]))[134] = M1(4,9); (*(M2[137]))[136] = M1(4,11); (*(M2[137]))[137] = M1(4,12); (*(M2[137]))[138] = M1(4,13); (*(M2[137]))[139] = M1(4,14); (*(M2[137]))[140] = M1(4,15); (*(M2[137]))[141] = M1(4,16); (*(M2[137]))[142] = M1(4,17); (*(M2[137]))[143] = M1(4,18); (*(M2[137]))[144] = M1(4,19); (*(M2[137]))[145] = M1(4,20); (*(M2[137]))[146] = M1(4,21); (*(M2[137]))[147] = M1(4,22); (*(M2[137]))[148] = M1(4,23); 
  (*(M2[138]))[130] = M1(5,5); (*(M2[138]))[132] = M1(5,7); (*(M2[138]))[133] = M1(5,8); (*(M2[138]))[134] = M1(5,9); (*(M2[138]))[136] = M1(5,11); (*(M2[138]))[137] = M1(5,12); (*(M2[138]))[138] = M1(5,13); (*(M2[138]))[139] = M1(5,14); (*(M2[138]))[140] = M1(5,15); (*(M2[138]))[141] = M1(5,16); (*(M2[138]))[142] = M1(5,17); (*(M2[138]))[143] = M1(5,18); (*(M2[138]))[144] = M1(5,19); (*(M2[138]))[145] = M1(5,20); (*(M2[138]))[146] = M1(5,21); (*(M2[138]))[147] = M1(5,22); (*(M2[138]))[148] = M1(5,23); 
  (*(M2[139]))[131] = M1(6,6); (*(M2[139]))[132] = M1(6,7); (*(M2[139]))[133] = M1(6,8); (*(M2[139]))[134] = M1(6,9); (*(M2[139]))[136] = M1(6,11); (*(M2[139]))[137] = M1(6,12); (*(M2[139]))[138] = M1(6,13); (*(M2[139]))[139] = M1(6,14); (*(M2[139]))[140] = M1(6,15); (*(M2[139]))[141] = M1(6,16); (*(M2[139]))[142] = M1(6,17); (*(M2[139]))[143] = M1(6,18); (*(M2[139]))[144] = M1(6,19); (*(M2[139]))[145] = M1(6,20); (*(M2[139]))[146] = M1(6,21); (*(M2[139]))[147] = M1(6,22); (*(M2[139]))[148] = M1(6,23); 
  (*(M2[140]))[135] = M1(7,10); (*(M2[140]))[137] = M1(7,12); (*(M2[140]))[140] = M1(7,15); (*(M2[140]))[144] = M1(7,19); (*(M2[140]))[148] = M1(7,23); 

  opengv::math::gauss_jordan(M2,121);
  Action = Eigen::Matrix<double,8,8>::Zero();
  for( int s = 0; s < 8; s++ )
    Action(0,s) -= (*(M2[121]))[141+s];
  for( int s = 0; s < 8; s++ )
    Action(1,s) -= (*(M2[122]))[141+s];
  for( int s = 0; s < 8; s++ )
    Action(2,s) -= (*(M2[123]))[141+s];
  for( int s = 0; s < 8; s++ )
    Action(3,s) -= (*(M2[124]))[141+s];
  Action(4,0) = 1.0;
  Action(5,1) = 1.0;
  Action(6,2) = 1.0;
  Action(7,3) = 1.0;
  //columns of Action mean:
  // x_1*x_4^2 x_2*x_4^2 x_3*x_4^2 x_4^3 x_1 x_2 x_3 x_4
  
  for( int r = 0; r < 141; r++ )
    delete M2[r];
}

