/* Copyright 2022 - 2025 R. Thomas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_ASM_AARCH64_REGISTER_H
#define LIEF_ASM_AARCH64_REGISTER_H
namespace LIEF {
namespace assembly {
namespace aarch64 {
enum class REG;
enum class SYSREG;
const char* get_register_name(REG r);
const char* get_register_name(SYSREG r);

enum class REG {
  NoRegister = 0,
  FFR = 1,
  FP = 2,
  FPCR = 3,
  FPMR = 4,
  FPSR = 5,
  LR = 6,
  NZCV = 7,
  SP = 8,
  VG = 9,
  WSP = 10,
  WSP_HI = 11,
  WZR = 12,
  WZR_HI = 13,
  XZR = 14,
  ZA = 15,
  B0 = 16,
  B1 = 17,
  B2 = 18,
  B3 = 19,
  B4 = 20,
  B5 = 21,
  B6 = 22,
  B7 = 23,
  B8 = 24,
  B9 = 25,
  B10 = 26,
  B11 = 27,
  B12 = 28,
  B13 = 29,
  B14 = 30,
  B15 = 31,
  B16 = 32,
  B17 = 33,
  B18 = 34,
  B19 = 35,
  B20 = 36,
  B21 = 37,
  B22 = 38,
  B23 = 39,
  B24 = 40,
  B25 = 41,
  B26 = 42,
  B27 = 43,
  B28 = 44,
  B29 = 45,
  B30 = 46,
  B31 = 47,
  D0 = 48,
  D1 = 49,
  D2 = 50,
  D3 = 51,
  D4 = 52,
  D5 = 53,
  D6 = 54,
  D7 = 55,
  D8 = 56,
  D9 = 57,
  D10 = 58,
  D11 = 59,
  D12 = 60,
  D13 = 61,
  D14 = 62,
  D15 = 63,
  D16 = 64,
  D17 = 65,
  D18 = 66,
  D19 = 67,
  D20 = 68,
  D21 = 69,
  D22 = 70,
  D23 = 71,
  D24 = 72,
  D25 = 73,
  D26 = 74,
  D27 = 75,
  D28 = 76,
  D29 = 77,
  D30 = 78,
  D31 = 79,
  H0 = 80,
  H1 = 81,
  H2 = 82,
  H3 = 83,
  H4 = 84,
  H5 = 85,
  H6 = 86,
  H7 = 87,
  H8 = 88,
  H9 = 89,
  H10 = 90,
  H11 = 91,
  H12 = 92,
  H13 = 93,
  H14 = 94,
  H15 = 95,
  H16 = 96,
  H17 = 97,
  H18 = 98,
  H19 = 99,
  H20 = 100,
  H21 = 101,
  H22 = 102,
  H23 = 103,
  H24 = 104,
  H25 = 105,
  H26 = 106,
  H27 = 107,
  H28 = 108,
  H29 = 109,
  H30 = 110,
  H31 = 111,
  P0 = 112,
  P1 = 113,
  P2 = 114,
  P3 = 115,
  P4 = 116,
  P5 = 117,
  P6 = 118,
  P7 = 119,
  P8 = 120,
  P9 = 121,
  P10 = 122,
  P11 = 123,
  P12 = 124,
  P13 = 125,
  P14 = 126,
  P15 = 127,
  PN0 = 128,
  PN1 = 129,
  PN2 = 130,
  PN3 = 131,
  PN4 = 132,
  PN5 = 133,
  PN6 = 134,
  PN7 = 135,
  PN8 = 136,
  PN9 = 137,
  PN10 = 138,
  PN11 = 139,
  PN12 = 140,
  PN13 = 141,
  PN14 = 142,
  PN15 = 143,
  Q0 = 144,
  Q1 = 145,
  Q2 = 146,
  Q3 = 147,
  Q4 = 148,
  Q5 = 149,
  Q6 = 150,
  Q7 = 151,
  Q8 = 152,
  Q9 = 153,
  Q10 = 154,
  Q11 = 155,
  Q12 = 156,
  Q13 = 157,
  Q14 = 158,
  Q15 = 159,
  Q16 = 160,
  Q17 = 161,
  Q18 = 162,
  Q19 = 163,
  Q20 = 164,
  Q21 = 165,
  Q22 = 166,
  Q23 = 167,
  Q24 = 168,
  Q25 = 169,
  Q26 = 170,
  Q27 = 171,
  Q28 = 172,
  Q29 = 173,
  Q30 = 174,
  Q31 = 175,
  S0 = 176,
  S1 = 177,
  S2 = 178,
  S3 = 179,
  S4 = 180,
  S5 = 181,
  S6 = 182,
  S7 = 183,
  S8 = 184,
  S9 = 185,
  S10 = 186,
  S11 = 187,
  S12 = 188,
  S13 = 189,
  S14 = 190,
  S15 = 191,
  S16 = 192,
  S17 = 193,
  S18 = 194,
  S19 = 195,
  S20 = 196,
  S21 = 197,
  S22 = 198,
  S23 = 199,
  S24 = 200,
  S25 = 201,
  S26 = 202,
  S27 = 203,
  S28 = 204,
  S29 = 205,
  S30 = 206,
  S31 = 207,
  W0 = 208,
  W1 = 209,
  W2 = 210,
  W3 = 211,
  W4 = 212,
  W5 = 213,
  W6 = 214,
  W7 = 215,
  W8 = 216,
  W9 = 217,
  W10 = 218,
  W11 = 219,
  W12 = 220,
  W13 = 221,
  W14 = 222,
  W15 = 223,
  W16 = 224,
  W17 = 225,
  W18 = 226,
  W19 = 227,
  W20 = 228,
  W21 = 229,
  W22 = 230,
  W23 = 231,
  W24 = 232,
  W25 = 233,
  W26 = 234,
  W27 = 235,
  W28 = 236,
  W29 = 237,
  W30 = 238,
  X0 = 239,
  X1 = 240,
  X2 = 241,
  X3 = 242,
  X4 = 243,
  X5 = 244,
  X6 = 245,
  X7 = 246,
  X8 = 247,
  X9 = 248,
  X10 = 249,
  X11 = 250,
  X12 = 251,
  X13 = 252,
  X14 = 253,
  X15 = 254,
  X16 = 255,
  X17 = 256,
  X18 = 257,
  X19 = 258,
  X20 = 259,
  X21 = 260,
  X22 = 261,
  X23 = 262,
  X24 = 263,
  X25 = 264,
  X26 = 265,
  X27 = 266,
  X28 = 267,
  Z0 = 268,
  Z1 = 269,
  Z2 = 270,
  Z3 = 271,
  Z4 = 272,
  Z5 = 273,
  Z6 = 274,
  Z7 = 275,
  Z8 = 276,
  Z9 = 277,
  Z10 = 278,
  Z11 = 279,
  Z12 = 280,
  Z13 = 281,
  Z14 = 282,
  Z15 = 283,
  Z16 = 284,
  Z17 = 285,
  Z18 = 286,
  Z19 = 287,
  Z20 = 288,
  Z21 = 289,
  Z22 = 290,
  Z23 = 291,
  Z24 = 292,
  Z25 = 293,
  Z26 = 294,
  Z27 = 295,
  Z28 = 296,
  Z29 = 297,
  Z30 = 298,
  Z31 = 299,
  ZAB0 = 300,
  ZAD0 = 301,
  ZAD1 = 302,
  ZAD2 = 303,
  ZAD3 = 304,
  ZAD4 = 305,
  ZAD5 = 306,
  ZAD6 = 307,
  ZAD7 = 308,
  ZAH0 = 309,
  ZAH1 = 310,
  ZAQ0 = 311,
  ZAQ1 = 312,
  ZAQ2 = 313,
  ZAQ3 = 314,
  ZAQ4 = 315,
  ZAQ5 = 316,
  ZAQ6 = 317,
  ZAQ7 = 318,
  ZAQ8 = 319,
  ZAQ9 = 320,
  ZAQ10 = 321,
  ZAQ11 = 322,
  ZAQ12 = 323,
  ZAQ13 = 324,
  ZAQ14 = 325,
  ZAQ15 = 326,
  ZAS0 = 327,
  ZAS1 = 328,
  ZAS2 = 329,
  ZAS3 = 330,
  ZT0 = 331,
  B0_HI = 332,
  B1_HI = 333,
  B2_HI = 334,
  B3_HI = 335,
  B4_HI = 336,
  B5_HI = 337,
  B6_HI = 338,
  B7_HI = 339,
  B8_HI = 340,
  B9_HI = 341,
  B10_HI = 342,
  B11_HI = 343,
  B12_HI = 344,
  B13_HI = 345,
  B14_HI = 346,
  B15_HI = 347,
  B16_HI = 348,
  B17_HI = 349,
  B18_HI = 350,
  B19_HI = 351,
  B20_HI = 352,
  B21_HI = 353,
  B22_HI = 354,
  B23_HI = 355,
  B24_HI = 356,
  B25_HI = 357,
  B26_HI = 358,
  B27_HI = 359,
  B28_HI = 360,
  B29_HI = 361,
  B30_HI = 362,
  B31_HI = 363,
  D0_HI = 364,
  D1_HI = 365,
  D2_HI = 366,
  D3_HI = 367,
  D4_HI = 368,
  D5_HI = 369,
  D6_HI = 370,
  D7_HI = 371,
  D8_HI = 372,
  D9_HI = 373,
  D10_HI = 374,
  D11_HI = 375,
  D12_HI = 376,
  D13_HI = 377,
  D14_HI = 378,
  D15_HI = 379,
  D16_HI = 380,
  D17_HI = 381,
  D18_HI = 382,
  D19_HI = 383,
  D20_HI = 384,
  D21_HI = 385,
  D22_HI = 386,
  D23_HI = 387,
  D24_HI = 388,
  D25_HI = 389,
  D26_HI = 390,
  D27_HI = 391,
  D28_HI = 392,
  D29_HI = 393,
  D30_HI = 394,
  D31_HI = 395,
  H0_HI = 396,
  H1_HI = 397,
  H2_HI = 398,
  H3_HI = 399,
  H4_HI = 400,
  H5_HI = 401,
  H6_HI = 402,
  H7_HI = 403,
  H8_HI = 404,
  H9_HI = 405,
  H10_HI = 406,
  H11_HI = 407,
  H12_HI = 408,
  H13_HI = 409,
  H14_HI = 410,
  H15_HI = 411,
  H16_HI = 412,
  H17_HI = 413,
  H18_HI = 414,
  H19_HI = 415,
  H20_HI = 416,
  H21_HI = 417,
  H22_HI = 418,
  H23_HI = 419,
  H24_HI = 420,
  H25_HI = 421,
  H26_HI = 422,
  H27_HI = 423,
  H28_HI = 424,
  H29_HI = 425,
  H30_HI = 426,
  H31_HI = 427,
  Q0_HI = 428,
  Q1_HI = 429,
  Q2_HI = 430,
  Q3_HI = 431,
  Q4_HI = 432,
  Q5_HI = 433,
  Q6_HI = 434,
  Q7_HI = 435,
  Q8_HI = 436,
  Q9_HI = 437,
  Q10_HI = 438,
  Q11_HI = 439,
  Q12_HI = 440,
  Q13_HI = 441,
  Q14_HI = 442,
  Q15_HI = 443,
  Q16_HI = 444,
  Q17_HI = 445,
  Q18_HI = 446,
  Q19_HI = 447,
  Q20_HI = 448,
  Q21_HI = 449,
  Q22_HI = 450,
  Q23_HI = 451,
  Q24_HI = 452,
  Q25_HI = 453,
  Q26_HI = 454,
  Q27_HI = 455,
  Q28_HI = 456,
  Q29_HI = 457,
  Q30_HI = 458,
  Q31_HI = 459,
  S0_HI = 460,
  S1_HI = 461,
  S2_HI = 462,
  S3_HI = 463,
  S4_HI = 464,
  S5_HI = 465,
  S6_HI = 466,
  S7_HI = 467,
  S8_HI = 468,
  S9_HI = 469,
  S10_HI = 470,
  S11_HI = 471,
  S12_HI = 472,
  S13_HI = 473,
  S14_HI = 474,
  S15_HI = 475,
  S16_HI = 476,
  S17_HI = 477,
  S18_HI = 478,
  S19_HI = 479,
  S20_HI = 480,
  S21_HI = 481,
  S22_HI = 482,
  S23_HI = 483,
  S24_HI = 484,
  S25_HI = 485,
  S26_HI = 486,
  S27_HI = 487,
  S28_HI = 488,
  S29_HI = 489,
  S30_HI = 490,
  S31_HI = 491,
  W0_HI = 492,
  W1_HI = 493,
  W2_HI = 494,
  W3_HI = 495,
  W4_HI = 496,
  W5_HI = 497,
  W6_HI = 498,
  W7_HI = 499,
  W8_HI = 500,
  W9_HI = 501,
  W10_HI = 502,
  W11_HI = 503,
  W12_HI = 504,
  W13_HI = 505,
  W14_HI = 506,
  W15_HI = 507,
  W16_HI = 508,
  W17_HI = 509,
  W18_HI = 510,
  W19_HI = 511,
  W20_HI = 512,
  W21_HI = 513,
  W22_HI = 514,
  W23_HI = 515,
  W24_HI = 516,
  W25_HI = 517,
  W26_HI = 518,
  W27_HI = 519,
  W28_HI = 520,
  W29_HI = 521,
  W30_HI = 522,
  D0_D1 = 523,
  D1_D2 = 524,
  D2_D3 = 525,
  D3_D4 = 526,
  D4_D5 = 527,
  D5_D6 = 528,
  D6_D7 = 529,
  D7_D8 = 530,
  D8_D9 = 531,
  D9_D10 = 532,
  D10_D11 = 533,
  D11_D12 = 534,
  D12_D13 = 535,
  D13_D14 = 536,
  D14_D15 = 537,
  D15_D16 = 538,
  D16_D17 = 539,
  D17_D18 = 540,
  D18_D19 = 541,
  D19_D20 = 542,
  D20_D21 = 543,
  D21_D22 = 544,
  D22_D23 = 545,
  D23_D24 = 546,
  D24_D25 = 547,
  D25_D26 = 548,
  D26_D27 = 549,
  D27_D28 = 550,
  D28_D29 = 551,
  D29_D30 = 552,
  D30_D31 = 553,
  D31_D0 = 554,
  D0_D1_D2_D3 = 555,
  D1_D2_D3_D4 = 556,
  D2_D3_D4_D5 = 557,
  D3_D4_D5_D6 = 558,
  D4_D5_D6_D7 = 559,
  D5_D6_D7_D8 = 560,
  D6_D7_D8_D9 = 561,
  D7_D8_D9_D10 = 562,
  D8_D9_D10_D11 = 563,
  D9_D10_D11_D12 = 564,
  D10_D11_D12_D13 = 565,
  D11_D12_D13_D14 = 566,
  D12_D13_D14_D15 = 567,
  D13_D14_D15_D16 = 568,
  D14_D15_D16_D17 = 569,
  D15_D16_D17_D18 = 570,
  D16_D17_D18_D19 = 571,
  D17_D18_D19_D20 = 572,
  D18_D19_D20_D21 = 573,
  D19_D20_D21_D22 = 574,
  D20_D21_D22_D23 = 575,
  D21_D22_D23_D24 = 576,
  D22_D23_D24_D25 = 577,
  D23_D24_D25_D26 = 578,
  D24_D25_D26_D27 = 579,
  D25_D26_D27_D28 = 580,
  D26_D27_D28_D29 = 581,
  D27_D28_D29_D30 = 582,
  D28_D29_D30_D31 = 583,
  D29_D30_D31_D0 = 584,
  D30_D31_D0_D1 = 585,
  D31_D0_D1_D2 = 586,
  D0_D1_D2 = 587,
  D1_D2_D3 = 588,
  D2_D3_D4 = 589,
  D3_D4_D5 = 590,
  D4_D5_D6 = 591,
  D5_D6_D7 = 592,
  D6_D7_D8 = 593,
  D7_D8_D9 = 594,
  D8_D9_D10 = 595,
  D9_D10_D11 = 596,
  D10_D11_D12 = 597,
  D11_D12_D13 = 598,
  D12_D13_D14 = 599,
  D13_D14_D15 = 600,
  D14_D15_D16 = 601,
  D15_D16_D17 = 602,
  D16_D17_D18 = 603,
  D17_D18_D19 = 604,
  D18_D19_D20 = 605,
  D19_D20_D21 = 606,
  D20_D21_D22 = 607,
  D21_D22_D23 = 608,
  D22_D23_D24 = 609,
  D23_D24_D25 = 610,
  D24_D25_D26 = 611,
  D25_D26_D27 = 612,
  D26_D27_D28 = 613,
  D27_D28_D29 = 614,
  D28_D29_D30 = 615,
  D29_D30_D31 = 616,
  D30_D31_D0 = 617,
  D31_D0_D1 = 618,
  P0_P1 = 619,
  P1_P2 = 620,
  P2_P3 = 621,
  P3_P4 = 622,
  P4_P5 = 623,
  P5_P6 = 624,
  P6_P7 = 625,
  P7_P8 = 626,
  P8_P9 = 627,
  P9_P10 = 628,
  P10_P11 = 629,
  P11_P12 = 630,
  P12_P13 = 631,
  P13_P14 = 632,
  P14_P15 = 633,
  P15_P0 = 634,
  Q0_Q1 = 635,
  Q1_Q2 = 636,
  Q2_Q3 = 637,
  Q3_Q4 = 638,
  Q4_Q5 = 639,
  Q5_Q6 = 640,
  Q6_Q7 = 641,
  Q7_Q8 = 642,
  Q8_Q9 = 643,
  Q9_Q10 = 644,
  Q10_Q11 = 645,
  Q11_Q12 = 646,
  Q12_Q13 = 647,
  Q13_Q14 = 648,
  Q14_Q15 = 649,
  Q15_Q16 = 650,
  Q16_Q17 = 651,
  Q17_Q18 = 652,
  Q18_Q19 = 653,
  Q19_Q20 = 654,
  Q20_Q21 = 655,
  Q21_Q22 = 656,
  Q22_Q23 = 657,
  Q23_Q24 = 658,
  Q24_Q25 = 659,
  Q25_Q26 = 660,
  Q26_Q27 = 661,
  Q27_Q28 = 662,
  Q28_Q29 = 663,
  Q29_Q30 = 664,
  Q30_Q31 = 665,
  Q31_Q0 = 666,
  Q0_Q1_Q2_Q3 = 667,
  Q1_Q2_Q3_Q4 = 668,
  Q2_Q3_Q4_Q5 = 669,
  Q3_Q4_Q5_Q6 = 670,
  Q4_Q5_Q6_Q7 = 671,
  Q5_Q6_Q7_Q8 = 672,
  Q6_Q7_Q8_Q9 = 673,
  Q7_Q8_Q9_Q10 = 674,
  Q8_Q9_Q10_Q11 = 675,
  Q9_Q10_Q11_Q12 = 676,
  Q10_Q11_Q12_Q13 = 677,
  Q11_Q12_Q13_Q14 = 678,
  Q12_Q13_Q14_Q15 = 679,
  Q13_Q14_Q15_Q16 = 680,
  Q14_Q15_Q16_Q17 = 681,
  Q15_Q16_Q17_Q18 = 682,
  Q16_Q17_Q18_Q19 = 683,
  Q17_Q18_Q19_Q20 = 684,
  Q18_Q19_Q20_Q21 = 685,
  Q19_Q20_Q21_Q22 = 686,
  Q20_Q21_Q22_Q23 = 687,
  Q21_Q22_Q23_Q24 = 688,
  Q22_Q23_Q24_Q25 = 689,
  Q23_Q24_Q25_Q26 = 690,
  Q24_Q25_Q26_Q27 = 691,
  Q25_Q26_Q27_Q28 = 692,
  Q26_Q27_Q28_Q29 = 693,
  Q27_Q28_Q29_Q30 = 694,
  Q28_Q29_Q30_Q31 = 695,
  Q29_Q30_Q31_Q0 = 696,
  Q30_Q31_Q0_Q1 = 697,
  Q31_Q0_Q1_Q2 = 698,
  Q0_Q1_Q2 = 699,
  Q1_Q2_Q3 = 700,
  Q2_Q3_Q4 = 701,
  Q3_Q4_Q5 = 702,
  Q4_Q5_Q6 = 703,
  Q5_Q6_Q7 = 704,
  Q6_Q7_Q8 = 705,
  Q7_Q8_Q9 = 706,
  Q8_Q9_Q10 = 707,
  Q9_Q10_Q11 = 708,
  Q10_Q11_Q12 = 709,
  Q11_Q12_Q13 = 710,
  Q12_Q13_Q14 = 711,
  Q13_Q14_Q15 = 712,
  Q14_Q15_Q16 = 713,
  Q15_Q16_Q17 = 714,
  Q16_Q17_Q18 = 715,
  Q17_Q18_Q19 = 716,
  Q18_Q19_Q20 = 717,
  Q19_Q20_Q21 = 718,
  Q20_Q21_Q22 = 719,
  Q21_Q22_Q23 = 720,
  Q22_Q23_Q24 = 721,
  Q23_Q24_Q25 = 722,
  Q24_Q25_Q26 = 723,
  Q25_Q26_Q27 = 724,
  Q26_Q27_Q28 = 725,
  Q27_Q28_Q29 = 726,
  Q28_Q29_Q30 = 727,
  Q29_Q30_Q31 = 728,
  Q30_Q31_Q0 = 729,
  Q31_Q0_Q1 = 730,
  X22_X23_X24_X25_X26_X27_X28_FP = 731,
  X0_X1_X2_X3_X4_X5_X6_X7 = 732,
  X2_X3_X4_X5_X6_X7_X8_X9 = 733,
  X4_X5_X6_X7_X8_X9_X10_X11 = 734,
  X6_X7_X8_X9_X10_X11_X12_X13 = 735,
  X8_X9_X10_X11_X12_X13_X14_X15 = 736,
  X10_X11_X12_X13_X14_X15_X16_X17 = 737,
  X12_X13_X14_X15_X16_X17_X18_X19 = 738,
  X14_X15_X16_X17_X18_X19_X20_X21 = 739,
  X16_X17_X18_X19_X20_X21_X22_X23 = 740,
  X18_X19_X20_X21_X22_X23_X24_X25 = 741,
  X20_X21_X22_X23_X24_X25_X26_X27 = 742,
  W30_WZR = 743,
  W0_W1 = 744,
  W2_W3 = 745,
  W4_W5 = 746,
  W6_W7 = 747,
  W8_W9 = 748,
  W10_W11 = 749,
  W12_W13 = 750,
  W14_W15 = 751,
  W16_W17 = 752,
  W18_W19 = 753,
  W20_W21 = 754,
  W22_W23 = 755,
  W24_W25 = 756,
  W26_W27 = 757,
  W28_W29 = 758,
  LR_XZR = 759,
  X28_FP = 760,
  X0_X1 = 761,
  X2_X3 = 762,
  X4_X5 = 763,
  X6_X7 = 764,
  X8_X9 = 765,
  X10_X11 = 766,
  X12_X13 = 767,
  X14_X15 = 768,
  X16_X17 = 769,
  X18_X19 = 770,
  X20_X21 = 771,
  X22_X23 = 772,
  X24_X25 = 773,
  X26_X27 = 774,
  Z0_Z1 = 775,
  Z1_Z2 = 776,
  Z2_Z3 = 777,
  Z3_Z4 = 778,
  Z4_Z5 = 779,
  Z5_Z6 = 780,
  Z6_Z7 = 781,
  Z7_Z8 = 782,
  Z8_Z9 = 783,
  Z9_Z10 = 784,
  Z10_Z11 = 785,
  Z11_Z12 = 786,
  Z12_Z13 = 787,
  Z13_Z14 = 788,
  Z14_Z15 = 789,
  Z15_Z16 = 790,
  Z16_Z17 = 791,
  Z17_Z18 = 792,
  Z18_Z19 = 793,
  Z19_Z20 = 794,
  Z20_Z21 = 795,
  Z21_Z22 = 796,
  Z22_Z23 = 797,
  Z23_Z24 = 798,
  Z24_Z25 = 799,
  Z25_Z26 = 800,
  Z26_Z27 = 801,
  Z27_Z28 = 802,
  Z28_Z29 = 803,
  Z29_Z30 = 804,
  Z30_Z31 = 805,
  Z31_Z0 = 806,
  Z0_Z1_Z2_Z3 = 807,
  Z1_Z2_Z3_Z4 = 808,
  Z2_Z3_Z4_Z5 = 809,
  Z3_Z4_Z5_Z6 = 810,
  Z4_Z5_Z6_Z7 = 811,
  Z5_Z6_Z7_Z8 = 812,
  Z6_Z7_Z8_Z9 = 813,
  Z7_Z8_Z9_Z10 = 814,
  Z8_Z9_Z10_Z11 = 815,
  Z9_Z10_Z11_Z12 = 816,
  Z10_Z11_Z12_Z13 = 817,
  Z11_Z12_Z13_Z14 = 818,
  Z12_Z13_Z14_Z15 = 819,
  Z13_Z14_Z15_Z16 = 820,
  Z14_Z15_Z16_Z17 = 821,
  Z15_Z16_Z17_Z18 = 822,
  Z16_Z17_Z18_Z19 = 823,
  Z17_Z18_Z19_Z20 = 824,
  Z18_Z19_Z20_Z21 = 825,
  Z19_Z20_Z21_Z22 = 826,
  Z20_Z21_Z22_Z23 = 827,
  Z21_Z22_Z23_Z24 = 828,
  Z22_Z23_Z24_Z25 = 829,
  Z23_Z24_Z25_Z26 = 830,
  Z24_Z25_Z26_Z27 = 831,
  Z25_Z26_Z27_Z28 = 832,
  Z26_Z27_Z28_Z29 = 833,
  Z27_Z28_Z29_Z30 = 834,
  Z28_Z29_Z30_Z31 = 835,
  Z29_Z30_Z31_Z0 = 836,
  Z30_Z31_Z0_Z1 = 837,
  Z31_Z0_Z1_Z2 = 838,
  Z0_Z1_Z2 = 839,
  Z1_Z2_Z3 = 840,
  Z2_Z3_Z4 = 841,
  Z3_Z4_Z5 = 842,
  Z4_Z5_Z6 = 843,
  Z5_Z6_Z7 = 844,
  Z6_Z7_Z8 = 845,
  Z7_Z8_Z9 = 846,
  Z8_Z9_Z10 = 847,
  Z9_Z10_Z11 = 848,
  Z10_Z11_Z12 = 849,
  Z11_Z12_Z13 = 850,
  Z12_Z13_Z14 = 851,
  Z13_Z14_Z15 = 852,
  Z14_Z15_Z16 = 853,
  Z15_Z16_Z17 = 854,
  Z16_Z17_Z18 = 855,
  Z17_Z18_Z19 = 856,
  Z18_Z19_Z20 = 857,
  Z19_Z20_Z21 = 858,
  Z20_Z21_Z22 = 859,
  Z21_Z22_Z23 = 860,
  Z22_Z23_Z24 = 861,
  Z23_Z24_Z25 = 862,
  Z24_Z25_Z26 = 863,
  Z25_Z26_Z27 = 864,
  Z26_Z27_Z28 = 865,
  Z27_Z28_Z29 = 866,
  Z28_Z29_Z30 = 867,
  Z29_Z30_Z31 = 868,
  Z30_Z31_Z0 = 869,
  Z31_Z0_Z1 = 870,
  Z16_Z24 = 871,
  Z17_Z25 = 872,
  Z18_Z26 = 873,
  Z19_Z27 = 874,
  Z20_Z28 = 875,
  Z21_Z29 = 876,
  Z22_Z30 = 877,
  Z23_Z31 = 878,
  Z0_Z8 = 879,
  Z1_Z9 = 880,
  Z2_Z10 = 881,
  Z3_Z11 = 882,
  Z4_Z12 = 883,
  Z5_Z13 = 884,
  Z6_Z14 = 885,
  Z7_Z15 = 886,
  Z16_Z20_Z24_Z28 = 887,
  Z17_Z21_Z25_Z29 = 888,
  Z18_Z22_Z26_Z30 = 889,
  Z19_Z23_Z27_Z31 = 890,
  Z0_Z4_Z8_Z12 = 891,
  Z1_Z5_Z9_Z13 = 892,
  Z2_Z6_Z10_Z14 = 893,
  Z3_Z7_Z11_Z15 = 894,
  NUM_TARGET_REGS = 895,
};

enum class SYSREG {
  OSDTRRX_EL1 = 32770,
  DBGBVR0_EL1 = 32772,
  DBGBCR0_EL1 = 32773,
  DBGWVR0_EL1 = 32774,
  DBGWCR0_EL1 = 32775,
  DBGBVR1_EL1 = 32780,
  DBGBCR1_EL1 = 32781,
  DBGWVR1_EL1 = 32782,
  DBGWCR1_EL1 = 32783,
  MDCCINT_EL1 = 32784,
  MDSCR_EL1 = 32786,
  DBGBVR2_EL1 = 32788,
  DBGBCR2_EL1 = 32789,
  DBGWVR2_EL1 = 32790,
  DBGWCR2_EL1 = 32791,
  OSDTRTX_EL1 = 32794,
  DBGBVR3_EL1 = 32796,
  DBGBCR3_EL1 = 32797,
  DBGWVR3_EL1 = 32798,
  DBGWCR3_EL1 = 32799,
  MDSELR_EL1 = 32802,
  DBGBVR4_EL1 = 32804,
  DBGBCR4_EL1 = 32805,
  DBGWVR4_EL1 = 32806,
  DBGWCR4_EL1 = 32807,
  MDSTEPOP_EL1 = 32810,
  DBGBVR5_EL1 = 32812,
  DBGBCR5_EL1 = 32813,
  DBGWVR5_EL1 = 32814,
  DBGWCR5_EL1 = 32815,
  OSECCR_EL1 = 32818,
  DBGBVR6_EL1 = 32820,
  DBGBCR6_EL1 = 32821,
  DBGWVR6_EL1 = 32822,
  DBGWCR6_EL1 = 32823,
  DBGBVR7_EL1 = 32828,
  DBGBCR7_EL1 = 32829,
  DBGWVR7_EL1 = 32830,
  DBGWCR7_EL1 = 32831,
  DBGBVR8_EL1 = 32836,
  DBGBCR8_EL1 = 32837,
  DBGWVR8_EL1 = 32838,
  DBGWCR8_EL1 = 32839,
  DBGBVR9_EL1 = 32844,
  DBGBCR9_EL1 = 32845,
  DBGWVR9_EL1 = 32846,
  DBGWCR9_EL1 = 32847,
  DBGBVR10_EL1 = 32852,
  DBGBCR10_EL1 = 32853,
  DBGWVR10_EL1 = 32854,
  DBGWCR10_EL1 = 32855,
  DBGBVR11_EL1 = 32860,
  DBGBCR11_EL1 = 32861,
  DBGWVR11_EL1 = 32862,
  DBGWCR11_EL1 = 32863,
  DBGBVR12_EL1 = 32868,
  DBGBCR12_EL1 = 32869,
  DBGWVR12_EL1 = 32870,
  DBGWCR12_EL1 = 32871,
  DBGBVR13_EL1 = 32876,
  DBGBCR13_EL1 = 32877,
  DBGWVR13_EL1 = 32878,
  DBGWCR13_EL1 = 32879,
  DBGBVR14_EL1 = 32884,
  DBGBCR14_EL1 = 32885,
  DBGWVR14_EL1 = 32886,
  DBGWCR14_EL1 = 32887,
  DBGBVR15_EL1 = 32892,
  DBGBCR15_EL1 = 32893,
  DBGWVR15_EL1 = 32894,
  DBGWCR15_EL1 = 32895,
  MDRAR_EL1 = 32896,
  OSLAR_EL1 = 32900,
  OSLSR_EL1 = 32908,
  OSDLR_EL1 = 32924,
  DBGPRCR_EL1 = 32932,
  DBGCLAIMSET_EL1 = 33734,
  DBGCLAIMCLR_EL1 = 33742,
  DBGAUTHSTATUS_EL1 = 33782,
  SPMCGCR0_EL1 = 34024,
  SPMCGCR1_EL1 = 34025,
  SPMACCESSR_EL1 = 34027,
  SPMIIDR_EL1 = 34028,
  SPMDEVARCH_EL1 = 34029,
  SPMDEVAFF_EL1 = 34030,
  SPMCFGR_EL1 = 34031,
  SPMINTENSET_EL1 = 34033,
  SPMINTENCLR_EL1 = 34034,
  PMEVCNTSVR0_EL1 = 34624,
  PMEVCNTSVR1_EL1 = 34625,
  PMEVCNTSVR2_EL1 = 34626,
  PMEVCNTSVR3_EL1 = 34627,
  PMEVCNTSVR4_EL1 = 34628,
  PMEVCNTSVR5_EL1 = 34629,
  PMEVCNTSVR6_EL1 = 34630,
  PMEVCNTSVR7_EL1 = 34631,
  PMEVCNTSVR8_EL1 = 34632,
  PMEVCNTSVR9_EL1 = 34633,
  PMEVCNTSVR10_EL1 = 34634,
  PMEVCNTSVR11_EL1 = 34635,
  PMEVCNTSVR12_EL1 = 34636,
  PMEVCNTSVR13_EL1 = 34637,
  PMEVCNTSVR14_EL1 = 34638,
  PMEVCNTSVR15_EL1 = 34639,
  PMEVCNTSVR16_EL1 = 34640,
  PMEVCNTSVR17_EL1 = 34641,
  PMEVCNTSVR18_EL1 = 34642,
  PMEVCNTSVR19_EL1 = 34643,
  PMEVCNTSVR20_EL1 = 34644,
  PMEVCNTSVR21_EL1 = 34645,
  PMEVCNTSVR22_EL1 = 34646,
  PMEVCNTSVR23_EL1 = 34647,
  PMEVCNTSVR24_EL1 = 34648,
  PMEVCNTSVR25_EL1 = 34649,
  PMEVCNTSVR26_EL1 = 34650,
  PMEVCNTSVR27_EL1 = 34651,
  PMEVCNTSVR28_EL1 = 34652,
  PMEVCNTSVR29_EL1 = 34653,
  PMEVCNTSVR30_EL1 = 34654,
  PMCCNTSVR_EL1 = 34655,
  PMICNTSVR_EL1 = 34656,
  TRCTRACEIDR = 34817,
  TRCVICTLR = 34818,
  TRCSEQEVR0 = 34820,
  TRCCNTRLDVR0 = 34821,
  TRCIDR8 = 34822,
  TRCIMSPEC0 = 34823,
  TRCPRGCTLR = 34824,
  TRCQCTLR = 34825,
  TRCVIIECTLR = 34826,
  TRCSEQEVR1 = 34828,
  TRCCNTRLDVR1 = 34829,
  TRCIDR9 = 34830,
  TRCIMSPEC1 = 34831,
  TRCPROCSELR = 34832,
  TRCITEEDCR = 34833,
  TRCVISSCTLR = 34834,
  TRCSEQEVR2 = 34836,
  TRCCNTRLDVR2 = 34837,
  TRCIDR10 = 34838,
  TRCIMSPEC2 = 34839,
  TRCSTATR = 34840,
  TRCVIPCSSCTLR = 34842,
  TRCCNTRLDVR3 = 34845,
  TRCIDR11 = 34846,
  TRCIMSPEC3 = 34847,
  TRCCONFIGR = 34848,
  TRCCNTCTLR0 = 34853,
  TRCIDR12 = 34854,
  TRCIMSPEC4 = 34855,
  TRCCNTCTLR1 = 34861,
  TRCIDR13 = 34862,
  TRCIMSPEC5 = 34863,
  TRCAUXCTLR = 34864,
  TRCSEQRSTEVR = 34868,
  TRCCNTCTLR2 = 34869,
  TRCIMSPEC6 = 34871,
  TRCSEQSTR = 34876,
  TRCCNTCTLR3 = 34877,
  TRCIMSPEC7 = 34879,
  TRCEVENTCTL0R = 34880,
  TRCVDCTLR = 34882,
  TRCEXTINSELR = 34884,
  TRCEXTINSELR0 = 34884,
  TRCCNTVR0 = 34885,
  TRCIDR0 = 34887,
  TRCEVENTCTL1R = 34888,
  TRCVDSACCTLR = 34890,
  TRCEXTINSELR1 = 34892,
  TRCCNTVR1 = 34893,
  TRCIDR1 = 34895,
  TRCRSR = 34896,
  TRCVDARCCTLR = 34898,
  TRCEXTINSELR2 = 34900,
  TRCCNTVR2 = 34901,
  TRCIDR2 = 34903,
  TRCSTALLCTLR = 34904,
  TRCEXTINSELR3 = 34908,
  TRCCNTVR3 = 34909,
  TRCIDR3 = 34911,
  TRCTSCTLR = 34912,
  TRCIDR4 = 34919,
  TRCSYNCPR = 34920,
  TRCIDR5 = 34927,
  TRCCCCTLR = 34928,
  TRCIDR6 = 34935,
  TRCBBCTLR = 34936,
  TRCIDR7 = 34943,
  TRCRSCTLR16 = 34945,
  TRCSSCCR0 = 34946,
  TRCSSPCICR0 = 34947,
  TRCOSLAR = 34948,
  TRCRSCTLR17 = 34953,
  TRCSSCCR1 = 34954,
  TRCSSPCICR1 = 34955,
  TRCOSLSR = 34956,
  TRCRSCTLR2 = 34960,
  TRCRSCTLR18 = 34961,
  TRCSSCCR2 = 34962,
  TRCSSPCICR2 = 34963,
  TRCRSCTLR3 = 34968,
  TRCRSCTLR19 = 34969,
  TRCSSCCR3 = 34970,
  TRCSSPCICR3 = 34971,
  TRCRSCTLR4 = 34976,
  TRCRSCTLR20 = 34977,
  TRCSSCCR4 = 34978,
  TRCSSPCICR4 = 34979,
  TRCPDCR = 34980,
  TRCRSCTLR5 = 34984,
  TRCRSCTLR21 = 34985,
  TRCSSCCR5 = 34986,
  TRCSSPCICR5 = 34987,
  TRCPDSR = 34988,
  TRCRSCTLR6 = 34992,
  TRCRSCTLR22 = 34993,
  TRCSSCCR6 = 34994,
  TRCSSPCICR6 = 34995,
  TRCRSCTLR7 = 35000,
  TRCRSCTLR23 = 35001,
  TRCSSCCR7 = 35002,
  TRCSSPCICR7 = 35003,
  TRCRSCTLR8 = 35008,
  TRCRSCTLR24 = 35009,
  TRCSSCSR0 = 35010,
  TRCRSCTLR9 = 35016,
  TRCRSCTLR25 = 35017,
  TRCSSCSR1 = 35018,
  TRCRSCTLR10 = 35024,
  TRCRSCTLR26 = 35025,
  TRCSSCSR2 = 35026,
  TRCRSCTLR11 = 35032,
  TRCRSCTLR27 = 35033,
  TRCSSCSR3 = 35034,
  TRCRSCTLR12 = 35040,
  TRCRSCTLR28 = 35041,
  TRCSSCSR4 = 35042,
  TRCRSCTLR13 = 35048,
  TRCRSCTLR29 = 35049,
  TRCSSCSR5 = 35050,
  TRCRSCTLR14 = 35056,
  TRCRSCTLR30 = 35057,
  TRCSSCSR6 = 35058,
  TRCRSCTLR15 = 35064,
  TRCRSCTLR31 = 35065,
  TRCSSCSR7 = 35066,
  TRCACVR0 = 35072,
  TRCACVR8 = 35073,
  TRCACATR0 = 35074,
  TRCACATR8 = 35075,
  TRCDVCVR0 = 35076,
  TRCDVCVR4 = 35077,
  TRCDVCMR0 = 35078,
  TRCDVCMR4 = 35079,
  TRCACVR1 = 35088,
  TRCACVR9 = 35089,
  TRCACATR1 = 35090,
  TRCACATR9 = 35091,
  TRCACVR2 = 35104,
  TRCACVR10 = 35105,
  TRCACATR2 = 35106,
  TRCACATR10 = 35107,
  TRCDVCVR1 = 35108,
  TRCDVCVR5 = 35109,
  TRCDVCMR1 = 35110,
  TRCDVCMR5 = 35111,
  TRCACVR3 = 35120,
  TRCACVR11 = 35121,
  TRCACATR3 = 35122,
  TRCACATR11 = 35123,
  TRCACVR4 = 35136,
  TRCACVR12 = 35137,
  TRCACATR4 = 35138,
  TRCACATR12 = 35139,
  TRCDVCVR2 = 35140,
  TRCDVCVR6 = 35141,
  TRCDVCMR2 = 35142,
  TRCDVCMR6 = 35143,
  TRCACVR5 = 35152,
  TRCACVR13 = 35153,
  TRCACATR5 = 35154,
  TRCACATR13 = 35155,
  TRCACVR6 = 35168,
  TRCACVR14 = 35169,
  TRCACATR6 = 35170,
  TRCACATR14 = 35171,
  TRCDVCVR3 = 35172,
  TRCDVCVR7 = 35173,
  TRCDVCMR3 = 35174,
  TRCDVCMR7 = 35175,
  TRCACVR7 = 35184,
  TRCACVR15 = 35185,
  TRCACATR7 = 35186,
  TRCACATR15 = 35187,
  TRCCIDCVR0 = 35200,
  TRCVMIDCVR0 = 35201,
  TRCCIDCCTLR0 = 35202,
  TRCCIDCCTLR1 = 35210,
  TRCCIDCVR1 = 35216,
  TRCVMIDCVR1 = 35217,
  TRCVMIDCCTLR0 = 35218,
  TRCVMIDCCTLR1 = 35226,
  TRCCIDCVR2 = 35232,
  TRCVMIDCVR2 = 35233,
  TRCCIDCVR3 = 35248,
  TRCVMIDCVR3 = 35249,
  TRCCIDCVR4 = 35264,
  TRCVMIDCVR4 = 35265,
  TRCCIDCVR5 = 35280,
  TRCVMIDCVR5 = 35281,
  TRCCIDCVR6 = 35296,
  TRCVMIDCVR6 = 35297,
  TRCCIDCVR7 = 35312,
  TRCVMIDCVR7 = 35313,
  TRCITCTRL = 35716,
  TRCDEVID = 35735,
  TRCDEVTYPE = 35743,
  TRCPIDR4 = 35751,
  TRCPIDR5 = 35759,
  TRCPIDR6 = 35767,
  TRCPIDR7 = 35775,
  TRCCLAIMSET = 35782,
  TRCPIDR0 = 35783,
  TRCCLAIMCLR = 35790,
  TRCPIDR1 = 35791,
  TRCDEVAFF0 = 35798,
  TRCPIDR2 = 35799,
  TRCDEVAFF1 = 35806,
  TRCPIDR3 = 35807,
  TRCLAR = 35814,
  TRCCIDR0 = 35815,
  TRCLSR = 35822,
  TRCCIDR1 = 35823,
  TRCAUTHSTATUS = 35830,
  TRCCIDR2 = 35831,
  TRCDEVARCH = 35838,
  TRCCIDR3 = 35839,
  BRBINF0_EL1 = 35840,
  BRBSRC0_EL1 = 35841,
  BRBTGT0_EL1 = 35842,
  BRBINF16_EL1 = 35844,
  BRBSRC16_EL1 = 35845,
  BRBTGT16_EL1 = 35846,
  BRBINF1_EL1 = 35848,
  BRBSRC1_EL1 = 35849,
  BRBTGT1_EL1 = 35850,
  BRBINF17_EL1 = 35852,
  BRBSRC17_EL1 = 35853,
  BRBTGT17_EL1 = 35854,
  BRBINF2_EL1 = 35856,
  BRBSRC2_EL1 = 35857,
  BRBTGT2_EL1 = 35858,
  BRBINF18_EL1 = 35860,
  BRBSRC18_EL1 = 35861,
  BRBTGT18_EL1 = 35862,
  BRBINF3_EL1 = 35864,
  BRBSRC3_EL1 = 35865,
  BRBTGT3_EL1 = 35866,
  BRBINF19_EL1 = 35868,
  BRBSRC19_EL1 = 35869,
  BRBTGT19_EL1 = 35870,
  BRBINF4_EL1 = 35872,
  BRBSRC4_EL1 = 35873,
  BRBTGT4_EL1 = 35874,
  BRBINF20_EL1 = 35876,
  BRBSRC20_EL1 = 35877,
  BRBTGT20_EL1 = 35878,
  BRBINF5_EL1 = 35880,
  BRBSRC5_EL1 = 35881,
  BRBTGT5_EL1 = 35882,
  BRBINF21_EL1 = 35884,
  BRBSRC21_EL1 = 35885,
  BRBTGT21_EL1 = 35886,
  BRBINF6_EL1 = 35888,
  BRBSRC6_EL1 = 35889,
  BRBTGT6_EL1 = 35890,
  BRBINF22_EL1 = 35892,
  BRBSRC22_EL1 = 35893,
  BRBTGT22_EL1 = 35894,
  BRBINF7_EL1 = 35896,
  BRBSRC7_EL1 = 35897,
  BRBTGT7_EL1 = 35898,
  BRBINF23_EL1 = 35900,
  BRBSRC23_EL1 = 35901,
  BRBTGT23_EL1 = 35902,
  BRBINF8_EL1 = 35904,
  BRBSRC8_EL1 = 35905,
  BRBTGT8_EL1 = 35906,
  BRBINF24_EL1 = 35908,
  BRBSRC24_EL1 = 35909,
  BRBTGT24_EL1 = 35910,
  BRBINF9_EL1 = 35912,
  BRBSRC9_EL1 = 35913,
  BRBTGT9_EL1 = 35914,
  BRBINF25_EL1 = 35916,
  BRBSRC25_EL1 = 35917,
  BRBTGT25_EL1 = 35918,
  BRBINF10_EL1 = 35920,
  BRBSRC10_EL1 = 35921,
  BRBTGT10_EL1 = 35922,
  BRBINF26_EL1 = 35924,
  BRBSRC26_EL1 = 35925,
  BRBTGT26_EL1 = 35926,
  BRBINF11_EL1 = 35928,
  BRBSRC11_EL1 = 35929,
  BRBTGT11_EL1 = 35930,
  BRBINF27_EL1 = 35932,
  BRBSRC27_EL1 = 35933,
  BRBTGT27_EL1 = 35934,
  BRBINF12_EL1 = 35936,
  BRBSRC12_EL1 = 35937,
  BRBTGT12_EL1 = 35938,
  BRBINF28_EL1 = 35940,
  BRBSRC28_EL1 = 35941,
  BRBTGT28_EL1 = 35942,
  BRBINF13_EL1 = 35944,
  BRBSRC13_EL1 = 35945,
  BRBTGT13_EL1 = 35946,
  BRBINF29_EL1 = 35948,
  BRBSRC29_EL1 = 35949,
  BRBTGT29_EL1 = 35950,
  BRBINF14_EL1 = 35952,
  BRBSRC14_EL1 = 35953,
  BRBTGT14_EL1 = 35954,
  BRBINF30_EL1 = 35956,
  BRBSRC30_EL1 = 35957,
  BRBTGT30_EL1 = 35958,
  BRBINF15_EL1 = 35960,
  BRBSRC15_EL1 = 35961,
  BRBTGT15_EL1 = 35962,
  BRBINF31_EL1 = 35964,
  BRBSRC31_EL1 = 35965,
  BRBTGT31_EL1 = 35966,
  BRBCR_EL1 = 35968,
  BRBFCR_EL1 = 35969,
  BRBTS_EL1 = 35970,
  BRBINFINJ_EL1 = 35976,
  BRBSRCINJ_EL1 = 35977,
  BRBTGTINJ_EL1 = 35978,
  BRBIDR0_EL1 = 35984,
  TEECR32_EL1 = 36864,
  TEEHBR32_EL1 = 36992,
  MDCCSR_EL0 = 38920,
  DBGDTR_EL0 = 38944,
  DBGDTRRX_EL0 = 38952,
  DBGDTRTX_EL0 = 38952,
  SPMCR_EL0 = 40160,
  SPMCNTENSET_EL0 = 40161,
  SPMCNTENCLR_EL0 = 40162,
  SPMOVSCLR_EL0 = 40163,
  SPMZR_EL0 = 40164,
  SPMSELR_EL0 = 40165,
  SPMOVSSET_EL0 = 40179,
  SPMEVCNTR0_EL0 = 40704,
  SPMEVCNTR1_EL0 = 40705,
  SPMEVCNTR2_EL0 = 40706,
  SPMEVCNTR3_EL0 = 40707,
  SPMEVCNTR4_EL0 = 40708,
  SPMEVCNTR5_EL0 = 40709,
  SPMEVCNTR6_EL0 = 40710,
  SPMEVCNTR7_EL0 = 40711,
  SPMEVCNTR8_EL0 = 40712,
  SPMEVCNTR9_EL0 = 40713,
  SPMEVCNTR10_EL0 = 40714,
  SPMEVCNTR11_EL0 = 40715,
  SPMEVCNTR12_EL0 = 40716,
  SPMEVCNTR13_EL0 = 40717,
  SPMEVCNTR14_EL0 = 40718,
  SPMEVCNTR15_EL0 = 40719,
  SPMEVTYPER0_EL0 = 40720,
  SPMEVTYPER1_EL0 = 40721,
  SPMEVTYPER2_EL0 = 40722,
  SPMEVTYPER3_EL0 = 40723,
  SPMEVTYPER4_EL0 = 40724,
  SPMEVTYPER5_EL0 = 40725,
  SPMEVTYPER6_EL0 = 40726,
  SPMEVTYPER7_EL0 = 40727,
  SPMEVTYPER8_EL0 = 40728,
  SPMEVTYPER9_EL0 = 40729,
  SPMEVTYPER10_EL0 = 40730,
  SPMEVTYPER11_EL0 = 40731,
  SPMEVTYPER12_EL0 = 40732,
  SPMEVTYPER13_EL0 = 40733,
  SPMEVTYPER14_EL0 = 40734,
  SPMEVTYPER15_EL0 = 40735,
  SPMEVFILTR0_EL0 = 40736,
  SPMEVFILTR1_EL0 = 40737,
  SPMEVFILTR2_EL0 = 40738,
  SPMEVFILTR3_EL0 = 40739,
  SPMEVFILTR4_EL0 = 40740,
  SPMEVFILTR5_EL0 = 40741,
  SPMEVFILTR6_EL0 = 40742,
  SPMEVFILTR7_EL0 = 40743,
  SPMEVFILTR8_EL0 = 40744,
  SPMEVFILTR9_EL0 = 40745,
  SPMEVFILTR10_EL0 = 40746,
  SPMEVFILTR11_EL0 = 40747,
  SPMEVFILTR12_EL0 = 40748,
  SPMEVFILTR13_EL0 = 40749,
  SPMEVFILTR14_EL0 = 40750,
  SPMEVFILTR15_EL0 = 40751,
  SPMEVFILT2R0_EL0 = 40752,
  SPMEVFILT2R1_EL0 = 40753,
  SPMEVFILT2R2_EL0 = 40754,
  SPMEVFILT2R3_EL0 = 40755,
  SPMEVFILT2R4_EL0 = 40756,
  SPMEVFILT2R5_EL0 = 40757,
  SPMEVFILT2R6_EL0 = 40758,
  SPMEVFILT2R7_EL0 = 40759,
  SPMEVFILT2R8_EL0 = 40760,
  SPMEVFILT2R9_EL0 = 40761,
  SPMEVFILT2R10_EL0 = 40762,
  SPMEVFILT2R11_EL0 = 40763,
  SPMEVFILT2R12_EL0 = 40764,
  SPMEVFILT2R13_EL0 = 40765,
  SPMEVFILT2R14_EL0 = 40766,
  SPMEVFILT2R15_EL0 = 40767,
  DBGVCR32_EL2 = 41016,
  BRBCR_EL2 = 42112,
  SPMACCESSR_EL2 = 42219,
  BRBCR_EL12 = 44160,
  SPMACCESSR_EL12 = 44267,
  SPMACCESSR_EL3 = 46315,
  SPMROOTCR_EL3 = 46327,
  SPMSCR_EL1 = 48375,
  MIDR_EL1 = 49152,
  MPUIR_EL1 = 49156,
  MPIDR_EL1 = 49157,
  REVIDR_EL1 = 49158,
  ID_PFR0_EL1 = 49160,
  ID_PFR1_EL1 = 49161,
  ID_DFR0_EL1 = 49162,
  ID_AFR0_EL1 = 49163,
  ID_MMFR0_EL1 = 49164,
  ID_MMFR1_EL1 = 49165,
  ID_MMFR2_EL1 = 49166,
  ID_MMFR3_EL1 = 49167,
  ID_ISAR0_EL1 = 49168,
  ID_ISAR1_EL1 = 49169,
  ID_ISAR2_EL1 = 49170,
  ID_ISAR3_EL1 = 49171,
  ID_ISAR4_EL1 = 49172,
  ID_ISAR5_EL1 = 49173,
  ID_MMFR4_EL1 = 49174,
  ID_ISAR6_EL1 = 49175,
  MVFR0_EL1 = 49176,
  MVFR1_EL1 = 49177,
  MVFR2_EL1 = 49178,
  ID_PFR2_EL1 = 49180,
  ID_DFR1_EL1 = 49181,
  ID_MMFR5_EL1 = 49182,
  ID_AA64PFR0_EL1 = 49184,
  ID_AA64PFR1_EL1 = 49185,
  ID_AA64PFR2_EL1 = 49186,
  ID_AA64ZFR0_EL1 = 49188,
  ID_AA64SMFR0_EL1 = 49189,
  ID_AA64FPFR0_EL1 = 49191,
  ID_AA64DFR0_EL1 = 49192,
  ID_AA64DFR1_EL1 = 49193,
  ID_AA64DFR2_EL1 = 49194,
  ID_AA64AFR0_EL1 = 49196,
  ID_AA64AFR1_EL1 = 49197,
  ID_AA64ISAR0_EL1 = 49200,
  ID_AA64ISAR1_EL1 = 49201,
  ID_AA64ISAR2_EL1 = 49202,
  ID_AA64ISAR3_EL1 = 49203,
  ID_AA64MMFR0_EL1 = 49208,
  ID_AA64MMFR1_EL1 = 49209,
  ID_AA64MMFR2_EL1 = 49210,
  ID_AA64MMFR3_EL1 = 49211,
  ID_AA64MMFR4_EL1 = 49212,
  SCTLR_EL1 = 49280,
  ACTLR_EL1 = 49281,
  CPACR_EL1 = 49282,
  SCTLR2_EL1 = 49283,
  RGSR_EL1 = 49285,
  GCR_EL1 = 49286,
  ZCR_EL1 = 49296,
  TRFCR_EL1 = 49297,
  TRCITECR_EL1 = 49299,
  SMPRI_EL1 = 49300,
  SMCR_EL1 = 49302,
  SCTLRMASK_EL1 = 49312,
  ACTLRMASK_EL1 = 49313,
  CPACRMASK_EL1 = 49314,
  SCTLR2MASK_EL1 = 49315,
  CPACRALIAS_EL1 = 49316,
  ACTLRALIAS_EL1 = 49317,
  SCTLRALIAS_EL1 = 49318,
  SCTLR2ALIAS_EL1 = 49319,
  TTBR0_EL1 = 49408,
  TTBR1_EL1 = 49409,
  TCR_EL1 = 49410,
  TCR2_EL1 = 49411,
  APIAKeyLo_EL1 = 49416,
  APIAKeyHi_EL1 = 49417,
  APIBKeyLo_EL1 = 49418,
  APIBKeyHi_EL1 = 49419,
  APDAKeyLo_EL1 = 49424,
  APDAKeyHi_EL1 = 49425,
  APDBKeyLo_EL1 = 49426,
  APDBKeyHi_EL1 = 49427,
  APGAKeyLo_EL1 = 49432,
  APGAKeyHi_EL1 = 49433,
  GCSCR_EL1 = 49448,
  GCSPR_EL1 = 49449,
  GCSCRE0_EL1 = 49450,
  TCRMASK_EL1 = 49466,
  TCR2MASK_EL1 = 49467,
  TCRALIAS_EL1 = 49470,
  TCR2ALIAS_EL1 = 49471,
  SPSR_EL1 = 49664,
  ELR_EL1 = 49665,
  SP_EL0 = 49672,
  SPSel = 49680,
  CurrentEL = 49682,
  PAN = 49683,
  UAO = 49684,
  ALLINT = 49688,
  PM = 49689,
  ICC_PMR_EL1 = 49712,
  AFSR0_EL1 = 49800,
  AFSR1_EL1 = 49801,
  ESR_EL1 = 49808,
  ERRIDR_EL1 = 49816,
  ERRSELR_EL1 = 49817,
  ERXGSR_EL1 = 49818,
  ERXFR_EL1 = 49824,
  ERXCTLR_EL1 = 49825,
  ERXSTATUS_EL1 = 49826,
  ERXADDR_EL1 = 49827,
  ERXPFGF_EL1 = 49828,
  ERXPFGCTL_EL1 = 49829,
  ERXPFGCDN_EL1 = 49830,
  ERXMISC0_EL1 = 49832,
  ERXMISC1_EL1 = 49833,
  ERXMISC2_EL1 = 49834,
  ERXMISC3_EL1 = 49835,
  TFSR_EL1 = 49840,
  TFSRE0_EL1 = 49841,
  FAR_EL1 = 49920,
  PFAR_EL1 = 49925,
  PRENR_EL1 = 49929,
  PRSELR_EL1 = 49937,
  PRBAR_EL1 = 49984,
  PRLAR_EL1 = 49985,
  PRBAR1_EL1 = 49988,
  PRLAR1_EL1 = 49989,
  PRBAR2_EL1 = 49992,
  PRLAR2_EL1 = 49993,
  PRBAR3_EL1 = 49996,
  PRLAR3_EL1 = 49997,
  PRBAR4_EL1 = 50000,
  PRLAR4_EL1 = 50001,
  PRBAR5_EL1 = 50004,
  PRLAR5_EL1 = 50005,
  PRBAR6_EL1 = 50008,
  PRLAR6_EL1 = 50009,
  PRBAR7_EL1 = 50012,
  PRLAR7_EL1 = 50013,
  PRBAR8_EL1 = 50016,
  PRLAR8_EL1 = 50017,
  PRBAR9_EL1 = 50020,
  PRLAR9_EL1 = 50021,
  PRBAR10_EL1 = 50024,
  PRLAR10_EL1 = 50025,
  PRBAR11_EL1 = 50028,
  PRLAR11_EL1 = 50029,
  PRBAR12_EL1 = 50032,
  PRLAR12_EL1 = 50033,
  PRBAR13_EL1 = 50036,
  PRLAR13_EL1 = 50037,
  PRBAR14_EL1 = 50040,
  PRLAR14_EL1 = 50041,
  PRBAR15_EL1 = 50044,
  PRLAR15_EL1 = 50045,
  PAR_EL1 = 50080,
  PMSCR_EL1 = 50376,
  PMSNEVFR_EL1 = 50377,
  PMSICR_EL1 = 50378,
  PMSIRR_EL1 = 50379,
  PMSFCR_EL1 = 50380,
  PMSEVFR_EL1 = 50381,
  PMSLATFR_EL1 = 50382,
  PMSIDR_EL1 = 50383,
  PMBLIMITR_EL1 = 50384,
  PMBPTR_EL1 = 50385,
  PMBSR_EL1 = 50387,
  PMSDSFR_EL1 = 50388,
  PMBMAR_EL1 = 50389,
  PMBIDR_EL1 = 50391,
  TRBLIMITR_EL1 = 50392,
  TRBPTR_EL1 = 50393,
  TRBBASER_EL1 = 50394,
  TRBSR_EL1 = 50395,
  TRBMAR_EL1 = 50396,
  TRBMPAM_EL1 = 50397,
  TRBTRG_EL1 = 50398,
  TRBIDR_EL1 = 50399,
  PMSSCR_EL1 = 50411,
  PMINTENSET_EL1 = 50417,
  PMINTENCLR_EL1 = 50418,
  PMUACR_EL1 = 50420,
  PMECR_EL1 = 50421,
  PMMIR_EL1 = 50422,
  PMIAR_EL1 = 50423,
  MAIR_EL1 = 50448,
  MAIR2_EL1 = 50449,
  PIRE0_EL1 = 50450,
  PIR_EL1 = 50451,
  POR_EL1 = 50452,
  S2POR_EL1 = 50453,
  AMAIR_EL1 = 50456,
  AMAIR2_EL1 = 50457,
  LORSA_EL1 = 50464,
  LOREA_EL1 = 50465,
  LORN_EL1 = 50466,
  LORC_EL1 = 50467,
  MPAMIDR_EL1 = 50468,
  MPAMBWIDR_EL1 = 50469,
  LORID_EL1 = 50471,
  MPAM1_EL1 = 50472,
  MPAM0_EL1 = 50473,
  MPAMSM_EL1 = 50475,
  MPAMBW1_EL1 = 50476,
  MPAMBW0_EL1 = 50477,
  MPAMBWSM_EL1 = 50479,
  VBAR_EL1 = 50688,
  RVBAR_EL1 = 50689,
  RMR_EL1 = 50690,
  ISR_EL1 = 50696,
  DISR_EL1 = 50697,
  ICC_IAR0_EL1 = 50752,
  ICC_EOIR0_EL1 = 50753,
  ICC_HPPIR0_EL1 = 50754,
  ICC_BPR0_EL1 = 50755,
  ICC_AP0R0_EL1 = 50756,
  ICC_AP0R1_EL1 = 50757,
  ICC_AP0R2_EL1 = 50758,
  ICC_AP0R3_EL1 = 50759,
  ICC_AP1R0_EL1 = 50760,
  ICC_AP1R1_EL1 = 50761,
  ICC_AP1R2_EL1 = 50762,
  ICC_AP1R3_EL1 = 50763,
  ICC_NMIAR1_EL1 = 50765,
  ICC_DIR_EL1 = 50777,
  ICC_RPR_EL1 = 50779,
  ICC_SGI1R_EL1 = 50781,
  ICC_ASGI1R_EL1 = 50782,
  ICC_SGI0R_EL1 = 50783,
  ICC_IAR1_EL1 = 50784,
  ICC_EOIR1_EL1 = 50785,
  ICC_HPPIR1_EL1 = 50786,
  ICC_BPR1_EL1 = 50787,
  ICC_CTLR_EL1 = 50788,
  ICC_SRE_EL1 = 50789,
  ICC_IGRPEN0_EL1 = 50790,
  ICC_IGRPEN1_EL1 = 50791,
  CONTEXTIDR_EL1 = 50817,
  RCWSMASK_EL1 = 50819,
  TPIDR_EL1 = 50820,
  ACCDATA_EL1 = 50821,
  RCWMASK_EL1 = 50822,
  SCXTNUM_EL1 = 50823,
  CNTKCTL_EL1 = 50952,
  CCSIDR_EL1 = 51200,
  CLIDR_EL1 = 51201,
  CCSIDR2_EL1 = 51202,
  GMID_EL1 = 51204,
  SMIDR_EL1 = 51206,
  AIDR_EL1 = 51207,
  CSSELR_EL1 = 53248,
  CTR_EL0 = 55297,
  DCZID_EL0 = 55303,
  RNDR = 55584,
  RNDRRS = 55585,
  GCSPR_EL0 = 55593,
  NZCV = 55824,
  DAIF = 55825,
  SVCR = 55826,
  DIT = 55829,
  SSBS = 55830,
  TCO = 55831,
  FPCR = 55840,
  FPSR = 55841,
  FPMR = 55842,
  DSPSR_EL0 = 55848,
  DLR_EL0 = 55849,
  PMICNTR_EL0 = 56480,
  PMICFILTR_EL0 = 56496,
  PMCR_EL0 = 56544,
  PMCNTENSET_EL0 = 56545,
  PMCNTENCLR_EL0 = 56546,
  PMOVSCLR_EL0 = 56547,
  PMSWINC_EL0 = 56548,
  PMSELR_EL0 = 56549,
  PMCEID0_EL0 = 56550,
  PMCEID1_EL0 = 56551,
  PMCCNTR_EL0 = 56552,
  PMXEVTYPER_EL0 = 56553,
  PMXEVCNTR_EL0 = 56554,
  PMZR_EL0 = 56556,
  PMUSERENR_EL0 = 56560,
  PMOVSSET_EL0 = 56563,
  POR_EL0 = 56596,
  TPIDR_EL0 = 56962,
  TPIDRRO_EL0 = 56963,
  TPIDR2_EL0 = 56965,
  SCXTNUM_EL0 = 56967,
  AMCR_EL0 = 56976,
  AMCFGR_EL0 = 56977,
  AMCGCR_EL0 = 56978,
  AMUSERENR_EL0 = 56979,
  AMCNTENCLR0_EL0 = 56980,
  AMCNTENSET0_EL0 = 56981,
  AMCG1IDR_EL0 = 56982,
  AMCNTENCLR1_EL0 = 56984,
  AMCNTENSET1_EL0 = 56985,
  AMEVCNTR00_EL0 = 56992,
  AMEVCNTR01_EL0 = 56993,
  AMEVCNTR02_EL0 = 56994,
  AMEVCNTR03_EL0 = 56995,
  AMEVTYPER00_EL0 = 57008,
  AMEVTYPER01_EL0 = 57009,
  AMEVTYPER02_EL0 = 57010,
  AMEVTYPER03_EL0 = 57011,
  AMEVCNTR10_EL0 = 57056,
  AMEVCNTR11_EL0 = 57057,
  AMEVCNTR12_EL0 = 57058,
  AMEVCNTR13_EL0 = 57059,
  AMEVCNTR14_EL0 = 57060,
  AMEVCNTR15_EL0 = 57061,
  AMEVCNTR16_EL0 = 57062,
  AMEVCNTR17_EL0 = 57063,
  AMEVCNTR18_EL0 = 57064,
  AMEVCNTR19_EL0 = 57065,
  AMEVCNTR110_EL0 = 57066,
  AMEVCNTR111_EL0 = 57067,
  AMEVCNTR112_EL0 = 57068,
  AMEVCNTR113_EL0 = 57069,
  AMEVCNTR114_EL0 = 57070,
  AMEVCNTR115_EL0 = 57071,
  AMEVTYPER10_EL0 = 57072,
  AMEVTYPER11_EL0 = 57073,
  AMEVTYPER12_EL0 = 57074,
  AMEVTYPER13_EL0 = 57075,
  AMEVTYPER14_EL0 = 57076,
  AMEVTYPER15_EL0 = 57077,
  AMEVTYPER16_EL0 = 57078,
  AMEVTYPER17_EL0 = 57079,
  AMEVTYPER18_EL0 = 57080,
  AMEVTYPER19_EL0 = 57081,
  AMEVTYPER110_EL0 = 57082,
  AMEVTYPER111_EL0 = 57083,
  AMEVTYPER112_EL0 = 57084,
  AMEVTYPER113_EL0 = 57085,
  AMEVTYPER114_EL0 = 57086,
  AMEVTYPER115_EL0 = 57087,
  CNTFRQ_EL0 = 57088,
  CNTPCT_EL0 = 57089,
  CNTVCT_EL0 = 57090,
  CNTPCTSS_EL0 = 57093,
  CNTVCTSS_EL0 = 57094,
  CNTP_TVAL_EL0 = 57104,
  CNTP_CTL_EL0 = 57105,
  CNTP_CVAL_EL0 = 57106,
  CNTV_TVAL_EL0 = 57112,
  CNTV_CTL_EL0 = 57113,
  CNTV_CVAL_EL0 = 57114,
  PMEVCNTR0_EL0 = 57152,
  PMEVCNTR1_EL0 = 57153,
  PMEVCNTR2_EL0 = 57154,
  PMEVCNTR3_EL0 = 57155,
  PMEVCNTR4_EL0 = 57156,
  PMEVCNTR5_EL0 = 57157,
  PMEVCNTR6_EL0 = 57158,
  PMEVCNTR7_EL0 = 57159,
  PMEVCNTR8_EL0 = 57160,
  PMEVCNTR9_EL0 = 57161,
  PMEVCNTR10_EL0 = 57162,
  PMEVCNTR11_EL0 = 57163,
  PMEVCNTR12_EL0 = 57164,
  PMEVCNTR13_EL0 = 57165,
  PMEVCNTR14_EL0 = 57166,
  PMEVCNTR15_EL0 = 57167,
  PMEVCNTR16_EL0 = 57168,
  PMEVCNTR17_EL0 = 57169,
  PMEVCNTR18_EL0 = 57170,
  PMEVCNTR19_EL0 = 57171,
  PMEVCNTR20_EL0 = 57172,
  PMEVCNTR21_EL0 = 57173,
  PMEVCNTR22_EL0 = 57174,
  PMEVCNTR23_EL0 = 57175,
  PMEVCNTR24_EL0 = 57176,
  PMEVCNTR25_EL0 = 57177,
  PMEVCNTR26_EL0 = 57178,
  PMEVCNTR27_EL0 = 57179,
  PMEVCNTR28_EL0 = 57180,
  PMEVCNTR29_EL0 = 57181,
  PMEVCNTR30_EL0 = 57182,
  PMEVTYPER0_EL0 = 57184,
  PMEVTYPER1_EL0 = 57185,
  PMEVTYPER2_EL0 = 57186,
  PMEVTYPER3_EL0 = 57187,
  PMEVTYPER4_EL0 = 57188,
  PMEVTYPER5_EL0 = 57189,
  PMEVTYPER6_EL0 = 57190,
  PMEVTYPER7_EL0 = 57191,
  PMEVTYPER8_EL0 = 57192,
  PMEVTYPER9_EL0 = 57193,
  PMEVTYPER10_EL0 = 57194,
  PMEVTYPER11_EL0 = 57195,
  PMEVTYPER12_EL0 = 57196,
  PMEVTYPER13_EL0 = 57197,
  PMEVTYPER14_EL0 = 57198,
  PMEVTYPER15_EL0 = 57199,
  PMEVTYPER16_EL0 = 57200,
  PMEVTYPER17_EL0 = 57201,
  PMEVTYPER18_EL0 = 57202,
  PMEVTYPER19_EL0 = 57203,
  PMEVTYPER20_EL0 = 57204,
  PMEVTYPER21_EL0 = 57205,
  PMEVTYPER22_EL0 = 57206,
  PMEVTYPER23_EL0 = 57207,
  PMEVTYPER24_EL0 = 57208,
  PMEVTYPER25_EL0 = 57209,
  PMEVTYPER26_EL0 = 57210,
  PMEVTYPER27_EL0 = 57211,
  PMEVTYPER28_EL0 = 57212,
  PMEVTYPER29_EL0 = 57213,
  PMEVTYPER30_EL0 = 57214,
  PMCCFILTR_EL0 = 57215,
  VPIDR_EL2 = 57344,
  MPUIR_EL2 = 57348,
  VMPIDR_EL2 = 57349,
  SCTLR_EL2 = 57472,
  ACTLR_EL2 = 57473,
  SCTLR2_EL2 = 57475,
  HCR_EL2 = 57480,
  MDCR_EL2 = 57481,
  CPTR_EL2 = 57482,
  HSTR_EL2 = 57483,
  HFGRTR_EL2 = 57484,
  HFGWTR_EL2 = 57485,
  HFGITR_EL2 = 57486,
  HACR_EL2 = 57487,
  ZCR_EL2 = 57488,
  TRFCR_EL2 = 57489,
  HCRX_EL2 = 57490,
  TRCITECR_EL2 = 57491,
  SMPRIMAP_EL2 = 57493,
  SMCR_EL2 = 57494,
  SDER32_EL2 = 57497,
  SCTLRMASK_EL2 = 57504,
  ACTLRMASK_EL2 = 57505,
  CPTRMASK_EL2 = 57506,
  SCTLR2MASK_EL2 = 57507,
  TTBR0_EL2 = 57600,
  VSCTLR_EL2 = 57600,
  TTBR1_EL2 = 57601,
  TCR_EL2 = 57602,
  TCR2_EL2 = 57603,
  VTTBR_EL2 = 57608,
  VTCR_EL2 = 57610,
  VNCR_EL2 = 57616,
  HDBSSBR_EL2 = 57626,
  HDBSSPROD_EL2 = 57627,
  HACDBSBR_EL2 = 57628,
  HACDBSCONS_EL2 = 57629,
  GCSCR_EL2 = 57640,
  GCSPR_EL2 = 57641,
  VSTTBR_EL2 = 57648,
  VSTCR_EL2 = 57650,
  TCRMASK_EL2 = 57658,
  TCR2MASK_EL2 = 57659,
  DACR32_EL2 = 57728,
  HDFGRTR2_EL2 = 57736,
  HDFGWTR2_EL2 = 57737,
  HFGRTR2_EL2 = 57738,
  HFGWTR2_EL2 = 57739,
  HDFGRTR_EL2 = 57740,
  HDFGWTR_EL2 = 57741,
  HAFGRTR_EL2 = 57742,
  HFGITR2_EL2 = 57743,
  SPSR_EL2 = 57856,
  ELR_EL2 = 57857,
  SP_EL1 = 57864,
  SPSR_irq = 57880,
  SPSR_abt = 57881,
  SPSR_und = 57882,
  SPSR_fiq = 57883,
  IFSR32_EL2 = 57985,
  AFSR0_EL2 = 57992,
  AFSR1_EL2 = 57993,
  ESR_EL2 = 58000,
  VSESR_EL2 = 58003,
  FPEXC32_EL2 = 58008,
  TFSR_EL2 = 58032,
  FAR_EL2 = 58112,
  HPFAR_EL2 = 58116,
  PFAR_EL2 = 58117,
  PRENR_EL2 = 58121,
  PRSELR_EL2 = 58129,
  PRBAR_EL2 = 58176,
  PRLAR_EL2 = 58177,
  PRBAR1_EL2 = 58180,
  PRLAR1_EL2 = 58181,
  PRBAR2_EL2 = 58184,
  PRLAR2_EL2 = 58185,
  PRBAR3_EL2 = 58188,
  PRLAR3_EL2 = 58189,
  PRBAR4_EL2 = 58192,
  PRLAR4_EL2 = 58193,
  PRBAR5_EL2 = 58196,
  PRLAR5_EL2 = 58197,
  PRBAR6_EL2 = 58200,
  PRLAR6_EL2 = 58201,
  PRBAR7_EL2 = 58204,
  PRLAR7_EL2 = 58205,
  PRBAR8_EL2 = 58208,
  PRLAR8_EL2 = 58209,
  PRBAR9_EL2 = 58212,
  PRLAR9_EL2 = 58213,
  PRBAR10_EL2 = 58216,
  PRLAR10_EL2 = 58217,
  PRBAR11_EL2 = 58220,
  PRLAR11_EL2 = 58221,
  PRBAR12_EL2 = 58224,
  PRLAR12_EL2 = 58225,
  PRBAR13_EL2 = 58228,
  PRLAR13_EL2 = 58229,
  PRBAR14_EL2 = 58232,
  PRLAR14_EL2 = 58233,
  PRBAR15_EL2 = 58236,
  PRLAR15_EL2 = 58237,
  PMSCR_EL2 = 58568,
  PMBSR_EL2 = 58579,
  TRBSR_EL2 = 58587,
  MAIR2_EL2 = 58633,
  MAIR_EL2 = 58640,
  PIRE0_EL2 = 58642,
  PIR_EL2 = 58643,
  POR_EL2 = 58644,
  S2PIR_EL2 = 58645,
  AMAIR_EL2 = 58648,
  AMAIR2_EL2 = 58649,
  MPAMHCR_EL2 = 58656,
  MPAMVPMV_EL2 = 58657,
  MPAM2_EL2 = 58664,
  MPAMBW2_EL2 = 58668,
  MPAMBWCAP_EL2 = 58670,
  MPAMVPM0_EL2 = 58672,
  MPAMVPM1_EL2 = 58673,
  MPAMVPM2_EL2 = 58674,
  MPAMVPM3_EL2 = 58675,
  MPAMVPM4_EL2 = 58676,
  MPAMVPM5_EL2 = 58677,
  MPAMVPM6_EL2 = 58678,
  MPAMVPM7_EL2 = 58679,
  MECID_P0_EL2 = 58688,
  MECID_A0_EL2 = 58689,
  MECID_P1_EL2 = 58690,
  MECID_A1_EL2 = 58691,
  MECIDR_EL2 = 58695,
  VMECID_P_EL2 = 58696,
  VMECID_A_EL2 = 58697,
  VBAR_EL2 = 58880,
  RVBAR_EL2 = 58881,
  RMR_EL2 = 58882,
  VDISR_EL2 = 58889,
  ICH_AP0R0_EL2 = 58944,
  ICH_AP0R1_EL2 = 58945,
  ICH_AP0R2_EL2 = 58946,
  ICH_AP0R3_EL2 = 58947,
  ICH_AP1R0_EL2 = 58952,
  ICH_AP1R1_EL2 = 58953,
  ICH_AP1R2_EL2 = 58954,
  ICH_AP1R3_EL2 = 58955,
  ICC_SRE_EL2 = 58957,
  ICH_HCR_EL2 = 58968,
  ICH_VTR_EL2 = 58969,
  ICH_MISR_EL2 = 58970,
  ICH_EISR_EL2 = 58971,
  ICH_ELRSR_EL2 = 58973,
  ICH_VMCR_EL2 = 58975,
  ICH_LR0_EL2 = 58976,
  ICH_LR1_EL2 = 58977,
  ICH_LR2_EL2 = 58978,
  ICH_LR3_EL2 = 58979,
  ICH_LR4_EL2 = 58980,
  ICH_LR5_EL2 = 58981,
  ICH_LR6_EL2 = 58982,
  ICH_LR7_EL2 = 58983,
  ICH_LR8_EL2 = 58984,
  ICH_LR9_EL2 = 58985,
  ICH_LR10_EL2 = 58986,
  ICH_LR11_EL2 = 58987,
  ICH_LR12_EL2 = 58988,
  ICH_LR13_EL2 = 58989,
  ICH_LR14_EL2 = 58990,
  ICH_LR15_EL2 = 58991,
  CONTEXTIDR_EL2 = 59009,
  TPIDR_EL2 = 59010,
  SCXTNUM_EL2 = 59015,
  AMEVCNTVOFF00_EL2 = 59072,
  AMEVCNTVOFF01_EL2 = 59073,
  AMEVCNTVOFF02_EL2 = 59074,
  AMEVCNTVOFF03_EL2 = 59075,
  AMEVCNTVOFF04_EL2 = 59076,
  AMEVCNTVOFF05_EL2 = 59077,
  AMEVCNTVOFF06_EL2 = 59078,
  AMEVCNTVOFF07_EL2 = 59079,
  AMEVCNTVOFF08_EL2 = 59080,
  AMEVCNTVOFF09_EL2 = 59081,
  AMEVCNTVOFF010_EL2 = 59082,
  AMEVCNTVOFF011_EL2 = 59083,
  AMEVCNTVOFF012_EL2 = 59084,
  AMEVCNTVOFF013_EL2 = 59085,
  AMEVCNTVOFF014_EL2 = 59086,
  AMEVCNTVOFF015_EL2 = 59087,
  AMEVCNTVOFF10_EL2 = 59088,
  AMEVCNTVOFF11_EL2 = 59089,
  AMEVCNTVOFF12_EL2 = 59090,
  AMEVCNTVOFF13_EL2 = 59091,
  AMEVCNTVOFF14_EL2 = 59092,
  AMEVCNTVOFF15_EL2 = 59093,
  AMEVCNTVOFF16_EL2 = 59094,
  AMEVCNTVOFF17_EL2 = 59095,
  AMEVCNTVOFF18_EL2 = 59096,
  AMEVCNTVOFF19_EL2 = 59097,
  AMEVCNTVOFF110_EL2 = 59098,
  AMEVCNTVOFF111_EL2 = 59099,
  AMEVCNTVOFF112_EL2 = 59100,
  AMEVCNTVOFF113_EL2 = 59101,
  AMEVCNTVOFF114_EL2 = 59102,
  AMEVCNTVOFF115_EL2 = 59103,
  CNTVOFF_EL2 = 59139,
  CNTSCALE_EL2 = 59140,
  CNTISCALE_EL2 = 59141,
  CNTPOFF_EL2 = 59142,
  CNTVFRQ_EL2 = 59143,
  CNTHCTL_EL2 = 59144,
  CNTHP_TVAL_EL2 = 59152,
  CNTHP_CTL_EL2 = 59153,
  CNTHP_CVAL_EL2 = 59154,
  CNTHV_TVAL_EL2 = 59160,
  CNTHV_CTL_EL2 = 59161,
  CNTHV_CVAL_EL2 = 59162,
  CNTHVS_TVAL_EL2 = 59168,
  CNTHVS_CTL_EL2 = 59169,
  CNTHVS_CVAL_EL2 = 59170,
  CNTHPS_TVAL_EL2 = 59176,
  CNTHPS_CTL_EL2 = 59177,
  CNTHPS_CVAL_EL2 = 59178,
  SCTLR_EL12 = 59520,
  ACTLR_EL12 = 59521,
  CPACR_EL12 = 59522,
  SCTLR2_EL12 = 59523,
  ZCR_EL12 = 59536,
  TRFCR_EL12 = 59537,
  TRCITECR_EL12 = 59539,
  SMCR_EL12 = 59542,
  SCTLRMASK_EL12 = 59552,
  ACTLRMASK_EL12 = 59553,
  CPACRMASK_EL12 = 59554,
  SCTLR2MASK_EL12 = 59555,
  TTBR0_EL12 = 59648,
  TTBR1_EL12 = 59649,
  TCR_EL12 = 59650,
  TCR2_EL12 = 59651,
  GCSCR_EL12 = 59688,
  GCSPR_EL12 = 59689,
  TCRMASK_EL12 = 59706,
  TCR2MASK_EL12 = 59707,
  SPSR_EL12 = 59904,
  ELR_EL12 = 59905,
  AFSR0_EL12 = 60040,
  AFSR1_EL12 = 60041,
  ESR_EL12 = 60048,
  TFSR_EL12 = 60080,
  FAR_EL12 = 60160,
  PFAR_EL12 = 60165,
  PMSCR_EL12 = 60616,
  PMBSR_EL12 = 60627,
  TRBSR_EL12 = 60635,
  MAIR_EL12 = 60688,
  MAIR2_EL12 = 60689,
  PIRE0_EL12 = 60690,
  PIR_EL12 = 60691,
  POR_EL12 = 60692,
  AMAIR_EL12 = 60696,
  AMAIR2_EL12 = 60697,
  MPAM1_EL12 = 60712,
  MPAMBW1_EL12 = 60716,
  VBAR_EL12 = 60928,
  CONTEXTIDR_EL12 = 61057,
  SCXTNUM_EL12 = 61063,
  CNTKCTL_EL12 = 61192,
  CNTP_TVAL_EL02 = 61200,
  CNTP_CTL_EL02 = 61201,
  CNTP_CVAL_EL02 = 61202,
  CNTV_TVAL_EL02 = 61208,
  CNTV_CTL_EL02 = 61209,
  CNTV_CVAL_EL02 = 61210,
  SCTLR_EL3 = 61568,
  ACTLR_EL3 = 61569,
  SCTLR2_EL3 = 61571,
  SCR_EL3 = 61576,
  SDER32_EL3 = 61577,
  CPTR_EL3 = 61578,
  FGWTE3_EL3 = 61581,
  ZCR_EL3 = 61584,
  SMCR_EL3 = 61590,
  MDCR_EL3 = 61593,
  TTBR0_EL3 = 61696,
  TCR_EL3 = 61698,
  GPTBR_EL3 = 61708,
  GPCBW_EL3 = 61709,
  GPCCR_EL3 = 61710,
  GCSCR_EL3 = 61736,
  GCSPR_EL3 = 61737,
  SPSR_EL3 = 61952,
  ELR_EL3 = 61953,
  SP_EL2 = 61960,
  AFSR0_EL3 = 62088,
  AFSR1_EL3 = 62089,
  ESR_EL3 = 62096,
  VSESR_EL3 = 62099,
  TFSR_EL3 = 62128,
  FAR_EL3 = 62208,
  MFAR_EL3 = 62213,
  PMBSR_EL3 = 62675,
  TRBSR_EL3 = 62683,
  MAIR2_EL3 = 62729,
  MAIR_EL3 = 62736,
  PIR_EL3 = 62739,
  POR_EL3 = 62740,
  AMAIR_EL3 = 62744,
  AMAIR2_EL3 = 62745,
  MPAM3_EL3 = 62760,
  MPAMBW3_EL3 = 62764,
  MECID_RL_A_EL3 = 62801,
  VBAR_EL3 = 62976,
  RVBAR_EL3 = 62977,
  RMR_EL3 = 62978,
  VDISR_EL3 = 62985,
  ICC_CTLR_EL3 = 63076,
  ICC_SRE_EL3 = 63077,
  ICC_IGRPEN1_EL3 = 63079,
  TPIDR_EL3 = 63106,
  SCXTNUM_EL3 = 63111,
  CNTPS_TVAL_EL1 = 65296,
  CNTPS_CTL_EL1 = 65297,
  CNTPS_CVAL_EL1 = 65298,
  NUM_TARGET_SYSREGS = 1254,
};
}
}
}
#endif
