// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: flushlog.proto

package flushlogpb

import (
	fmt "fmt"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"

	io "io"
	math "math"
	math_bits "math/bits"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// FlushLog holds information about a flush operation for a given alert group.
type FlushLog struct {
	// The fingerprint identifying the dispatching group.
	GroupFingerprint uint64 `protobuf:"varint,1,opt,name=group_fingerprint,json=groupFingerprint,proto3" json:"group_fingerprint,omitempty"`
	// Timestamp of the flush.
	Timestamp            time.Time `protobuf:"bytes,2,opt,name=timestamp,proto3,stdtime" json:"timestamp"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *FlushLog) Reset()         { *m = FlushLog{} }
func (m *FlushLog) String() string { return proto.CompactTextString(m) }
func (*FlushLog) ProtoMessage()    {}
func (*FlushLog) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2f508cb1f80adf5, []int{0}
}
func (m *FlushLog) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FlushLog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FlushLog.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FlushLog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlushLog.Merge(m, src)
}
func (m *FlushLog) XXX_Size() int {
	return m.Size()
}
func (m *FlushLog) XXX_DiscardUnknown() {
	xxx_messageInfo_FlushLog.DiscardUnknown(m)
}

var xxx_messageInfo_FlushLog proto.InternalMessageInfo

// MeshFlushLog is a wrapper message to communicate a flush log
// entry through a mesh network.
type MeshFlushLog struct {
	// The original raw flush log entry.
	FlushLog *FlushLog `protobuf:"bytes,1,opt,name=flushLog,proto3" json:"flushLog,omitempty"`
	// A timestamp indicating when the mesh peer should evict
	// the log entry from its state.
	ExpiresAt            time.Time `protobuf:"bytes,2,opt,name=expires_at,json=expiresAt,proto3,stdtime" json:"expires_at"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *MeshFlushLog) Reset()         { *m = MeshFlushLog{} }
func (m *MeshFlushLog) String() string { return proto.CompactTextString(m) }
func (*MeshFlushLog) ProtoMessage()    {}
func (*MeshFlushLog) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2f508cb1f80adf5, []int{1}
}
func (m *MeshFlushLog) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshFlushLog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshFlushLog.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshFlushLog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshFlushLog.Merge(m, src)
}
func (m *MeshFlushLog) XXX_Size() int {
	return m.Size()
}
func (m *MeshFlushLog) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshFlushLog.DiscardUnknown(m)
}

var xxx_messageInfo_MeshFlushLog proto.InternalMessageInfo

func init() {
	proto.RegisterType((*FlushLog)(nil), "flushlogpb.FlushLog")
	proto.RegisterType((*MeshFlushLog)(nil), "flushlogpb.MeshFlushLog")
}

func init() { proto.RegisterFile("flushlog.proto", fileDescriptor_f2f508cb1f80adf5) }

var fileDescriptor_f2f508cb1f80adf5 = []byte{
	// 242 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0xe2, 0x4b, 0xcb, 0x29, 0x2d,
	0xce, 0xc8, 0xc9, 0x4f, 0xd7, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0x17, 0xe2, 0x82, 0xf1, 0x0b, 0x92,
	0xa4, 0xe4, 0xd3, 0xf3, 0xf3, 0xd3, 0x73, 0x52, 0xf5, 0xc1, 0x32, 0x49, 0xa5, 0x69, 0xfa, 0x25,
	0x99, 0xb9, 0xa9, 0xc5, 0x25, 0x89, 0xb9, 0x05, 0x10, 0xc5, 0x52, 0x22, 0xe9, 0xf9, 0xe9, 0xf9,
	0x60, 0xa6, 0x3e, 0x88, 0x05, 0x11, 0x55, 0xaa, 0xe6, 0xe2, 0x70, 0x03, 0x19, 0xe2, 0x93, 0x9f,
	0x2e, 0xa4, 0xcd, 0x25, 0x98, 0x5e, 0x94, 0x5f, 0x5a, 0x10, 0x9f, 0x96, 0x99, 0x97, 0x9e, 0x5a,
	0x54, 0x50, 0x94, 0x99, 0x57, 0x22, 0xc1, 0xa8, 0xc0, 0xa8, 0xc1, 0x12, 0x24, 0x00, 0x96, 0x70,
	0x43, 0x88, 0x0b, 0x39, 0x71, 0x71, 0xc2, 0x6d, 0x90, 0x60, 0x52, 0x60, 0xd4, 0xe0, 0x36, 0x92,
	0xd2, 0x83, 0xb8, 0x41, 0x0f, 0xe6, 0x06, 0xbd, 0x10, 0x98, 0x0a, 0x27, 0x8e, 0x13, 0xf7, 0xe4,
	0x19, 0x26, 0xdc, 0x97, 0x67, 0x0c, 0x42, 0x68, 0x53, 0x6a, 0x65, 0xe4, 0xe2, 0xf1, 0x4d, 0x2d,
	0xce, 0x80, 0xbb, 0xc0, 0x80, 0x8b, 0x23, 0x0d, 0xca, 0x06, 0x5b, 0xcc, 0x6d, 0x24, 0xa2, 0x87,
	0xf0, 0xa3, 0x1e, 0x4c, 0x5d, 0x10, 0x5c, 0x95, 0x90, 0x33, 0x17, 0x57, 0x6a, 0x45, 0x41, 0x66,
	0x51, 0x6a, 0x71, 0x7c, 0x62, 0x09, 0x69, 0xee, 0x80, 0xea, 0x73, 0x2c, 0x71, 0x12, 0x38, 0xf1,
	0x50, 0x8e, 0xe1, 0xc4, 0x23, 0x39, 0xc6, 0x0b, 0x8f, 0xe4, 0x18, 0x1f, 0x3c, 0x92, 0x63, 0x4c,
	0x62, 0x03, 0x6b, 0x35, 0x06, 0x04, 0x00, 0x00, 0xff, 0xff, 0x51, 0x6a, 0xcb, 0xd7, 0x72, 0x01,
	0x00, 0x00,
}

func (m *FlushLog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FlushLog) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FlushLog) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	n1, err1 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Timestamp, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.Timestamp):])
	if err1 != nil {
		return 0, err1
	}
	i -= n1
	i = encodeVarintFlushlog(dAtA, i, uint64(n1))
	i--
	dAtA[i] = 0x12
	if m.GroupFingerprint != 0 {
		i = encodeVarintFlushlog(dAtA, i, uint64(m.GroupFingerprint))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MeshFlushLog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshFlushLog) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshFlushLog) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	n2, err2 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.ExpiresAt, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.ExpiresAt):])
	if err2 != nil {
		return 0, err2
	}
	i -= n2
	i = encodeVarintFlushlog(dAtA, i, uint64(n2))
	i--
	dAtA[i] = 0x12
	if m.FlushLog != nil {
		{
			size, err := m.FlushLog.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFlushlog(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintFlushlog(dAtA []byte, offset int, v uint64) int {
	offset -= sovFlushlog(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *FlushLog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.GroupFingerprint != 0 {
		n += 1 + sovFlushlog(uint64(m.GroupFingerprint))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Timestamp)
	n += 1 + l + sovFlushlog(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshFlushLog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FlushLog != nil {
		l = m.FlushLog.Size()
		n += 1 + l + sovFlushlog(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.ExpiresAt)
	n += 1 + l + sovFlushlog(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovFlushlog(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozFlushlog(x uint64) (n int) {
	return sovFlushlog(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *FlushLog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFlushlog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FlushLog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FlushLog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupFingerprint", wireType)
			}
			m.GroupFingerprint = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFlushlog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GroupFingerprint |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFlushlog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFlushlog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFlushlog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Timestamp, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipFlushlog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthFlushlog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshFlushLog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFlushlog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MeshFlushLog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MeshFlushLog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FlushLog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFlushlog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFlushlog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFlushlog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FlushLog == nil {
				m.FlushLog = &FlushLog{}
			}
			if err := m.FlushLog.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiresAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFlushlog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFlushlog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFlushlog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.ExpiresAt, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipFlushlog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthFlushlog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipFlushlog(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowFlushlog
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowFlushlog
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowFlushlog
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthFlushlog
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupFlushlog
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthFlushlog
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthFlushlog        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowFlushlog          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupFlushlog = fmt.Errorf("proto: unexpected end of group")
)
