/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// SuccessPolicyRuleApplyConfiguration represents a declarative configuration of the SuccessPolicyRule type for use
// with apply.
//
// SuccessPolicyRule describes rule for declaring a Job as succeeded.
// Each rule must have at least one of the "succeededIndexes" or "succeededCount" specified.
type SuccessPolicyRuleApplyConfiguration struct {
	// succeededIndexes specifies the set of indexes
	// which need to be contained in the actual set of the succeeded indexes for the Job.
	// The list of indexes must be within 0 to ".spec.completions-1" and
	// must not contain duplicates. At least one element is required.
	// The indexes are represented as intervals separated by commas.
	// The intervals can be a decimal integer or a pair of decimal integers separated by a hyphen.
	// The number are listed in represented by the first and last element of the series,
	// separated by a hyphen.
	// For example, if the completed indexes are 1, 3, 4, 5 and 7, they are
	// represented as "1,3-5,7".
	// When this field is null, this field doesn't default to any value
	// and is never evaluated at any time.
	SucceededIndexes *string `json:"succeededIndexes,omitempty"`
	// succeededCount specifies the minimal required size of the actual set of the succeeded indexes
	// for the Job. When succeededCount is used along with succeededIndexes, the check is
	// constrained only to the set of indexes specified by succeededIndexes.
	// For example, given that succeededIndexes is "1-4", succeededCount is "3",
	// and completed indexes are "1", "3", and "5", the Job isn't declared as succeeded
	// because only "1" and "3" indexes are considered in that rules.
	// When this field is null, this doesn't default to any value and
	// is never evaluated at any time.
	// When specified it needs to be a positive integer.
	SucceededCount *int32 `json:"succeededCount,omitempty"`
}

// SuccessPolicyRuleApplyConfiguration constructs a declarative configuration of the SuccessPolicyRule type for use with
// apply.
func SuccessPolicyRule() *SuccessPolicyRuleApplyConfiguration {
	return &SuccessPolicyRuleApplyConfiguration{}
}

// WithSucceededIndexes sets the SucceededIndexes field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SucceededIndexes field is set to the value of the last call.
func (b *SuccessPolicyRuleApplyConfiguration) WithSucceededIndexes(value string) *SuccessPolicyRuleApplyConfiguration {
	b.SucceededIndexes = &value
	return b
}

// WithSucceededCount sets the SucceededCount field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SucceededCount field is set to the value of the last call.
func (b *SuccessPolicyRuleApplyConfiguration) WithSucceededCount(value int32) *SuccessPolicyRuleApplyConfiguration {
	b.SucceededCount = &value
	return b
}
