/*
   SPDX-FileCopyrightText: 2023-2026 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/
#pragma once

#include "textaddonswidgets_export.h"
#include <TextAddonsWidgets/WhatsNewInfo>

#include <QCoreApplication>
#include <QDialog>

namespace TextAddonsWidgets
{
class WhatsNewWidget;
/*!
 * \class TextAddonsWidgets::WhatsNewDialog
 * \inmodule TextAddonsWidgets
 * \inheaderfile TextAddonsWidgets/WhatsNewDialog
 *
 * \brief The WhatsNewDialog class
 * \author Laurent Montel <montel@kde.org>
 */
class TEXTADDONSWIDGETS_EXPORT WhatsNewDialog : public QDialog
{
    Q_OBJECT
public:
    /*!
     * \brief Constructor for WhatsNewDialog
     * \param infos A list of WhatsNewInfo objects to display
     * \param parent The parent widget
     * \param applicationName The name of the application
     */
    explicit WhatsNewDialog(const QList<TextAddonsWidgets::WhatsNewInfo> &infos,
                            QWidget *parent = nullptr,
                            const QString &applicationName = QCoreApplication::applicationName());
    /*!
     * \brief Destructor for WhatsNewDialog
     */
    ~WhatsNewDialog() override;

    /*!
     * \brief Updates the WhatsNew information display
     */
    void updateInformations();

private:
    TEXTADDONSWIDGETS_NO_EXPORT void readConfig();
    TEXTADDONSWIDGETS_NO_EXPORT void writeConfig();
    WhatsNewWidget *const mWhatsNewWidget;
};
}
