
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "ksandbox_processcontext_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

using namespace KSandbox;

extern "C" {
static PyTypeObject *_Sbk_KSandbox_ProcessContext_Type = nullptr;
static PyTypeObject *Sbk_KSandbox_ProcessContext_TypeF(void)
{
    return _Sbk_KSandbox_ProcessContext_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KSandbox_ProcessContext_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNonConstructible("ProcessContext");
    return -1;
}


static const char *Sbk_KSandbox_ProcessContext_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KSandbox_ProcessContext_methods[] = {
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyObject *Sbk_KSandbox_ProcessContext_get_program(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSandbox::ProcessContext *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSandbox_ProcessContext_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->program);
}

static PyObject *Sbk_KSandbox_ProcessContext_get_arguments(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSandbox::ProcessContext *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSandbox_ProcessContext_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppSelf->arguments);
}

// Getters and Setters for ProcessContext
static PyGetSetDef Sbk_KSandbox_ProcessContext_getsetlist[] = {
    {"program", Sbk_KSandbox_ProcessContext_get_program, nullptr, "QString", nullptr},
    {"arguments", Sbk_KSandbox_ProcessContext_get_arguments, nullptr, "QStringList", nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KSandbox_ProcessContext_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KSandbox_ProcessContext_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KSandbox_ProcessContext_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KSandbox_ProcessContext_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KSandbox_ProcessContext_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KSandbox_ProcessContext_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_KSandbox_ProcessContext_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KSandbox_ProcessContext_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KSandbox_ProcessContext_spec = {
    "1:KCoreAddons.KSandbox.ProcessContext",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KSandbox_ProcessContext_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void ProcessContext_PythonToCpp_ProcessContext_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KSandbox_ProcessContext_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_ProcessContext_PythonToCpp_ProcessContext_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KSandbox_ProcessContext_TypeF()))
        return ProcessContext_PythonToCpp_ProcessContext_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *ProcessContext_PTR_CppToPython_ProcessContext(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KSandbox_ProcessContext_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KSandbox_ProcessContext_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KSandbox_ProcessContext_SignatureStrings[] = {
    nullptr}; // Sentinel
#else
static constexpr size_t KSandbox_ProcessContext_SignatureByteSize = 0;
static constexpr uint8_t KSandbox_ProcessContext_SignatureBytes[1] = {
    0x00
};
#endif

PyTypeObject *init_KSandbox_ProcessContext(PyObject *enclosingClass)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KSandbox_ProcessContext_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KSandbox_ProcessContext_IDX].type;

    Shiboken::AutoDecRef Sbk_KSandbox_ProcessContext_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KSandbox_ProcessContext_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "ProcessContext",
        "KSandbox::ProcessContext*",
        &Sbk_KSandbox_ProcessContext_spec,
        &Shiboken::callCppDestructor< ::KSandbox::ProcessContext >,
        Sbk_KSandbox_ProcessContext_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass);
    auto *pyType = _Sbk_KSandbox_ProcessContext_Type; // references _Sbk_KSandbox_ProcessContext_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KSandbox_ProcessContext_SignatureStrings);
#else
    InitSignatureBytes(pyType, KSandbox_ProcessContext_SignatureBytes, KSandbox_ProcessContext_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KSandbox_ProcessContext_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KSandbox_ProcessContext_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        ProcessContext_PythonToCpp_ProcessContext_PTR,
        is_ProcessContext_PythonToCpp_ProcessContext_PTR_Convertible,
        ProcessContext_PTR_CppToPython_ProcessContext);

    Shiboken::Conversions::registerConverterName(converter, "KSandbox::ProcessContext");
    Shiboken::Conversions::registerConverterName(converter, "KSandbox::ProcessContext*");
    Shiboken::Conversions::registerConverterName(converter, "KSandbox::ProcessContext&");
    Shiboken::Conversions::registerConverterAlias(converter, "ProcessContext");
    Shiboken::Conversions::registerConverterAlias(converter, "ProcessContext*");
    Shiboken::Conversions::registerConverterAlias(converter, "ProcessContext&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KSandbox::ProcessContext).name());

    qRegisterMetaType< ::KSandbox::ProcessContext *>();

    return pyType;
}
