//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/http/stateful_session/envelope/v3/envelope.proto

package envelopev3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on EnvelopeSessionState with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *EnvelopeSessionState) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on EnvelopeSessionState with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// EnvelopeSessionStateMultiError, or nil if none found.
func (m *EnvelopeSessionState) ValidateAll() error {
	return m.validate(true)
}

func (m *EnvelopeSessionState) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetHeader() == nil {
		err := EnvelopeSessionStateValidationError{
			field:  "Header",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetHeader()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, EnvelopeSessionStateValidationError{
					field:  "Header",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, EnvelopeSessionStateValidationError{
					field:  "Header",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHeader()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return EnvelopeSessionStateValidationError{
				field:  "Header",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return EnvelopeSessionStateMultiError(errors)
	}

	return nil
}

// EnvelopeSessionStateMultiError is an error wrapping multiple validation
// errors returned by EnvelopeSessionState.ValidateAll() if the designated
// constraints aren't met.
type EnvelopeSessionStateMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m EnvelopeSessionStateMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m EnvelopeSessionStateMultiError) AllErrors() []error { return m }

// EnvelopeSessionStateValidationError is the validation error returned by
// EnvelopeSessionState.Validate if the designated constraints aren't met.
type EnvelopeSessionStateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EnvelopeSessionStateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EnvelopeSessionStateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EnvelopeSessionStateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EnvelopeSessionStateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EnvelopeSessionStateValidationError) ErrorName() string {
	return "EnvelopeSessionStateValidationError"
}

// Error satisfies the builtin error interface
func (e EnvelopeSessionStateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEnvelopeSessionState.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EnvelopeSessionStateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EnvelopeSessionStateValidationError{}

// Validate checks the field values on EnvelopeSessionState_Header with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *EnvelopeSessionState_Header) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on EnvelopeSessionState_Header with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// EnvelopeSessionState_HeaderMultiError, or nil if none found.
func (m *EnvelopeSessionState_Header) ValidateAll() error {
	return m.validate(true)
}

func (m *EnvelopeSessionState_Header) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := EnvelopeSessionState_HeaderValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return EnvelopeSessionState_HeaderMultiError(errors)
	}

	return nil
}

// EnvelopeSessionState_HeaderMultiError is an error wrapping multiple
// validation errors returned by EnvelopeSessionState_Header.ValidateAll() if
// the designated constraints aren't met.
type EnvelopeSessionState_HeaderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m EnvelopeSessionState_HeaderMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m EnvelopeSessionState_HeaderMultiError) AllErrors() []error { return m }

// EnvelopeSessionState_HeaderValidationError is the validation error returned
// by EnvelopeSessionState_Header.Validate if the designated constraints
// aren't met.
type EnvelopeSessionState_HeaderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EnvelopeSessionState_HeaderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EnvelopeSessionState_HeaderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EnvelopeSessionState_HeaderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EnvelopeSessionState_HeaderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EnvelopeSessionState_HeaderValidationError) ErrorName() string {
	return "EnvelopeSessionState_HeaderValidationError"
}

// Error satisfies the builtin error interface
func (e EnvelopeSessionState_HeaderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEnvelopeSessionState_Header.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EnvelopeSessionState_HeaderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EnvelopeSessionState_HeaderValidationError{}
