// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v6.33.2
// source: envoy/extensions/filters/network/tcp_proxy/v3/tcp_proxy.proto

package tcp_proxyv3

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	_ "github.com/envoyproxy/go-control-plane/envoy/annotations"
	v31 "github.com/envoyproxy/go-control-plane/envoy/config/accesslog/v3"
	v3 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
	v33 "github.com/envoyproxy/go-control-plane/envoy/extensions/filters/network/http_connection_manager/v3"
	v32 "github.com/envoyproxy/go-control-plane/envoy/type/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies when the TCP proxy establishes the upstream connection.
type UpstreamConnectMode int32

const (
	// Establish the upstream connection immediately when the downstream connection is accepted.
	// This is the default behavior and provides the lowest latency.
	UpstreamConnectMode_IMMEDIATE UpstreamConnectMode = 0
	// Wait for initial data from the downstream connection before establishing the upstream connection.
	// This allows preceding filters to inspect the initial data (e.g., extracting SNI from TLS ClientHello)
	// before the upstream connection is established.
	//
	// This mode requires “max_early_data_bytes“ to be set.
	//
	// .. warning::
	//
	//	This mode is not suitable for server-first protocols (e.g., SMTP, MySQL, POP3) where the
	//	server sends the initial greeting. For such protocols, use ``IMMEDIATE`` mode.
	UpstreamConnectMode_ON_DOWNSTREAM_DATA UpstreamConnectMode = 1
	// Wait for the downstream TLS handshake to complete before establishing the upstream connection.
	// This allows access to the full TLS connection information, including client certificates
	// and negotiated parameters, which can be used for routing decisions or passed as metadata
	// to the upstream.
	//
	// .. note::
	//
	//	This mode is only effective when the downstream connection uses TLS. For non-TLS
	//	connections, it behaves the same as ``IMMEDIATE``.
	UpstreamConnectMode_ON_DOWNSTREAM_TLS_HANDSHAKE UpstreamConnectMode = 2
)

// Enum value maps for UpstreamConnectMode.
var (
	UpstreamConnectMode_name = map[int32]string{
		0: "IMMEDIATE",
		1: "ON_DOWNSTREAM_DATA",
		2: "ON_DOWNSTREAM_TLS_HANDSHAKE",
	}
	UpstreamConnectMode_value = map[string]int32{
		"IMMEDIATE":                   0,
		"ON_DOWNSTREAM_DATA":          1,
		"ON_DOWNSTREAM_TLS_HANDSHAKE": 2,
	}
)

func (x UpstreamConnectMode) Enum() *UpstreamConnectMode {
	p := new(UpstreamConnectMode)
	*p = x
	return p
}

func (x UpstreamConnectMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpstreamConnectMode) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_enumTypes[0].Descriptor()
}

func (UpstreamConnectMode) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_enumTypes[0]
}

func (x UpstreamConnectMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpstreamConnectMode.Descriptor instead.
func (UpstreamConnectMode) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDescGZIP(), []int{0}
}

// [#next-free-field: 23]
type TcpProxy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The prefix to use when emitting :ref:`statistics
	// <config_network_filters_tcp_proxy_stats>`.
	StatPrefix string `protobuf:"bytes,1,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	// Types that are valid to be assigned to ClusterSpecifier:
	//
	//	*TcpProxy_Cluster
	//	*TcpProxy_WeightedClusters
	ClusterSpecifier isTcpProxy_ClusterSpecifier `protobuf_oneof:"cluster_specifier"`
	// The on demand policy for the upstream cluster.
	// It applies to both
	// :ref:`TcpProxy.cluster <envoy_v3_api_field_extensions.filters.network.tcp_proxy.v3.TcpProxy.cluster>`
	// and
	// :ref:`TcpProxy.weighted_clusters <envoy_v3_api_field_extensions.filters.network.tcp_proxy.v3.TcpProxy.weighted_clusters>`.
	OnDemand *TcpProxy_OnDemand `protobuf:"bytes,14,opt,name=on_demand,json=onDemand,proto3" json:"on_demand,omitempty"`
	// Optional endpoint metadata match criteria used by the subset load balancer. Only endpoints
	// in the upstream cluster with metadata matching what is set in this field will be considered
	// for load balancing. The filter name should be specified as “envoy.lb“.
	MetadataMatch *v3.Metadata `protobuf:"bytes,9,opt,name=metadata_match,json=metadataMatch,proto3" json:"metadata_match,omitempty"`
	// The idle timeout for connections managed by the TCP proxy filter. The idle timeout is defined as the
	// period in which there are no bytes sent or received on either the upstream or downstream connection.
	// If not set, the default idle timeout is 1 hour. If set to “0s“, the timeout is disabled.
	// It is possible to dynamically override this configuration by setting a per-connection filter state
	// object for the key “envoy.tcp_proxy.per_connection_idle_timeout_ms“.
	//
	// .. warning::
	//
	//	Disabling this timeout is likely to yield connection leaks due to lost TCP FIN packets, etc.
	IdleTimeout *durationpb.Duration `protobuf:"bytes,8,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	// [#not-implemented-hide:] The idle timeout for connections managed by the TCP proxy
	// filter. The idle timeout is defined as the period in which there is no
	// active traffic. If not set, there is no idle timeout. When the idle timeout
	// is reached the connection will be closed. The distinction between
	// downstream_idle_timeout/upstream_idle_timeout provides a means to set
	// timeout based on the last byte sent on the downstream/upstream connection.
	DownstreamIdleTimeout *durationpb.Duration `protobuf:"bytes,3,opt,name=downstream_idle_timeout,json=downstreamIdleTimeout,proto3" json:"downstream_idle_timeout,omitempty"`
	// [#not-implemented-hide:]
	UpstreamIdleTimeout *durationpb.Duration `protobuf:"bytes,4,opt,name=upstream_idle_timeout,json=upstreamIdleTimeout,proto3" json:"upstream_idle_timeout,omitempty"`
	// Configuration for :ref:`access logs <arch_overview_access_logs>` emitted by this TCP proxy.
	AccessLog []*v31.AccessLog `protobuf:"bytes,5,rep,name=access_log,json=accessLog,proto3" json:"access_log,omitempty"`
	// The maximum number of unsuccessful connection attempts that will be made before
	// giving up. If the parameter is not specified, 1 connection attempt will be made.
	MaxConnectAttempts *wrapperspb.UInt32Value `protobuf:"bytes,7,opt,name=max_connect_attempts,json=maxConnectAttempts,proto3" json:"max_connect_attempts,omitempty"`
	// Sets the backoff strategy. If not set, the retries are performed without backoff.
	BackoffOptions *v3.BackoffStrategy `protobuf:"bytes,18,opt,name=backoff_options,json=backoffOptions,proto3" json:"backoff_options,omitempty"`
	// Optional configuration for TCP proxy hash policy. If hash_policy is not set, the hash-based
	// load balancing algorithms will select a host randomly. Currently the number of hash policies is
	// limited to 1.
	HashPolicy []*v32.HashPolicy `protobuf:"bytes,11,rep,name=hash_policy,json=hashPolicy,proto3" json:"hash_policy,omitempty"`
	// If set, this configures tunneling, for example configuration options to tunnel TCP payload over
	// HTTP CONNECT. If this message is absent, the payload is proxied upstream as usual.
	// It is possible to dynamically override this configuration and disable tunneling per connection by
	// setting a per-connection filter state object for the key “envoy.tcp_proxy.disable_tunneling“.
	TunnelingConfig *TcpProxy_TunnelingConfig `protobuf:"bytes,12,opt,name=tunneling_config,json=tunnelingConfig,proto3" json:"tunneling_config,omitempty"`
	// The maximum duration of a connection. The duration is defined as the period since a connection was
	// established. If not set, there is no maximum duration. When “max_downstream_connection_duration“ is
	// reached, the connection is closed. The duration must be at least “1ms“.
	MaxDownstreamConnectionDuration *durationpb.Duration `protobuf:"bytes,13,opt,name=max_downstream_connection_duration,json=maxDownstreamConnectionDuration,proto3" json:"max_downstream_connection_duration,omitempty"`
	// Percentage-based jitter for “max_downstream_connection_duration“. The jitter increases the
	// “max_downstream_connection_duration“ by a random duration up to the provided percentage.
	// This field is ignored if “max_downstream_connection_duration“ is not set. If not set, no jitter
	// is added.
	MaxDownstreamConnectionDurationJitterPercentage *v32.Percent `protobuf:"bytes,20,opt,name=max_downstream_connection_duration_jitter_percentage,json=maxDownstreamConnectionDurationJitterPercentage,proto3" json:"max_downstream_connection_duration_jitter_percentage,omitempty"`
	// If both this field and :ref:`access_log_flush_interval
	// <envoy_v3_api_field_extensions.filters.network.tcp_proxy.v3.TcpProxy.TcpAccessLogOptions.access_log_flush_interval>`
	// are specified, the former (deprecated field) is ignored.
	//
	// .. attention::
	//
	//	This field is deprecated in favor of
	//	:ref:`access_log_flush_interval
	//	<envoy_v3_api_field_extensions.filters.network.tcp_proxy.v3.TcpProxy.TcpAccessLogOptions.access_log_flush_interval>`.
	//
	// Deprecated: Marked as deprecated in envoy/extensions/filters/network/tcp_proxy/v3/tcp_proxy.proto.
	AccessLogFlushInterval *durationpb.Duration `protobuf:"bytes,15,opt,name=access_log_flush_interval,json=accessLogFlushInterval,proto3" json:"access_log_flush_interval,omitempty"`
	// If both this field and :ref:`flush_access_log_on_connected
	// <envoy_v3_api_field_extensions.filters.network.tcp_proxy.v3.TcpProxy.TcpAccessLogOptions.flush_access_log_on_connected>`
	// are specified, the former (deprecated field) is ignored.
	//
	// .. attention::
	//
	//	This field is deprecated in favor of
	//	:ref:`flush_access_log_on_connected
	//	<envoy_v3_api_field_extensions.filters.network.tcp_proxy.v3.TcpProxy.TcpAccessLogOptions.flush_access_log_on_connected>`.
	//
	// Deprecated: Marked as deprecated in envoy/extensions/filters/network/tcp_proxy/v3/tcp_proxy.proto.
	FlushAccessLogOnConnected bool `protobuf:"varint,16,opt,name=flush_access_log_on_connected,json=flushAccessLogOnConnected,proto3" json:"flush_access_log_on_connected,omitempty"`
	// Additional access log options for the TCP proxy.
	AccessLogOptions *TcpProxy_TcpAccessLogOptions `protobuf:"bytes,17,opt,name=access_log_options,json=accessLogOptions,proto3" json:"access_log_options,omitempty"`
	// If set, the specified “PROXY“ protocol TLVs (Type-Length-Value) are added to the “PROXY“ protocol state
	// created by the TCP proxy filter. These TLVs are sent in the PROXY protocol v2 header to the upstream.
	//
	// This field only takes effect when the TCP proxy filter is creating new “PROXY“ protocol state and an
	// upstream proxy protocol transport socket is configured in the cluster. If the connection already
	// contains “PROXY“ protocol state (including any TLVs) parsed by a downstream proxy protocol listener
	// upstream proxy protocol transport socket is configured in the cluster. If the connection already
	// contains PROXY protocol state (including any TLVs) parsed by a downstream proxy protocol listener
	// filter, the TLVs specified here are ignored.
	//
	// .. note::
	//
	//	To ensure the specified TLVs are allowed in the upstream ``PROXY`` protocol header, you must also
	//	configure passthrough TLVs on the upstream proxy protocol transport. See
	//	:ref:`core.v3.ProxyProtocolConfig.pass_through_tlvs <envoy_v3_api_field_config.core.v3.ProxyProtocolConfig.pass_through_tlvs>`
	//	for details.
	ProxyProtocolTlvs []*v3.TlvEntry `protobuf:"bytes,19,rep,name=proxy_protocol_tlvs,json=proxyProtocolTlvs,proto3" json:"proxy_protocol_tlvs,omitempty"`
	// Specifies when to establish the upstream connection.
	//
	// When not specified, defaults to “IMMEDIATE“ for backward compatibility.
	//
	// .. attention::
	//
	//	Server-first protocols (e.g., SMTP, MySQL, POP3) require ``IMMEDIATE`` mode.
	UpstreamConnectMode UpstreamConnectMode `protobuf:"varint,21,opt,name=upstream_connect_mode,json=upstreamConnectMode,proto3,enum=envoy.extensions.filters.network.tcp_proxy.v3.UpstreamConnectMode" json:"upstream_connect_mode,omitempty"`
	// Maximum bytes of early data to buffer from the downstream connection before
	// the upstream connection is established.
	//
	// If not set, the TCP proxy will read-disable the downstream connection until the
	// upstream connection is established (legacy behavior).
	//
	// If set, enables “receive_before_connect“ mode where the filter allows the filter
	// chain to read downstream data before the upstream connection exists. The data is
	// buffered and forwarded once the upstream connection is ready. When the buffer exceeds
	// this limit, the downstream connection is read-disabled to prevent excessive memory usage.
	//
	// This field is required when “upstream_connect_mode“ is “ON_DOWNSTREAM_DATA“.
	//
	// .. note::
	//
	//	Use this carefully with server-first protocols. The upstream may send data before
	//	receiving anything from downstream, which could fill the early data buffer.
	MaxEarlyDataBytes *wrapperspb.UInt32Value `protobuf:"bytes,22,opt,name=max_early_data_bytes,json=maxEarlyDataBytes,proto3" json:"max_early_data_bytes,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *TcpProxy) Reset() {
	*x = TcpProxy{}
	mi := &file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TcpProxy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpProxy) ProtoMessage() {}

func (x *TcpProxy) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpProxy.ProtoReflect.Descriptor instead.
func (*TcpProxy) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDescGZIP(), []int{0}
}

func (x *TcpProxy) GetStatPrefix() string {
	if x != nil {
		return x.StatPrefix
	}
	return ""
}

func (x *TcpProxy) GetClusterSpecifier() isTcpProxy_ClusterSpecifier {
	if x != nil {
		return x.ClusterSpecifier
	}
	return nil
}

func (x *TcpProxy) GetCluster() string {
	if x != nil {
		if x, ok := x.ClusterSpecifier.(*TcpProxy_Cluster); ok {
			return x.Cluster
		}
	}
	return ""
}

func (x *TcpProxy) GetWeightedClusters() *TcpProxy_WeightedCluster {
	if x != nil {
		if x, ok := x.ClusterSpecifier.(*TcpProxy_WeightedClusters); ok {
			return x.WeightedClusters
		}
	}
	return nil
}

func (x *TcpProxy) GetOnDemand() *TcpProxy_OnDemand {
	if x != nil {
		return x.OnDemand
	}
	return nil
}

func (x *TcpProxy) GetMetadataMatch() *v3.Metadata {
	if x != nil {
		return x.MetadataMatch
	}
	return nil
}

func (x *TcpProxy) GetIdleTimeout() *durationpb.Duration {
	if x != nil {
		return x.IdleTimeout
	}
	return nil
}

func (x *TcpProxy) GetDownstreamIdleTimeout() *durationpb.Duration {
	if x != nil {
		return x.DownstreamIdleTimeout
	}
	return nil
}

func (x *TcpProxy) GetUpstreamIdleTimeout() *durationpb.Duration {
	if x != nil {
		return x.UpstreamIdleTimeout
	}
	return nil
}

func (x *TcpProxy) GetAccessLog() []*v31.AccessLog {
	if x != nil {
		return x.AccessLog
	}
	return nil
}

func (x *TcpProxy) GetMaxConnectAttempts() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxConnectAttempts
	}
	return nil
}

func (x *TcpProxy) GetBackoffOptions() *v3.BackoffStrategy {
	if x != nil {
		return x.BackoffOptions
	}
	return nil
}

func (x *TcpProxy) GetHashPolicy() []*v32.HashPolicy {
	if x != nil {
		return x.HashPolicy
	}
	return nil
}

func (x *TcpProxy) GetTunnelingConfig() *TcpProxy_TunnelingConfig {
	if x != nil {
		return x.TunnelingConfig
	}
	return nil
}

func (x *TcpProxy) GetMaxDownstreamConnectionDuration() *durationpb.Duration {
	if x != nil {
		return x.MaxDownstreamConnectionDuration
	}
	return nil
}

func (x *TcpProxy) GetMaxDownstreamConnectionDurationJitterPercentage() *v32.Percent {
	if x != nil {
		return x.MaxDownstreamConnectionDurationJitterPercentage
	}
	return nil
}

// Deprecated: Marked as deprecated in envoy/extensions/filters/network/tcp_proxy/v3/tcp_proxy.proto.
func (x *TcpProxy) GetAccessLogFlushInterval() *durationpb.Duration {
	if x != nil {
		return x.AccessLogFlushInterval
	}
	return nil
}

// Deprecated: Marked as deprecated in envoy/extensions/filters/network/tcp_proxy/v3/tcp_proxy.proto.
func (x *TcpProxy) GetFlushAccessLogOnConnected() bool {
	if x != nil {
		return x.FlushAccessLogOnConnected
	}
	return false
}

func (x *TcpProxy) GetAccessLogOptions() *TcpProxy_TcpAccessLogOptions {
	if x != nil {
		return x.AccessLogOptions
	}
	return nil
}

func (x *TcpProxy) GetProxyProtocolTlvs() []*v3.TlvEntry {
	if x != nil {
		return x.ProxyProtocolTlvs
	}
	return nil
}

func (x *TcpProxy) GetUpstreamConnectMode() UpstreamConnectMode {
	if x != nil {
		return x.UpstreamConnectMode
	}
	return UpstreamConnectMode_IMMEDIATE
}

func (x *TcpProxy) GetMaxEarlyDataBytes() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxEarlyDataBytes
	}
	return nil
}

type isTcpProxy_ClusterSpecifier interface {
	isTcpProxy_ClusterSpecifier()
}

type TcpProxy_Cluster struct {
	// The upstream cluster to connect to.
	Cluster string `protobuf:"bytes,2,opt,name=cluster,proto3,oneof"`
}

type TcpProxy_WeightedClusters struct {
	// Multiple upstream clusters can be specified. The request is routed to one of the upstream clusters
	// based on the weights assigned to each cluster.
	WeightedClusters *TcpProxy_WeightedCluster `protobuf:"bytes,10,opt,name=weighted_clusters,json=weightedClusters,proto3,oneof"`
}

func (*TcpProxy_Cluster) isTcpProxy_ClusterSpecifier() {}

func (*TcpProxy_WeightedClusters) isTcpProxy_ClusterSpecifier() {}

// Allows specification of multiple upstream clusters along with weights indicating the percentage of
// traffic forwarded to each cluster. The cluster selection is based on these weights.
type TcpProxy_WeightedCluster struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies the upstream clusters associated with this configuration.
	Clusters      []*TcpProxy_WeightedCluster_ClusterWeight `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TcpProxy_WeightedCluster) Reset() {
	*x = TcpProxy_WeightedCluster{}
	mi := &file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TcpProxy_WeightedCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpProxy_WeightedCluster) ProtoMessage() {}

func (x *TcpProxy_WeightedCluster) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpProxy_WeightedCluster.ProtoReflect.Descriptor instead.
func (*TcpProxy_WeightedCluster) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDescGZIP(), []int{0, 0}
}

func (x *TcpProxy_WeightedCluster) GetClusters() []*TcpProxy_WeightedCluster_ClusterWeight {
	if x != nil {
		return x.Clusters
	}
	return nil
}

// Configuration for tunneling TCP over other transports or application layers.
// Tunneling is supported over HTTP/1.1 and HTTP/2. The upstream protocol is
// determined by the cluster configuration.
// [#next-free-field: 10]
type TcpProxy_TunnelingConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The hostname to send in the synthesized CONNECT headers to the upstream proxy.
	// This field evaluates command operators if present; otherwise, the value is used as-is.
	//
	// For example, dynamically set the hostname using downstream SNI:
	//
	// .. code-block:: yaml
	//
	//	tunneling_config:
	//	  hostname: "%REQUESTED_SERVER_NAME%:443"
	//
	// For example, dynamically set the hostname using dynamic metadata:
	//
	// .. code-block:: yaml
	//
	//	tunneling_config:
	//	  hostname: "%DYNAMIC_METADATA(tunnel:address)%"
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Use the “POST“ method instead of the “CONNECT“ method to tunnel the TCP stream.
	// The “protocol: bytestream“ header is not set for HTTP/2 to comply with the specification.
	//
	// The upstream proxy is expected to interpret the POST payload as raw TCP.
	UsePost bool `protobuf:"varint,2,opt,name=use_post,json=usePost,proto3" json:"use_post,omitempty"`
	// Additional request headers to send to the upstream proxy. This is mainly used to
	// trigger the upstream to convert POST requests back to CONNECT requests.
	//
	// Neither “:“-prefixed pseudo-headers like “:path“ nor the “host“ header can be overridden.
	HeadersToAdd []*v3.HeaderValueOption `protobuf:"bytes,3,rep,name=headers_to_add,json=headersToAdd,proto3" json:"headers_to_add,omitempty"`
	// Save response headers to the downstream connection's filter state for consumption
	// by network filters. The filter state key is “envoy.tcp_proxy.propagate_response_headers“.
	PropagateResponseHeaders bool `protobuf:"varint,4,opt,name=propagate_response_headers,json=propagateResponseHeaders,proto3" json:"propagate_response_headers,omitempty"`
	// The path used with the POST method. The default path is “/“. If this field is specified and
	// :ref:`use_post field <envoy_v3_api_field_extensions.filters.network.tcp_proxy.v3.TcpProxy.TunnelingConfig.use_post>`
	// is not set to true, the configuration will be rejected.
	PostPath string `protobuf:"bytes,5,opt,name=post_path,json=postPath,proto3" json:"post_path,omitempty"`
	// Save response trailers to the downstream connection's filter state for consumption
	// by network filters. The filter state key is “envoy.tcp_proxy.propagate_response_trailers“.
	PropagateResponseTrailers bool `protobuf:"varint,6,opt,name=propagate_response_trailers,json=propagateResponseTrailers,proto3" json:"propagate_response_trailers,omitempty"`
	// The configuration of the request ID extension used for generation, validation, and
	// associated tracing operations when tunneling.
	//
	// If this field is set, a request ID is generated using the specified extension. If
	// this field is not set, no request ID is generated.
	//
	// When a request ID is generated, it is also stored in the downstream connection's
	// dynamic metadata under the namespace “envoy.filters.network.tcp_proxy“ with the key
	// “tunnel_request_id“ to allow emission from TCP proxy access logs via the
	// “%DYNAMIC_METADATA(envoy.filters.network.tcp_proxy:tunnel_request_id)%“ formatter.
	// [#extension-category: envoy.request_id]
	RequestIdExtension *v33.RequestIDExtension `protobuf:"bytes,7,opt,name=request_id_extension,json=requestIdExtension,proto3" json:"request_id_extension,omitempty"`
	// The request header name to use for emitting the generated request ID on the tunneling
	// HTTP request.
	//
	// If not specified or set to an empty string, the default header name “x-request-id“ is
	// used.
	//
	// .. note::
	//
	//	This setting does not alter the internal request ID handling elsewhere in Envoy and
	//	only controls the header emitted on the tunneling request.
	RequestIdHeader string `protobuf:"bytes,8,opt,name=request_id_header,json=requestIdHeader,proto3" json:"request_id_header,omitempty"`
	// The dynamic metadata key to use when storing the generated request ID. The metadata is
	// stored under the namespace “envoy.filters.network.tcp_proxy“.
	//
	// If not specified or set to an empty string, the default key “tunnel_request_id“ is used.
	// This enables customizing the key used by access log formatters such as
	// “%DYNAMIC_METADATA(envoy.filters.network.tcp_proxy:<key>)%“.
	RequestIdMetadataKey string `protobuf:"bytes,9,opt,name=request_id_metadata_key,json=requestIdMetadataKey,proto3" json:"request_id_metadata_key,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *TcpProxy_TunnelingConfig) Reset() {
	*x = TcpProxy_TunnelingConfig{}
	mi := &file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TcpProxy_TunnelingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpProxy_TunnelingConfig) ProtoMessage() {}

func (x *TcpProxy_TunnelingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpProxy_TunnelingConfig.ProtoReflect.Descriptor instead.
func (*TcpProxy_TunnelingConfig) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDescGZIP(), []int{0, 1}
}

func (x *TcpProxy_TunnelingConfig) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *TcpProxy_TunnelingConfig) GetUsePost() bool {
	if x != nil {
		return x.UsePost
	}
	return false
}

func (x *TcpProxy_TunnelingConfig) GetHeadersToAdd() []*v3.HeaderValueOption {
	if x != nil {
		return x.HeadersToAdd
	}
	return nil
}

func (x *TcpProxy_TunnelingConfig) GetPropagateResponseHeaders() bool {
	if x != nil {
		return x.PropagateResponseHeaders
	}
	return false
}

func (x *TcpProxy_TunnelingConfig) GetPostPath() string {
	if x != nil {
		return x.PostPath
	}
	return ""
}

func (x *TcpProxy_TunnelingConfig) GetPropagateResponseTrailers() bool {
	if x != nil {
		return x.PropagateResponseTrailers
	}
	return false
}

func (x *TcpProxy_TunnelingConfig) GetRequestIdExtension() *v33.RequestIDExtension {
	if x != nil {
		return x.RequestIdExtension
	}
	return nil
}

func (x *TcpProxy_TunnelingConfig) GetRequestIdHeader() string {
	if x != nil {
		return x.RequestIdHeader
	}
	return ""
}

func (x *TcpProxy_TunnelingConfig) GetRequestIdMetadataKey() string {
	if x != nil {
		return x.RequestIdMetadataKey
	}
	return ""
}

type TcpProxy_OnDemand struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional configuration for the on-demand cluster discovery service.
	// If not specified, on-demand cluster discovery is disabled. When specified, the filter pauses a request
	// to an unknown cluster and begins a cluster discovery process. When discovery completes (successfully
	// or not), the request is resumed.
	OdcdsConfig *v3.ConfigSource `protobuf:"bytes,1,opt,name=odcds_config,json=odcdsConfig,proto3" json:"odcds_config,omitempty"`
	// xdstp:// resource locator for on-demand cluster collection.
	// [#not-implemented-hide:]
	ResourcesLocator string `protobuf:"bytes,2,opt,name=resources_locator,json=resourcesLocator,proto3" json:"resources_locator,omitempty"`
	// The timeout for on-demand cluster lookup. If the CDS cannot return the required cluster,
	// the downstream request will be closed with the error code detail NO_CLUSTER_FOUND.
	// [#not-implemented-hide:]
	Timeout       *durationpb.Duration `protobuf:"bytes,3,opt,name=timeout,proto3" json:"timeout,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TcpProxy_OnDemand) Reset() {
	*x = TcpProxy_OnDemand{}
	mi := &file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TcpProxy_OnDemand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpProxy_OnDemand) ProtoMessage() {}

func (x *TcpProxy_OnDemand) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpProxy_OnDemand.ProtoReflect.Descriptor instead.
func (*TcpProxy_OnDemand) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDescGZIP(), []int{0, 2}
}

func (x *TcpProxy_OnDemand) GetOdcdsConfig() *v3.ConfigSource {
	if x != nil {
		return x.OdcdsConfig
	}
	return nil
}

func (x *TcpProxy_OnDemand) GetResourcesLocator() string {
	if x != nil {
		return x.ResourcesLocator
	}
	return ""
}

func (x *TcpProxy_OnDemand) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

type TcpProxy_TcpAccessLogOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The interval for flushing access logs. By default, the TCP proxy flushes a single access log when the
	// connection is closed. If this field is set, the TCP proxy flushes access logs periodically at the
	// specified interval.
	// The interval must be at least 1ms.
	AccessLogFlushInterval *durationpb.Duration `protobuf:"bytes,1,opt,name=access_log_flush_interval,json=accessLogFlushInterval,proto3" json:"access_log_flush_interval,omitempty"`
	// If set to true, the access log is flushed when the TCP proxy successfully establishes a
	// connection with the upstream. If the connection fails, the access log is not flushed.
	FlushAccessLogOnConnected bool `protobuf:"varint,2,opt,name=flush_access_log_on_connected,json=flushAccessLogOnConnected,proto3" json:"flush_access_log_on_connected,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *TcpProxy_TcpAccessLogOptions) Reset() {
	*x = TcpProxy_TcpAccessLogOptions{}
	mi := &file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TcpProxy_TcpAccessLogOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpProxy_TcpAccessLogOptions) ProtoMessage() {}

func (x *TcpProxy_TcpAccessLogOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpProxy_TcpAccessLogOptions.ProtoReflect.Descriptor instead.
func (*TcpProxy_TcpAccessLogOptions) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDescGZIP(), []int{0, 3}
}

func (x *TcpProxy_TcpAccessLogOptions) GetAccessLogFlushInterval() *durationpb.Duration {
	if x != nil {
		return x.AccessLogFlushInterval
	}
	return nil
}

func (x *TcpProxy_TcpAccessLogOptions) GetFlushAccessLogOnConnected() bool {
	if x != nil {
		return x.FlushAccessLogOnConnected
	}
	return false
}

type TcpProxy_WeightedCluster_ClusterWeight struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the upstream cluster.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// When a request matches the route, the choice of an upstream cluster is
	// determined by its weight. The sum of weights across all entries in the
	// clusters array determines the total weight.
	Weight uint32 `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
	// Optional endpoint metadata match criteria used by the subset load balancer. Only endpoints
	// in the upstream cluster with metadata matching what is set in this field will be considered
	// for load balancing. Note that this will be merged with what's provided in
	// :ref:`TcpProxy.metadata_match
	// <envoy_v3_api_field_extensions.filters.network.tcp_proxy.v3.TcpProxy.metadata_match>`, with values
	// here taking precedence. The filter name should be specified as “envoy.lb“.
	MetadataMatch *v3.Metadata `protobuf:"bytes,3,opt,name=metadata_match,json=metadataMatch,proto3" json:"metadata_match,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TcpProxy_WeightedCluster_ClusterWeight) Reset() {
	*x = TcpProxy_WeightedCluster_ClusterWeight{}
	mi := &file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TcpProxy_WeightedCluster_ClusterWeight) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpProxy_WeightedCluster_ClusterWeight) ProtoMessage() {}

func (x *TcpProxy_WeightedCluster_ClusterWeight) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpProxy_WeightedCluster_ClusterWeight.ProtoReflect.Descriptor instead.
func (*TcpProxy_WeightedCluster_ClusterWeight) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *TcpProxy_WeightedCluster_ClusterWeight) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TcpProxy_WeightedCluster_ClusterWeight) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *TcpProxy_WeightedCluster_ClusterWeight) GetMetadataMatch() *v3.Metadata {
	if x != nil {
		return x.MetadataMatch
	}
	return nil
}

var File_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto protoreflect.FileDescriptor

const file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDesc = "" +
	"\n" +
	"=envoy/extensions/filters/network/tcp_proxy/v3/tcp_proxy.proto\x12-envoy.extensions.filters.network.tcp_proxy.v3\x1a)envoy/config/accesslog/v3/accesslog.proto\x1a\"envoy/config/core/v3/backoff.proto\x1a\x1fenvoy/config/core/v3/base.proto\x1a(envoy/config/core/v3/config_source.proto\x1a)envoy/config/core/v3/proxy_protocol.proto\x1aYenvoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.proto\x1a\x1fenvoy/type/v3/hash_policy.proto\x1a\x1benvoy/type/v3/percent.proto\x1a\x1egoogle/protobuf/duration.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a#envoy/annotations/deprecation.proto\x1a\x1dudpa/annotations/status.proto\x1a!udpa/annotations/versioning.proto\x1a\x17validate/validate.proto\"\xfb\x1a\n" +
	"\bTcpProxy\x12(\n" +
	"\vstat_prefix\x18\x01 \x01(\tB\a\xfaB\x04r\x02\x10\x01R\n" +
	"statPrefix\x12\x1a\n" +
	"\acluster\x18\x02 \x01(\tH\x00R\acluster\x12v\n" +
	"\x11weighted_clusters\x18\n" +
	" \x01(\v2G.envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.WeightedClusterH\x00R\x10weightedClusters\x12]\n" +
	"\ton_demand\x18\x0e \x01(\v2@.envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.OnDemandR\bonDemand\x12E\n" +
	"\x0emetadata_match\x18\t \x01(\v2\x1e.envoy.config.core.v3.MetadataR\rmetadataMatch\x12<\n" +
	"\fidle_timeout\x18\b \x01(\v2\x19.google.protobuf.DurationR\vidleTimeout\x12Q\n" +
	"\x17downstream_idle_timeout\x18\x03 \x01(\v2\x19.google.protobuf.DurationR\x15downstreamIdleTimeout\x12M\n" +
	"\x15upstream_idle_timeout\x18\x04 \x01(\v2\x19.google.protobuf.DurationR\x13upstreamIdleTimeout\x12C\n" +
	"\n" +
	"access_log\x18\x05 \x03(\v2$.envoy.config.accesslog.v3.AccessLogR\taccessLog\x12W\n" +
	"\x14max_connect_attempts\x18\a \x01(\v2\x1c.google.protobuf.UInt32ValueB\a\xfaB\x04*\x02(\x01R\x12maxConnectAttempts\x12N\n" +
	"\x0fbackoff_options\x18\x12 \x01(\v2%.envoy.config.core.v3.BackoffStrategyR\x0ebackoffOptions\x12D\n" +
	"\vhash_policy\x18\v \x03(\v2\x19.envoy.type.v3.HashPolicyB\b\xfaB\x05\x92\x01\x02\x10\x01R\n" +
	"hashPolicy\x12r\n" +
	"\x10tunneling_config\x18\f \x01(\v2G.envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.TunnelingConfigR\x0ftunnelingConfig\x12t\n" +
	"\"max_downstream_connection_duration\x18\r \x01(\v2\x19.google.protobuf.DurationB\f\xfaB\t\xaa\x01\x062\x04\x10\xc0\x84=R\x1fmaxDownstreamConnectionDuration\x12\x85\x01\n" +
	"4max_downstream_connection_duration_jitter_percentage\x18\x14 \x01(\v2\x16.envoy.type.v3.PercentR/maxDownstreamConnectionDurationJitterPercentage\x12m\n" +
	"\x19access_log_flush_interval\x18\x0f \x01(\v2\x19.google.protobuf.DurationB\x17\xfaB\t\xaa\x01\x062\x04\x10\xc0\x84=\x92ǆ\xd8\x04\x033.0\x18\x01R\x16accessLogFlushInterval\x12M\n" +
	"\x1dflush_access_log_on_connected\x18\x10 \x01(\bB\v\x92ǆ\xd8\x04\x033.0\x18\x01R\x19flushAccessLogOnConnected\x12y\n" +
	"\x12access_log_options\x18\x11 \x01(\v2K.envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.TcpAccessLogOptionsR\x10accessLogOptions\x12N\n" +
	"\x13proxy_protocol_tlvs\x18\x13 \x03(\v2\x1e.envoy.config.core.v3.TlvEntryR\x11proxyProtocolTlvs\x12\x80\x01\n" +
	"\x15upstream_connect_mode\x18\x15 \x01(\x0e2B.envoy.extensions.filters.network.tcp_proxy.v3.UpstreamConnectModeB\b\xfaB\x05\x82\x01\x02\x10\x01R\x13upstreamConnectMode\x12X\n" +
	"\x14max_early_data_bytes\x18\x16 \x01(\v2\x1c.google.protobuf.UInt32ValueB\t\xfaB\x06*\x04\x18\x80\x80@R\x11maxEarlyDataBytes\x1a\xc7\x03\n" +
	"\x0fWeightedCluster\x12{\n" +
	"\bclusters\x18\x01 \x03(\v2U.envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.WeightedCluster.ClusterWeightB\b\xfaB\x05\x92\x01\x02\b\x01R\bclusters\x1a\xec\x01\n" +
	"\rClusterWeight\x12\x1b\n" +
	"\x04name\x18\x01 \x01(\tB\a\xfaB\x04r\x02\x10\x01R\x04name\x12\x1f\n" +
	"\x06weight\x18\x02 \x01(\rB\a\xfaB\x04*\x02(\x01R\x06weight\x12E\n" +
	"\x0emetadata_match\x18\x03 \x01(\v2\x1e.envoy.config.core.v3.MetadataR\rmetadataMatch:V\x9aň\x1eQ\n" +
	"Oenvoy.config.filter.network.tcp_proxy.v2.TcpProxy.WeightedCluster.ClusterWeight:H\x9aň\x1eC\n" +
	"Aenvoy.config.filter.network.tcp_proxy.v2.TcpProxy.WeightedCluster\x1a\xf7\x04\n" +
	"\x0fTunnelingConfig\x12#\n" +
	"\bhostname\x18\x01 \x01(\tB\a\xfaB\x04r\x02\x10\x01R\bhostname\x12\x19\n" +
	"\buse_post\x18\x02 \x01(\bR\ausePost\x12X\n" +
	"\x0eheaders_to_add\x18\x03 \x03(\v2'.envoy.config.core.v3.HeaderValueOptionB\t\xfaB\x06\x92\x01\x03\x10\xe8\aR\fheadersToAdd\x12<\n" +
	"\x1apropagate_response_headers\x18\x04 \x01(\bR\x18propagateResponseHeaders\x12\x1b\n" +
	"\tpost_path\x18\x05 \x01(\tR\bpostPath\x12>\n" +
	"\x1bpropagate_response_trailers\x18\x06 \x01(\bR\x19propagateResponseTrailers\x12\x81\x01\n" +
	"\x14request_id_extension\x18\a \x01(\v2O.envoy.extensions.filters.network.http_connection_manager.v3.RequestIDExtensionR\x12requestIdExtension\x12*\n" +
	"\x11request_id_header\x18\b \x01(\tR\x0frequestIdHeader\x125\n" +
	"\x17request_id_metadata_key\x18\t \x01(\tR\x14requestIdMetadataKey:H\x9aň\x1eC\n" +
	"Aenvoy.config.filter.network.tcp_proxy.v2.TcpProxy.TunnelingConfig\x1a\xb3\x01\n" +
	"\bOnDemand\x12E\n" +
	"\fodcds_config\x18\x01 \x01(\v2\".envoy.config.core.v3.ConfigSourceR\vodcdsConfig\x12+\n" +
	"\x11resources_locator\x18\x02 \x01(\tR\x10resourcesLocator\x123\n" +
	"\atimeout\x18\x03 \x01(\v2\x19.google.protobuf.DurationR\atimeout\x1a\xbb\x01\n" +
	"\x13TcpAccessLogOptions\x12b\n" +
	"\x19access_log_flush_interval\x18\x01 \x01(\v2\x19.google.protobuf.DurationB\f\xfaB\t\xaa\x01\x062\x04\x10\xc0\x84=R\x16accessLogFlushInterval\x12@\n" +
	"\x1dflush_access_log_on_connected\x18\x02 \x01(\bR\x19flushAccessLogOnConnected:8\x9aň\x1e3\n" +
	"1envoy.config.filter.network.tcp_proxy.v2.TcpProxyB\x18\n" +
	"\x11cluster_specifier\x12\x03\xf8B\x01J\x04\b\x06\x10\aR\rdeprecated_v1*]\n" +
	"\x13UpstreamConnectMode\x12\r\n" +
	"\tIMMEDIATE\x10\x00\x12\x16\n" +
	"\x12ON_DOWNSTREAM_DATA\x10\x01\x12\x1f\n" +
	"\x1bON_DOWNSTREAM_TLS_HANDSHAKE\x10\x02B\xb8\x01\xba\x80\xc8\xd1\x06\x02\x10\x02\n" +
	";io.envoyproxy.envoy.extensions.filters.network.tcp_proxy.v3B\rTcpProxyProtoP\x01Z`github.com/envoyproxy/go-control-plane/envoy/extensions/filters/network/tcp_proxy/v3;tcp_proxyv3b\x06proto3"

var (
	file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDescOnce sync.Once
	file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDescData []byte
)

func file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDescGZIP() []byte {
	file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDescOnce.Do(func() {
		file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDesc), len(file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDesc)))
	})
	return file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDescData
}

var file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_goTypes = []any{
	(UpstreamConnectMode)(0),                       // 0: envoy.extensions.filters.network.tcp_proxy.v3.UpstreamConnectMode
	(*TcpProxy)(nil),                               // 1: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy
	(*TcpProxy_WeightedCluster)(nil),               // 2: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.WeightedCluster
	(*TcpProxy_TunnelingConfig)(nil),               // 3: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.TunnelingConfig
	(*TcpProxy_OnDemand)(nil),                      // 4: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.OnDemand
	(*TcpProxy_TcpAccessLogOptions)(nil),           // 5: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.TcpAccessLogOptions
	(*TcpProxy_WeightedCluster_ClusterWeight)(nil), // 6: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.WeightedCluster.ClusterWeight
	(*v3.Metadata)(nil),                            // 7: envoy.config.core.v3.Metadata
	(*durationpb.Duration)(nil),                    // 8: google.protobuf.Duration
	(*v31.AccessLog)(nil),                          // 9: envoy.config.accesslog.v3.AccessLog
	(*wrapperspb.UInt32Value)(nil),                 // 10: google.protobuf.UInt32Value
	(*v3.BackoffStrategy)(nil),                     // 11: envoy.config.core.v3.BackoffStrategy
	(*v32.HashPolicy)(nil),                         // 12: envoy.type.v3.HashPolicy
	(*v32.Percent)(nil),                            // 13: envoy.type.v3.Percent
	(*v3.TlvEntry)(nil),                            // 14: envoy.config.core.v3.TlvEntry
	(*v3.HeaderValueOption)(nil),                   // 15: envoy.config.core.v3.HeaderValueOption
	(*v33.RequestIDExtension)(nil),                 // 16: envoy.extensions.filters.network.http_connection_manager.v3.RequestIDExtension
	(*v3.ConfigSource)(nil),                        // 17: envoy.config.core.v3.ConfigSource
}
var file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_depIdxs = []int32{
	2,  // 0: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.weighted_clusters:type_name -> envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.WeightedCluster
	4,  // 1: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.on_demand:type_name -> envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.OnDemand
	7,  // 2: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.metadata_match:type_name -> envoy.config.core.v3.Metadata
	8,  // 3: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.idle_timeout:type_name -> google.protobuf.Duration
	8,  // 4: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.downstream_idle_timeout:type_name -> google.protobuf.Duration
	8,  // 5: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.upstream_idle_timeout:type_name -> google.protobuf.Duration
	9,  // 6: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.access_log:type_name -> envoy.config.accesslog.v3.AccessLog
	10, // 7: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.max_connect_attempts:type_name -> google.protobuf.UInt32Value
	11, // 8: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.backoff_options:type_name -> envoy.config.core.v3.BackoffStrategy
	12, // 9: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.hash_policy:type_name -> envoy.type.v3.HashPolicy
	3,  // 10: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.tunneling_config:type_name -> envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.TunnelingConfig
	8,  // 11: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.max_downstream_connection_duration:type_name -> google.protobuf.Duration
	13, // 12: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.max_downstream_connection_duration_jitter_percentage:type_name -> envoy.type.v3.Percent
	8,  // 13: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.access_log_flush_interval:type_name -> google.protobuf.Duration
	5,  // 14: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.access_log_options:type_name -> envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.TcpAccessLogOptions
	14, // 15: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.proxy_protocol_tlvs:type_name -> envoy.config.core.v3.TlvEntry
	0,  // 16: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.upstream_connect_mode:type_name -> envoy.extensions.filters.network.tcp_proxy.v3.UpstreamConnectMode
	10, // 17: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.max_early_data_bytes:type_name -> google.protobuf.UInt32Value
	6,  // 18: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.WeightedCluster.clusters:type_name -> envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.WeightedCluster.ClusterWeight
	15, // 19: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.TunnelingConfig.headers_to_add:type_name -> envoy.config.core.v3.HeaderValueOption
	16, // 20: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.TunnelingConfig.request_id_extension:type_name -> envoy.extensions.filters.network.http_connection_manager.v3.RequestIDExtension
	17, // 21: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.OnDemand.odcds_config:type_name -> envoy.config.core.v3.ConfigSource
	8,  // 22: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.OnDemand.timeout:type_name -> google.protobuf.Duration
	8,  // 23: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.TcpAccessLogOptions.access_log_flush_interval:type_name -> google.protobuf.Duration
	7,  // 24: envoy.extensions.filters.network.tcp_proxy.v3.TcpProxy.WeightedCluster.ClusterWeight.metadata_match:type_name -> envoy.config.core.v3.Metadata
	25, // [25:25] is the sub-list for method output_type
	25, // [25:25] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_init() }
func file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_init() {
	if File_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto != nil {
		return
	}
	file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes[0].OneofWrappers = []any{
		(*TcpProxy_Cluster)(nil),
		(*TcpProxy_WeightedClusters)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDesc), len(file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_goTypes,
		DependencyIndexes: file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_depIdxs,
		EnumInfos:         file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_enumTypes,
		MessageInfos:      file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_msgTypes,
	}.Build()
	File_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto = out.File
	file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_goTypes = nil
	file_envoy_extensions_filters_network_tcp_proxy_v3_tcp_proxy_proto_depIdxs = nil
}
