/*****************************************************************************\
  dj600ColorMaps.cpp : Color maps for the DJ600

  Copyright (c) 1996 - 2015, HP Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of HP nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\*****************************************************************************/


#include "CommonDefinitions.h"

uint32_t ulMapDJ600_CCM_K[ 9 * 9 * 9 ]=
// DJ600_CCM_K
    {
        226UL, 137UL, 135UL, 132UL, 128UL, 122UL, 111UL, 98UL, 90UL,
        133UL, 133UL, 132UL, 130UL, 125UL, 118UL, 107UL, 96UL, 88UL,
        120UL, 120UL, 118UL, 114UL, 109UL, 101UL, 95UL, 88UL, 80UL,
        92UL, 92UL, 91UL, 89UL, 87UL, 83UL, 79UL, 73UL, 69UL,
        69UL, 69UL, 69UL, 68UL, 67UL, 66UL, 63UL, 61UL, 59UL,
        55UL, 55UL, 55UL, 55UL, 54UL, 53UL, 51UL, 49UL, 47UL,
        41UL, 41UL, 40UL, 40UL, 39UL, 38UL, 37UL, 35UL, 33UL,
        25UL, 25UL, 25UL, 25UL, 24UL, 23UL, 22UL, 21UL, 19UL,
        11UL, 11UL, 11UL, 11UL, 11UL, 10UL, 10UL, 10UL, 9UL,
        136UL, 136UL, 134UL, 132UL, 127UL, 121UL, 110UL, 98UL, 90UL,
        132UL, 132UL, 132UL, 129UL, 124UL, 116UL, 106UL, 95UL, 88UL,
        119UL, 118UL, 116UL, 113UL, 107UL, 100UL, 94UL, 88UL, 80UL,
        92UL, 91UL, 90UL, 89UL, 87UL, 83UL, 78UL, 73UL, 68UL,
        69UL, 69UL, 69UL, 68UL, 67UL, 66UL, 63UL, 61UL, 58UL,
        55UL, 55UL, 55UL, 54UL, 54UL, 53UL, 51UL, 49UL, 47UL,
        40UL, 40UL, 40UL, 40UL, 39UL, 38UL, 36UL, 35UL, 33UL,
        25UL, 25UL, 25UL, 24UL, 23UL, 23UL, 22UL, 21UL, 19UL,
        11UL, 11UL, 11UL, 11UL, 10UL, 10UL, 10UL, 10UL, 9UL,
        132UL, 132UL, 131UL, 128UL, 124UL, 115UL, 105UL, 95UL, 88UL,
        129UL, 129UL, 127UL, 124UL, 120UL, 112UL, 101UL, 94UL, 86UL,
        114UL, 113UL, 112UL, 108UL, 103UL, 96UL, 92UL, 86UL, 78UL,
        89UL, 89UL, 88UL, 87UL, 84UL, 80UL, 76UL, 72UL, 67UL,
        68UL, 68UL, 68UL, 67UL, 66UL, 64UL, 62UL, 60UL, 58UL,
        55UL, 55UL, 54UL, 54UL, 53UL, 52UL, 50UL, 48UL, 46UL,
        40UL, 40UL, 40UL, 39UL, 39UL, 37UL, 36UL, 34UL, 33UL,
        25UL, 25UL, 24UL, 23UL, 23UL, 22UL, 21UL, 20UL, 19UL,
        11UL, 11UL, 11UL, 11UL, 10UL, 10UL, 10UL, 10UL, 9UL,
        124UL, 124UL, 123UL, 119UL, 113UL, 105UL, 97UL, 90UL, 83UL,
        121UL, 120UL, 118UL, 114UL, 109UL, 102UL, 95UL, 88UL, 81UL,
        104UL, 103UL, 102UL, 98UL, 95UL, 92UL, 87UL, 80UL, 74UL,
        84UL, 84UL, 83UL, 82UL, 80UL, 76UL, 73UL, 69UL, 66UL,
        66UL, 66UL, 66UL, 65UL, 64UL, 62UL, 61UL, 59UL, 56UL,
        53UL, 53UL, 53UL, 52UL, 52UL, 50UL, 49UL, 47UL, 45UL,
        39UL, 39UL, 38UL, 37UL, 37UL, 36UL, 35UL, 33UL, 31UL,
        23UL, 23UL, 23UL, 23UL, 22UL, 21UL, 20UL, 19UL, 18UL,
        10UL, 10UL, 10UL, 10UL, 10UL, 10UL, 10UL, 9UL, 9UL,
        108UL, 107UL, 105UL, 103UL, 98UL, 94UL, 88UL, 83UL, 76UL,
        104UL, 104UL, 102UL, 99UL, 95UL, 92UL, 87UL, 81UL, 74UL,
        93UL, 93UL, 92UL, 90UL, 88UL, 84UL, 80UL, 74UL, 69UL,
        77UL, 77UL, 76UL, 75UL, 73UL, 71UL, 68UL, 66UL, 62UL,
        63UL, 63UL, 62UL, 62UL, 61UL, 60UL, 58UL, 56UL, 54UL,
        51UL, 50UL, 50UL, 50UL, 49UL, 48UL, 47UL, 45UL, 43UL,
        36UL, 36UL, 36UL, 36UL, 35UL, 34UL, 33UL, 31UL, 29UL,
        22UL, 22UL, 21UL, 21UL, 21UL, 20UL, 19UL, 18UL, 16UL,
        10UL, 10UL, 10UL, 10UL, 10UL, 10UL, 9UL, 9UL, 9UL,
        92UL, 92UL, 91UL, 89UL, 87UL, 83UL, 79UL, 73UL, 69UL,
        90UL, 89UL, 89UL, 88UL, 85UL, 81UL, 77UL, 72UL, 68UL,
        82UL, 82UL, 81UL, 80UL, 77UL, 74UL, 71UL, 68UL, 64UL,
        69UL, 69UL, 69UL, 68UL, 67UL, 66UL, 63UL, 61UL, 59UL,
        59UL, 59UL, 59UL, 58UL, 57UL, 56UL, 54UL, 53UL, 50UL,
        48UL, 48UL, 47UL, 47UL, 46UL, 45UL, 43UL, 41UL, 39UL,
        34UL, 34UL, 33UL, 33UL, 32UL, 31UL, 30UL, 28UL, 27UL,
        20UL, 20UL, 19UL, 19UL, 19UL, 18UL, 17UL, 16UL, 14UL,
        10UL, 9UL, 9UL, 9UL, 9UL, 9UL, 9UL, 9UL, 8UL,
        78UL, 78UL, 77UL, 75UL, 73UL, 71UL, 68UL, 66UL, 62UL,
        76UL, 76UL, 75UL, 74UL, 73UL, 70UL, 68UL, 65UL, 62UL,
        70UL, 70UL, 70UL, 69UL, 68UL, 66UL, 64UL, 62UL, 59UL,
        63UL, 63UL, 63UL, 62UL, 61UL, 60UL, 58UL, 56UL, 54UL,
        54UL, 54UL, 54UL, 53UL, 53UL, 52UL, 50UL, 48UL, 46UL,
        43UL, 43UL, 43UL, 42UL, 41UL, 40UL, 39UL, 37UL, 35UL,
        30UL, 30UL, 30UL, 29UL, 29UL, 28UL, 27UL, 25UL, 23UL,
        17UL, 17UL, 16UL, 16UL, 16UL, 15UL, 14UL, 13UL, 11UL,
        9UL, 9UL, 9UL, 9UL, 9UL, 8UL, 8UL, 7UL, 7UL,
        66UL, 66UL, 66UL, 65UL, 64UL, 63UL, 61UL, 59UL, 56UL,
        66UL, 66UL, 65UL, 64UL, 63UL, 62UL, 60UL, 58UL, 55UL,
        62UL, 62UL, 62UL, 61UL, 60UL, 59UL, 58UL, 55UL, 53UL,
        56UL, 56UL, 56UL, 56UL, 55UL, 54UL, 52UL, 50UL, 48UL,
        49UL, 49UL, 48UL, 48UL, 47UL, 46UL, 44UL, 43UL, 40UL,
        37UL, 37UL, 37UL, 37UL, 36UL, 35UL, 34UL, 33UL, 30UL,
        26UL, 26UL, 25UL, 25UL, 25UL, 23UL, 22UL, 21UL, 20UL,
        13UL, 13UL, 13UL, 12UL, 12UL, 11UL, 11UL, 11UL, 10UL,
        7UL, 7UL, 7UL, 7UL, 7UL, 7UL, 7UL, 7UL, 6UL,
        58UL, 58UL, 58UL, 57UL, 56UL, 55UL, 53UL, 52UL, 49UL,
        58UL, 57UL, 57UL, 56UL, 55UL, 54UL, 53UL, 51UL, 49UL,
        55UL, 55UL, 54UL, 54UL, 53UL, 52UL, 50UL, 49UL, 46UL,
        50UL, 50UL, 49UL, 49UL, 48UL, 47UL, 45UL, 44UL, 41UL,
        42UL, 42UL, 41UL, 41UL, 40UL, 39UL, 38UL, 36UL, 34UL,
        32UL, 32UL, 31UL, 31UL, 30UL, 30UL, 28UL, 27UL, 25UL,
        21UL, 21UL, 21UL, 20UL, 20UL, 19UL, 18UL, 17UL, 15UL,
        10UL, 10UL, 10UL, 10UL, 10UL, 10UL, 10UL, 9UL, 9UL,
        6UL, 6UL, 6UL, 6UL, 6UL, 6UL, 6UL, 6UL, 0
    };
uint32_t ulMapDJ600_CCM_CMY[ 9 * 9 * 9 ]=
    // DJ600_CCM_CMY
    {
        3789676800UL, 2159472384UL, 1369304832UL, 831057920UL, 443871744UL, 191099648UL, 39120640UL, 4910336UL, 4585216UL,
        3699167488UL, 2137910016UL, 1332802048UL, 761852160UL, 408810240UL, 156103424UL, 21295104UL, 4253440UL, 3929600UL,
        3494949376UL, 2403977216UL, 1313134080UL, 725868032UL, 373351936UL, 138080256UL, 20313344UL, 3468032UL, 3339008UL,
        3308362240UL, 2486086656UL, 1479195392UL, 723895552UL, 371774208UL, 170517248UL, 36236288UL, 2746112UL, 2747904UL,
        3206385408UL, 2417728256UL, 1645915136UL, 957921280UL, 471253760UL, 219795200UL, 52158464UL, 2024704UL, 2222592UL,
        3138358784UL, 2416875520UL, 1745725184UL, 1124971008UL, 655080192UL, 286049024UL, 101634816UL, 1237504UL, 1632256UL,
        3087372544UL, 2432997888UL, 1812244736UL, 1241755904UL, 805550592UL, 436453120UL, 151243264UL, 17291520UL, 1106432UL,
        2952827392UL, 2348848384UL, 1811980544UL, 1291888128UL, 939569152UL, 587248896UL, 302038016UL, 67225856UL, 579584UL,
        2835387136UL, 2332071936UL, 1828756992UL, 1358995968UL, 1023452928UL, 738242304UL, 469808896UL, 218153216UL, 53248UL,
        4092890368UL, 3118959616UL, 1893638400UL, 1104588544UL, 499235328UL, 178898688UL, 26462464UL, 8503296UL, 7259136UL,
        4001661696UL, 2155905024UL, 1670552320UL, 1066312192UL, 612410368UL, 292463872UL, 90351360UL, 5743360UL, 5354752UL,
        3612442112UL, 2472181504UL, 1616546048UL, 1029477120UL, 626563072UL, 323984640UL, 105292544UL, 4301568UL, 4239616UL,
        3459346944UL, 2520282624UL, 1731755264UL, 1010271744UL, 607751680UL, 339384064UL, 137797632UL, 3449856UL, 3453440UL,
        3273419264UL, 2468507392UL, 1814263808UL, 1176796672UL, 656704256UL, 371756288UL, 170432768UL, 19374592UL, 2798336UL,
        3272567808UL, 2467524352UL, 1846834688UL, 1293253120UL, 806780672UL, 404193536UL, 186224128UL, 52140800UL, 2011904UL,
        3271913216UL, 2449960704UL, 1862759424UL, 1376352768UL, 940211968UL, 537690624UL, 218924032UL, 51418112UL, 1355264UL,
        3170923264UL, 2365616128UL, 1845523200UL, 1409317632UL, 1023508736UL, 671319296UL, 352552448UL, 84249600UL, 698112UL,
        3036707328UL, 2365617408UL, 1879078912UL, 1476427264UL, 1124107264UL, 822119680UL, 520131072UL, 251696384UL, 40448UL,
        3991889152UL, 3304284928UL, 2280153856UL, 1407741184UL, 736064768UL, 231570688UL, 12618240UL, 11374080UL, 9539072UL,
        3952630272UL, 2627495168UL, 1905878784UL, 1285254656UL, 747859968UL, 344354560UL, 108754176UL, 7437056UL, 7112704UL,
        3679670272UL, 2472499712UL, 1616928768UL, 1164404992UL, 727936000UL, 391998720UL, 139817728UL, 5208064UL, 5276416UL,
        3660795136UL, 2570737408UL, 1832803072UL, 1144872960UL, 725575424UL, 423652352UL, 171864576UL, 3962880UL, 4096768UL,
        3558689024UL, 2586072320UL, 1931958528UL, 1327979264UL, 791175424UL, 439052288UL, 187461376UL, 19691008UL, 3310336UL,
        3507505920UL, 2601801216UL, 1964333568UL, 1444371456UL, 924344320UL, 505045504UL, 236742912UL, 52392448UL, 2457856UL,
        3523629056UL, 2617857536UL, 1963481600UL, 1477074176UL, 1040933120UL, 621634304UL, 286156288UL, 85093888UL, 1605376UL,
        3439351040UL, 2566936832UL, 1895848192UL, 1476418560UL, 1107321088UL, 738288896UL, 385967616UL, 134572544UL, 752640UL,
        3254804480UL, 2483052288UL, 1929403904UL, 1560305664UL, 1224762624UL, 905996544UL, 570452992UL, 285241088UL, 30720UL,
        3924050432UL, 3203088384UL, 2229485568UL, 1305885696UL, 701841920UL, 265570304UL, 30233088UL, 12475392UL, 11428608UL,
        3969464832UL, 2745255168UL, 2057455872UL, 1335576576UL, 815483648UL, 412503040UL, 126767616UL, 8673536UL, 8479488UL,
        3848025344UL, 2657632256UL, 1852655616UL, 1248676352UL, 812535296UL, 443109120UL, 157504000UL, 6182912UL, 6185472UL,
        3711053824UL, 2537175296UL, 1849769984UL, 1145324544UL, 793266688UL, 474435328UL, 189092608UL, 4479232UL, 4612864UL,
        3659280384UL, 2602842624UL, 1982414848UL, 1395343872UL, 841762304UL, 506350336UL, 221270016UL, 19945472UL, 3564288UL,
        3675271936UL, 2652191744UL, 2065121792UL, 1494762496UL, 1008289280UL, 572213248UL, 270421248UL, 69293568UL, 2647040UL,
        3708237312UL, 2752134912UL, 2081047552UL, 1544176896UL, 1108035584UL, 688670976UL, 353258240UL, 101864192UL, 1664000UL,
        3724622848UL, 2751546112UL, 2063615744UL, 1543522048UL, 1157646336UL, 805390848UL, 436292608UL, 168054784UL, 680960UL,
        3422569728UL, 2617264384UL, 2030062336UL, 1610632192UL, 1258310656UL, 956321536UL, 637554688UL, 335565568UL, 23552UL,
        3956942848UL, 3118802688UL, 2145593088UL, 1322853632UL, 718414848UL, 299182336UL, 30683136UL, 12990976UL, 12402944UL,
        4019397376UL, 2795384064UL, 2074488832UL, 1419718656UL, 848965632UL, 463221504UL, 161035776UL, 9321472UL, 9323776UL,
        3999211264UL, 2792106496UL, 1987326208UL, 1366504192UL, 846279936UL, 477312768UL, 175061504UL, 6897152UL, 6965248UL,
        3895991296UL, 2722244352UL, 2018192896UL, 1330459136UL, 843985920UL, 508573952UL, 223230976UL, 4931584UL, 5130240UL,
        3659275008UL, 2636522752UL, 2032937728UL, 1395601152UL, 808464384UL, 540292608UL, 271923712UL, 20332544UL, 3819520UL,
        3658555136UL, 2736203520UL, 2132422144UL, 1545286144UL, 1025258496UL, 605893888UL, 304101632UL, 69353472UL, 2705664UL,
        3775406848UL, 2869701376UL, 2181902592UL, 1628255232UL, 1141716480UL, 739128832UL, 370096128UL, 101858816UL, 1722880UL,
        3858835456UL, 2936221696UL, 2181116672UL, 1644246784UL, 1191261952UL, 838940672UL, 486684928UL, 184826880UL, 674304UL,
        3623890688UL, 2818585856UL, 2147498496UL, 1660960000UL, 1275083776UL, 973093888UL, 671104512UL, 369115136UL, 17920UL,
        3956413952UL, 3034584320UL, 2078414080UL, 1339954432UL, 785847296UL, 349508352UL, 47585280UL, 13443584UL, 12986624UL,
        4002288640UL, 2845382912UL, 2090998784UL, 1486888192UL, 949820672UL, 479927552UL, 161226752UL, 9774336UL, 9776896UL,
        4015853824UL, 2960005632UL, 2071272704UL, 1467424512UL, 947265792UL, 494215680UL, 192291840UL, 7415552UL, 7549696UL,
        3996848128UL, 2907248896UL, 2152799488UL, 1448354304UL, 945169408UL, 542516736UL, 240592896UL, 22358784UL, 5649408UL,
        3810660352UL, 2838370048UL, 2201230336UL, 1513562112UL, 943203328UL, 557458944UL, 289220608UL, 37563392UL, 4142080UL,
        3759280384UL, 2769819392UL, 2166103040UL, 1545412096UL, 1008673280UL, 572662272UL, 321201664UL, 86387456UL, 2896896UL,
        3808957696UL, 2920094208UL, 2265915136UL, 1678713344UL, 1141842944UL, 739255296UL, 386999552UL, 135538944UL, 1782784UL,
        3942717440UL, 3036945920UL, 2315592192UL, 1728325120UL, 1208100352UL, 855778816UL, 520365824UL, 218442240UL, 668672UL,
        3841990400UL, 3003130880UL, 2281711616UL, 1728064512UL, 1308634624UL, 989867520UL, 671100160UL, 385887744UL, 13056UL,
        3939174656UL, 3034580992UL, 2095319040UL, 1407518720UL, 870254592UL, 416941824UL, 81200640UL, 13570304UL, 13441536UL,
        4001957888UL, 2861960448UL, 2107576064UL, 1537412864UL, 1017253632UL, 580914944UL, 194842368UL, 10163456UL, 10231296UL,
        4015720448UL, 3010268672UL, 2104823808UL, 1517949184UL, 1048187136UL, 595137024UL, 225972992UL, 7739136UL, 7872768UL,
        4013754112UL, 3075149312UL, 2253721600UL, 1549406976UL, 1046156288UL, 609948928UL, 257693184UL, 22812928UL, 6169088UL,
        3978758144UL, 3073576192UL, 2335838208UL, 1597903616UL, 1044256256UL, 608179968UL, 289478656UL, 37951744UL, 4596480UL,
        3944089600UL, 3038579968UL, 2334396416UL, 1663439360UL, 1076302848UL, 640161536UL, 321525760UL, 86776576UL, 3219968UL,
        3909683200UL, 3020819712UL, 2349994240UL, 1712526080UL, 1158878208UL, 722736384UL, 370546176UL, 135862784UL, 1974784UL,
        3993046272UL, 3104117248UL, 2433160192UL, 1795560960UL, 1275468032UL, 872814848UL, 520558848UL, 218634752UL, 794624UL,
        3959427840UL, 3154122240UL, 2415925248UL, 1828723712UL, 1342185216UL, 1006641152UL, 687873792UL, 385883904UL, 8704UL,
        3972661760UL, 3084779520UL, 2196045824UL, 1524957184UL, 1021444096UL, 601882624UL, 249364480UL, 47579904UL, 13831168UL,
        4018667520UL, 2945909760UL, 2208498944UL, 1655244032UL, 1152058624UL, 732693760UL, 329778432UL, 44303872UL, 10686208UL,
        4032561152UL, 3094086656UL, 2239169792UL, 1669334272UL, 1182991872UL, 746718720UL, 360711936UL, 41814272UL, 8065536UL,
        4030726144UL, 3226338304UL, 2388198912UL, 1667172096UL, 1164117760UL, 744818688UL, 375719936UL, 40110592UL, 6492928UL,
        4029350144UL, 3275162880UL, 2453603840UL, 1749288704UL, 1145374976UL, 726075904UL, 357042688UL, 55118592UL, 4985856UL,
        4011524352UL, 3273852160UL, 2519270912UL, 1798047744UL, 1194264576UL, 724503040UL, 372312576UL, 87166208UL, 3609600UL,
        4010672384UL, 3272869120UL, 2568488960UL, 1880754176UL, 1260062976UL, 807078400UL, 421202688UL, 119409920UL, 2298624UL,
        4026729216UL, 3255240192UL, 2550728704UL, 1913260288UL, 1326057984UL, 889784832UL, 503974400UL, 185273088UL, 1052928UL,
        4009756928UL, 3288336896UL, 2583694080UL, 1962937600UL, 1459621632UL, 1056968960UL, 704647680UL, 369103104UL, 4608UL,
        4040097792UL, 3236167680UL, 2465136640UL, 1827536896UL, 1307246592UL, 904396800UL, 551878656UL, 266403840UL, 14221312UL,
        4035969024UL, 3366453248UL, 2579103744UL, 1891631104UL, 1354956800UL, 952172544UL, 566034432UL, 263651328UL, 11141120UL,
        4033019904UL, 3396730880UL, 2592473088UL, 1905328128UL, 1402404864UL, 999751680UL, 580255744UL, 261160960UL, 8716288UL,
        4031184896UL, 3461611520UL, 2657222656UL, 1936457728UL, 1383071744UL, 980615168UL, 561250304UL, 225574912UL, 6946816UL,
        4029874176UL, 3527147520UL, 2739273728UL, 2051932160UL, 1397751808UL, 945029120UL, 542441472UL, 206897152UL, 5505024UL,
        4028891136UL, 3609788416UL, 2855272448UL, 2151022592UL, 1429864448UL, 943390720UL, 524025856UL, 188547072UL, 4063232UL,
        4028039168UL, 3743023104UL, 3055484928UL, 2283929600UL, 1545863168UL, 1009057792UL, 539230208UL, 203751424UL, 2752512UL,
        4027252736UL, 3792502784UL, 3155099648UL, 2400190464UL, 1729232896UL, 1142030336UL, 655491072UL, 252837888UL, 1376256UL,
        4026531840UL, 3573547008UL, 2952790016UL, 2281701376UL, 1694498816UL, 1191182336UL, 754974720UL, 369098752UL, 0
    };

uint32_t ulMapDJ660_CCM_KCMY[ 9 * 9 * 9 ]=
    {
        422720226UL, 142187374UL, 94354238UL, 62442785UL, 45668877UL, 27648516UL, 8972032UL, 7335680UL, 5895424UL,
2519110233UL, 807846483UL, 391693109UL, 260029471UL, 143570703UL, 42776580UL, 8501760UL, 7782400UL, 6539520UL,
3072173868UL, 1881129514UL, 841465387UL, 524792087UL, 358391818UL, 174364420UL, 40408577UL, 6920704UL, 6530560UL,
3407591425UL, 2551891200UL, 1612695808UL, 824489479UL, 506699268UL, 306153730UL, 105283329UL, 5144320UL, 5737216UL,
3289364224UL, 2584592128UL, 1829749504UL, 1142143232UL, 639280640UL, 405048832UL, 204241920UL, 53835264UL, 4290816UL,
2970005760UL, 2449717248UL, 1862580992UL, 1325905408UL, 856467712UL, 487757568UL, 270041856UL, 119436800UL, 2650624UL,
2583865856UL, 2214636288UL, 1811983360UL, 1392618240UL, 973382656UL, 621320448UL, 336235520UL, 152010496UL, 1405952UL,
2197856768UL, 1996530176UL, 1711316992UL, 1375772160UL, 1040226048UL, 721654784UL, 436506368UL, 184846592UL, 622592UL,
1879088896UL, 1778424576UL, 1593874176UL, 1342214912UL, 1073778688UL, 788565504UL, 536907264UL, 268472320UL, 37120UL,
2191458944UL, 130097257UL, 63659581UL, 30835745UL, 30318351UL, 28684549UL, 9946880UL, 8574976UL, 7855360UL,
2351640941UL, 1230197602UL, 763002927UL, 394890269UL, 193893645UL, 59415555UL, 8365312UL, 7515392UL, 6534656UL,
2938266166UL, 2184740132UL, 1212123679UL, 760318735UL, 459048710UL, 173835267UL, 22906624UL, 6065408UL, 5544192UL,
3273752070UL, 2552530688UL, 1730711808UL, 1043106817UL, 641040129UL, 373061120UL, 104886784UL, 4355584UL, 4489984UL,
3155526144UL, 2501084160UL, 1846774528UL, 1242990592UL, 807173632UL, 488796928UL, 220555776UL, 53111296UL, 3305728UL,
2970190592UL, 2399567872UL, 1829078016UL, 1342538496UL, 940211456UL, 588280832UL, 286354176UL, 102065408UL, 1992448UL,
2802024960UL, 2231400192UL, 1795192832UL, 1375762944UL, 1023440896UL, 721712640UL, 436629248UL, 168257792UL, 813056UL,
2583724288UL, 2097182464UL, 1744860672UL, 1409316864UL, 1124104448UL, 822113792UL, 520122624UL, 251686400UL, 225024UL,
2315289088UL, 1996520960UL, 1694530816UL, 1392540928UL, 1124105216UL, 872446720UL, 620787968UL, 352352768UL, 31744UL,
2813265494UL, 886309456UL, 47912514UL, 31343650UL, 47801870UL, 30114052UL, 11901184UL, 10791936UL, 9878016UL,
2858360649UL, 1938110261UL, 764624176UL, 429676569UL, 211511561UL, 43283459UL, 9142784UL, 8359936UL, 7380736UL,
2788045111UL, 2135115815UL, 1701143808UL, 1080584704UL, 577202944UL, 224619520UL, 6057728UL, 5864704UL, 5343744UL,
3056161036UL, 2435668741UL, 1815635456UL, 1195009792UL, 725443840UL, 373187328UL, 104752128UL, 3894016UL, 3831552UL,
2988071680UL, 2400804096UL, 1847354112UL, 1293771776UL, 857694464UL, 488791552UL, 220486400UL, 52715264UL, 2582272UL,
2920177152UL, 2332777728UL, 1829330688UL, 1359503616UL, 973824256UL, 621763840UL, 269506560UL, 118642944UL, 1335040UL,
2886099200UL, 2265144064UL, 1778407680UL, 1392532480UL, 1073766144UL, 755195648UL, 453270272UL, 184834304UL, 482560UL,
2852218112UL, 2197838848UL, 1811963136UL, 1476419840UL, 1191208192UL, 889218048UL, 587227392UL, 302014208UL, 25088UL,
2717935872UL, 2231395840UL, 1811965440UL, 1476421888UL, 1191209984UL, 939551744UL, 687892736UL, 402679808UL, 27136UL,
3249604153UL, 1708524086UL, 585171507UL, 48370214UL, 31601680UL, 14372868UL, 13461760UL, 12680448UL, 11702272UL,
3195409712UL, 2224038185UL, 1083974180UL, 396241692UL, 178339850UL, 43994626UL, 10051072UL, 9596416UL, 8880128UL,
3007980834UL, 2337813271UL, 1785678080UL, 1081100800UL, 561007616UL, 191713280UL, 6706688UL, 6514176UL, 6124544UL,
2838245394UL, 2301901833UL, 1799440128UL, 1128481536UL, 742672896UL, 356862976UL, 105075200UL, 4217344UL, 4024320UL,
2871016960UL, 2300592640UL, 1797474304UL, 1311000576UL, 874990080UL, 505956608UL, 220744448UL, 52842752UL, 2382848UL,
2836546048UL, 2249147648UL, 1779386112UL, 1359956224UL, 974146048UL, 605243648UL, 320030720UL, 101862400UL, 1135360UL,
2903066112UL, 2214872320UL, 1778665216UL, 1426278656UL, 1090735104UL, 755256320UL, 436488960UL, 184830720UL, 282368UL,
3003337216UL, 2264942592UL, 1862290176UL, 1526747136UL, 1191203584UL, 889213696UL, 604000512UL, 318787840UL, 21248UL,
3070251008UL, 2432716800UL, 1929400832UL, 1577080320UL, 1258314496UL, 989879296UL, 738220800UL, 436230400UL, 22784UL,
3568109346UL, 2262106917UL, 1122173220UL, 367395105UL, 31854613UL, 15083526UL, 14368512UL, 13717760UL, 13067776UL,
3447722013UL, 2459112987UL, 1369380887UL, 547296537UL, 195174925UL, 44445699UL, 10698496UL, 10439936UL, 10182144UL,
3143179283UL, 2439259148UL, 1785868800UL, 1098199552UL, 561329152UL, 192231424UL, 7487232UL, 7621632UL, 7428352UL,
2856002824UL, 2302618117UL, 1766339072UL, 1212887808UL, 726479872UL, 340670208UL, 89013504UL, 5064192UL, 4871424UL,
2770675968UL, 2217095168UL, 1730819072UL, 1261188352UL, 842150400UL, 489698816UL, 204552704UL, 53363200UL, 2968832UL,
2752916736UL, 2165649920UL, 1712731648UL, 1310078464UL, 957822464UL, 605632256UL, 303642624UL, 102251776UL, 1394176UL,
2886480128UL, 2198352896UL, 1728526080UL, 1376139264UL, 1040595200UL, 721893888UL, 436746752UL, 185023232UL, 475392UL,
3104126208UL, 2298623744UL, 1828731392UL, 1476410624UL, 1157644288UL, 855654656UL, 570441728UL, 285229056UL, 17408UL,
3338680832UL, 2550152192UL, 1996505088UL, 1610630400UL, 1308641536UL, 1006652416UL, 754994176UL, 436226816UL, 18944UL,
3752199442UL, 2714829590UL, 1608712727UL, 786891031UL, 266863123UL, 15403531UL, 15080962UL, 14429952UL, 13975808UL,
3565226513UL, 2610105871UL, 1587482636UL, 832573198UL, 228527886UL, 44439813UL, 11020288UL, 11023360UL, 11091712UL,
3160347149UL, 2439583495UL, 1769086464UL, 1114971648UL, 527834880UL, 175710720UL, 8006144UL, 8336896UL, 8536320UL,
2789414919UL, 2235964420UL, 1749885184UL, 1213211136UL, 726868480UL, 324412160UL, 89664000UL, 5976832UL, 6111488UL,
2670533632UL, 2150506752UL, 1680941824UL, 1261642752UL, 859251456UL, 473506816UL, 188360704UL, 3747328UL, 3947264UL,
2702777344UL, 2082087680UL, 1629168896UL, 1260135936UL, 924722432UL, 572662272UL, 287385088UL, 86060032UL, 2176512UL,
2886606592UL, 2114724864UL, 1644898048UL, 1292577024UL, 990652416UL, 688727808UL, 386803968UL, 151857920UL, 930304UL,
3171230464UL, 2265130496UL, 1711286016UL, 1375742464UL, 1090530304UL, 839003904UL, 553857024UL, 268644352UL, 209664UL,
3540002560UL, 2583702016UL, 1962946304UL, 1610625792UL, 1308636928UL, 1023425024UL, 738212608UL, 436222720UL, 14848UL,
3819438857UL, 3083666187UL, 2028077070UL, 1189478414UL, 652804109UL, 250413065UL, 15598599UL, 15144192UL, 14820608UL,
3632465161UL, 2693924616UL, 1738344454UL, 1050674951UL, 530646791UL, 94635528UL, 27923458UL, 11411200UL, 11806464UL,
3143895559UL, 2439646467UL, 1735462912UL, 1131745024UL, 611847936UL, 209326336UL, 8198144UL, 8791040UL, 9382656UL,
2689011205UL, 2185891842UL, 1716523520UL, 1196626432UL, 743903488UL, 307827200UL, 73341184UL, 6627840UL, 7154944UL,
2587038208UL, 2067010560UL, 1647711488UL, 1228477952UL, 842863872UL, 440341504UL, 155326208UL, 4529664UL, 4926208UL,
2635993600UL, 2015368960UL, 1579161344UL, 1210259200UL, 874780160UL, 539497984UL, 254351104UL, 69934080UL, 3090176UL,
2869890816UL, 2081429504UL, 1578113536UL, 1242569216UL, 957422080UL, 655563008UL, 387389184UL, 135666432UL, 1581568UL,
3238466560UL, 2248480768UL, 1677990656UL, 1325669632UL, 1040457216UL, 772087296UL, 503717120UL, 235282176UL, 533248UL,
3724548096UL, 2617252608UL, 1895833344UL, 1526735616UL, 1241523712UL, 973088768UL, 704653312UL, 402663424UL, 10240UL,
3754033155UL, 3252158469UL, 2414215174UL, 1625948167UL, 1089339398UL, 653393924UL, 301334531UL, 15925254UL, 15732736UL,
3616342532UL, 2777940483UL, 1872626178UL, 1252262146UL, 765985026UL, 380240130UL, 44958469UL, 11668480UL, 12325888UL,
3144155907UL, 2439775233UL, 1718682624UL, 1165427712UL, 695993088UL, 310313984UL, 58918914UL, 9114112UL, 9770752UL,
2672559362UL, 2186151169UL, 1699939840UL, 1196885248UL, 760939776UL, 375391488UL, 90507776UL, 7082496UL, 7608320UL,
2486700288UL, 2017003520UL, 1614481664UL, 1212024832UL, 843122432UL, 474285824UL, 155781376UL, 5050112UL, 5641984UL,
2552498432UL, 1965361920UL, 1546062336UL, 1193806592UL, 858393088UL, 539822336UL, 254806528UL, 53808640UL, 3872000UL,
2819885312UL, 2064911360UL, 1561660672UL, 1192627200UL, 890702848UL, 605621248UL, 337316608UL, 119409920UL, 2298624UL,
3288794880UL, 2282097664UL, 1644563968UL, 1241911040UL, 939986944UL, 688393984UL, 436866560UL, 185273088UL, 921856UL,
3875539712UL, 2701135104UL, 1879052032UL, 1409290752UL, 1107301376UL, 855643392UL, 620762368UL, 335549440UL, 5376UL,
3539009536UL, 3170041856UL, 2666856448UL, 2096496640UL, 1559756800UL, 1090125824UL, 721158144UL, 352124928UL, 16711680UL,
3433627648UL, 2795896832UL, 2125332480UL, 1572143104UL, 1119551488UL, 750780416UL, 432275456UL, 180748288UL, 13041664UL,
3111387136UL, 2507407360UL, 1887109120UL, 1350828032UL, 931725312UL, 563019776UL, 278200320UL, 77070336UL, 10158080UL,
2689794048UL, 2253717504UL, 1784283136UL, 1314914304UL, 895811584UL, 527106048UL, 258998272UL, 58064896UL, 8126464UL,
2436694016UL, 2050949120UL, 1665204224UL, 1279524864UL, 910753792UL, 575537152UL, 273874944UL, 72941568UL, 6291456UL,
2469003264UL, 1948975104UL, 1579941888UL, 1227816960UL, 909115392UL, 607453184UL, 322568192UL, 104792064UL, 4653056UL,
2803433472UL, 2098790400UL, 1595539456UL, 1192951808UL, 874315776UL, 606011392UL, 371326976UL, 153550848UL, 3080192UL,
3339386880UL, 2416508928UL, 1711931392UL, 1242169344UL, 889978880UL, 621608960UL, 403636224UL, 185729024UL, 1507328UL,
4026531840UL, 2936012800UL, 2030043136UL, 1409286144UL, 1006632960UL, 704643072UL, 469762048UL, 234881024UL, 0
    };

uint32_t ulMapDJ690_CMYK[ 9 * 9 * 9 ]=
// DJ690_CMYK
    {
 337848575UL,   37838470UL,  155209268UL,  137905152UL,   36454656UL,    2310144UL,
   2179072UL,    2051072UL,    1733120UL, 2013280119UL,  385897321UL,  303379741UL,
 270610688UL,  102772224UL,    1844992UL,    1911552UL,    1847296UL,    1784832UL,
2080387626UL, 1157643294UL,  452996881UL,  335555072UL,  202384384UL,   50991872UL,
      2304UL,     922880UL,    1319680UL, 2164273408UL, 1409300992UL,  721433088UL,
 385886976UL,  268444928UL,  151000832UL,   16777216UL,          0UL,       2048UL,
2147495424UL, 1426075648UL,  838872576UL,  520104192UL,  301999872UL,  201335040UL,
  83889408UL,          0UL,          0UL, 2231381504UL, 1459629056UL,  922756864UL,
 603988736UL,  402662656UL,  234889984UL,  134224640UL,   33554432UL,          0UL,
2365598720UL, 1711286528UL, 1023417856UL,  687873280UL,  469770240UL,  318775552UL,
 151002624UL,   67112448UL,          0UL, 2147492608UL, 1660951808UL, 1040191744UL,
 738202112UL,  520098560UL,  352326656UL,  234888192UL,   83891968UL,        512UL,
1744833536UL, 1493176064UL, 1056967168UL,  771754240UL,  570427136UL,  402655744UL,
 285216512UL,  151000832UL,       5120UL, 1867382908UL,  242679926UL,  273556510UL,
 171977984UL,   37040896UL,    2963456UL,    2375168UL,    2380544UL,    2060288UL,
2399142003UL,  336202819UL,  371005455UL,  287581184UL,  102769152UL,    1314048UL,
   1381120UL,    1515264UL,    1388032UL, 2214599729UL, 1107302927UL,  520100352UL,
 352328704UL,  219160320UL,   50333952UL,          0UL,       2560UL,       6144UL,
2063606016UL, 1090527232UL,  671096832UL,  419437824UL,  285219584UL,  150998528UL,
  16777216UL,          0UL,       1024UL, 1677729536UL, 1056971776UL,  738204416UL,
 520100352UL,  352328448UL,  201331968UL,   83886080UL,          0UL,          0UL,
1694504960UL, 1073743872UL,  771753728UL,  553649920UL,  419432704UL,  268439296UL,
 134219264UL,   33554432UL,          0UL, 1761611520UL, 1040187392UL,  822083584UL,
 620756992UL,  436207616UL,  301989888UL,  184549376UL,   67108864UL,          0UL,
1979714048UL, 1073741824UL,  855638016UL,  687865856UL,  486539264UL,  352321536UL,
 234881024UL,   83886080UL,          0UL, 2214593536UL, 1275068416UL,  939524096UL,
 738197504UL,  553648128UL,  402653184UL,  268435456UL,  150994944UL,          0UL,
2102263844UL, 1063190564UL,  391119377UL,  239537664UL,   54595584UL,    3940096UL,
   3616512UL,    3753984UL,    3105792UL, 2284060719UL, 1159987223UL,  421789697UL,
 321327616UL,  119671296UL,    1638400UL,    1572864UL,    1838080UL,    2041600UL,
1962934313UL,  956301324UL,  402653184UL,  369889024UL,  236065536UL,   50331648UL,
         0UL,          0UL,       2560UL, 1543507718UL, 1040191232UL,  687870208UL,
 419434496UL,  285217280UL,  150995968UL,   16777216UL,          0UL,          0UL,
1426067200UL, 1040190976UL,  738201344UL,  536874496UL,  369102592UL,  218106112UL,
  83886080UL,          0UL,          0UL, 1509949952UL, 1040187392UL,  788529152UL,
 587202560UL,  419430400UL,  285212672UL,  134217728UL,   33554432UL,          0UL,
1644167168UL, 1023410176UL,  805306368UL,  637534208UL,  469762048UL,  318767104UL,
 184549376UL,   67108864UL,          0UL, 1946157056UL, 1056964608UL,  872415232UL,
 687865856UL,  520093696UL,  352321536UL,  234881024UL,  117440512UL,          0UL,
2801795072UL, 1325400064UL,  939524096UL,  771751936UL,  553648128UL,  419430400UL,
 301989888UL,  184549376UL,          0UL, 2286419968UL, 1263140864UL,  608436224UL,
 290062336UL,   88997888UL,    4784128UL,    4720384UL,    4793600UL,    4932352UL,
2452488192UL, 1126694912UL,  606535680UL,  338167040UL,  153354240UL,    2031616UL,
   1900544UL,    2031616UL,    2624768UL, 2014248971UL, 1074659328UL,  655294464UL,
 370344448UL,  235930880UL,   50331648UL,          0UL,          0UL,     786432UL,
1308622848UL,  922746880UL,  654311424UL,  385875968UL,  285215232UL,  150994944UL,
  16777216UL,          0UL,          0UL, 1308623360UL, 1023411456UL,  771753728UL,
 536873216UL,  352323840UL,  201327104UL,   83886080UL,          0UL,          0UL,
1392508928UL, 1023410176UL,  805306368UL,  587202560UL,  419430400UL,  268435456UL,
 134217728UL,   33554432UL,          0UL, 1577058304UL, 1040187392UL,  822083584UL,
 637534208UL,  503316480UL,  352321536UL,  184549376UL,   50331648UL,          0UL,
1912602624UL, 1073741824UL,  889192448UL,  738197504UL,  587202560UL,  436207616UL,
 251658240UL,  100663296UL,          0UL, 3154116608UL, 1325400064UL,  973078528UL,
 788529152UL,  620756992UL,  469762048UL,  318767104UL,  201326592UL,          0UL,
2185035776UL, 1245380608UL,  674693120UL,  407109632UL,  139132928UL,    5177344UL,
   5373952UL,    5636096UL,    6294784UL, 2435710976UL, 1059454976UL,  623050752UL,
 354680832UL,  153485312UL,    1966080UL,    1900544UL,    2228224UL,    3080192UL,
1963982848UL, 1057816576UL,  672071680UL,  420478976UL,  218955776UL,   50331648UL,
         0UL,     786432UL,    1310720UL, 1426063360UL, 1006632960UL,  704643072UL,
 419430400UL,  285213184UL,  167772160UL,   16777216UL,          0UL,          0UL,
1275068416UL, 1006632960UL,  738197504UL,  536870912UL,  335544320UL,  201326592UL,
  83886080UL,          0UL,          0UL, 1342177280UL, 1006632960UL,  805306368UL,
 603979776UL,  419430400UL,  234881024UL,  134217728UL,   16777216UL,          0UL,
1543503872UL, 1056964608UL,  822083584UL,  637534208UL,  469762048UL,  318767104UL,
 150994944UL,   50331648UL,          0UL, 1895825408UL, 1107296256UL,  922746880UL,
 771751936UL,  637534208UL,  469762048UL,  285212672UL,  117440512UL,          0UL,
3288334336UL, 1392508928UL, 1023410176UL,  855638016UL,  704643072UL,  553648128UL,
 385875968UL,  218103808UL,          0UL, 2033516544UL, 1160642560UL,  792068096UL,
 541261824UL,  256376832UL,   39124992UL,    5701632UL,    6029312UL,    6684672UL,
2166882304UL, 1008533504UL,  622526464UL,  387710976UL,  169541632UL,   18808832UL,
   1835008UL,    2031616UL,    3276800UL, 1812594688UL, 1023410176UL,  603979776UL,
 402653184UL,  218103808UL,   50331648UL,          0UL,          0UL,    1310720UL,
1526726656UL, 1023410176UL,  721420288UL,  452984832UL,  301989888UL,  150994944UL,
  16777216UL,          0UL,          0UL, 1375731712UL, 1006632960UL,  754974720UL,
 553648128UL,  335544320UL,  201326592UL,   83886080UL,          0UL,          0UL,
1325400064UL,  989855744UL,  788529152UL,  603979776UL,  419430400UL,  251658240UL,
 134217728UL,   16777216UL,          0UL, 1476395008UL, 1056964608UL,  838860800UL,
 654311424UL,  503316480UL,  318767104UL,  150994944UL,   50331648UL,          0UL,
1895825408UL, 1124073472UL,  939524096UL,  754974720UL,  620756992UL,  469762048UL,
 285212672UL,  100663296UL,          0UL, 3355443200UL, 1459617792UL, 1006632960UL,
 855638016UL,  721420288UL,  603979776UL,  419430400UL,  251658240UL,          0UL,
2050097152UL, 1345191936UL,  942800896UL,  675479552UL,  408027136UL,  123404288UL,
   5963776UL,    6422528UL,    6881280UL, 1948385280UL,  890437632UL,  605290496UL,
 404094976UL,  236453888UL,   51904512UL,    1572864UL,    2162688UL,    3407872UL,
1795162112UL,  956301312UL,  553648128UL,  369098752UL,  218103808UL,   67108864UL,
         0UL,          0UL,    1245184UL, 1644167168UL, 1023410176UL,  721420288UL,
 469762048UL,  318767104UL,  167772160UL,   16777216UL,          0UL,          0UL,
1577058304UL, 1040187392UL,  788529152UL,  570425344UL,  385875968UL,  234881024UL,
  83886080UL,          0UL,          0UL, 1509949440UL, 1056964608UL,  838860800UL,
 637534208UL,  452984832UL,  251658240UL,  117440512UL,   16777216UL,          0UL,
1509949440UL, 1073741824UL,  838860800UL,  671088640UL,  503316480UL,  318767104UL,
 167772160UL,   33554432UL,          0UL, 1895825408UL, 1124073472UL,  922746880UL,
 754974720UL,  587202560UL,  436207616UL,  268435456UL,   33554432UL,          0UL,
3388997632UL, 1526726656UL, 1006632960UL,  838860800UL,  671088640UL,  553648128UL,
 419430400UL,  251658240UL,          0UL, 2016280576UL, 1664221184UL, 1346240512UL,
 995360768UL,  643629056UL,  341704704UL,  140705792UL,   23134208UL,    6881280UL,
2132803584UL,  856489984UL,  621805568UL,  454426624UL,  286982144UL,  102432768UL,
   1441792UL,    1900544UL,    3538944UL, 2063597568UL,  905969664UL,  536870912UL,
 385875968UL,  234881024UL,  117440512UL,          0UL,     655360UL,    1179648UL,
1979711488UL, 1023410176UL,  687865856UL,  452984832UL,  318767104UL,  167772160UL,
  33554432UL,          0UL,          0UL, 1962934272UL, 1107296256UL,  822083584UL,
 603979776UL,  402653184UL,  251658240UL,   67108864UL,          0UL,          0UL,
1929379840UL, 1140850688UL,  872415232UL,  654311424UL,  469762048UL,  268435456UL,
 117440512UL,          0UL,          0UL, 1895825408UL, 1157627904UL,  905969664UL,
 704643072UL,  503316480UL,  335544320UL,  150994944UL,   33554432UL,          0UL,
2030043136UL, 1174405120UL,  922746880UL,  754974720UL,  553648128UL,  385875968UL,
 218103808UL,   67108864UL,          0UL, 3439329280UL, 1577058304UL, 1006632960UL,
 822083584UL,  637534208UL,  503316480UL,  352321536UL,  201326592UL,          0UL,
1865285632UL, 2033319936UL, 2017591296UL, 1700331520UL, 1164181504UL,  711131136UL,
 459538432UL,  225116160UL,    6291456UL, 2199322624UL, 1108738048UL,  773455872UL,
 623509504UL,  455999488UL,  305201152UL,  154402816UL,   36700160UL,    3014656UL,
2667577344UL, 1090519040UL,  570425344UL,  402653184UL,  251658240UL,  117440512UL,
  16777216UL,          0UL,          0UL, 2969567232UL, 1191182336UL,  704643072UL,
 436207616UL,  285212672UL,  167772160UL,   33554432UL,          0UL,          0UL,
3170893824UL, 1342177280UL,  889192448UL,  620756992UL,  402653184UL,  251658240UL,
  83886080UL,          0UL,          0UL, 3271557120UL, 1442840576UL,  973078528UL,
 738197504UL,  520093696UL,  335544320UL,  167772160UL,          0UL,          0UL,
3355443200UL, 1509949440UL, 1006632960UL,  805306368UL,  570425344UL,  402653184UL,
 201326592UL,   50331648UL,          0UL, 3422552064UL, 1560281088UL, 1040187392UL,
 822083584UL,  620756992UL,  436207616UL,  251658240UL,   83886080UL,          0UL,
3489660928UL, 1711276032UL, 1073741824UL,  805306368UL,  620756992UL,  436207616UL,
 285212672UL,  134217728UL,          0
};
uint32_t ulMapDJ690_ClMlxx[ 9 * 9 * 9 ]=
// DJ690_ClMlxx
{
         0UL,     988160UL,    2242048UL,    4611328UL,    5341952UL,    5871616UL,
   5937408UL,    5671424UL,    5528064UL,    2036480UL,    3948288UL,    6779392UL,
   5597696UL,    5207040UL,    7057152UL,    6992128UL,    6860800UL,    6332928UL,
   5190656UL,    6178560UL,    7304448UL,    8222208UL,    5007616UL,    7057408UL,
  10153472UL,    8443904UL,    7652352UL,    6115072UL,    6113792UL,    5529088UL,
   5990656UL,    5662720UL,    5736704UL,    6872064UL,    8580864UL,    9892096UL,
   3887360UL,    3366400UL,    3042816UL,    3501568UL,    3960320UL,    3829504UL,
   4171008UL,    4903680UL,    6808832UL,    2249728UL,    1731840UL,    1478400UL,
   1543424UL,    2260480UL,    2718720UL,    2589184UL,    2808576UL,    3855616UL,
   1072384UL,     688384UL,     441088UL,     373248UL,     761344UL,    1412608UL,
   1609472UL,    1619712UL,    2152960UL,     292864UL,      41472UL,      57344UL,
     55040UL,      53760UL,     312576UL,     632832UL,     767744UL,     915712UL,
     49408UL,      51712UL,      60160UL,      60928UL,      60416UL,      58624UL,
     55808UL,      53760UL,      58880UL,     597248UL,    2176256UL,    3496192UL,
   4875520UL,    5734656UL,    5935360UL,    6002944UL,    5275136UL,    5069568UL,
   2632192UL,    6326784UL,    8163328UL,    5664256UL,    5601792UL,    8573952UL,
   8310272UL,    7783168UL,    7124480UL,    4866560UL,    7764992UL,    9082624UL,
   8289280UL,    4941568UL,    8307456UL,    9697792UL,   10087680UL,    9951232UL,
   6381312UL,    5529344UL,    5137152UL,    5598464UL,    5333760UL,    5541888UL,
   5949440UL,    7397376UL,    8321024UL,    3956224UL,    3171328UL,    2780416UL,
   2912512UL,    3370240UL,    3238912UL,    3649536UL,    4045312UL,    5167616UL,
   2454272UL,    1678592UL,    1224192UL,    1289984UL,    1614080UL,    2002176UL,
   1742592UL,    2468352UL,    3326464UL,    1414144UL,     638464UL,     313344UL,
    248832UL,     312576UL,     638720UL,     964608UL,     828928UL,    1686016UL,
    698624UL,      48128UL,      50944UL,      53248UL,      51712UL,      50944UL,
    180992UL,     244992UL,     312576UL,      47616UL,      51968UL,      57856UL,
     59904UL,      58624UL,      57856UL,      56576UL,      59904UL,      60672UL,
   1727488UL,    2906112UL,    4613888UL,    5140480UL,    6131712UL,    6264320UL,
   5933824UL,    4749312UL,    4219392UL,    4279296UL,    6452992UL,    9082880UL,
   5795328UL,    6720768UL,    8898048UL,    9032448UL,    8373760UL,    7123200UL,
   5988352UL,    9147392UL,   10662656UL,    6847488UL,    5269504UL,    9155584UL,
  10146304UL,   10415616UL,   10022400UL,    5990656UL,    6189312UL,    5926400UL,
   5795840UL,    5398528UL,    5737472UL,    6072320UL,    6800640UL,    6939904UL,
   3960064UL,    3566336UL,    3171584UL,    3042048UL,    3237632UL,    3174656UL,
   3705600UL,    3777536UL,    4246016UL,    2462464UL,    2003200UL,    1607936UL,
   1411840UL,    1477632UL,    1675520UL,    1606144UL,    2328832UL,    2861568UL,
   1481216UL,     953088UL,     491520UL,     231680UL,     166144UL,     427264UL,
    754176UL,     818432UL,    1350144UL,     762112UL,     167424UL,      37120UL,
     40192UL,      39424UL,      41472UL,      38144UL,     102144UL,      39424UL,
     40960UL,      41216UL,      43008UL,      47616UL,      49152UL,      48384UL,
     47616UL,      46336UL,      44800UL,    3890176UL,    5201152UL,    6052864UL,
   5790208UL,    5993216UL,    6591488UL,    6333440UL,    5473536UL,    4156416UL,
   6186240UL,    6449408UL,    7105024UL,    5988352UL,    7304448UL,    8817664UL,
   9019392UL,    8763136UL,    7780352UL,    7496192UL,    8024832UL,    7042304UL,
   6647808UL,    6646016UL,    9928704UL,   10855168UL,   11451392UL,    9688320UL,
   6910208UL,    6714368UL,    6649600UL,    6913792UL,    5724416UL,    6256640UL,
   6782464UL,    7249152UL,    7520768UL,    4091904UL,    4025088UL,    3825408UL,
   3691776UL,    3560192UL,    3828992UL,    4027648UL,    3899136UL,    4235264UL,
   2716672UL,    2388224UL,    2125312UL,    1862912UL,    1798912UL,    1929728UL,
   2125056UL,    2256896UL,    2590464UL,    1602304UL,    1141760UL,     813056UL,
    550144UL,     419840UL,     485888UL,     813824UL,     748032UL,    1144064UL,
    751104UL,     224768UL,      26624UL,      28416UL,      29184UL,      30720UL,
     29184UL,      93952UL,      29184UL,      30976UL,      30976UL,      31232UL,
     33792UL,      35328UL,      37376UL,      37376UL,      35328UL,      33280UL,
   5782272UL,    6700800UL,    7356416UL,    6242048UL,    7091968UL,    7228160UL,
   6385408UL,    5869056UL,    4821504UL,    6505728UL,    6833920UL,    7620352UL,
   6965248UL,    7688960UL,    9918976UL,    9662720UL,    8816640UL,    8036096UL,
   9129984UL,    8474880UL,    7295232UL,    7426816UL,    8082944UL,   10640128UL,
  11301376UL,   10258688UL,    9608704UL,    8344832UL,    7755264UL,    7558656UL,
   7099648UL,    6901504UL,    6772736UL,    7364608UL,    8221184UL,    9344256UL,
   4344576UL,    4345344UL,    4214272UL,    4083456UL,    4412928UL,    4413696UL,
   4546048UL,    4349952UL,    4880384UL,    2839808UL,    2643200UL,    2511360UL,
   2381056UL,    2316288UL,    2249984UL,    2578688UL,    2448384UL,    2649344UL,
   1660928UL,    1266688UL,    1135104UL,    1069824UL,     938752UL,     873984UL,
   1005312UL,    1005056UL,    1138688UL,     742912UL,     283904UL,     152320UL,
     21504UL,      21504UL,      23808UL,      23040UL,      87808UL,      23040UL,
     23040UL,      23808UL,      23040UL,      24832UL,      25600UL,      27904UL,
     28416UL,      27136UL,      25856UL,    7480832UL,    8333056UL,    8923648UL,
   7088640UL,    7545600UL,    8199168UL,    7091200UL,    6246144UL,    5269760UL,
   8137984UL,    8989952UL,    9907712UL,    9318144UL,    9972736UL,   10435328UL,
  10635264UL,    9984768UL,    8416512UL,   11154688UL,   11744768UL,   11220480UL,
  11220736UL,   10957824UL,   11091456UL,   11424256UL,   12344576UL,   10185728UL,
   8731392UL,    8207104UL,    8076032UL,    7813376UL,    7813632UL,    7355392UL,
   7947776UL,    8738560UL,   10119680UL,    5126912UL,    5192704UL,    5060864UL,
   5192192UL,    5257216UL,    4930304UL,    5063424UL,    5130752UL,    5987584UL,
   2962432UL,    2831616UL,    2765568UL,    2765824UL,    2634752UL,    2832384UL,
   3096576UL,    3163904UL,    3298560UL,    1784576UL,    1457408UL,    1392128UL,
   1392384UL,    1457664UL,    1392128UL,    1326336UL,    1392384UL,    1658880UL,
    801792UL,     409600UL,     343808UL,     212992UL,     278272UL,     147712UL,
    148224UL,     213504UL,      18176UL,      16128UL,      17920UL,      17664UL,
     17920UL,      18688UL,      20224UL,      21760UL,      21760UL,      20480UL,
   9245952UL,   10163712UL,   10098944UL,    8133120UL,    7410688UL,    8325632UL,
   8850176UL,    7087104UL,    5977344UL,   10164736UL,   11933696UL,   12130304UL,
  11606272UL,   11409664UL,   12262656UL,   12070656UL,   10501632UL,    9191680UL,
  13836288UL,   12918784UL,   12263168UL,   12263424UL,   11673344UL,   11739648UL,
  11811328UL,   12601088UL,   11028992UL,    9315584UL,    8529152UL,    8332288UL,
   7938560UL,    8004096UL,    7675392UL,    8334848UL,    9256960UL,   10571008UL,
   5973248UL,    5645824UL,    5580288UL,    5514240UL,    5448960UL,    5580032UL,
   5449728UL,    5911040UL,    6767872UL,    3810304UL,    3614464UL,    3679744UL,
   3482880UL,    3679744UL,    3614208UL,    3613952UL,    3682048UL,    4209920UL,
   1777408UL,    1646080UL,    1580544UL,    1646336UL,    1712128UL,    1646848UL,
   1910272UL,    1911552UL,    2374144UL,     862208UL,     600320UL,     535552UL,
    469760UL,     469760UL,     469248UL,     469504UL,     403456UL,     668160UL,
     10496UL,      11520UL,      12544UL,      12544UL,      12544UL,      12800UL,
     14336UL,      15616UL,      14336UL,   10946304UL,   11077376UL,   10160896UL,
   8325888UL,    7013888UL,    7602176UL,    8060928UL,    8586240UL,    7410432UL,
  11799552UL,   14288896UL,   14157824UL,   13240832UL,   12716544UL,   13043712UL,
  14028544UL,   12133888UL,   10102784UL,   14880512UL,   13307392UL,   12520192UL,
  13176320UL,   12848640UL,   13176320UL,   12980992UL,   11677440UL,   12071680UL,
  10293504UL,    8851712UL,    8589312UL,    8589056UL,    8458240UL,    8523520UL,
   8983296UL,    9775616UL,   11024384UL,    6492928UL,    5968640UL,    5968640UL,
   5968896UL,    5968640UL,    6099968UL,    5968128UL,    6562048UL,    7417088UL,
   4198656UL,    3871232UL,    4002304UL,    4002816UL,    4068352UL,    4199424UL,
   4068096UL,    4266240UL,    4663296UL,    2494464UL,    2232832UL,    2167552UL,
   2167808UL,    2167808UL,    2167808UL,    2429696UL,    2429952UL,    3023360UL,
    790016UL,     658432UL,     660480UL,     658432UL,     658432UL,     658432UL,
    658688UL,     856576UL,    1252608UL,       5376UL,       6144UL,       6400UL,
      7168UL,       7168UL,       6656UL,       5888UL,       7424UL,       7424UL,
  11599872UL,   11272192UL,   10092544UL,    7995392UL,    6619136UL,    6750208UL,
   6946816UL,    6946816UL,    8912896UL,   14155776UL,   15073280UL,   14090240UL,
  11796480UL,   11206656UL,   11075584UL,   11599872UL,   12582912UL,   12910592UL,
  16646144UL,   15335424UL,   15335424UL,   15532032UL,   15466496UL,   15663104UL,
  16580608UL,   16711680UL,   16711680UL,   11993088UL,   10027008UL,   10027008UL,
  10158080UL,    9961472UL,   10027008UL,   10616832UL,   11337728UL,   12124160UL,
   7471104UL,    6553600UL,    6553600UL,    6619136UL,    6946816UL,    6619136UL,
   6750208UL,    7471104UL,    8388608UL,    4718592UL,    4390912UL,    4521984UL,
   4587520UL,    4784128UL,    5177344UL,    4784128UL,    4718592UL,    5636096UL,
   3014656UL,    2752512UL,    2686976UL,    2883584UL,    2818048UL,    3080192UL,
   3276800UL,    3080192UL,    3670016UL,    1441792UL,    1179648UL,    1114112UL,
   1048576UL,    1048576UL,    1179648UL,    1376256UL,    1638400UL,    1966080UL,
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL,
         0UL,          0UL,          0UL,
};

