/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-cab-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_cab_compression_to_string(FuCabCompression val)
{
    if (val == FU_CAB_COMPRESSION_NONE)
        return "none";
    if (val == FU_CAB_COMPRESSION_MSZIP)
        return "mszip";
    if (val == FU_CAB_COMPRESSION_QUANTUM)
        return "quantum";
    if (val == FU_CAB_COMPRESSION_LZX)
        return "lzx";
    return NULL;
}

static const gchar *
fu_cab_file_attribute_to_string(FuCabFileAttribute val)
{
    if (val == FU_CAB_FILE_ATTRIBUTE_NONE)
        return "none";
    if (val == FU_CAB_FILE_ATTRIBUTE_READONLY)
        return "readonly";
    if (val == FU_CAB_FILE_ATTRIBUTE_HIDDEN)
        return "hidden";
    if (val == FU_CAB_FILE_ATTRIBUTE_SYSTEM)
        return "system";
    if (val == FU_CAB_FILE_ATTRIBUTE_ARCH)
        return "arch";
    if (val == FU_CAB_FILE_ATTRIBUTE_EXEC)
        return "exec";
    if (val == FU_CAB_FILE_ATTRIBUTE_NAME_UTF8)
        return "name-utf8";
    return NULL;
}
/**
 * fu_struct_cab_data_ref: (skip):
 **/
FuStructCabData *
fu_struct_cab_data_ref(FuStructCabData *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_cab_data_unref: (skip):
 **/
void
fu_struct_cab_data_unref(FuStructCabData *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCabData refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructCabData *
fu_struct_cab_data_new_internal(void)
{
    FuStructCabData *st = g_new0(FuStructCabData, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_cab_data_get_checksum: (skip):
 **/
guint32
fu_struct_cab_data_get_checksum(const FuStructCabData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_data_get_comp: (skip):
 **/
guint16
fu_struct_cab_data_get_comp(const FuStructCabData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_data_get_uncomp: (skip):
 **/
guint16
fu_struct_cab_data_get_uncomp(const FuStructCabData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_cab_data_set_checksum: (skip):
 **/
void
fu_struct_cab_data_set_checksum(FuStructCabData *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_data_set_comp: (skip):
 **/
void
fu_struct_cab_data_set_comp(FuStructCabData *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_data_set_uncomp: (skip):
 **/
void
fu_struct_cab_data_set_uncomp(FuStructCabData *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_data_new: (skip):
 **/
FuStructCabData *
fu_struct_cab_data_new(void)
{
    FuStructCabData *st = fu_struct_cab_data_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    return st;
}
/**
 * fu_struct_cab_data_to_string: (skip):
 **/
static gchar *
fu_struct_cab_data_to_string(const FuStructCabData *st)
{
    g_autoptr(GString) str = g_string_new("FuStructCabData:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_cab_data_get_checksum(st));
    g_string_append_printf(str, "  comp: 0x%x\n",
                           (guint) fu_struct_cab_data_get_comp(st));
    g_string_append_printf(str, "  uncomp: 0x%x\n",
                           (guint) fu_struct_cab_data_get_uncomp(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_cab_data_validate_internal(FuStructCabData *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_cab_data_parse_internal(FuStructCabData *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_cab_data_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_cab_data_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_cab_data_parse_stream: (skip):
 **/
FuStructCabData *
fu_struct_cab_data_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructCabData) st = fu_struct_cab_data_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 8, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructCabData failed read of 0x%x: ", (guint) 8);
        return NULL;
    }
    if (st->buf->len != 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructCabData requested 0x%x and got 0x%x",
                    (guint) 8,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_cab_data_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_cab_file_ref: (skip):
 **/
FuStructCabFile *
fu_struct_cab_file_ref(FuStructCabFile *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_cab_file_unref: (skip):
 **/
void
fu_struct_cab_file_unref(FuStructCabFile *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCabFile refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructCabFile *
fu_struct_cab_file_new_internal(void)
{
    FuStructCabFile *st = g_new0(FuStructCabFile, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_cab_file_get_usize: (skip):
 **/
guint32
fu_struct_cab_file_get_usize(const FuStructCabFile *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_get_uoffset: (skip):
 **/
guint32
fu_struct_cab_file_get_uoffset(const FuStructCabFile *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_get_index: (skip):
 **/
guint16
fu_struct_cab_file_get_index(const FuStructCabFile *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_get_date: (skip):
 **/
guint16
fu_struct_cab_file_get_date(const FuStructCabFile *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_get_time: (skip):
 **/
guint16
fu_struct_cab_file_get_time(const FuStructCabFile *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_get_fattr: (skip):
 **/
FuCabFileAttribute
fu_struct_cab_file_get_fattr(const FuStructCabFile *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 14, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_cab_file_set_usize: (skip):
 **/
void
fu_struct_cab_file_set_usize(FuStructCabFile *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_set_uoffset: (skip):
 **/
void
fu_struct_cab_file_set_uoffset(FuStructCabFile *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_set_index: (skip):
 **/
void
fu_struct_cab_file_set_index(FuStructCabFile *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_set_date: (skip):
 **/
void
fu_struct_cab_file_set_date(FuStructCabFile *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 10, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_set_time: (skip):
 **/
void
fu_struct_cab_file_set_time(FuStructCabFile *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_set_fattr: (skip):
 **/
void
fu_struct_cab_file_set_fattr(FuStructCabFile *st, FuCabFileAttribute value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 14, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_new: (skip):
 **/
FuStructCabFile *
fu_struct_cab_file_new(void)
{
    FuStructCabFile *st = fu_struct_cab_file_new_internal();
    st->buf = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st->buf, 16, 0x0);
    return st;
}
/**
 * fu_struct_cab_file_to_string: (skip):
 **/
static gchar *
fu_struct_cab_file_to_string(const FuStructCabFile *st)
{
    g_autoptr(GString) str = g_string_new("FuStructCabFile:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  usize: 0x%x\n",
                           (guint) fu_struct_cab_file_get_usize(st));
    g_string_append_printf(str, "  uoffset: 0x%x\n",
                           (guint) fu_struct_cab_file_get_uoffset(st));
    g_string_append_printf(str, "  index: 0x%x\n",
                           (guint) fu_struct_cab_file_get_index(st));
    g_string_append_printf(str, "  date: 0x%x\n",
                           (guint) fu_struct_cab_file_get_date(st));
    g_string_append_printf(str, "  time: 0x%x\n",
                           (guint) fu_struct_cab_file_get_time(st));
    {
        const gchar *tmp = fu_cab_file_attribute_to_string(fu_struct_cab_file_get_fattr(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  fattr: 0x%x [%s]\n", (guint) fu_struct_cab_file_get_fattr(st), tmp);
        } else {
            g_string_append_printf(str, "  fattr: 0x%x\n", (guint) fu_struct_cab_file_get_fattr(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_cab_file_validate_internal(FuStructCabFile *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_cab_file_parse_internal(FuStructCabFile *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_cab_file_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_cab_file_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_cab_file_parse_stream: (skip):
 **/
FuStructCabFile *
fu_struct_cab_file_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructCabFile) st = fu_struct_cab_file_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 16, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructCabFile failed read of 0x%x: ", (guint) 16);
        return NULL;
    }
    if (st->buf->len != 16) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructCabFile requested 0x%x and got 0x%x",
                    (guint) 16,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_cab_file_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_cab_folder_ref: (skip):
 **/
FuStructCabFolder *
fu_struct_cab_folder_ref(FuStructCabFolder *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_cab_folder_unref: (skip):
 **/
void
fu_struct_cab_folder_unref(FuStructCabFolder *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCabFolder refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructCabFolder *
fu_struct_cab_folder_new_internal(void)
{
    FuStructCabFolder *st = g_new0(FuStructCabFolder, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_cab_folder_get_offset: (skip):
 **/
guint32
fu_struct_cab_folder_get_offset(const FuStructCabFolder *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_folder_get_ndatab: (skip):
 **/
guint16
fu_struct_cab_folder_get_ndatab(const FuStructCabFolder *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_folder_get_compression: (skip):
 **/
FuCabCompression
fu_struct_cab_folder_get_compression(const FuStructCabFolder *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_cab_folder_set_offset: (skip):
 **/
void
fu_struct_cab_folder_set_offset(FuStructCabFolder *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_folder_set_ndatab: (skip):
 **/
void
fu_struct_cab_folder_set_ndatab(FuStructCabFolder *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_folder_set_compression: (skip):
 **/
void
fu_struct_cab_folder_set_compression(FuStructCabFolder *st, FuCabCompression value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_folder_new: (skip):
 **/
FuStructCabFolder *
fu_struct_cab_folder_new(void)
{
    FuStructCabFolder *st = fu_struct_cab_folder_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    return st;
}
/**
 * fu_struct_cab_folder_to_string: (skip):
 **/
static gchar *
fu_struct_cab_folder_to_string(const FuStructCabFolder *st)
{
    g_autoptr(GString) str = g_string_new("FuStructCabFolder:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_cab_folder_get_offset(st));
    g_string_append_printf(str, "  ndatab: 0x%x\n",
                           (guint) fu_struct_cab_folder_get_ndatab(st));
    {
        const gchar *tmp = fu_cab_compression_to_string(fu_struct_cab_folder_get_compression(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  compression: 0x%x [%s]\n", (guint) fu_struct_cab_folder_get_compression(st), tmp);
        } else {
            g_string_append_printf(str, "  compression: 0x%x\n", (guint) fu_struct_cab_folder_get_compression(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_cab_folder_validate_internal(FuStructCabFolder *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_cab_folder_parse_internal(FuStructCabFolder *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_cab_folder_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_cab_folder_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_cab_folder_parse_stream: (skip):
 **/
FuStructCabFolder *
fu_struct_cab_folder_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructCabFolder) st = fu_struct_cab_folder_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 8, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructCabFolder failed read of 0x%x: ", (guint) 8);
        return NULL;
    }
    if (st->buf->len != 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructCabFolder requested 0x%x and got 0x%x",
                    (guint) 8,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_cab_folder_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_cab_header_ref: (skip):
 **/
FuStructCabHeader *
fu_struct_cab_header_ref(FuStructCabHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_cab_header_unref: (skip):
 **/
void
fu_struct_cab_header_unref(FuStructCabHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCabHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructCabHeader *
fu_struct_cab_header_new_internal(void)
{
    FuStructCabHeader *st = g_new0(FuStructCabHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_cab_header_get_signature: (skip):
 **/
static gchar *
fu_struct_cab_header_get_signature(const FuStructCabHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 4, NULL);
}
/**
 * fu_struct_cab_header_get_size: (skip):
 **/
guint32
fu_struct_cab_header_get_size(const FuStructCabHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_get_off_cffile: (skip):
 **/
guint32
fu_struct_cab_header_get_off_cffile(const FuStructCabHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_get_version_minor: (skip):
 **/
static guint8
fu_struct_cab_header_get_version_minor(const FuStructCabHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[24];
}
/**
 * fu_struct_cab_header_get_version_major: (skip):
 **/
static guint8
fu_struct_cab_header_get_version_major(const FuStructCabHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[25];
}
/**
 * fu_struct_cab_header_get_nr_folders: (skip):
 **/
guint16
fu_struct_cab_header_get_nr_folders(const FuStructCabHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 26, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_get_nr_files: (skip):
 **/
guint16
fu_struct_cab_header_get_nr_files(const FuStructCabHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_get_flags: (skip):
 **/
guint16
fu_struct_cab_header_get_flags(const FuStructCabHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 30, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_get_set_id: (skip):
 **/
guint16
fu_struct_cab_header_get_set_id(const FuStructCabHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_get_idx_cabinet: (skip):
 **/
guint16
fu_struct_cab_header_get_idx_cabinet(const FuStructCabHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 34, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_cab_header_set_signature: (skip):
 **/
static gboolean
fu_struct_cab_header_set_signature(FuStructCabHeader *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 0, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructCabHeader.signature (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_cab_header_set_size: (skip):
 **/
void
fu_struct_cab_header_set_size(FuStructCabHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_set_off_cffile: (skip):
 **/
void
fu_struct_cab_header_set_off_cffile(FuStructCabHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_set_version_minor: (skip):
 **/
static void
fu_struct_cab_header_set_version_minor(FuStructCabHeader *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[24] = value;
}
/**
 * fu_struct_cab_header_set_version_major: (skip):
 **/
static void
fu_struct_cab_header_set_version_major(FuStructCabHeader *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[25] = value;
}
/**
 * fu_struct_cab_header_set_nr_folders: (skip):
 **/
void
fu_struct_cab_header_set_nr_folders(FuStructCabHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 26, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_set_nr_files: (skip):
 **/
void
fu_struct_cab_header_set_nr_files(FuStructCabHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_set_flags: (skip):
 **/
void
fu_struct_cab_header_set_flags(FuStructCabHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 30, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_set_set_id: (skip):
 **/
void
fu_struct_cab_header_set_set_id(FuStructCabHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 32, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_set_idx_cabinet: (skip):
 **/
void
fu_struct_cab_header_set_idx_cabinet(FuStructCabHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 34, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_new: (skip):
 **/
FuStructCabHeader *
fu_struct_cab_header_new(void)
{
    FuStructCabHeader *st = fu_struct_cab_header_new_internal();
    st->buf = g_byte_array_sized_new(36);
    fu_byte_array_set_size(st->buf, 36, 0x0);
    fu_struct_cab_header_set_signature(st, "MSCF", NULL);
    fu_struct_cab_header_set_version_minor(st, 3);
    fu_struct_cab_header_set_version_major(st, 1);
    fu_struct_cab_header_set_nr_folders(st, 1);
    return st;
}
/**
 * fu_struct_cab_header_to_string: (skip):
 **/
static gchar *
fu_struct_cab_header_to_string(const FuStructCabHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructCabHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_cab_header_get_size(st));
    g_string_append_printf(str, "  off_cffile: 0x%x\n",
                           (guint) fu_struct_cab_header_get_off_cffile(st));
    g_string_append_printf(str, "  nr_folders: 0x%x\n",
                           (guint) fu_struct_cab_header_get_nr_folders(st));
    g_string_append_printf(str, "  nr_files: 0x%x\n",
                           (guint) fu_struct_cab_header_get_nr_files(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_cab_header_get_flags(st));
    g_string_append_printf(str, "  set_id: 0x%x\n",
                           (guint) fu_struct_cab_header_get_set_id(st));
    g_string_append_printf(str, "  idx_cabinet: 0x%x\n",
                           (guint) fu_struct_cab_header_get_idx_cabinet(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_cab_header_validate_internal(FuStructCabHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "MSCF", 4) != 0) {
        g_autofree gchar *str = fu_struct_cab_header_get_signature(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructCabHeader.signature was not valid, "
                    "expected 'MSCF' and got '%s'",
                    str);
        return FALSE;
    }
    if (fu_struct_cab_header_get_version_minor(st) != 3) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructCabHeader.version_minor was not valid");
        return FALSE;
    }
    if (fu_struct_cab_header_get_version_major(st) != 1) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructCabHeader.version_major was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_cab_header_validate_stream: (skip):
 **/
gboolean
fu_struct_cab_header_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructCabHeader) st = fu_struct_cab_header_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 36, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructCabHeader failed read of 0x%x: ", (guint) 36);
        return FALSE;
    }
    if (st->buf->len != 36) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructCabHeader requested 0x%x and got 0x%x",
                    (guint) 36,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_cab_header_validate_internal(st, error);
}
static gboolean
fu_struct_cab_header_parse_internal(FuStructCabHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_cab_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_cab_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_cab_header_parse_stream: (skip):
 **/
FuStructCabHeader *
fu_struct_cab_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructCabHeader) st = fu_struct_cab_header_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 36, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructCabHeader failed read of 0x%x: ", (guint) 36);
        return NULL;
    }
    if (st->buf->len != 36) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructCabHeader requested 0x%x and got 0x%x",
                    (guint) 36,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_cab_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_cab_header_reserve_ref: (skip):
 **/
FuStructCabHeaderReserve *
fu_struct_cab_header_reserve_ref(FuStructCabHeaderReserve *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_cab_header_reserve_unref: (skip):
 **/
void
fu_struct_cab_header_reserve_unref(FuStructCabHeaderReserve *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCabHeaderReserve refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructCabHeaderReserve *
fu_struct_cab_header_reserve_new_internal(void)
{
    FuStructCabHeaderReserve *st = g_new0(FuStructCabHeaderReserve, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_cab_header_reserve_get_rsvd_hdr: (skip):
 **/
guint16
fu_struct_cab_header_reserve_get_rsvd_hdr(const FuStructCabHeaderReserve *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_reserve_get_rsvd_folder: (skip):
 **/
guint8
fu_struct_cab_header_reserve_get_rsvd_folder(const FuStructCabHeaderReserve *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_cab_header_reserve_get_rsvd_block: (skip):
 **/
guint8
fu_struct_cab_header_reserve_get_rsvd_block(const FuStructCabHeaderReserve *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}

/* setters */
/**
 * fu_struct_cab_header_reserve_set_rsvd_hdr: (skip):
 **/
void
fu_struct_cab_header_reserve_set_rsvd_hdr(FuStructCabHeaderReserve *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_reserve_set_rsvd_folder: (skip):
 **/
void
fu_struct_cab_header_reserve_set_rsvd_folder(FuStructCabHeaderReserve *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_cab_header_reserve_set_rsvd_block: (skip):
 **/
void
fu_struct_cab_header_reserve_set_rsvd_block(FuStructCabHeaderReserve *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_cab_header_reserve_new: (skip):
 **/
FuStructCabHeaderReserve *
fu_struct_cab_header_reserve_new(void)
{
    FuStructCabHeaderReserve *st = fu_struct_cab_header_reserve_new_internal();
    st->buf = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st->buf, 4, 0x0);
    return st;
}
/**
 * fu_struct_cab_header_reserve_to_string: (skip):
 **/
static gchar *
fu_struct_cab_header_reserve_to_string(const FuStructCabHeaderReserve *st)
{
    g_autoptr(GString) str = g_string_new("FuStructCabHeaderReserve:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  rsvd_hdr: 0x%x\n",
                           (guint) fu_struct_cab_header_reserve_get_rsvd_hdr(st));
    g_string_append_printf(str, "  rsvd_folder: 0x%x\n",
                           (guint) fu_struct_cab_header_reserve_get_rsvd_folder(st));
    g_string_append_printf(str, "  rsvd_block: 0x%x\n",
                           (guint) fu_struct_cab_header_reserve_get_rsvd_block(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_cab_header_reserve_validate_internal(FuStructCabHeaderReserve *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_cab_header_reserve_parse_internal(FuStructCabHeaderReserve *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_cab_header_reserve_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_cab_header_reserve_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_cab_header_reserve_parse_stream: (skip):
 **/
FuStructCabHeaderReserve *
fu_struct_cab_header_reserve_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructCabHeaderReserve) st = fu_struct_cab_header_reserve_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 4, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructCabHeaderReserve failed read of 0x%x: ", (guint) 4);
        return NULL;
    }
    if (st->buf->len != 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructCabHeaderReserve requested 0x%x and got 0x%x",
                    (guint) 4,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_cab_header_reserve_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
