/* calculator-plugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from calculator-plugin.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include "slingshot.h"
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SYNAPSE_CALCULATOR_PLUGIN_0_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_calculator_plugin_properties[SYNAPSE_CALCULATOR_PLUGIN_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT (synapse_calculator_plugin_result_get_type ())
#define SYNAPSE_CALCULATOR_PLUGIN_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResult))
#define SYNAPSE_CALCULATOR_PLUGIN_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResultClass))
#define SYNAPSE_CALCULATOR_PLUGIN_IS_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT))
#define SYNAPSE_CALCULATOR_PLUGIN_IS_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT))
#define SYNAPSE_CALCULATOR_PLUGIN_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResultClass))

typedef struct _SynapseCalculatorPluginResult SynapseCalculatorPluginResult;
typedef struct _SynapseCalculatorPluginResultClass SynapseCalculatorPluginResultClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseCalculatorPluginSearchData SynapseCalculatorPluginSearchData;
typedef struct _SynapseCalculatorPluginResultPrivate SynapseCalculatorPluginResultPrivate;
enum  {
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_0_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_TEXT_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_TEXT_ORIGIN_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_NUM_PROPERTIES
};
static GParamSpec* synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_NUM_PROPERTIES];

struct _SynapseCalculatorPluginPrivate {
	gboolean _enabled;
	GRegex* regex;
};

struct _SynapseCalculatorPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseCalculatorPlugin* self;
	SynapseQuery query;
	SynapseResultSet* result;
	gchar* input;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean matched;
	GRegex* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gchar* _tmp16_;
	GRegex* _tmp17_;
	const gchar* _tmp18_;
	GPid pid;
	gint read_fd;
	gint write_fd;
	gchar** argv;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gint argv_length1;
	gint _argv_size_;
	gchar* solution;
	gchar** _tmp22_;
	gint _tmp22__length1;
	GPid _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GUnixInputStream* read_stream;
	GUnixInputStream* _tmp26_;
	GDataInputStream* bc_output;
	GUnixInputStream* _tmp27_;
	GDataInputStream* _tmp28_;
	GUnixOutputStream* write_stream;
	GUnixOutputStream* _tmp29_;
	GDataOutputStream* bc_input;
	GUnixOutputStream* _tmp30_;
	GDataOutputStream* _tmp31_;
	GDataOutputStream* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	SynapseQuery _tmp36_;
	GCancellable* _tmp37_;
	GDataOutputStream* _tmp38_;
	SynapseQuery _tmp39_;
	GCancellable* _tmp40_;
	gchar* _tmp41_;
	GDataInputStream* _tmp42_;
	SynapseQuery _tmp43_;
	GCancellable* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	gdouble d;
	const gchar* _tmp48_;
	SynapseCalculatorPluginResult* _result_;
	SynapseQuery _tmp49_;
	const gchar* _tmp50_;
	SynapseCalculatorPluginResult* _tmp51_;
	SynapseCalculatorPluginResult* _tmp52_;
	SynapseQuery _tmp53_;
	const gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp61_;
	SynapseResultSet* _tmp62_;
	SynapseCalculatorPluginResult* _tmp63_;
	GError* err;
	GError* _tmp64_;
	const gchar* _tmp65_;
	GError* _inner_error0_;
};

struct _SynapseCalculatorPluginResult {
	SynapseMatch parent_instance;
	SynapseCalculatorPluginResultPrivate * priv;
};

struct _SynapseCalculatorPluginResultClass {
	SynapseMatchClass parent_class;
};

struct _SynapseCalculatorPluginResultPrivate {
	gint _default_relevancy;
	gchar* _text;
	SynapseTextOrigin _text_origin;
};

static gint SynapseCalculatorPlugin_private_offset;
static gpointer synapse_calculator_plugin_parent_class = NULL;
static gint SynapseCalculatorPluginResult_private_offset;
static gpointer synapse_calculator_plugin_result_parent_class = NULL;
static SynapseTextMatchIface * synapse_calculator_plugin_result_synapse_text_match_parent_iface = NULL;
static GType synapse_calculator_plugin_result_type_id = 0;
static SynapseActivatableIface * synapse_calculator_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_calculator_plugin_synapse_item_provider_parent_iface = NULL;
static GType synapse_calculator_plugin_type_id = 0;

static void synapse_calculator_plugin_real_activate (SynapseActivatable* base);
static void synapse_calculator_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_calculator_plugin_register_plugin (void);
static void _synapse_calculator_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_calculator_plugin_real_handles_query (SynapseItemProvider* base,
                                                       SynapseQuery* query);
static void synapse_calculator_plugin_real_search_data_free (gpointer _data);
static void synapse_calculator_plugin_real_search (SynapseItemProvider* base,
                                            SynapseQuery* query,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gboolean synapse_calculator_plugin_real_search_co (SynapseCalculatorPluginSearchData* _data_);
static void synapse_calculator_plugin_search_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
GType synapse_calculator_plugin_result_register_type (GTypeModule * module);
VALA_EXTERN GType synapse_calculator_plugin_result_get_type (void) G_GNUC_CONST ;
static SynapseCalculatorPluginResult* synapse_calculator_plugin_result_new (gdouble _result_,
                                                                     const gchar* match_string);
static SynapseCalculatorPluginResult* synapse_calculator_plugin_result_construct (GType object_type,
                                                                           gdouble _result_,
                                                                           const gchar* match_string);
static gint synapse_calculator_plugin_result_get_default_relevancy (SynapseCalculatorPluginResult* self);
static void synapse_calculator_plugin_result_set_default_relevancy (SynapseCalculatorPluginResult* self,
                                                             gint value);
static void synapse_calculator_plugin_result_finalize (GObject * obj);
static void _vala_synapse_calculator_plugin_result_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_synapse_calculator_plugin_result_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static GObject * synapse_calculator_plugin_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void synapse_calculator_plugin_finalize (GObject * obj);
static void _vala_synapse_calculator_plugin_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_synapse_calculator_plugin_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
synapse_calculator_plugin_get_instance_private (SynapseCalculatorPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCalculatorPlugin_private_offset);
}

static void
synapse_calculator_plugin_real_activate (SynapseActivatable* base)
{
	SynapseCalculatorPlugin * self;
	self = (SynapseCalculatorPlugin*) base;
}

static void
synapse_calculator_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseCalculatorPlugin * self;
	self = (SynapseCalculatorPlugin*) base;
}

static void
_synapse_calculator_plugin_register_plugin_synapse_plugin_register_func (void)
{
	synapse_calculator_plugin_register_plugin ();
}

static void
synapse_calculator_plugin_register_plugin (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_;
	SynapseDataSinkPluginRegistry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_find_program_in_path ("bc");
	_tmp3_ = _tmp2_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_CALCULATOR_PLUGIN, _ ("Calculator"), _ ("Calculate basic expressions."), "accessories-calculator", _synapse_calculator_plugin_register_plugin_synapse_plugin_register_func, _tmp3_ != NULL, _ ("bc is not installed"));
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
}

static gboolean
synapse_calculator_plugin_real_handles_query (SynapseItemProvider* base,
                                              SynapseQuery* query)
{
	SynapseCalculatorPlugin * self;
	SynapseQuery _tmp0_;
	gboolean result;
	self = (SynapseCalculatorPlugin*) base;
	g_return_val_if_fail (query != NULL, FALSE);
	_tmp0_ = *query;
	result = (_tmp0_.query_type & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS;
	return result;
}

static void
synapse_calculator_plugin_real_search_data_free (gpointer _data)
{
	SynapseCalculatorPluginSearchData* _data_;
	_data_ = _data;
	synapse_query_destroy (&_data_->query);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseCalculatorPluginSearchData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
synapse_calculator_plugin_real_search (SynapseItemProvider* base,
                                       SynapseQuery* query,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	SynapseCalculatorPlugin * self;
	SynapseCalculatorPluginSearchData* _data_;
	SynapseCalculatorPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
	g_return_if_fail (query != NULL);
	self = (SynapseCalculatorPlugin*) base;
	_data_ = g_slice_new0 (SynapseCalculatorPluginSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_calculator_plugin_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = *query;
	_tmp2_ = _tmp1_;
	synapse_query_copy (&_tmp2_, &_tmp3_);
	synapse_query_destroy (&_data_->query);
	_data_->query = _tmp3_;
	synapse_calculator_plugin_real_search_co (_data_);
}

static SynapseResultSet*
synapse_calculator_plugin_search_finish (SynapseItemProvider* base,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	SynapseResultSet* result;
	SynapseCalculatorPluginSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
synapse_calculator_plugin_search_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	SynapseCalculatorPluginSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	synapse_calculator_plugin_real_search_co (_data_);
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gboolean
synapse_calculator_plugin_real_search_co (SynapseCalculatorPluginSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->query;
	_data_->_tmp1_ = _data_->_tmp0_.query_string;
	_data_->_tmp2_ = string_replace (_data_->_tmp1_, " ", "");
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = string_replace (_data_->_tmp3_, ",", ".");
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_free0 (_data_->_tmp3_);
	_data_->input = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->self->priv->regex;
	_data_->_tmp7_ = _data_->input;
	_data_->matched = g_regex_match (_data_->_tmp6_, _data_->_tmp7_, 0, NULL);
	if (!_data_->matched) {
		_data_->_tmp9_ = _data_->input;
		_data_->_tmp10_ = strlen (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp8_ = _data_->_tmp11_ > 1;
	} else {
		_data_->_tmp8_ = FALSE;
	}
	if (_data_->_tmp8_) {
		_data_->_tmp12_ = _data_->input;
		_data_->_tmp13_ = _data_->input;
		_data_->_tmp14_ = strlen (_data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = string_slice (_data_->_tmp12_, (glong) 0, (glong) (_data_->_tmp15_ - 1));
		_g_free0 (_data_->input);
		_data_->input = _data_->_tmp16_;
		_data_->_tmp17_ = _data_->self->priv->regex;
		_data_->_tmp18_ = _data_->input;
		_data_->matched = g_regex_match (_data_->_tmp17_, _data_->_tmp18_, 0, NULL);
	}
	if (_data_->matched) {
		_data_->_tmp19_ = g_strdup ("bc");
		_data_->_tmp20_ = g_strdup ("-l");
		_data_->_tmp21_ = g_new0 (gchar*, 2 + 1);
		_data_->_tmp21_[0] = _data_->_tmp19_;
		_data_->_tmp21_[1] = _data_->_tmp20_;
		_data_->argv = _data_->_tmp21_;
		_data_->argv_length1 = 2;
		_data_->_argv_size_ = _data_->argv_length1;
		_data_->solution = NULL;
		{
			_data_->_tmp22_ = _data_->argv;
			_data_->_tmp22__length1 = _data_->argv_length1;
			_data_->_tmp23_ = 0;
			_data_->_tmp24_ = 0;
			_data_->_tmp25_ = 0;
			g_spawn_async_with_pipes (NULL, _data_->_tmp22_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_data_->_tmp23_, &_data_->_tmp24_, &_data_->_tmp25_, NULL, &_data_->_inner_error0_);
			_data_->pid = _data_->_tmp23_;
			_data_->write_fd = _data_->_tmp24_;
			_data_->read_fd = _data_->_tmp25_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp26_ = (GUnixInputStream*) g_unix_input_stream_new (_data_->read_fd, TRUE);
			_data_->read_stream = _data_->_tmp26_;
			_data_->_tmp27_ = _data_->read_stream;
			_data_->_tmp28_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp27_);
			_data_->bc_output = _data_->_tmp28_;
			_data_->_tmp29_ = (GUnixOutputStream*) g_unix_output_stream_new (_data_->write_fd, TRUE);
			_data_->write_stream = _data_->_tmp29_;
			_data_->_tmp30_ = _data_->write_stream;
			_data_->_tmp31_ = g_data_output_stream_new ((GOutputStream*) _data_->_tmp30_);
			_data_->bc_input = _data_->_tmp31_;
			_data_->_tmp32_ = _data_->bc_input;
			_data_->_tmp33_ = _data_->input;
			_data_->_tmp34_ = g_strconcat (_data_->_tmp33_, "\n", NULL);
			_data_->_tmp35_ = _data_->_tmp34_;
			_data_->_tmp36_ = _data_->query;
			_data_->_tmp37_ = _data_->_tmp36_.cancellable;
			g_data_output_stream_put_string (_data_->_tmp32_, _data_->_tmp35_, _data_->_tmp37_, &_data_->_inner_error0_);
			_g_free0 (_data_->_tmp35_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->bc_input);
				_g_object_unref0 (_data_->write_stream);
				_g_object_unref0 (_data_->bc_output);
				_g_object_unref0 (_data_->read_stream);
				goto __catch0_g_error;
			}
			_data_->_tmp38_ = _data_->bc_input;
			_data_->_tmp39_ = _data_->query;
			_data_->_tmp40_ = _data_->_tmp39_.cancellable;
			_data_->_state_ = 1;
			g_output_stream_close_async ((GOutputStream*) _data_->_tmp38_, G_PRIORITY_DEFAULT, _data_->_tmp40_, synapse_calculator_plugin_search_ready, _data_);
			return FALSE;
			_state_1:
			g_output_stream_close_finish ((GOutputStream*) _data_->_tmp38_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->bc_input);
				_g_object_unref0 (_data_->write_stream);
				_g_object_unref0 (_data_->bc_output);
				_g_object_unref0 (_data_->read_stream);
				goto __catch0_g_error;
			}
			_data_->_tmp42_ = _data_->bc_output;
			_data_->_tmp43_ = _data_->query;
			_data_->_tmp44_ = _data_->_tmp43_.cancellable;
			_data_->_state_ = 2;
			g_data_input_stream_read_line_async (_data_->_tmp42_, G_PRIORITY_DEFAULT_IDLE, _data_->_tmp44_, synapse_calculator_plugin_search_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp45_ = g_data_input_stream_read_line_finish (_data_->_tmp42_, _data_->_res_, NULL, &_data_->_inner_error0_);
			_data_->_tmp41_ = _data_->_tmp45_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->bc_input);
				_g_object_unref0 (_data_->write_stream);
				_g_object_unref0 (_data_->bc_output);
				_g_object_unref0 (_data_->read_stream);
				goto __catch0_g_error;
			}
			_data_->_tmp46_ = _data_->_tmp41_;
			_data_->_tmp41_ = NULL;
			_g_free0 (_data_->solution);
			_data_->solution = _data_->_tmp46_;
			_data_->_tmp47_ = _data_->solution;
			if (_data_->_tmp47_ != NULL) {
				_data_->_tmp48_ = _data_->solution;
				_data_->d = double_parse (_data_->_tmp48_);
				_data_->_tmp49_ = _data_->query;
				_data_->_tmp50_ = _data_->_tmp49_.query_string;
				_data_->_tmp51_ = synapse_calculator_plugin_result_new (_data_->d, _data_->_tmp50_);
				_data_->_result_ = _data_->_tmp51_;
				_data_->_tmp52_ = _data_->_result_;
				_data_->_tmp53_ = _data_->query;
				_data_->_tmp54_ = _data_->_tmp53_.query_string;
				_data_->_tmp55_ = g_strdup_printf ("%s = %g", _data_->_tmp54_, _data_->d);
				_data_->_tmp56_ = _data_->_tmp55_;
				_data_->_tmp57_ = g_strdup_printf ("<span weight=\"600\" size=\"smaller\" alpha=\"75%\">%s</span>", _ ("Click to copy result to clipboard"));
				_data_->_tmp58_ = _data_->_tmp57_;
				_data_->_tmp59_ = g_strdup_printf ("%s\n%s", _data_->_tmp56_, _data_->_tmp58_);
				_data_->_tmp60_ = _data_->_tmp59_;
				synapse_match_set_description ((SynapseMatch*) _data_->_tmp52_, _data_->_tmp60_);
				_g_free0 (_data_->_tmp60_);
				_g_free0 (_data_->_tmp58_);
				_g_free0 (_data_->_tmp56_);
				_data_->_tmp61_ = synapse_result_set_new ();
				_data_->results = _data_->_tmp61_;
				_data_->_tmp62_ = _data_->results;
				_data_->_tmp63_ = _data_->_result_;
				synapse_result_set_add (_data_->_tmp62_, (SynapseMatch*) _data_->_tmp63_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
				synapse_query_check_cancellable (&_data_->query, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->results);
					_g_object_unref0 (_data_->_result_);
					_g_free0 (_data_->_tmp41_);
					_g_object_unref0 (_data_->bc_input);
					_g_object_unref0 (_data_->write_stream);
					_g_object_unref0 (_data_->bc_output);
					_g_object_unref0 (_data_->read_stream);
					goto __catch0_g_error;
				}
				_data_->result = _data_->results;
				_g_object_unref0 (_data_->_result_);
				_g_free0 (_data_->_tmp41_);
				_g_object_unref0 (_data_->bc_input);
				_g_object_unref0 (_data_->write_stream);
				_g_object_unref0 (_data_->bc_output);
				_g_object_unref0 (_data_->read_stream);
				_g_free0 (_data_->solution);
				_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->input);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_free0 (_data_->_tmp41_);
			_g_object_unref0 (_data_->bc_input);
			_g_object_unref0 (_data_->write_stream);
			_g_object_unref0 (_data_->bc_output);
			_g_object_unref0 (_data_->read_stream);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			if (!synapse_query_is_cancelled (&_data_->query)) {
				_data_->_tmp64_ = _data_->err;
				_data_->_tmp65_ = _data_->_tmp64_->message;
				g_warning ("calculator-plugin.vala:138: %s", _data_->_tmp65_);
			}
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_free0 (_data_->solution);
				_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->input);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_free0 (_data_->solution);
				_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->input);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_g_free0 (_data_->solution);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
	}
	synapse_query_check_cancellable (&_data_->query, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->input);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->input);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = NULL;
	_g_free0 (_data_->input);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SynapseCalculatorPlugin*
synapse_calculator_plugin_construct (GType object_type)
{
	SynapseCalculatorPlugin * self = NULL;
	self = (SynapseCalculatorPlugin*) g_object_new (object_type, NULL);
	return self;
}

SynapseCalculatorPlugin*
synapse_calculator_plugin_new (void)
{
	return synapse_calculator_plugin_construct (SYNAPSE_TYPE_CALCULATOR_PLUGIN);
}

static gboolean
synapse_calculator_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseCalculatorPlugin* self;
	self = (SynapseCalculatorPlugin*) base;
	result = self->priv->_enabled;
	return result;
}

static void
synapse_calculator_plugin_real_set_enabled (SynapseActivatable* base,
                                            gboolean value)
{
	SynapseCalculatorPlugin* self;
	gboolean old_value;
	self = (SynapseCalculatorPlugin*) base;
	old_value = synapse_calculator_plugin_real_get_enabled (base);
	if (old_value != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_calculator_plugin_properties[SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY]);
	}
}

static inline gpointer
synapse_calculator_plugin_result_get_instance_private (SynapseCalculatorPluginResult* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCalculatorPluginResult_private_offset);
}

static SynapseCalculatorPluginResult*
synapse_calculator_plugin_result_construct (GType object_type,
                                            gdouble _result_,
                                            const gchar* match_string)
{
	SynapseCalculatorPluginResult * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (match_string != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%g", _result_);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%g", _result_);
	_tmp3_ = _tmp2_;
	self = (SynapseCalculatorPluginResult*) g_object_new (object_type, "match-type", SYNAPSE_MATCH_TYPE_TEXT, "text", _tmp1_, "title", _tmp3_, "icon-name", "accessories-calculator", "text-origin", SYNAPSE_TEXT_ORIGIN_UNKNOWN, NULL);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	return self;
}

static SynapseCalculatorPluginResult*
synapse_calculator_plugin_result_new (gdouble _result_,
                                      const gchar* match_string)
{
	return synapse_calculator_plugin_result_construct (SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, _result_, match_string);
}

static gint
synapse_calculator_plugin_result_get_default_relevancy (SynapseCalculatorPluginResult* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_default_relevancy;
	return result;
}

static void
synapse_calculator_plugin_result_set_default_relevancy (SynapseCalculatorPluginResult* self,
                                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_calculator_plugin_result_get_default_relevancy (self);
	if (old_value != value) {
		self->priv->_default_relevancy = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY]);
	}
}

static const gchar*
synapse_calculator_plugin_result_real_get_text (SynapseTextMatch* base)
{
	const gchar* result;
	SynapseCalculatorPluginResult* self;
	const gchar* _tmp0_;
	self = (SynapseCalculatorPluginResult*) base;
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

static void
synapse_calculator_plugin_result_real_set_text (SynapseTextMatch* base,
                                                const gchar* value)
{
	SynapseCalculatorPluginResult* self;
	gchar* old_value;
	self = (SynapseCalculatorPluginResult*) base;
	old_value = synapse_calculator_plugin_result_real_get_text (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_TEXT_PROPERTY]);
	}
}

static SynapseTextOrigin
synapse_calculator_plugin_result_real_get_text_origin (SynapseTextMatch* base)
{
	SynapseTextOrigin result;
	SynapseCalculatorPluginResult* self;
	self = (SynapseCalculatorPluginResult*) base;
	result = self->priv->_text_origin;
	return result;
}

static void
synapse_calculator_plugin_result_real_set_text_origin (SynapseTextMatch* base,
                                                       SynapseTextOrigin value)
{
	SynapseCalculatorPluginResult* self;
	SynapseTextOrigin old_value;
	self = (SynapseCalculatorPluginResult*) base;
	old_value = synapse_calculator_plugin_result_real_get_text_origin (base);
	if (old_value != value) {
		self->priv->_text_origin = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_TEXT_ORIGIN_PROPERTY]);
	}
}

static void
synapse_calculator_plugin_result_class_init (SynapseCalculatorPluginResultClass * klass,
                                             gpointer klass_data)
{
	synapse_calculator_plugin_result_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseCalculatorPluginResult_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_calculator_plugin_result_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_calculator_plugin_result_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_calculator_plugin_result_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_TEXT_PROPERTY, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_TEXT_ORIGIN_PROPERTY, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_TEXT_ORIGIN_PROPERTY] = g_param_spec_enum ("text-origin", "text-origin", "text-origin", SYNAPSE_TYPE_TEXT_ORIGIN, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
synapse_calculator_plugin_result_synapse_text_match_interface_init (SynapseTextMatchIface * iface,
                                                                    gpointer iface_data)
{
	synapse_calculator_plugin_result_synapse_text_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_text = synapse_calculator_plugin_result_real_get_text;
	iface->set_text = synapse_calculator_plugin_result_real_set_text;
	iface->get_text_origin = synapse_calculator_plugin_result_real_get_text_origin;
	iface->set_text_origin = synapse_calculator_plugin_result_real_set_text_origin;
}

static void
synapse_calculator_plugin_result_instance_init (SynapseCalculatorPluginResult * self,
                                                gpointer klass)
{
	gchar* _tmp0_;
	self->priv = synapse_calculator_plugin_result_get_instance_private (self);
	self->priv->_default_relevancy = 0;
	_tmp0_ = g_strdup ("");
	self->priv->_text = _tmp0_;
}

static void
synapse_calculator_plugin_result_finalize (GObject * obj)
{
	SynapseCalculatorPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResult);
	_g_free0 (self->priv->_text);
	G_OBJECT_CLASS (synapse_calculator_plugin_result_parent_class)->finalize (obj);
}

GType
synapse_calculator_plugin_result_get_type (void)
{
	return synapse_calculator_plugin_result_type_id;
}

GType
synapse_calculator_plugin_result_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCalculatorPluginResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_calculator_plugin_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCalculatorPluginResult), 0, (GInstanceInitFunc) synapse_calculator_plugin_result_instance_init, NULL };
	static const GInterfaceInfo synapse_text_match_info = { (GInterfaceInitFunc) synapse_calculator_plugin_result_synapse_text_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	synapse_calculator_plugin_result_type_id = g_type_module_register_type (module, SYNAPSE_TYPE_MATCH, "SynapseCalculatorPluginResult", &g_define_type_info, 0);
	g_type_module_add_interface (module, synapse_calculator_plugin_result_type_id, SYNAPSE_TYPE_TEXT_MATCH, &synapse_text_match_info);
	SynapseCalculatorPluginResult_private_offset = sizeof (SynapseCalculatorPluginResultPrivate);
	return synapse_calculator_plugin_result_type_id;
}

static void
_vala_synapse_calculator_plugin_result_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	SynapseCalculatorPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResult);
	switch (property_id) {
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
		g_value_set_int (value, synapse_calculator_plugin_result_get_default_relevancy (self));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_TEXT_PROPERTY:
		g_value_set_string (value, synapse_text_match_get_text ((SynapseTextMatch*) self));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_TEXT_ORIGIN_PROPERTY:
		g_value_set_enum (value, synapse_text_match_get_text_origin ((SynapseTextMatch*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_calculator_plugin_result_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	SynapseCalculatorPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResult);
	switch (property_id) {
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
		synapse_calculator_plugin_result_set_default_relevancy (self, g_value_get_int (value));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_TEXT_PROPERTY:
		synapse_text_match_set_text ((SynapseTextMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_TEXT_ORIGIN_PROPERTY:
		synapse_text_match_set_text_origin ((SynapseTextMatch*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
synapse_calculator_plugin_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCalculatorPlugin * self;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (synapse_calculator_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin);
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new ("^\\(*(-?([.,]\\d+)?)([*/+-^]\\(*(-?([.,]\\d+)?)\\)*)+$", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (self->priv->regex);
		self->priv->regex = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("calculator-plugin.vala:77: Error creating regexp: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
synapse_calculator_plugin_class_init (SynapseCalculatorPluginClass * klass,
                                      gpointer klass_data)
{
	synapse_calculator_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseCalculatorPlugin_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_calculator_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_calculator_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_calculator_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_calculator_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY, synapse_calculator_plugin_properties[SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	synapse_calculator_plugin_register_plugin ();
}

static void
synapse_calculator_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                              gpointer iface_data)
{
	synapse_calculator_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (SynapseActivatable*)) synapse_calculator_plugin_real_activate;
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_calculator_plugin_real_deactivate;
	iface->get_enabled = synapse_calculator_plugin_real_get_enabled;
	iface->set_enabled = synapse_calculator_plugin_real_set_enabled;
}

static void
synapse_calculator_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                                gpointer iface_data)
{
	synapse_calculator_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_calculator_plugin_real_handles_query;
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_calculator_plugin_real_search;
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_calculator_plugin_search_finish;
}

static void
synapse_calculator_plugin_instance_init (SynapseCalculatorPlugin * self,
                                         gpointer klass)
{
	self->priv = synapse_calculator_plugin_get_instance_private (self);
	self->priv->_enabled = TRUE;
}

static void
synapse_calculator_plugin_finalize (GObject * obj)
{
	SynapseCalculatorPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin);
	_g_regex_unref0 (self->priv->regex);
	G_OBJECT_CLASS (synapse_calculator_plugin_parent_class)->finalize (obj);
}

GType
synapse_calculator_plugin_get_type (void)
{
	return synapse_calculator_plugin_type_id;
}

GType
synapse_calculator_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCalculatorPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_calculator_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCalculatorPlugin), 0, (GInstanceInitFunc) synapse_calculator_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_calculator_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_calculator_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	synapse_calculator_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SynapseCalculatorPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, synapse_calculator_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_module_add_interface (module, synapse_calculator_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseCalculatorPlugin_private_offset = sizeof (SynapseCalculatorPluginPrivate);
	return synapse_calculator_plugin_type_id;
}

static void
_vala_synapse_calculator_plugin_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SynapseCalculatorPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin);
	switch (property_id) {
		case SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_calculator_plugin_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SynapseCalculatorPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin);
	switch (property_id) {
		case SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

