﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/apigateway/model/GetBasePathMappingResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::APIGateway::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetBasePathMappingResult::GetBasePathMappingResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

GetBasePathMappingResult& GetBasePathMappingResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("basePath")) {
    m_basePath = jsonValue.GetString("basePath");
    m_basePathHasBeenSet = true;
  }
  if (jsonValue.ValueExists("restApiId")) {
    m_restApiId = jsonValue.GetString("restApiId");
    m_restApiIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("stage")) {
    m_stage = jsonValue.GetString("stage");
    m_stageHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
