
/* VRMLFunc.c generated by VRMLC.pm. DO NOT MODIFY, MODIFY VRMLC.pm INSTEAD */
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glx.h>

#include "OpenGL/OpenGL.m"

#define offset_of(p_type,field) ((unsigned int)(&(((p_type)NULL)->field)-NULL))

#define TC(a,b) glTexCoord2f(a,b)

D_OPENGL;


/* Rearrange to take advantage of headlight when off */
int curlight = 0;
int nlightcodes = 7;
int lightcode[7] = {
	GL_LIGHT1,
	GL_LIGHT2,
	GL_LIGHT3,
	GL_LIGHT4,
	GL_LIGHT5,
	GL_LIGHT6,
	GL_LIGHT7,
};
int nextlight() {
	if(curlight == nlightcodes) { return -1; }
	return lightcode[curlight++];
}

struct VRML_Virt {
	void (*prep)(void *);
	void (*rend)(void *); 
	void (*children)(void *);
	void (*fin)(void *);
	void (*rendray)(void *);
	void (*mkpolyrep)(void *);
	void (*light)(void *);
	/* And get float coordinates : Coordinate, Color */
	/* XXX Relies on MFColor repr.. */
	struct SFColor *(*get3)(void *, int *); /* Number in int */
	char *name;
};

/* Internal representation of IndexedFaceSet, Extrusion & ElevationGrid:
 * set of triangles.
 * done so that we get rid of concave polygons etc.
 */
struct VRML_PolyRep {
	int _change;
	int ntri; /* number of triangles */
	int *cindex;   /* triples (per triangle) */
	float *coord; /* triples (per point) */
	int *colindex;   /* triples (per triangle) */
	float *color; /* triples or null */
	int *norindex;
	float *normal; /* triples or null */
};

struct Multi_Float { int n; float  *p; };struct SFRotation {
 	float r[4]; };struct Multi_Rotation { int n; struct SFRotation  *p; };struct Multi_Vec3f { int n; struct SFColor  *p; };struct Multi_Int32 { int n; int  *p; };struct Multi_Node { int n; void * *p; };struct SFColor {
	float c[3]; };struct Multi_Color { int n; struct SFColor  *p; };struct Multi_String { int n; SV * *p; };struct SFVec2f {
	float c[2]; };struct Multi_Vec2f { int n; struct SFVec2f  *p; };struct VRML_Background {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	int __y_left;
	SV *__data_left;
	int __depth_back;
	struct Multi_String backUrl;
	int __depth_top;
	struct Multi_String topUrl;
	int __y_back;
	int __depth_bottom;
	SV *__data_back;
	int __x_top;
	struct Multi_String bottomUrl;
	int __y_top;
	int __y_bottom;
	float bindTime;
	SV *__data_bottom;
	int __depth_right;
	int __x_right;
	int isBound;
	int __y_right;
	struct Multi_Float groundAngle;
	struct Multi_Color skyColor;
	SV *__data_front;
	int __x_left;
	int __x_back;
	int set_bind;
	SV *__data_top;
	int __x_bottom;
	struct Multi_Color groundColor;
	struct Multi_String rightUrl;
	SV *__data_right;
	int __depth_front;
	struct Multi_String frontUrl;
	int __depth_left;
	struct Multi_String leftUrl;
	struct Multi_Float skyAngle;
	int __x_front;
	int __y_front;
};
struct VRML_Viewpoint {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	float fieldOfView;
	SV *description;
	int isBound;
	struct SFColor position;
	int set_bind;
	float bindTime;
	int jump;
	struct SFRotation orientation;
};
struct VRML_Cone {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	float height;
	float bottomRadius;
	int side;
	int bottom;
};
struct VRML_Text {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	void *fontStyle;
	int __rendersub;
	struct Multi_Float length;
	float maxExtent;
	struct Multi_String string;
};
struct VRML_DirectionalLight {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	struct SFColor direction;
	int on;
	float ambientIntensity;
	struct SFColor color;
	float intensity;
};
struct VRML_Sphere {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	float radius;
};
struct VRML_Coordinate {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	struct Multi_Vec3f point;
};
struct VRML_FontStyle {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	SV *style;
	struct Multi_String family;
	SV *language;
	float spacing;
	int horizontal;
	int topToBottom;
	float size;
	int leftToRight;
	struct Multi_String justify;
};
struct VRML_Normal {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	struct Multi_Vec3f vector;
};
struct VRML_Box {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	struct SFColor size;
};
struct VRML_Billboard {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	struct Multi_Node children;
	struct SFColor axisOfRotation;
	struct SFColor bboxCenter;
	struct SFColor bboxSize;
};
struct VRML_Group {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	struct Multi_Node children;
	struct SFColor bboxCenter;
	struct SFColor bboxSize;
};
struct VRML_ElevationGrid {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	int zDimension;
	void *normal;
	struct Multi_Float height;
	float creaseAngle;
	int solid;
	float xSpacing;
	int xDimension;
	float zSpacing;
	void *color;
};
struct VRML_Material {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	float transparency;
	struct SFColor emissiveColor;
	float shininess;
	struct SFColor diffuseColor;
	struct SFColor specularColor;
	float ambientIntensity;
};
struct VRML_Appearance {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	void *texture;
	void *material;
};
struct VRML_Extrusion {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	int convex;
	struct Multi_Vec2f scale;
	int beginCap;
	float creaseAngle;
	int solid;
	int endCap;
	struct Multi_Rotation orientation;
	int ccw;
	struct Multi_Vec2f crossSection;
	struct Multi_Vec3f spine;
};
struct VRML_Shape {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	void *appearance;
	void *geometry;
};
struct VRML_Switch {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	struct Multi_Node choice;
	int whichChoice;
};
struct VRML_ImageTexture {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	SV *__data;
	struct Multi_String url;
	int __depth;
	int repeatS;
	int repeatT;
	int __x;
	int __y;
};
struct VRML_IndexedLineSet {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	int colorPerVertex;
	void *coord;
	void *color;
	struct Multi_Int32 colorIndex;
	struct Multi_Int32 coordIndex;
};
struct VRML_PointSet {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	void *color;
	void *coord;
};
struct VRML_Cylinder {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	float radius;
	float height;
	int top;
	int side;
	int bottom;
};
struct VRML_Anchor {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	struct Multi_Node children;
	struct Multi_String parameter;
	struct Multi_String url;
	SV *description;
	struct SFColor bboxCenter;
	struct SFColor bboxSize;
};
struct VRML_IndexedFaceSet {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	struct Multi_Int32 texCoordIndex;
	struct Multi_Int32 normalIndex;
	int convex;
	int colorPerVertex;
	void *coord;
	struct Multi_Int32 colorIndex;
	void *texCoord;
	void *normal;
	float creaseAngle;
	int solid;
	int ccw;
	struct Multi_Int32 coordIndex;
	void *color;
};
struct VRML_Transform {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	struct SFRotation rotation;
	struct SFColor center;
	struct SFRotation scaleOrientation;
	struct SFColor bboxSize;
	struct SFColor scale;
	struct Multi_Node children;
	struct SFColor bboxCenter;
	struct SFColor translation;
};
struct VRML_Color {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	struct Multi_Color color;
};
struct VRML_LOD {struct VRML_Virt *v;int _sens;int _hit; 
		int _change; int _dlchange; GLuint _dlist; int _dl2change; GLuint _dl2ist; void *_intern; 
	struct Multi_Node level;
	struct SFColor center;
	struct Multi_Float range;
};


int verbose;

int reverse_trans;
int render_vp; 
int render_geom;
int render_light;
int render_sensitive;

int horiz_div; int vert_div;

int cur_hits=0;

/* These two points define a ray in window coordinates */

struct pt {GLdouble x,y,z;};

struct pt r1 = {0,0,-1},r2 = {0,0,0};
struct pt t_r1,t_r2; /* transformed ray */
void *hypersensitive; int hyperhit;
struct pt hyper_r1,hyper_r2; /* Transformed ray for the hypersensitive node */

GLint viewport[4] = {-1,-1,2,2};

/* These three points define 1. hitpoint 2., 3. two different tangents
 * of the surface at hitpoint (to get transformation correctly */ 

/* All in window coordinates */

struct pt hp, ht1, ht2;
double hpdist; /* distance in ray: 0 = r1, 1 = r2, 2 = 2*r2-r1... */

struct currayhit {
void *node; /* What node hit at that distance? */
GLdouble modelMatrix[16]; /* What the matrices were at that node */
GLdouble projMatrix[16];
} rh,rph;
 /* used to test new hits */

/* defines for raycasting: */
#define APPROX(a,b) (fabs(a-b)<0.00000001)
#define XEQ (APPROX(t_r1.x,t_r2.x))
#define YEQ (APPROX(t_r1.x,t_r2.x))
#define ZEQ (APPROX(t_r1.x,t_r2.x))
/* xrat(a) = ratio to reach coordinate a on axis x */
#define XRAT(a) (((a)-t_r1.x)/(t_r2.x-t_r1.x))
#define YRAT(a) (((a)-t_r1.y)/(t_r2.y-t_r1.y))
#define ZRAT(a) (((a)-t_r1.z)/(t_r2.z-t_r1.z))
/* mratx(r) = x-coordinate gotten by multiplying by given ratio */
#define MRATX(a) (t_r1.x + (a)*(t_r2.x-t_r1.x))
#define MRATY(a) (t_r1.y + (a)*(t_r2.y-t_r1.y))
#define MRATZ(a) (t_r1.z + (a)*(t_r2.z-t_r1.z))
/* trat: test if a ratio is reasonable */
#undef TRAT
#define TRAT(a) 1
#undef TRAT
#define TRAT(a) ((a) > 0 && ((a) < hpdist || hpdist < 0))

#define VECSQ(a) VECPT(a,a)
#define VECPT(a,b) ((a).x*(b).x + (a).y*(b).y + (a).z*(b).z)
#define VECDIFF(a,b,c) {(c).x = (a).x-(b).x;(c).y = (a).y-(b).y;(c).z = (a).z-(b).z;}
#define VEC_FROM_CDIFF(a,b,r) {(r).x = (a).c[0]-(b).c[0];(r).y = (a).c[1]-(b).c[1];(r).z = (a).c[2]-(b).c[2];}
#define VECCP(a,b,c) {(c).x = (a).y*(b).z-(b).y*(a).z; (c).y = -((a).x*(b).z-(b).x*(a).z); (c).z = (a).x*(b).y-(b).x*(a).y;}
#define VECSCALE(a,c) {(a).x *= c; (a).y *= c; (a).z *= c;}
#define HIT rayhit

/* Sub, rather than big macro... */
void rayhit(float rat, float cx,float cy,float cz, float nx,float ny,float nz, 
float tx,float ty, char *descr)  {
	GLdouble modelMatrix[16];
	GLdouble projMatrix[16];
	GLdouble wx, wy, wz;
	/* Real rat-testing */
	if(verbose) printf("RAY HIT %s! %f (%f %f %f) (%f %f %f)\n",
		descr, rat,cx,cy,cz,nx,ny,nz);
	if(rat<0 || (rat>hpdist && hpdist >= 0)) {
		return;
	}
	glGetDoublev(GL_MODELVIEW_MATRIX, modelMatrix);
	glGetDoublev(GL_PROJECTION_MATRIX, projMatrix);
	gluProject(cx,cy,cz, modelMatrix, projMatrix, viewport,
		&hp.x, &hp.y, &hp.z);
	hpdist = rat;
	rh=rph;
}

/* Call this when modelview and projection modified */
void upd_ray() {
	GLdouble modelMatrix[16];
	GLdouble projMatrix[16];
	glGetDoublev(GL_MODELVIEW_MATRIX, modelMatrix);
	glGetDoublev(GL_PROJECTION_MATRIX, projMatrix);
	gluUnProject(r1.x,r1.y,r1.z,modelMatrix,projMatrix,viewport,
		&t_r1.x,&t_r1.y,&t_r1.z);
	gluUnProject(r2.x,r2.y,r2.z,modelMatrix,projMatrix,viewport,
		&t_r2.x,&t_r2.y,&t_r2.z);
/*	printf("Upd_ray: (%f %f %f)->(%f %f %f) == (%f %f %f)->(%f %f %f)\n",
		r1.x,r1.y,r1.z,r2.x,r2.y,r2.z,
		t_r1.x,t_r1.y,t_r1.z,t_r2.x,t_r2.y,t_r2.z);
*/
}


void *what_vp;
int render_anything; /* Turned off when we hit the viewpoint */
void render_node(void *node);
void render_polyrep(void *node, 
	int npoints, struct SFColor *points,
	int ncolors, struct SFColor *colors,
	int nnormals, struct SFColor *normals);
void regen_polyrep(void *node) ;
void calc_poly_normals_flat(struct VRML_PolyRep *rep);
void render_ray_polyrep(void *node,
	int npoints, struct SFColor *points);
	void Background_Rend(void *nod_){
			struct VRML_Background *this_ = (struct VRML_Background *)nod_;
			{
	GLdouble mod[16];
	GLdouble proj[16];
	GLdouble unit[16] = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
	struct pt vec[4]; struct pt vec2[4]; struct pt vec3[4];
	int i,j; int ind=0;
	GLdouble x,y,z;
	GLdouble x1,y1,z1;
	GLdouble sx, sy, sz;
	struct SFColor *c1,*c2;
	int hdiv = horiz_div;
	int h,v;
	double va1, va2, ha1, ha2;


	if(!((this_->isBound))) {return;}
	
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};

	glPushAttrib(GL_LIGHTING_BIT|GL_ENABLE_BIT|GL_TEXTURE_BIT);
	glPushMatrix();

	glGetDoublev(GL_MODELVIEW_MATRIX, mod);
	glGetDoublev(GL_PROJECTION_MATRIX, proj);
	/* Get origin */
	gluUnProject(0,0,0,mod,proj,viewport,&x,&y,&z);
	glTranslatef(x,y,z);


	gluUnProject(0,0,0,mod,unit,viewport,&x,&y,&z);
	/* Get scale */
	gluProject(x+1,y,z,mod,unit,viewport,&x1,&y1,&z1);
	sx = 1/sqrt( x1*x1 + y1*y1 + z1*z1*4 );
	gluProject(x,y+1,z,mod,unit,viewport,&x1,&y1,&z1);
	sy = 1/sqrt( x1*x1 + y1*y1 + z1*z1*4 );
	gluProject(x,y,z+1,mod,unit,viewport,&x1,&y1,&z1);
	sz = 1/sqrt( x1*x1 + y1*y1 + z1*z1*4 );

	/* Undo the translation and scale effects */
	glScalef(sx,sy,sz);
	if(verbose) printf("TS: %f %f %f,      %f %f %f\n",x,y,z,sx,sy,sz);
	glDisable(GL_LIGHTING);

	glScalef(100,100,100);

	glBegin(GL_QUADS);
	for(v=0; v<((this_->skyColor).n); v++) {
		if(v==0) {
			va1 = 0;
		} else {
			va1 = ((this_->skyAngle).p[v-1]);
		}
		c1 = &(((this_->skyColor).p[v]));
		if(v==((this_->skyColor).n)-1) {
			c2 = &(((this_->skyColor).p[v]));
			va2 = 3.142;
		} else {
			c2 = &(((this_->skyColor).p[v+1]));
			va2 = ((this_->skyAngle).p[v]);
		}
		for(h=0; h<hdiv; h++) {
			ha1 = h * 6.29 / hdiv;
			ha2 = (h+1) * 6.29 / hdiv;
			/* glNormal3f(sin(van) * cos(han), sin(van) * sin(han), cos(van)); */
			glColor3f(c2->c[0], c2->c[1], c2->c[2]);
			glVertex3f(sin(va2) * cos(ha1), cos(va2), sin(va2) * sin(ha1));
			glVertex3f(sin(va2) * cos(ha2), cos(va2), sin(va2) * sin(ha2));
			glColor3f(c1->c[0], c1->c[1], c1->c[2]);
			glVertex3f(sin(va1) * cos(ha2), cos(va1), sin(va1) * sin(ha2));
			glVertex3f(sin(va1) * cos(ha1), cos(va1), sin(va1) * sin(ha1));
		}
	}
	glBegin(GL_QUADS);
	for(v=0; v<((this_->groundColor).n); v++) {
		if(v==0) {
			va1 = 0;
		} else {
			va1 = ((this_->groundAngle).p[v-1]);
		}
		c1 = &(((this_->groundColor).p[v]));
		if(v==((this_->groundColor).n)-1) {
			c2 = &(((this_->groundColor).p[v]));
			va2 = 1.56;
		} else {
			c2 = &(((this_->skyColor).p[v+1]));
			va2 = ((this_->skyAngle).p[v]);
		}
		for(h=0; h<hdiv; h++) {
			ha1 = h * 6.29 / hdiv;
			ha2 = (h+1) * 6.29 / hdiv;
			/* glNormal3f(sin(van) * cos(han), sin(van) * sin(han), cos(van)); */
			glColor3f(c2->c[0], c2->c[1], c2->c[2]);
			glVertex3f(sin(va2) * cos(ha1), cos(va2), sin(va2) * sin(ha1));
			glVertex3f(sin(va2) * cos(ha2), cos(va2), sin(va2) * sin(ha2));
			glColor3f(c1->c[0], c1->c[1], c1->c[2]);
			glVertex3f(sin(va1) * cos(ha2), cos(va1), sin(va1) * sin(ha2));
			glVertex3f(sin(va1) * cos(ha1), cos(va1), sin(va1) * sin(ha1));
		}
	}
	glEnd();
	
		{
		float x=0.5,y=0.5,z=0.5;
		unsigned int len;
		unsigned char *ptr = SvPV((this_->__data_front),len);
		if(ptr && len) {

		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
		glDisable(GL_LIGHTING);
		glEnable(GL_TEXTURE_2D);
		glColor3f(1,1,1);
			
		glTexImage2D(GL_TEXTURE_2D,
			     0, 
			     (this_->__depth_front),  
			     (this_->__x_front), (this_->__y_front),
			     0,
			     ((this_->__depth_front)==1 ? GL_LUMINANCE : GL_RGB),
			     GL_UNSIGNED_BYTE,
			     ptr
		);
		glBegin(GL_QUADS);
		glNormal3f(0,0,1);
		TC(1,1);
		glVertex3f(x,y,z);
		TC(0,1);
		glVertex3f(-x,y,z);
		TC(0,0);
		glVertex3f(-x,-y,z);
		TC(1,0);
		glVertex3f(x,-y,z);
		glEnd();
		}
		}
		{
		float x=0.5,y=0.5,z=0.5;
		unsigned int len;
		unsigned char *ptr = SvPV((this_->__data_back),len);
		if(ptr && len) {

		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
		glDisable(GL_LIGHTING);
		glEnable(GL_TEXTURE_2D);
		glColor3f(1,1,1);
			
		glTexImage2D(GL_TEXTURE_2D,
			     0, 
			     (this_->__depth_back),  
			     (this_->__x_back), (this_->__y_back),
			     0,
			     ((this_->__depth_back)==1 ? GL_LUMINANCE : GL_RGB),
			     GL_UNSIGNED_BYTE,
			     ptr
		);
		glBegin(GL_QUADS);
		glNormal3f(0,0,-(1));
		TC(1,1);
		glVertex3f(x,y,-(z));
		TC(0,1);
		glVertex3f(-x,y,-(z));
		TC(0,0);
		glVertex3f(-x,-y,-(z));
		TC(1,0);
		glVertex3f(x,-y,-(z));
		glEnd();
		}
		}
		{
		float x=0.5,y=0.5,z=0.5;
		unsigned int len;
		unsigned char *ptr = SvPV((this_->__data_top),len);
		if(ptr && len) {

		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
		glDisable(GL_LIGHTING);
		glEnable(GL_TEXTURE_2D);
		glColor3f(1,1,1);
			
		glTexImage2D(GL_TEXTURE_2D,
			     0, 
			     (this_->__depth_top),  
			     (this_->__x_top), (this_->__y_top),
			     0,
			     ((this_->__depth_top)==1 ? GL_LUMINANCE : GL_RGB),
			     GL_UNSIGNED_BYTE,
			     ptr
		);
		glBegin(GL_QUADS);
		glNormal3f(0,1,0);
		TC(1,1);
		glVertex3f(x,z,y);
		TC(0,1);
		glVertex3f(-x,z,y);
		TC(0,0);
		glVertex3f(-x,z,-y);
		TC(1,0);
		glVertex3f(x,z,-y);
		glEnd();
		}
		}
		{
		float x=0.5,y=0.5,z=0.5;
		unsigned int len;
		unsigned char *ptr = SvPV((this_->__data_bottom),len);
		if(ptr && len) {

		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
		glDisable(GL_LIGHTING);
		glEnable(GL_TEXTURE_2D);
		glColor3f(1,1,1);
			
		glTexImage2D(GL_TEXTURE_2D,
			     0, 
			     (this_->__depth_bottom),  
			     (this_->__x_bottom), (this_->__y_bottom),
			     0,
			     ((this_->__depth_bottom)==1 ? GL_LUMINANCE : GL_RGB),
			     GL_UNSIGNED_BYTE,
			     ptr
		);
		glBegin(GL_QUADS);
		glNormal3f(0,-(1),0);
		TC(1,1);
		glVertex3f(x,-(z),y);
		TC(0,1);
		glVertex3f(-x,-(z),y);
		TC(0,0);
		glVertex3f(-x,-(z),-y);
		TC(1,0);
		glVertex3f(x,-(z),-y);
		glEnd();
		}
		}
		{
		float x=0.5,y=0.5,z=0.5;
		unsigned int len;
		unsigned char *ptr = SvPV((this_->__data_left),len);
		if(ptr && len) {

		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
		glDisable(GL_LIGHTING);
		glEnable(GL_TEXTURE_2D);
		glColor3f(1,1,1);
			
		glTexImage2D(GL_TEXTURE_2D,
			     0, 
			     (this_->__depth_left),  
			     (this_->__x_left), (this_->__y_left),
			     0,
			     ((this_->__depth_left)==1 ? GL_LUMINANCE : GL_RGB),
			     GL_UNSIGNED_BYTE,
			     ptr
		);
		glBegin(GL_QUADS);
		glNormal3f(1,0,0);
		TC(1,1);
		glVertex3f(z,y,x);
		TC(0,1);
		glVertex3f(z,y,-x);
		TC(0,0);
		glVertex3f(z,-y,-x);
		TC(1,0);
		glVertex3f(z,-y,x);
		glEnd();
		}
		}
		{
		float x=0.5,y=0.5,z=0.5;
		unsigned int len;
		unsigned char *ptr = SvPV((this_->__data_right),len);
		if(ptr && len) {

		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
		glDisable(GL_LIGHTING);
		glEnable(GL_TEXTURE_2D);
		glColor3f(1,1,1);
			
		glTexImage2D(GL_TEXTURE_2D,
			     0, 
			     (this_->__depth_right),  
			     (this_->__x_right), (this_->__y_right),
			     0,
			     ((this_->__depth_right)==1 ? GL_LUMINANCE : GL_RGB),
			     GL_UNSIGNED_BYTE,
			     ptr
		);
		glBegin(GL_QUADS);
		glNormal3f(-(1),0,0);
		TC(1,1);
		glVertex3f(-(z),y,x);
		TC(0,1);
		glVertex3f(-(z),y,-x);
		TC(0,0);
		glVertex3f(-(z),-y,-x);
		TC(1,0);
		glVertex3f(-(z),-y,x);
		glEnd();
		}
		}
	glPopMatrix();
	glPopAttrib();
	
			glEndList()
			;
}
			}void Viewpoint_Prep(void *nod_){
			struct VRML_Viewpoint *this_ = (struct VRML_Viewpoint *)nod_;
			{
	if(render_vp) {
		if(verbose) printf("RENDVIEWP: %d %d\n",this_,what_vp); 
		if(this_ == what_vp) {
		render_anything = 0; /* Stop rendering any more */
		glTranslatef(-(((this_->position).c[0])),-(((this_->position).c[1])),-(((this_->position).c[2]))
		);
		glRotatef(-(((this_->orientation).r[3]))/3.1415926536*180,((this_->orientation).r[0]),((this_->orientation).r[1]),((this_->orientation).r[2])
		);
	/*
#		glMatrixMode(&GL_PROJECTION);
#		glLoadIdentity();
#		gluPerspective($f->{fieldOfView}/3.1415926536*180,1,0.1,10000);
#		glMatrixMode(&GL_MODELVIEW);
	 */
	 	}
	}
}
			}void Cone_Rend(void *nod_){
			struct VRML_Cone *this_ = (struct VRML_Cone *)nod_;
			{
		int div = horiz_div;
		float df = div;
		float h = (this_->height)/2;
		float r = (this_->bottomRadius); 
		float a,a1,a2;
		int i;
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		if(h <= 0 && r <= 0) {return;}
		/* XXX
		glPushAttrib(GL_LIGHTING);
		glShadeModel(GL_FLAT);
		*/
		if(((this_->bottom))) {
			glBegin(GL_POLYGON);
			glNormal3f(0,-1,0);
			for(i=div-1; i>=0; i--) {
				a = i * 6.29 / div;
				TC(0.5+0.5*sin(a),0.5+0.5*cos(a));
				glVertex3f(r*sin(a),-h,r*cos(a));
			}
			glEnd();
		}
		/*
		glShadeModel(GL_SMOOTH);
		*/
		if(((this_->side))) {
			double ml = sqrt(h*h + r * r);
			double mlh = h / ml;
			double mlr = r / ml;
				/* if(!nomode) {
				glPushAttrib(GL_LIGHTING);
				# glShadeModel(GL_SMOOTH);
				} */
			for(i=0; i<div; i++) {
				a = i * 6.29 / div;
				a1 = (i+1) * 6.29 / div;
				a2 = (a+a1)/2;
				glBegin(GL_POLYGON);
				glNormal3f(mlh*sin(a),mlr,mlh*cos(a));
				TC((i+1)/df,0);
				glVertex3f(0,h,0);
				TC(i/df,0);
				glVertex3f(r*sin(a),-h,r*cos(a));
				glNormal3f(mlh*sin(a1),mlr,mlh*cos(a1));
				TC(i/df,1);
				glVertex3f(r*sin(a1),-h,r*cos(a1));
				TC((i+1)/df,1);
				glVertex3f(0,h,0);
				glEnd();
				#ifdef FOOBAR
				glBegin(GL_POLYGON);
				glNormal3f(mlh*sin(a),mlr,mlh*cos(a));
				glVertex3f(0,h,0);
				glVertex3f(0.5*r*sin(a),0,0.5*r*cos(a));
				glNormal3f(mlh*sin(a1),mlr,mlh*cos(a1));
				glVertex3f(0.5*r*sin(a1),0,0.5*r*cos(a1));
				glVertex3f(0,h,0);
				glEnd();
				glBegin(GL_POLYGON);
				glNormal3f(mlh*sin(a),mlr,mlh*cos(a));
				glVertex3f(0.5*r*sin(a),0,0.5*r*cos(a));
				glVertex3f(r*sin(a),-h,r*cos(a));
				glNormal3f(mlh*sin(a1),mlr,mlh*cos(a1));
				glVertex3f(r*sin(a1),-h,r*cos(a1));
				glVertex3f(0.5*r*sin(a1),0,0.5*r*cos(a1));
				glEnd();
				#endif
			}
				/*
				if(!nomode) {
				glPopAttrib();
				}
				*/
		}
		/*
		glPopAttrib();
		*/
		
		
			glEndList()
			;
}
			}void Cone_RendRay(void *nod_){
			struct VRML_Cone *this_ = (struct VRML_Cone *)nod_;
			{
	float h = (this_->height)/2; /* pos and neg dir. */
	float y = h;
	float r = (this_->bottomRadius);
	float dx = t_r2.x-t_r1.x; float dz = t_r2.z-t_r1.z;
	float dy = t_r2.y-t_r1.y;
	float a = dx*dx + dz*dz - (r*r*dy*dy/(2*h*2*h));
	float b = 2*(dx*t_r1.x + dz*t_r1.z) +
		2*r*r*dy/(2*h)*(0.5-t_r1.y/(2*h));
	float tmp = (0.5-t_r1.y/(2*h));
	float c = t_r1.x * t_r1.x + t_r1.z * t_r1.z 
		- r*r*tmp*tmp;
	float und;
	b /= a; c /= a;
	und = b*b - 4*c;
	/* 
	printf("CONSOL0: (%f %f %f) (%f %f %f)\n",
		t_r1.x, t_r1.y, t_r1.z, t_r2.x, t_r2.y, t_r2.z);
	printf("CONSOL: (%f %f %f) (%f) (%f %f) (%f)\n",
		dx, dy, dz, a, b, c, und);
	*/
	if(und > 0) { /* HITS the infinite cylinder */
		float sol1 = (-b+sqrt(und))/2;
		float sol2 = (-b-sqrt(und))/2;
		float cy,cx,cz;
		float cy0;
		cy = MRATY(sol1);
		if(cy > -h && cy < h) {
			cx = MRATX(sol1);
			cz = MRATZ(sol1);
			/* XXX Normal */
			HIT(sol1, cx,cy,cz, cx/r,0,cz/r, -1,-1, "conside 1");
		}
		cy0 = cy;
		cy = MRATY(sol2);
		if(cy > -h && cy < h) {
			cx = MRATX(sol2);
			cz = MRATZ(sol2);
			HIT(sol2, cx,cy,cz, cx/r,0,cz/r, -1,-1, "conside 2");
		}
		/*
		printf("CONSOLV: (%f %f) (%f %f)\n", sol1, sol2,cy0,cy);
		*/
	}
	if(!YEQ) {
		float yrat0 = YRAT(-y);
		if(TRAT(yrat0)) {
			float cx = MRATX(yrat0);
			float cz = MRATZ(yrat0);
			if(r*r > cx*cx + cz*cz) {
				HIT(yrat0, cx, -y, cz, 0, -1, 0, -1, -1, "conbot");
			}
		}
	}
}
			}void Text_Rend(void *nod_){
			struct VRML_Text *this_ = (struct VRML_Text *)nod_;
			{
	void (*f)(int n, SV **p,int nl, float *l, float maxext, double spacing,double size);
	double spacing = 1.0;
	double size = 1.0; 
	
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
	/* We need both sides */
	glPushAttrib(GL_ENABLE_BIT);
	glDisable(GL_CULL_FACE);
	f = (void *)(this_->__rendersub);
	/* printf("Render text: %d \n", f); */
	if((this_->fontStyle)) {
		struct VRML_FontStyle *fsp = (this_->fontStyle);
		spacing = fsp->spacing;
		size = fsp->size;
	}
	if(f) {
		f(((this_->string).n),((this_->string).p),((this_->length).n),((this_->length).p),(this_->maxExtent),spacing,size );
	}
	glPopAttrib();
	
			glEndList()
			;
}
			}void DirectionalLight_Light(void *nod_){
			struct VRML_DirectionalLight *this_ = (struct VRML_DirectionalLight *)nod_;
			{
		if(((this_->on))) {
			int light = nextlight();
			if(light >= 0) {
				float vec[4];
				glEnable(light);
				vec[0] = -((this_->direction).c[0]);
				vec[1] = -((this_->direction).c[1]);
				vec[2] = -((this_->direction).c[2]);
				vec[3] = 0;
				glLightfv(light, GL_POSITION, vec);
				vec[0] = ((this_->color).c[0]) * (this_->intensity);
				vec[1] = ((this_->color).c[1]) * (this_->intensity);
				vec[2] = ((this_->color).c[2]) * (this_->intensity);
				vec[3] = 1;
				glLightfv(light, GL_DIFFUSE, vec);
				glLightfv(light, GL_SPECULAR, vec);
				vec[0] *= (this_->ambientIntensity);
				vec[1] *= (this_->ambientIntensity);
				vec[2] *= (this_->ambientIntensity);
				glLightfv(light, GL_AMBIENT, vec);
			}
		}
	}
			}void Sphere_Rend(void *nod_){
			struct VRML_Sphere *this_ = (struct VRML_Sphere *)nod_;
			{int vdiv = vert_div;
		int hdiv = horiz_div;
	   float vf = vert_div;
	   float hf = horiz_div;
		int v; int h;
		float va1,va2,van,ha1,ha2,han;
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		glPushMatrix();
			/* if(!nomode) {
				glPushAttrib(&GL_LIGHTING);
				# glShadeModel(&GL_SMOOTH);
			} */
		glScalef((this_->radius), (this_->radius), (this_->radius));
		glBegin(GL_QUAD_STRIP);
		for(v=0; v<vdiv; v++) {
			va1 = v * 3.15 / vdiv;
			va2 = (v+1) * 3.15 / vdiv;
			van = (v+0.5) * 3.15 / vdiv;
			for(h=0; h<=hdiv; h++) {
				ha1 = h * 6.29 / hdiv;
				ha2 = (h+1) * 6.29 / hdiv;
				han = (h+0.5) * 6.29 / hdiv;

				glNormal3f(sin(va1) * cos(ha1), sin(va1) * sin(ha1), cos(va1));
				TC(v/vf,h/hf);
				glVertex3f(sin(va1) * cos(ha1), sin(va1) * sin(ha1), cos(va1));

				glNormal3f(sin(va2) * cos(ha1), sin(va2) * sin(ha1), cos(va2));
				TC((v+1)/vf,h/hf);
				glVertex3f(sin(va2) * cos(ha1), sin(va2) * sin(ha1), cos(va2));
			#ifdef FOO
				glNormal3f(sin(va2) * cos(ha1), sin(va2) * sin(ha1), cos(va2));
				TC((v+1)/vf,h/hf);
				glVertex3f(sin(va2) * cos(ha1), sin(va2) * sin(ha1), cos(va2));
				glNormal3f(sin(va2) * cos(ha2), sin(va2) * sin(ha2), cos(va2));
				TC((v+1)/vf,(h+1)/hf);
				glVertex3f(sin(va2) * cos(ha2), sin(va2) * sin(ha2), cos(va2));
				glNormal3f(sin(va1) * cos(ha2), sin(va1) * sin(ha2), cos(va1));
				TC(v/vf,(h+1)/hf);
				glVertex3f(sin(va1) * cos(ha2), sin(va1) * sin(ha2), cos(va1));
				glNormal3f(sin(va1) * cos(ha1), sin(va1) * sin(ha1), cos(va1));
				TC(v/vf,h/hf);
				glVertex3f(sin(va1) * cos(ha1), sin(va1) * sin(ha1), cos(va1));
			#endif
			}
		}
		glEnd();
		glPopMatrix();
					/* if(!$nomode) {
						glPopAttrib();
					} */
		
			glEndList()
			;
}
			}void Sphere_RendRay(void *nod_){
			struct VRML_Sphere *this_ = (struct VRML_Sphere *)nod_;
			{
	float r = (this_->radius);
	/* Center is at zero. t_r1 to t_r2 and t_r1 to zero are the vecs */
	float tr1sq = VECSQ(t_r1);
	float tr2sq = VECSQ(t_r2);
	float tr1tr2 = VECPT(t_r1,t_r2);
	struct pt dr2r1;
	float dlen;
	float a,b,c,und;

	VECDIFF(t_r2,t_r1,dr2r1);
	dlen = VECSQ(dr2r1);

	a = dlen; /* tr1sq - 2*tr1tr2 + tr2sq; */
	b = 2*(VECPT(dr2r1, t_r1));
	c = tr1sq - r*r;

	b /= a; c/= a; /* Normalize first term out */
	
	und = b*b - 4*c; /* What is the term under square root */
	if(und > 0) { /* HITS */
		float sol1 = (-b+sqrt(und))/2;
		float sol2 = (-b-sqrt(und))/2;
		float cx,cy,cz;
		printf("SPHSOL0: (%f %f %f) (%f %f %f)\n",
			t_r1.x, t_r1.y, t_r1.z, t_r2.x, t_r2.y, t_r2.z);
		printf("SPHSOL: (%f %f %f) (%f) (%f %f) (%f) (%f %f)\n",
			tr1sq, tr2sq, tr1tr2, a, b, c, und, sol1, sol2);
		cx = MRATX(sol1);
		cy = MRATY(sol1);
		cz = MRATZ(sol1);
		HIT(sol1, cx,cy,cz, cx/r,cy/r,cz/r, -1,-1, "sphere 0");
		cx = MRATX(sol2);
		cy = MRATY(sol2);
		cz = MRATZ(sol2);
		HIT(sol2, cx,cy,cz, cx/r,cy/r,cz/r, -1,-1, "sphere 1");
	}
}
			}struct SFColor *Coordinate_Get3(void *nod_,int *n){
			struct VRML_Coordinate *this_ = (struct VRML_Coordinate *)nod_;
			{
	*n = ((this_->point).n); 
	return ((this_->point).p);
}
			}void FontStyle_Rend(void *nod_){
			struct VRML_FontStyle *this_ = (struct VRML_FontStyle *)nod_;
			{}
			}struct SFColor *Normal_Get3(void *nod_,int *n){
			struct VRML_Normal *this_ = (struct VRML_Normal *)nod_;
			{
	*n = ((this_->vector).n);
	return ((this_->vector).p);
}
			}void Box_Rend(void *nod_){
			struct VRML_Box *this_ = (struct VRML_Box *)nod_;
			{
	 float x = ((this_->size).c[0])/2;
	 float y = ((this_->size).c[1])/2;
	 float z = ((this_->size).c[2])/2;
	 
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
	glPushAttrib(GL_LIGHTING);
	glShadeModel(GL_FLAT);
		glBegin(GL_QUADS);
		glNormal3f(0,0,1);
		TC(1,1);
		glVertex3f(x,y,z);
		TC(0,1);
		glVertex3f(-x,y,z);
		TC(0,0);
		glVertex3f(-x,-y,z);
		TC(1,0);
		glVertex3f(x,-y,z);

		glNormal3f(0,0,-1);
		TC(1,0);
		glVertex3f(x,-y,-z);
		TC(0,0);
		glVertex3f(-x,-y,-z);
		TC(0,1);
		glVertex3f(-x,y,-z);
		TC(1,1);
		glVertex3f(x,y,-z);

		glNormal3f(0,1,0);
		TC(1,1);
		glVertex3f(x,y,z);
		TC(1,0);
		glVertex3f(x,y,-z);
		TC(0,0);
		glVertex3f(-x,y,-z);
		TC(0,1);
		glVertex3f(-x,y,z);

		glNormal3f(0,-1,0);
		TC(0,1);
		glVertex3f(-x,-y,z);
		TC(0,0);
		glVertex3f(-x,-y,-z);
		TC(1,0);
		glVertex3f(x,-y,-z);
		TC(1,1);
		glVertex3f(x,-y,z);

		glNormal3f(1,0,0);
		TC(1,1);
		glVertex3f(x,y,z);
		TC(0,1);
		glVertex3f(x,-y,z);
		TC(0,0);
		glVertex3f(x,-y,-z);
		TC(1,0);
		glVertex3f(x,y,-z);

		glNormal3f(-1,0,0);
		TC(1,0);
		glVertex3f(-x,y,-z);
		TC(0,0);
		glVertex3f(-x,-y,-z);
		TC(0,1);
		glVertex3f(-x,-y,z);
		TC(1,1);
		glVertex3f(-x,y,z);
		glEnd();
	glPopAttrib();
	 
			glEndList()
			;
	}
			}void Box_RendRay(void *nod_){
			struct VRML_Box *this_ = (struct VRML_Box *)nod_;
			{
	float x = ((this_->size).c[0])/2;
	float y = ((this_->size).c[1])/2;
	float z = ((this_->size).c[2])/2;
	/* 1. x=const-plane faces? */
	if(!XEQ) {
		float xrat0 = XRAT(x);
		float xrat1 = XRAT(-x);
		if(verbose) printf("!XEQ: %f %f\n",xrat0,xrat1);
		if(TRAT(xrat0)) {
			float cy = MRATY(xrat0);
			if(verbose) printf("TRok: %f\n",cy);
			if(cy >= -y && cy < y) {
				float cz = MRATZ(xrat0);
				if(verbose) printf("cyok: %f\n",cz);
				if(cz >= -z && cz < z) {
					if(verbose) printf("czok:\n");
					HIT(xrat0, x,cy,cz, 1,0,0, -1,-1, "cube x0");
				}
			}
		}
		if(TRAT(xrat1)) {
			float cy = MRATY(xrat1);
			if(cy >= -y && cy < y) {
				float cz = MRATZ(xrat1);
				if(cz >= -z && cz < z) {
					HIT(xrat1, -x,cy,cz, -1,0,0, -1,-1, "cube x1");
				}
			}
		}
	}
	if(!YEQ) {
		float yrat0 = YRAT(y);
		float yrat1 = YRAT(-y);
		if(TRAT(yrat0)) {
			float cx = MRATX(yrat0);
			if(cx >= -x && cx < x) {
				float cz = MRATZ(yrat0);
				if(cz >= -z && cz < z) {
					HIT(yrat0, cx,y,cz, 0,1,0, -1,-1, "cube y0");
				}
			}
		}
		if(TRAT(yrat1)) {
			float cx = MRATX(yrat1);
			if(cx >= -x && cx < x) {
				float cz = MRATZ(yrat1);
				if(cz >= -z && cz < z) {
					HIT(yrat1, cx,-y,cz, 0,-1,0, -1,-1, "cube y1");
				}
			}
		}
	}
	if(!ZEQ) {
		float zrat0 = ZRAT(z);
		float zrat1 = ZRAT(-z);
		if(TRAT(zrat0)) {
			float cx = MRATX(zrat0);
			if(cx >= -x && cx < x) {
				float cy = MRATY(zrat0);
				if(cy >= -y && cy < y) {
					HIT(zrat0, cx,cy,z, 0,0,1, -1,-1,"cube z0");
				}
			}
		}
		if(TRAT(zrat1)) {
			float cx = MRATX(zrat1);
			if(cx >= -x && cx < x) {
				float cy = MRATY(zrat1);
				if(cy >= -y && cy < y) {
					HIT(zrat1, cx,cy,-z, 0,0,-1,  -1,-1,"cube z1");
				}
			}
		}
	}
}
			}void Billboard_Prep(void *nod_){
			struct VRML_Billboard *this_ = (struct VRML_Billboard *)nod_;
			{
	GLdouble mod[16];
	GLdouble proj[16];
	struct pt vec, ax, cp, z = {0,0,1}, cp2,cp3, arcp;
	int align;
	double len; double len2;
	double angle;
	int sign;
	ax.x = ((this_->axisOfRotation).c[0]);
	ax.y = ((this_->axisOfRotation).c[1]);
	ax.z = ((this_->axisOfRotation).c[2]);
	align = (APPROX(VECSQ(ax),0));
	glPushMatrix();

	glGetDoublev(GL_MODELVIEW_MATRIX, mod);
	glGetDoublev(GL_PROJECTION_MATRIX, proj);
	gluUnProject(0,0,0,mod,proj,viewport,
		&vec.x,&vec.y,&vec.z);
	len = VECSQ(vec); if(APPROX(len,0)) {return;}
	VECSCALE(vec,1/sqrt(len));
	/* printf("Billboard: (%f %f %f) (%f %f %f)\n",vec.x,vec.y,vec.z,	
		ax.x, ax.y, ax.z); */
	if(!align) {
		VECCP(ax,z,arcp);
		VECCP(ax,arcp,cp3);
		len = VECSQ(ax); VECSCALE(ax,1/sqrt(len));
		VECCP(vec,ax,cp); /* cp is now 90deg to both vector and axis */
		len = sqrt(VECSQ(cp)); 
		if(APPROX(len,0)) {return;} /* Cant do a thing */
		VECSCALE(cp, 1/len)
		/* printf("Billboard: (%f %f %f) (%f %f %f)\n",cp.x,cp.y,cp.z,	
			cp3.x, cp3.y, cp3.z); */
		/* Now, find out angle between this and z axis */
		VECCP(cp,z,cp2);
		len2 = VECPT(cp,z); /* cos(angle) */
		len = sqrt(VECSQ(cp2)); /* this is abs(sin(angle)) */
		/* Now we need to find the sign first */
		if(VECPT(cp, arcp)>0) sign=-1; else sign=1;
		angle = atan2(len2,sign*len);
		/* printf("Billboard: sin angle = %f, cos angle = %f\n, sign: %d,
			atan2: %f\n", len, len2,sign,angle); */
		glRotatef(angle/3.1415926536*180, ax.x,ax.y,ax.z);
	} else {
		/* cp is the axis of the first rotation... */
		VECCP(z,vec,cp); len = sqrt(VECSQ(cp)); 
		VECSCALE(cp,1/len);
		VECCP(z,cp,cp2); 
		angle = asin(VECPT(cp2,vec));
		glRotatef(angle/3.1415926536*180, ax.x,ax.y,ax.z);
		
		/* XXXX */
		/* die("Cant do 0 0 0 billboard"); */

	}
}
			}void Billboard_Child(void *nod_){
			struct VRML_Billboard *this_ = (struct VRML_Billboard *)nod_;
			{
		int nc = ((this_->children).n); 
		int i;
		if(verbose) {printf("RENDER GROUP START %d (%d)\n",this_, nc);}
		for(i=0; i<nc; i++) {
			void *p = ((this_->children).p[i]);
			if(verbose) {printf("RENDER GROUP %d CHILD %d\n",this_, p);}
			render_node(p);
		}
		if(verbose) {printf("RENDER GROUP END %d\n",this_);}
	}
			}void Billboard_Fin(void *nod_){
			struct VRML_Billboard *this_ = (struct VRML_Billboard *)nod_;
			{
	glPopMatrix();
}
			}void Group_Child(void *nod_){
			struct VRML_Group *this_ = (struct VRML_Group *)nod_;
			{
		int nc = ((this_->children).n); 
		int i;
		if(verbose) {printf("RENDER GROUP START %d (%d)\n",this_, nc);}
		for(i=0; i<nc; i++) {
			void *p = ((this_->children).p[i]);
			if(verbose) {printf("RENDER GROUP %d CHILD %d\n",this_, p);}
			render_node(p);
		}
		if(verbose) {printf("RENDER GROUP END %d\n",this_);}
	}
			}void ElevationGrid_Rend(void *nod_){
			struct VRML_ElevationGrid *this_ = (struct VRML_ElevationGrid *)nod_;
			{
		struct SFColor *colors; int ncolors=0;
		struct SFColor *normals; int nnormals=0;
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		if(this_->color) {
		  if(!(*(struct VRML_Virt **)(this_->color))-> get3) {
		  	die("NULL METHOD ElevationGrid color  get3");
		  }
		   colors =  ((*(struct VRML_Virt **)(this_->color))-> get3(this_->color,
		     &ncolors)) ;
		};
		if(this_->normal) {
		  if(!(*(struct VRML_Virt **)(this_->normal))-> get3) {
		  	die("NULL METHOD ElevationGrid normal  get3");
		  }
		   normals =  ((*(struct VRML_Virt **)(this_->normal))-> get3(this_->normal,
		     &nnormals)) ;
		};
		if(!this_->_intern || 
			this_->_change != ((struct VRML_PolyRep *)this_->_intern)->_change)
				regen_polyrep(this_);;
		if(!((this_->solid))) {
			glPushAttrib(GL_ENABLE_BIT);
			glDisable(GL_CULL_FACE);
		}
		render_polyrep(this_, 
			0, NULL,
			ncolors, colors,
			nnormals, normals
		);
		if(!((this_->solid))) {
			glPopAttrib();
		}
		
			glEndList()
			;
}
			}void ElevationGrid_RendRay(void *nod_){
			struct VRML_ElevationGrid *this_ = (struct VRML_ElevationGrid *)nod_;
			{
		if(!this_->_intern || 
			this_->_change != ((struct VRML_PolyRep *)this_->_intern)->_change)
				regen_polyrep(this_);;
		render_ray_polyrep(this_, 
			0, NULL
		);
}
			}void ElevationGrid_GenPolyRep(void *nod_){
			struct VRML_ElevationGrid *this_ = (struct VRML_ElevationGrid *)nod_;
			{
		int x,z;
		int nx = (this_->xDimension);
		float xs = (this_->xSpacing);
		int nz = (this_->zDimension);
		float zs = (this_->zSpacing);
		float *f = ((this_->height).p);
		float a[3],b[3];
		int *cindex; 
		float *coord;
		int ntri = 2 * (nx-1) * (nz-1);
		int triind;
		int nf = ((this_->height).n);
		struct VRML_PolyRep *rep_ = this_->_intern;
		rep_->ntri = ntri;
		printf("Gen elevgrid %d %d %d\n", ntri, nx, nz);
		if(nf != nx * nz) {
			die("Elevationgrid: too many / too few: %d %d %d\n",
				nf, nx, nz);
		}
		cindex = rep_->cindex = malloc(sizeof(*(rep_->cindex))*3*(ntri));
		coord = rep_->coord = malloc(sizeof(*(rep_->coord))*nx*nz*3);
		/* Flat */
		rep_->normal = malloc(sizeof(*(rep_->normal))*3*ntri);
		rep_->norindex = malloc(sizeof(*(rep_->norindex))*3*ntri);
		/* Prepare the coordinates */
		for(x=0; x<nx; x++) {
		 for(z=0; z<nz; z++) {
		  float h = f[x+z*nx];
		  coord[(x+z*nx)*3+0] = x*xs;
		  coord[(x+z*nx)*3+1] = h;
		  coord[(x+z*nx)*3+2] = z*zs;
		 }
		}
		triind = 0;
		for(x=0; x<nx-1; x++) {
		 for(z=0; z<nz-1; z++) {
		  /* 1: */
		  cindex[triind*3+0] = x+z*nx;
		  cindex[triind*3+1] = x+(z+1)*nx;
		  cindex[triind*3+2] = (x+1)+z*nx;
		rep_->norindex[triind*3+0] = triind;
		rep_->norindex[triind*3+1] = triind;
		rep_->norindex[triind*3+2] = triind;
		  triind ++;
		  /* 2: */
		  cindex[triind*3+0] = x+(z+1)*nx;
		  cindex[triind*3+1] = (x+1)+(z+1)*nx;
		  cindex[triind*3+2] = (x+1)+z*nx;
		rep_->norindex[triind*3+0] = triind;
		rep_->norindex[triind*3+1] = triind;
		rep_->norindex[triind*3+2] = triind;
		  triind ++; 
		 }
		}
		calc_poly_normals_flat(rep_);
	}
			}void Material_Rend(void *nod_){
			struct VRML_Material *this_ = (struct VRML_Material *)nod_;
			{	float m[4]; int i;
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		m[0] = ((this_->diffuseColor).c[0]);m[1] = ((this_->diffuseColor).c[1]);m[2] = ((this_->diffuseColor).c[2]);m[3] = 1;;
		glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, m);
		for(i=0; i<3; i++) {
			m[i] *= (this_->ambientIntensity);
		}
		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, m);
		m[0] = ((this_->specularColor).c[0]);m[1] = ((this_->specularColor).c[1]);m[2] = ((this_->specularColor).c[2]);m[3] = 1;;
		glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, m);

		m[0] = ((this_->emissiveColor).c[0]);m[1] = ((this_->emissiveColor).c[1]);m[2] = ((this_->emissiveColor).c[2]);m[3] = 1;;
		glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, m);

		if(fabs((this_->shininess) - 0.2) > 0.001) {
			printf("Set shininess: %f\n",(this_->shininess));
			glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, 
				128*(this_->shininess)*(this_->shininess));
				/* 128-(128*(this_->shininess))); */
				/* 1.0/((",getf(Material,shininess),"+1)/128.0)); */
		}
		
			glEndList()
			;
		
}
			}void Appearance_Child(void *nod_){
			struct VRML_Appearance *this_ = (struct VRML_Appearance *)nod_;
			{
		if((this_->material)) {render_node((this_->material));}
		else {glColor3f(1.0,1.0,1.0);} /* XXX */
		if((this_->texture)) {
			render_node((this_->texture));
		}
	}
			}void Extrusion_Rend(void *nod_){
			struct VRML_Extrusion *this_ = (struct VRML_Extrusion *)nod_;
			{
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		if(!this_->_intern || 
			this_->_change != ((struct VRML_PolyRep *)this_->_intern)->_change)
				regen_polyrep(this_);;
		if(!((this_->solid))) {
			glPushAttrib(GL_ENABLE_BIT);
			glDisable(GL_CULL_FACE);
		}
		render_polyrep(this_, 
			0, NULL,
			0, NULL,
			0, NULL
		);
		if(!((this_->solid))) {
			glPopAttrib();
		}
		
			glEndList()
			;
}
			}void Extrusion_RendRay(void *nod_){
			struct VRML_Extrusion *this_ = (struct VRML_Extrusion *)nod_;
			{
		if(!this_->_intern || 
			this_->_change != ((struct VRML_PolyRep *)this_->_intern)->_change)
				regen_polyrep(this_);;
		render_ray_polyrep(this_, 
			0, NULL
		);
}
			}void Extrusion_GenPolyRep(void *nod_){
			struct VRML_Extrusion *this_ = (struct VRML_Extrusion *)nod_;
			{
		int nspi = ((this_->spine).n);
		int nsec = ((this_->crossSection).n);
		int nori = ((this_->orientation).n);
		int nsca = ((this_->scale).n);
		int ntri = 2 * (nspi-1) * (nsec-1);
		int spi,sec;
		int triind;
		int closed = 0;
		float spxlen,spylen,spzlen;
		int *cindex;
		float *coord;
		struct pt spm1,spc,spp1,spcp,spy,spz,spoz,spx;
		struct VRML_PolyRep *rep_ = this_->_intern;
		struct SFColor *spine = ((this_->spine).p);
		rep_->ntri = ntri;
		cindex = rep_->cindex = malloc(sizeof(*(rep_->cindex))*3*(ntri));
		coord = rep_->coord = malloc(sizeof(*(rep_->coord))*nspi*nsec*3);
		/* Flat */
		rep_->normal = malloc(sizeof(*(rep_->normal))*3*ntri);
		rep_->norindex = malloc(sizeof(*(rep_->norindex))*3*ntri);
		/* Coordinates: find first non-collinear */
		if(spine[0].c[0] == spine[nspi-1].c[0] &&
		   spine[0].c[1] == spine[nspi-1].c[1] &&
		   spine[0].c[2] == spine[nspi-1].c[2]) 
		   	closed = 1;
		/* Special-case, always find entire-collinear */
		if(nspi < 3) {
			die("Collinear spine :( :( :(");
		}
		/* Find first non-zero cross product */
		for(spi = 0; spi<nspi; spi++) {
			if(spi==0) {
				if(closed) {
					VEC_FROM_CDIFF(spine[1],spine[nspi-2], spy);
					VEC_FROM_CDIFF(spine[1],spine[0], spp1);
					VEC_FROM_CDIFF(spine[nspi-2],spine[0], spm1);
				} else {
					VEC_FROM_CDIFF(spine[1],spine[0], spy);
					VEC_FROM_CDIFF(spine[0],spine[1], spm1);
					VEC_FROM_CDIFF(spine[2],spine[1], spp1);
				}
				VECCP(spp1,spm1,spz);
				if(APPROX(VECSQ(spz),0)) {
					double ptlen,cplen,rangle;

					/* Ok, this is where it gets tough...
					 * the first two vecs are collinear */
				 	int j;
					for(j=1; j<nspi-1; j++) {
						VEC_FROM_CDIFF(spine[j-1],spine[j], spm1);
						VEC_FROM_CDIFF(spine[j+1],spine[j], spp1);
						VECCP(spp1,spm1,spz);
						if(!APPROX(VECSQ(spz),0)) 
						  goto got_nz;
					}
					/* Even worse: the whole spine is
					 * linear. Why do they keep doing that!? 
					 */	
					/* Find y -> spp1 */
					spylen = 1/sqrt(VECSQ(spy)); VECSCALE(spy, spylen);
					spzlen = 1/sqrt(VECSQ(spm1)); VECSCALE(spm1, spzlen);
					/* Now, the rotation from (0 1 0) to
					 * spy is the key -- XXX Check
					 * whether we do it right.. */
					VECCP(spy,spz,spp1);
					ptlen = VECPT(spy,spz);
					cplen = sqrt(VECSQ(spp1));
					if(APPROX(cplen,0)) {
						spz.x = 0; spz.y = 0;
						spz.z = 1; goto got_nz;
					}
					VECSCALE(spp1, 1/cplen);
					rangle = atan2(ptlen,cplen);
					spz.x = 
					spz.y = 
					spz.z = spp1.z + 
						(1-spp1.z) * 1; /* cosZZ */
						
					
					die("Collinear spine");
					got_nz:; /* Its all right */
				}
			} else if(spi==nspi-1) {
				if(closed) {
					VEC_FROM_CDIFF(spine[1],spine[nspi-2], spy);
					VEC_FROM_CDIFF(spine[1],spine[0], spp1);
					VEC_FROM_CDIFF(spine[nspi-2],spine[0], spm1);
				} else {
					VEC_FROM_CDIFF(spine[nspi-1],spine[nspi-2], spy);
					VEC_FROM_CDIFF(spine[nspi-3],spine[nspi-2], spm1);
					VEC_FROM_CDIFF(spine[nspi-1],spine[nspi-2], spp1);
				}
				VECCP(spp1,spm1,spz);
			} else {
				VEC_FROM_CDIFF(spine[spi+1],spine[spi-1], spy);
				VEC_FROM_CDIFF(spine[spi-1],spine[spi], spm1);
				VEC_FROM_CDIFF(spine[spi+1],spine[spi], spp1);
				VECCP(spp1,spm1,spz);
			}
			if(APPROX(VECSQ(spz),0)) {
				spz = spoz;
			}
			VECCP(spy,spz,spx);
			spylen = 1/sqrt(VECSQ(spy)); VECSCALE(spy, spylen);
			spzlen = 1/sqrt(VECSQ(spz)); VECSCALE(spz, spzlen);
			spxlen = 1/sqrt(VECSQ(spx)); VECSCALE(spx, spxlen);
			/* Now we have spy and spz in every case */
			for(sec = 0; sec<nsec; sec++) {
				struct pt point;
				float ptx = ((this_->crossSection).p[sec]).c[0];
				float ptz = ((this_->crossSection).p[sec]).c[1];
				if(nsca) {
					int sca = (nsca==1 ? 0 : spi);
					ptx *= ((this_->scale).p[sca]).c[0];
					ptz *= ((this_->scale).p[sca]).c[1];
				}
				if(nori) {
					int ori = (nori==1 ? 0 : spi);
					/* XXX */
					point.x = ptx;
					point.y = 0; 
					point.z = ptz;
				} else {
					point.x = ptx;
					point.y = 0; 
					point.z = ptz;
				}
			   coord[(sec+spi*nsec)*3+0] = 
			    spx.x * point.x + spy.x * point.y + spz.x * point.z
			    + ((this_->spine).p[spi]).c[0];
			   coord[(sec+spi*nsec)*3+1] = 
			    spx.y * point.x + spy.y * point.y + spz.y * point.z
			    + ((this_->spine).p[spi]).c[1];
			   coord[(sec+spi*nsec)*3+2] = 
			    spx.z * point.x + spy.z * point.y + spz.z * point.z
			    + ((this_->spine).p[spi]).c[2];
			}
			spoz = spz;
		}
		triind = 0;
		{
		int x,z; int nx=nsec; int nz=nspi;
		for(x=0; x<nx-1; x++) {
		 for(z=0; z<nz-1; z++) {
		  /* 1: */
		  cindex[triind*3+0] = x+z*nx;
		  cindex[triind*3+1] = x+(z+1)*nx;
		  cindex[triind*3+2] = (x+1)+z*nx;
		rep_->norindex[triind*3+0] = triind;
		rep_->norindex[triind*3+1] = triind;
		rep_->norindex[triind*3+2] = triind;
		  triind ++;
		  /* 2: */
		  cindex[triind*3+0] = x+(z+1)*nx;
		  cindex[triind*3+1] = (x+1)+(z+1)*nx;
		  cindex[triind*3+2] = (x+1)+z*nx;
		rep_->norindex[triind*3+0] = triind;
		rep_->norindex[triind*3+1] = triind;
		rep_->norindex[triind*3+2] = triind;
		  triind ++; 
		 }
		}
		}
		calc_poly_normals_flat(rep_);
}
			}void Shape_Child(void *nod_){
			struct VRML_Shape *this_ = (struct VRML_Shape *)nod_;
			{
		/* if(!(this_->appearance) || !(this_->geometry)) */
		if(!(this_->geometry)) {
			return;
		}
		glPushAttrib(GL_LIGHTING_BIT|GL_ENABLE_BIT|GL_TEXTURE_BIT);
		/* glLightModeli(GL_LIGHT_MODEL_TWO_SIDE,GL_TRUE); */
		if((this_->appearance)) {
			render_node((this_->appearance));
		}
		render_node((this_->geometry));
		glPopAttrib();
	}
			}void Switch_Child(void *nod_){
			struct VRML_Switch *this_ = (struct VRML_Switch *)nod_;
			{
		int wc = (this_->whichChoice);
		if(wc >= 0 && wc < ((this_->choice).n)) {
			void *p = ((this_->choice).p[wc]);
			render_node(p);
		}
	}
			}void ImageTexture_Rend(void *nod_){
			struct VRML_ImageTexture *this_ = (struct VRML_ImageTexture *)nod_;
			{
	/* ASSUMING 2^n * 2^n XXX Check */
	unsigned char *ptr = SvPV((this_->__data),na);
	
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
	printf("PTR: %d, %d %d %d %d %d %d %d %d %d %d\n",
		ptr, ptr[0], ptr[1], ptr[2], ptr[3], ptr[4], ptr[5],
		ptr[6], ptr[7], ptr[8], ptr[9]);

        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
	printf("Doing imagetext %d %d %d\n",(this_->__depth),(this_->__x),(this_->__y));
	glDisable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
	glColor3f(1,1,1);
        	
	glTexImage2D(GL_TEXTURE_2D,
		     0, 
		     (this_->__depth),  
		     (this_->__x), (this_->__y),
		     0,
		     ((this_->__depth)==1 ? GL_LUMINANCE : GL_RGB),
		     GL_UNSIGNED_BYTE,
		     ptr
	);
	
			glEndList()
			;
}
			}void IndexedLineSet_Rend(void *nod_){
			struct VRML_IndexedLineSet *this_ = (struct VRML_IndexedLineSet *)nod_;
			{
		int i;
		int cin = ((this_->coordIndex).n);
		int colin = ((this_->colorIndex).n);
		int cpv = ((this_->colorPerVertex));
		int plno = 0;
		int ind1,ind2;
		int ind;
		int c;
		struct SFColor *points; int npoints;
		struct SFColor *colors; int ncolors=0;
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		if(this_->coord) {
		  if(!(*(struct VRML_Virt **)(this_->coord))-> get3) {
		  	die("NULL METHOD IndexedLineSet coord  get3");
		  }
		   points =  ((*(struct VRML_Virt **)(this_->coord))-> get3(this_->coord,
		     &npoints)) ;}
 	  else { (die("NULL FIELD IndexedLineSet coord "));};
		if(this_->color) {
		  if(!(*(struct VRML_Virt **)(this_->color))-> get3) {
		  	die("NULL METHOD IndexedLineSet color  get3");
		  }
		   colors =  ((*(struct VRML_Virt **)(this_->color))-> get3(this_->color,
		     &ncolors)) ;
		};
		glDisable(GL_LIGHTING);
		if(ncolors && !cpv) {
			glColor3f(colors[plno].c[0],
				  colors[plno].c[1],
				  colors[plno].c[2]);
		}
		if(!ncolors) {glColor3f(1,1,1);} /* XXX WRONG */
		glBegin(GL_LINE_STRIP);
		for(i=0; i<cin; i++) {
			ind = ((this_->coordIndex).p[i]);
			/* printf("Line: %d %d\n",i,ind); */
			if(ind==-1) {
				glEnd();
				plno++;
				if(ncolors && !cpv) {
					c = plno;
					if((!colin && plno < ncolors) ||
					   (colin && plno < colin)) {
						if(colin) {
							c = ((this_->colorIndex).p[c]);
						}
						glColor3f(colors[c].c[0],
							  colors[c].c[1],
							  colors[c].c[2]);
					}
				}
				glBegin(GL_LINE_STRIP);
			} else {
				if(ncolors && cpv) {
					c = i;
					if(colin) {
						c = ((this_->colorIndex).p[c]);
					}
					glColor3f(colors[c].c[0],
						  colors[c].c[1],
						  colors[c].c[2]);
				}
				/* printf("Line: vertex %f %f %f\n",
					points[ind].c[0],
					points[ind].c[1],
					points[ind].c[2]
				);
				*/
				glVertex3f(
					points[ind].c[0],
					points[ind].c[1],
					points[ind].c[2]
				);
			}
		}
		glEnd();
		glEnable(GL_LIGHTING);
		
			glEndList()
			;
}
			}void PointSet_Rend(void *nod_){
			struct VRML_PointSet *this_ = (struct VRML_PointSet *)nod_;
			{
	int i; 
	struct SFColor *points; int npoints=0;
	struct SFColor *colors; int ncolors=0;
	
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
	if(this_->coord) {
		  if(!(*(struct VRML_Virt **)(this_->coord))-> get3) {
		  	die("NULL METHOD PointSet coord  get3");
		  }
		   points =  ((*(struct VRML_Virt **)(this_->coord))-> get3(this_->coord,
		     &npoints)) ;}
 	  else { (die("NULL FIELD PointSet coord "));};
	if(this_->color) {
		  if(!(*(struct VRML_Virt **)(this_->color))-> get3) {
		  	die("NULL METHOD PointSet color  get3");
		  }
		   colors =  ((*(struct VRML_Virt **)(this_->color))-> get3(this_->color,
		     &ncolors)) ;
		};
	if(ncolors && ncolors != npoints) {
		die("Not same number of colors and points");
	}
	glDisable(GL_LIGHTING);
	if(!ncolors) {glColor3f(1,1,1);} /* XXX WRONG */
	glBegin(GL_POINTS);
	if(verbose) printf("PointSet: %d %d\n", npoints, ncolors);
	for(i=0; i<npoints; i++) {
		if(ncolors) {
			if(verbose) printf("Color: %f %f %f\n",
				  colors[i].c[0],
				  colors[i].c[1],
				  colors[i].c[2]);
			glColor3f(colors[i].c[0],
				  colors[i].c[1],
				  colors[i].c[2]);
		}
		glVertex3f(
			points[i].c[0],
			points[i].c[1],
			points[i].c[2]
		);
	}
	glEnd();
	glEnable(GL_LIGHTING);
	
			glEndList()
			;
}
			}void Cylinder_Rend(void *nod_){
			struct VRML_Cylinder *this_ = (struct VRML_Cylinder *)nod_;
			{
		int div = horiz_div;
		float df = div;
		float h = (this_->height)/2;
		float r = (this_->radius);
		float a,a1,a2;
		int i;
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		if(((this_->bottom))) {
			glBegin(GL_POLYGON);
			glNormal3f(0,1,0);
			for(i=div-1; i>=0; i--) {
				a = i * 6.29 / div;
				TC(0.5+0.5*sin(a),0.5+0.5*cos(a));
				glVertex3f(r*sin(a),-h,r*cos(a));
			}
			glEnd();
		} 
		if(((this_->top))) {
			glBegin(GL_POLYGON);
			glNormal3f(0,-1,0);
			for(i=0; i<div; i++) {
				a = i * 6.29 / div;
				TC(0.5+0.5*sin(a),0.5+0.5*cos(a));
				glVertex3f(r*sin(a),h,r*cos(a));
			}
			glEnd();
		}
		if(((this_->side))) {
				/* if(!nomode) {
				glPushAttrib(GL_LIGHTING);
				# glShadeModel(GL_SMOOTH);
				} */
			glBegin(GL_QUADS);
			for(i=0; i<div; i++) {
				a = i * 6.29 / div;
				a1 = (i+1) * 6.29 / div;
				a2 = (a+a1)/2;
				glNormal3f(sin(a),0,cos(a));
				TC(i/df,0);
				glVertex3f(r*sin(a),-h,r*cos(a));
				glNormal3f(sin(a1),0,cos(a1));
				TC((i+1)/df,0);
				glVertex3f(r*sin(a1),-h,r*cos(a1));
				/* glNormal3f(sin(a1),0,cos(a1));  (same) */
				TC((i+1)/df,1);
				glVertex3f(r*sin(a1),h,r*cos(a1));
				glNormal3f(sin(a),0,cos(a));
				TC(i/df,1);
				glVertex3f(r*sin(a),h,r*cos(a));
			}
			glEnd();
				/*
				if(!nomode) {
				glPopAttrib();
				}
				*/
		}
		
			glEndList()
			;
}
			}void Cylinder_RendRay(void *nod_){
			struct VRML_Cylinder *this_ = (struct VRML_Cylinder *)nod_;
			{
	float h = (this_->height)/2; /* pos and neg dir. */
	float r = (this_->radius);
	float y = h;
	/* Caps */
	if(!YEQ) {
		float yrat0 = YRAT(y);
		float yrat1 = YRAT(-y);
		if(TRAT(yrat0)) {
			float cx = MRATX(yrat0);
			float cz = MRATZ(yrat0);
			if(r*r > cx*cx+cz*cz) {
				HIT(yrat0, cx,y,cz, 0,1,0, -1,-1, "cylcap 0");
			}
		}
		if(TRAT(yrat1)) {
			float cx = MRATX(yrat1);
			float cz = MRATZ(yrat1);
			if(r*r > cx*cx+cz*cz) {
				HIT(yrat1, cx,-y,cz, 0,-1,0, -1,-1, "cylcap 1");
			}
		}
	}
	/* Body -- do same as for sphere, except no y axis in distance */
	if((!XEQ) && (!ZEQ)) {
		float dx = t_r2.x-t_r1.x; float dz = t_r2.z-t_r1.z;
		float a = dx*dx + dz*dz;
		float b = 2*(dx * t_r1.x + dz * t_r1.z);
		float c = t_r1.x * t_r1.x + t_r1.z * t_r1.z - r*r;
		float und;
		b /= a; c /= a;
		und = b*b - 4*c;
		if(und > 0) { /* HITS the infinite cylinder */
			float sol1 = (-b+sqrt(und))/2;
			float sol2 = (-b-sqrt(und))/2;
			float cy,cx,cz;
			cy = MRATY(sol1);
			if(cy > -h && cy < h) {
				cx = MRATX(sol1);
				cz = MRATZ(sol1);
				HIT(sol1, cx,cy,cz, cx/r,0,cz/r, -1,-1, "cylside 1");
			}
			cy = MRATY(sol2);
			if(cy > -h && cy < h) {
				cx = MRATX(sol2);
				cz = MRATZ(sol2);
				HIT(sol2, cx,cy,cz, cx/r,0,cz/r, -1,-1, "cylside 2");
			}
		}
	}
}
			}void Anchor_Child(void *nod_){
			struct VRML_Anchor *this_ = (struct VRML_Anchor *)nod_;
			{
		int nc = ((this_->children).n); 
		int i;
		if(verbose) {printf("RENDER GROUP START %d (%d)\n",this_, nc);}
		for(i=0; i<nc; i++) {
			void *p = ((this_->children).p[i]);
			if(verbose) {printf("RENDER GROUP %d CHILD %d\n",this_, p);}
			render_node(p);
		}
		if(verbose) {printf("RENDER GROUP END %d\n",this_);}
	}
			}void IndexedFaceSet_Rend(void *nod_){
			struct VRML_IndexedFaceSet *this_ = (struct VRML_IndexedFaceSet *)nod_;
			{
		struct SFColor *points; int npoints;
		struct SFColor *colors; int ncolors=0;
		struct SFColor *normals; int nnormals=0;
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		if(this_->coord) {
		  if(!(*(struct VRML_Virt **)(this_->coord))-> get3) {
		  	die("NULL METHOD IndexedFaceSet coord  get3");
		  }
		   points =  ((*(struct VRML_Virt **)(this_->coord))-> get3(this_->coord,
		     &npoints)) ;}
 	  else { (die("NULL FIELD IndexedFaceSet coord "));};
		if(this_->color) {
		  if(!(*(struct VRML_Virt **)(this_->color))-> get3) {
		  	die("NULL METHOD IndexedFaceSet color  get3");
		  }
		   colors =  ((*(struct VRML_Virt **)(this_->color))-> get3(this_->color,
		     &ncolors)) ;
		};
		if(this_->normal) {
		  if(!(*(struct VRML_Virt **)(this_->normal))-> get3) {
		  	die("NULL METHOD IndexedFaceSet normal  get3");
		  }
		   normals =  ((*(struct VRML_Virt **)(this_->normal))-> get3(this_->normal,
		     &nnormals)) ;
		};
		if(!this_->_intern || 
			this_->_change != ((struct VRML_PolyRep *)this_->_intern)->_change)
				regen_polyrep(this_);;
		if(!((this_->solid))) {
			glPushAttrib(GL_ENABLE_BIT);
			glDisable(GL_CULL_FACE);
		}
		render_polyrep(this_, 
			npoints, points,
			ncolors, colors,
			nnormals, normals
		);
		if(!((this_->solid))) {
			glPopAttrib();
		}
		
			glEndList()
			;
}
			}void IndexedFaceSet_RendRay(void *nod_){
			struct VRML_IndexedFaceSet *this_ = (struct VRML_IndexedFaceSet *)nod_;
			{
		struct SFColor *points; int npoints;
		if(this_->coord) {
		  if(!(*(struct VRML_Virt **)(this_->coord))-> get3) {
		  	die("NULL METHOD IndexedFaceSet coord  get3");
		  }
		   points =  ((*(struct VRML_Virt **)(this_->coord))-> get3(this_->coord,
		     &npoints)) ;}
 	  else { (die("NULL FIELD IndexedFaceSet coord "));};
		if(!this_->_intern || 
			this_->_change != ((struct VRML_PolyRep *)this_->_intern)->_change)
				regen_polyrep(this_);;
		render_ray_polyrep(this_, 
			npoints, points
		);
}
			}void IndexedFaceSet_GenPolyRep(void *nod_){
			struct VRML_IndexedFaceSet *this_ = (struct VRML_IndexedFaceSet *)nod_;
			{
	int i;
	int cin = ((this_->coordIndex).n);
	int cpv = ((this_->colorPerVertex));
	int ntri = 0;
	int nvert = 0;
	struct SFColor *c1,*c2,*c3;
	float a[3]; float b[3];
	struct SFColor *points; int npoints;
	struct SFColor *normals; int nnormals=0;
	struct VRML_PolyRep *rep_ = this_->_intern;
	int *cindex;
	if(this_->coord) {
		  if(!(*(struct VRML_Virt **)(this_->coord))-> get3) {
		  	die("NULL METHOD IndexedFaceSet coord  get3");
		  }
		   points =  ((*(struct VRML_Virt **)(this_->coord))-> get3(this_->coord,
		     &npoints)) ;}
 	  else { (die("NULL FIELD IndexedFaceSet coord "));};
	if(this_->normal) {
		  if(!(*(struct VRML_Virt **)(this_->normal))-> get3) {
		  	die("NULL METHOD IndexedFaceSet normal  get3");
		  }
		   normals =  ((*(struct VRML_Virt **)(this_->normal))-> get3(this_->normal,
		     &nnormals)) ;
		};
	
	for(i=0; i<cin; i++) {
		if(((this_->coordIndex).p[i]) == -1) {
			if(nvert < 3) {
				die("Too few vertices in indexedfaceset poly");
			}
			ntri += nvert-2;
			nvert = 0;
		} else {
			nvert ++;
		}
	}
	cindex = rep_->cindex = malloc(sizeof(*(rep_->cindex))*3*(ntri));
	rep_->ntri = ntri;
	if(!nnormals) {
		/* We have to generate -- do flat only for now */
		rep_->normal = malloc(sizeof(*(rep_->normal))*3*ntri);
		rep_->norindex = malloc(sizeof(*(rep_->norindex))*3*ntri);
	}
	/* color = NULL; coord = NULL; normal = NULL;
		colindex = NULL; norindex = NULL;
	*/
	if(!((this_->convex))) {
		die("AAAAARGHHH!!!  Non-convex polygons! Help!");
		/* XXX Fixme using gluNewTess, gluTessVertex et al */
	} else {
		int initind=-1;
		int lastind=-1;
		int triind = 0;
		for(i=0; i<cin; i++) {
			if(((this_->coordIndex).p[i]) == -1) {
				initind=-1;
				lastind=-1;
			} else {
				if(initind == -1) {
					initind = ((this_->coordIndex).p[i]);
				} else if(lastind == -1) {
					lastind = ((this_->coordIndex).p[i]);
				} else {
					
					cindex[triind*3+0] = initind;
					cindex[triind*3+1] = lastind;
					cindex[triind*3+2] = ((this_->coordIndex).p[i]);
					if(rep_->normal) {
						c1 = &(points[initind]);
						c2 = &(points[lastind]); 
						c3 = &(points[((this_->coordIndex).p[i])]);
						a[0] = c2->c[0] - c1->c[0];
						a[1] = c2->c[1] - c1->c[1];
						a[2] = c2->c[2] - c1->c[2];
						b[0] = c3->c[0] - c1->c[0];
						b[1] = c3->c[1] - c1->c[1];
						b[2] = c3->c[2] - c1->c[2];
						rep_->normal[triind*3+0] =
							a[1]*b[2] - b[1]*a[2];
						rep_->normal[triind*3+1] =
							-(a[0]*b[2] - b[0]*a[2]);
						rep_->normal[triind*3+2] =
							a[0]*b[1] - b[0]*a[1];
						rep_->norindex[triind*3+0] = triind;
						rep_->norindex[triind*3+1] = triind;
						rep_->norindex[triind*3+2] = triind;
					}
					lastind = ((this_->coordIndex).p[i]);
					triind++;
				}
			}
		}
	}
}
			}void Transform_Prep(void *nod_){
			struct VRML_Transform *this_ = (struct VRML_Transform *)nod_;
			{
	glPushMatrix();
	if(!reverse_trans) {
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		glTranslatef(((this_->translation).c[0]),((this_->translation).c[1]),((this_->translation).c[2])
		);
		glTranslatef(((this_->center).c[0]),((this_->center).c[1]),((this_->center).c[2])
		);
		glRotatef(((this_->rotation).r[3])/3.1415926536*180,((this_->rotation).r[0]),((this_->rotation).r[1]),((this_->rotation).r[2])
		);
		glRotatef(((this_->scaleOrientation).r[3])/3.1415926536*180,((this_->scaleOrientation).r[0]),((this_->scaleOrientation).r[1]),((this_->scaleOrientation).r[2])
		);
		glScalef(((this_->scale).c[0]),((this_->scale).c[1]),((this_->scale).c[2])
		);
		glRotatef(-(((this_->scaleOrientation).r[3])/3.1415926536*180),((this_->scaleOrientation).r[0]),((this_->scaleOrientation).r[1]),((this_->scaleOrientation).r[2])
		);
		glTranslatef(-(((this_->center).c[0])),-(((this_->center).c[1])),-(((this_->center).c[2]))
		);
		
			glEndList()
			;
	} else {
		
		        if(!this_->_dl2ist) {
				this_->_dl2ist = glGenLists(1);
			}
			if(this_->_dl2change != this_->_change) {
				glNewList(this_->_dl2ist,GL_COMPILE_AND_EXECUTE);
				this_->_dl2change = this_->_change;
			} else {
				glCallList(this_->_dl2ist); return;
			};
		glTranslatef(((this_->center).c[0]),((this_->center).c[1]),((this_->center).c[2])
		);
		glRotatef(((this_->scaleOrientation).r[3])/3.1415926536*180,((this_->scaleOrientation).r[0]),((this_->scaleOrientation).r[1]),((this_->scaleOrientation).r[2])
		);
		glScalef(1.0/(((this_->scale).c[0])),1.0/(((this_->scale).c[1])),1.0/(((this_->scale).c[2]))
		);
		glRotatef(-(((this_->scaleOrientation).r[3])/3.1415926536*180),((this_->scaleOrientation).r[0]),((this_->scaleOrientation).r[1]),((this_->scaleOrientation).r[2])
		);
		glRotatef(-(((this_->rotation).r[3]))/3.1415926536*180,((this_->rotation).r[0]),((this_->rotation).r[1]),((this_->rotation).r[2])
		);
		glTranslatef(-(((this_->center).c[0])),-(((this_->center).c[1])),-(((this_->center).c[2]))
		);
		glTranslatef(-(((this_->translation).c[0])),-(((this_->translation).c[1])),-(((this_->translation).c[2]))
		);
		
			glEndList()
			;
	}
}
			}void Transform_Child(void *nod_){
			struct VRML_Transform *this_ = (struct VRML_Transform *)nod_;
			{
		int nc = ((this_->children).n); 
		int i;
		if(verbose) {printf("RENDER GROUP START %d (%d)\n",this_, nc);}
		for(i=0; i<nc; i++) {
			void *p = ((this_->children).p[i]);
			if(verbose) {printf("RENDER GROUP %d CHILD %d\n",this_, p);}
			render_node(p);
		}
		if(verbose) {printf("RENDER GROUP END %d\n",this_);}
	}
			}void Transform_Fin(void *nod_){
			struct VRML_Transform *this_ = (struct VRML_Transform *)nod_;
			{
	glPopMatrix();
}
			}struct SFColor *Color_Get3(void *nod_,int *n){
			struct VRML_Color *this_ = (struct VRML_Color *)nod_;
			{
	*n = ((this_->color).n); 
	return ((this_->color).p);
}
			}void LOD_Child(void *nod_){
			struct VRML_LOD *this_ = (struct VRML_LOD *)nod_;
			{
		GLdouble mod[16];
		GLdouble proj[16];
		struct pt vec;
		double dist;
		int nran = ((this_->range).n);
		int nnod = ((this_->level).n);
		int i;
		if(!nran) {
			void *p = ((this_->level).p[ 0]);
			render_node(p);
			return;
		}

		glGetDoublev(GL_MODELVIEW_MATRIX, mod);
		glGetDoublev(GL_PROJECTION_MATRIX, proj);
		gluUnProject(0,0,0,mod,proj,viewport,
			&vec.x,&vec.y,&vec.z);
		vec.x -= ((this_->center).c[0]);
		vec.y -= ((this_->center).c[1]);
		vec.z -= ((this_->center).c[2]);
		dist = sqrt(VECSQ(vec));
		for(i=0; i<nran; i++) {
			if(dist < ((this_->range).p[i])) {
				void *p;
				if(i >= nnod) {i = nnod-1;}
				p = ((this_->level).p[i]);
				render_node(p);
			}
		}
		render_node(((this_->level).p[nnod-1]));

	}
			}
static struct VRML_Virt virt_Background = { NULL,Background_Rend,NULL,NULL,NULL,NULL,NULL,NULL,"Background"};
static struct VRML_Virt virt_Viewpoint = { Viewpoint_Prep,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"Viewpoint"};
static struct VRML_Virt virt_Cone = { NULL,Cone_Rend,NULL,NULL,Cone_RendRay,NULL,NULL,NULL,"Cone"};
static struct VRML_Virt virt_Text = { NULL,Text_Rend,NULL,NULL,NULL,NULL,NULL,NULL,"Text"};
static struct VRML_Virt virt_DirectionalLight = { NULL,NULL,NULL,NULL,NULL,NULL,DirectionalLight_Light,NULL,"DirectionalLight"};
static struct VRML_Virt virt_Sphere = { NULL,Sphere_Rend,NULL,NULL,Sphere_RendRay,NULL,NULL,NULL,"Sphere"};
static struct VRML_Virt virt_Coordinate = { NULL,NULL,NULL,NULL,NULL,NULL,NULL,Coordinate_Get3,"Coordinate"};
static struct VRML_Virt virt_FontStyle = { NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"FontStyle"};
static struct VRML_Virt virt_Normal = { NULL,NULL,NULL,NULL,NULL,NULL,NULL,Normal_Get3,"Normal"};
static struct VRML_Virt virt_Box = { NULL,Box_Rend,NULL,NULL,Box_RendRay,NULL,NULL,NULL,"Box"};
static struct VRML_Virt virt_Billboard = { Billboard_Prep,NULL,Billboard_Child,Billboard_Fin,NULL,NULL,NULL,NULL,"Billboard"};
static struct VRML_Virt virt_Group = { NULL,NULL,Group_Child,NULL,NULL,NULL,NULL,NULL,"Group"};
static struct VRML_Virt virt_ElevationGrid = { NULL,ElevationGrid_Rend,NULL,NULL,ElevationGrid_RendRay,ElevationGrid_GenPolyRep,NULL,NULL,"ElevationGrid"};
static struct VRML_Virt virt_Material = { NULL,Material_Rend,NULL,NULL,NULL,NULL,NULL,NULL,"Material"};
static struct VRML_Virt virt_Appearance = { NULL,NULL,Appearance_Child,NULL,NULL,NULL,NULL,NULL,"Appearance"};
static struct VRML_Virt virt_Extrusion = { NULL,Extrusion_Rend,NULL,NULL,Extrusion_RendRay,Extrusion_GenPolyRep,NULL,NULL,"Extrusion"};
static struct VRML_Virt virt_Shape = { NULL,NULL,Shape_Child,NULL,NULL,NULL,NULL,NULL,"Shape"};
static struct VRML_Virt virt_Switch = { NULL,NULL,Switch_Child,NULL,NULL,NULL,NULL,NULL,"Switch"};
static struct VRML_Virt virt_ImageTexture = { NULL,ImageTexture_Rend,NULL,NULL,NULL,NULL,NULL,NULL,"ImageTexture"};
static struct VRML_Virt virt_IndexedLineSet = { NULL,IndexedLineSet_Rend,NULL,NULL,NULL,NULL,NULL,NULL,"IndexedLineSet"};
static struct VRML_Virt virt_PointSet = { NULL,PointSet_Rend,NULL,NULL,NULL,NULL,NULL,NULL,"PointSet"};
static struct VRML_Virt virt_Cylinder = { NULL,Cylinder_Rend,NULL,NULL,Cylinder_RendRay,NULL,NULL,NULL,"Cylinder"};
static struct VRML_Virt virt_Anchor = { NULL,NULL,Anchor_Child,NULL,NULL,NULL,NULL,NULL,"Anchor"};
static struct VRML_Virt virt_IndexedFaceSet = { NULL,IndexedFaceSet_Rend,NULL,NULL,IndexedFaceSet_RendRay,IndexedFaceSet_GenPolyRep,NULL,NULL,"IndexedFaceSet"};
static struct VRML_Virt virt_Transform = { Transform_Prep,NULL,Transform_Child,Transform_Fin,NULL,NULL,NULL,NULL,"Transform"};
static struct VRML_Virt virt_Color = { NULL,NULL,NULL,NULL,NULL,NULL,NULL,Color_Get3,"Color"};
static struct VRML_Virt virt_LOD = { NULL,NULL,LOD_Child,NULL,NULL,NULL,NULL,NULL,"LOD"};

void render_polyrep(void *node, 
	int npoints, struct SFColor *points,
	int ncolors, struct SFColor *colors,
	int nnormals, struct SFColor *normals)
{
	struct VRML_Virt *v;
	struct VRML_Box *p;
	struct VRML_PolyRep *r;
	int i;
	int pt;
	int pti;
	int hasc;
	v = *(struct VRML_Virt **)node;
	p = node;
	r = p->_intern;
/*	printf("Render polyrep %d '%s' (%d %d): %d\n",node,v->name, 
		p->_change, r->_change, r->ntri);
 */
	glBegin(GL_TRIANGLES);
	hasc = (ncolors || r->color);
	if(hasc) {
		glEnable(GL_COLOR_MATERIAL);
	}
	for(i=0; i<r->ntri*3; i++) {
		int nori = i;
		int coli = i;
		int ind = r->cindex[i];
		GLfloat color[4];
		if(r->norindex) {nori = r->norindex[i];}
		else nori = ind;
		if(r->colindex) {coli = r->colindex[i];}
		else coli = ind;
		if(nnormals) {
			glNormal3fv(normals[nori].c);
		} else if(r->normal) {
			glNormal3fv(r->normal+3*nori);
		}
		if(hasc) {
			if(ncolors) {
				/* ColorMaterial -> these set Material too */
				glColor3fv(colors[coli].c);
			} else if(r->color) {
				glColor3fv(r->color+3*coli);
			}
		}
		if(points) {
			glVertex3fv(points[ind].c);
		} else if(r->coord) {
			glVertex3fv(r->coord+3*ind);
		}
	}
	if(hasc) {
		glDisable(GL_COLOR_MATERIAL);
	}
	glEnd();
}

void render_ray_polyrep(void *node,
	int npoints, struct SFColor *points)
{
	struct VRML_Virt *v;
	struct VRML_Box *p;
	struct VRML_PolyRep *r;
	int i;
	int pt;
	int pti;
	float *point[3];
	v = *(struct VRML_Virt **)node;
	p = node;
	r = p->_intern;
/*	printf("Render polyrepray %d '%s' (%d %d): %d\n",node,v->name, 
		p->_change, r->_change, r->ntri);
 */
	for(i=0; i<r->ntri; i++) {
		for(pt = 0; pt<3; pt++) {
			int ind = r->cindex[i*3+pt];
			if(points) {
				point[pt] = (points[ind].c);
			} else if(r->coord) {
				point[pt] = (r->coord+3*ind);
			}
		}
		/* First we need to project our point to the surface */
		/* XXXXXXX!!! */
	}
}

void regen_polyrep(void *node) 
{
	struct VRML_Virt *v;
	struct VRML_Box *p;
	struct VRML_PolyRep *r;
	v = *(struct VRML_Virt **)node;
	p = node;
	printf("Regen polyrep %d '%s'\n",node,v->name);
	if(!p->_intern) {
		p->_intern = malloc(sizeof(struct VRML_PolyRep));
		r = p->_intern;
		r->ntri = -1;
		r->cindex = 0; r->coord = 0; r->colindex = 0; r->color = 0;
		r->norindex = 0; r->normal = 0;
	}
	r = p->_intern;
	r->_change = p->_change;
#define FREE_IF_NZ(a) if(a) {free(a); a = 0;}
	FREE_IF_NZ(r->cindex);
	FREE_IF_NZ(r->coord);
	FREE_IF_NZ(r->colindex);
	FREE_IF_NZ(r->color);
	FREE_IF_NZ(r->norindex);
	FREE_IF_NZ(r->normal);
	v->mkpolyrep(node);
}

/* Assuming that norindexes set */
void calc_poly_normals_flat(struct VRML_PolyRep *rep) 
{
	int i;
	float a[3],b[3], *v1,*v2,*v3;
	for(i=0; i<rep->ntri; i++) {
		v1 = rep->coord+3*rep->cindex[i*3+0];
		v2 = rep->coord+3*rep->cindex[i*3+1];
		v3 = rep->coord+3*rep->cindex[i*3+2];
		a[0] = v2[0]-v1[0];
		a[1] = v2[1]-v1[1];
		a[2] = v2[2]-v1[2];
		b[0] = v3[0]-v1[0];
		b[1] = v3[1]-v1[1];
		b[2] = v3[2]-v1[2];
		rep->normal[i*3+0] =
			a[1]*b[2] - b[1]*a[2];
		rep->normal[i*3+1] =
			-(a[0]*b[2] - b[0]*a[2]);
		rep->normal[i*3+2] =
			a[0]*b[1] - b[0]*a[1];
	}
}

void render_node(void *node) {
	struct VRML_Virt *v;
	struct VRML_Box *p;
	int srg;
	int sch;
	struct currayhit srh;
	if(verbose) printf("Render_node %d\n",node);
	if(!node) {return;}
	v = *(struct VRML_Virt **)node;
	p = node;
	if(verbose) printf("Render_node_v %d\n",v);
	if(verbose) printf("Render_node_v_d \"%s\"\n",v->name);
	if(verbose) printf("Render_node_v_prep %d\n",v->prep);
	if(verbose) printf("Render_node_v_rend %d\n",v->rend);
	if(verbose) printf("Render_node_v_children %d\n",v->children);
	if(verbose) printf("Render_node_v_fin %d\n",v->fin);
	if(render_anything && v->prep) {v->prep(node);
		if(render_sensitive && v == &virt_Transform) { upd_ray(); }
	}
	if(render_anything && render_geom && v->rend) {v->rend(node);}
	if(render_anything && render_light && v->light) {v->light(node);}
	if(render_anything && render_geom && render_sensitive &&
		v->rendray) {v->rendray(node);}
	/* Future optimization: when doing VP/Lights, do only 
	 * that child... further in future: could just calculate
	 * transforms myself..
	 */
	if(render_anything &&
	   render_sensitive &&
	   p->_sens) {
	   	srg = render_geom;
		render_geom = 1;
		cur_hits += glRenderMode(GL_SELECT);
		if(verbose) printf("CH1 %d: %d\n",node, cur_hits, p->_hit);
		glInitNames();
		glPushName(1);
		sch = cur_hits;
		cur_hits = 0;
		/* HP */
		srh = rph;
		rph.node = node;
		glGetDoublev(GL_MODELVIEW_MATRIX, rph.modelMatrix);
		glGetDoublev(GL_PROJECTION_MATRIX, rph.projMatrix);
	}
	if(hypersensitive == node) {
		hyper_r1 = t_r1;
		hyper_r2 = t_r2;
		hyperhit = 1;
	}
	if(render_anything && v->children) {v->children(node);}
	if(render_anything &&
	   render_sensitive &&
	   p->_sens) {
	   	cur_hits += glRenderMode(GL_SELECT);
		if(verbose) printf("CH2 %d: %d\n",node, cur_hits);
		glInitNames();
		glPushName(1);
		/* p->_hit += cur_hits; */
		render_geom = srg;
		cur_hits = sch;
		if(verbose) printf("CH3: %d %d\n",cur_hits, p->_hit);
		/* HP */
		rph = srh;
	}
	if(render_anything && v->fin) {v->fin(node);
		if(render_sensitive && v == &virt_Transform) { upd_ray(); }
	}
}


MODULE = VRML::VRMLFunc PACKAGE = VRML::VRMLFunc

void *
alloc_struct(siz,virt)
	int siz
	void *virt
CODE:
	void *ptr = malloc(siz);
	struct VRML_Box *p = ptr;
	printf("Alloc: %d %d -> %d\n", siz, virt, ptr);
	*(struct VRML_Virt **)ptr = (struct VRML_Virt *)virt;
	p->_sens = p->_hit = 0;
	p->_intern = 0;
	p->_change = 153;
	p->_dlchange = 0;
	p->_dlist = 0;
	p->_dl2change = 0;
	p->_dl2ist = 0;
	RETVAL=ptr;
OUTPUT:
	RETVAL

void
release_struct(ptr)
	void *ptr
CODE:
	free(ptr); /* COULD BE MEMLEAK IF STUFF LEFT INSIDE */

void
set_sensitive(ptr,sens)
	void *ptr
	int sens
CODE:
	/* Choose box randomly */
	struct VRML_Box *p = ptr;
	p->_sens = sens;

void 
set_hypersensitive(ptr)
	void *ptr
CODE:	
	hypersensitive = ptr;
	hyperhit = 0;

int
get_hyperhit(x1,y1,z1,x2,y2,z2)
	double x1
	double y1
	double z1
	double x2
	double y2
	double z2
CODE:
	if(hyperhit) {
		x1 = hyper_r1.x;
		y1 = hyper_r1.y;
		z1 = hyper_r1.z;
		x2 = hyper_r2.x;
		y2 = hyper_r2.y;
		z2 = hyper_r2.z;
		RETVAL=1;
	} else RETVAL = 0;
OUTPUT:
	RETVAL
	x1
	y1
	z1
	x2
	y2
	z2
	

int
get_hits(ptr)
	void *ptr
CODE:
	struct VRML_Box *p = ptr;
	RETVAL = p->_hit;
	p->_hit = 0;
OUTPUT:
	RETVAL

void
zero_hits(ptr)
	void *ptr
CODE:
	struct VRML_Box *p = ptr;
	p->_hit = 0;

void 
render_verbose(i)
	int i;
CODE:
	verbose=i;

void
render_geom(p)
	void *p
CODE:
	struct VRML_Virt *v;
	if(!p) {
		die("Render_geom null!??");
	}
	v = *(struct VRML_Virt **)p;
	v->rend(p);

void 
render_hier(p,revt,rvp,rgeom,rlight,rsens,wvp)
	void *p
	int revt
	int rvp
	int rgeom
	int rlight
	int rsens
	void *wvp
CODE:
	reverse_trans = revt;
	render_vp = rvp;
	render_geom =  rgeom;
	render_light = rlight;
	render_sensitive = rsens;
	curlight = 0;
	what_vp = wvp;
	render_anything = 1;
	hpdist = -1;
	if(!p) {
		die("Render_hier null!??");
	}
	if(verbose) printf("Render_hier %d %d %d %d %d %d\n", p, revt, rvp, rgeom, rlight, wvp);
	if(render_sensitive) upd_ray();
	render_node(p);
	if(render_sensitive) { /* Get raycasting results */
		if(hpdist >= 0) {
			if(verbose) printf("RAY HIT!\n");
		}
	}

void *
get_rayhit(x,y,z,nx,ny,nz,tx,ty)
	double x
	double y
	double z
	double nx
	double ny
	double nz
	double tx
	double ty
CODE:
	if(hpdist >= 0) {
		gluUnProject(hp.x,hp.y,hp.z,rh.modelMatrix,rh.projMatrix,viewport,
			&x,&y,&z);
		RETVAL = rh.node;
	} else {
		RETVAL=0;
	}
OUTPUT:
	RETVAL
	x
	y
	z
	nx
	ny
	nz
	tx
	ty

void
set_divs(horiz,vert)
int horiz
int vert
CODE:
	horiz_div = horiz;
	vert_div = vert;



void 
set_offs_SFFloat(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	float *ptr_ = (float *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	(*ptr_) = SvNV(sv_);



void 
alloc_offs_SFFloat(ptr,offs)
	void *ptr
	int offs
CODE:
	float *ptr_ = (float *)(((char *)ptr)+offs);
	

void
free_offs_SFFloat(ptr,offs)
	void *ptr
	int offs
CODE:
	float *ptr_ = (float *)(((char *)ptr)+offs);
	



void 
set_offs_MFFloat(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_Float *ptr_ = (struct Multi_Float *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			die("Help! Multi without being ref");
		}
		if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
			die("Help! Multi without being arrayref");
		}
		aM = (AV *) SvRV(sv_);
		lM = av_len(aM)+1;
		/* XXX Free previous p */
		(*ptr_).n = lM;
		(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
		/* XXX ALLOC */
		for(iM=0; iM<lM; iM++) {
			bM = av_fetch(aM, iM, 1); /* LVal for easiness */
			if(!bM) {
				die("Help: Multi VRML::Field::SFFloat bM == 0");
			}
			
			((*ptr_).p[iM]) = SvNV((*bM));

		}
	}
	


void 
alloc_offs_MFFloat(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Float *ptr_ = (struct Multi_Float *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFFloat(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Float *ptr_ = (struct Multi_Float *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;



void 
set_offs_SFRotation(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct SFRotation *ptr_ = (struct SFRotation *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *a;
		SV **b;
		int i;
		if(!SvROK(sv_)) {
			die("Help! SFRotation without being ref");
		}
		if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
			die("Help! SFRotation without being arrayref");
		}
		a = (AV *) SvRV(sv_);
		for(i=0; i<4; i++) {
			b = av_fetch(a, i, 1); /* LVal for easiness */
			if(!b) {
				die("Help: SFColor b == 0");
			}
			(*ptr_).r[i] = SvNV(*b);
		}
	}
	


void 
alloc_offs_SFRotation(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFRotation *ptr_ = (struct SFRotation *)(((char *)ptr)+offs);
	

void
free_offs_SFRotation(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFRotation *ptr_ = (struct SFRotation *)(((char *)ptr)+offs);
	



void 
set_offs_MFRotation(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_Rotation *ptr_ = (struct Multi_Rotation *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			die("Help! Multi without being ref");
		}
		if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
			die("Help! Multi without being arrayref");
		}
		aM = (AV *) SvRV(sv_);
		lM = av_len(aM)+1;
		/* XXX Free previous p */
		(*ptr_).n = lM;
		(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
		/* XXX ALLOC */
		for(iM=0; iM<lM; iM++) {
			bM = av_fetch(aM, iM, 1); /* LVal for easiness */
			if(!bM) {
				die("Help: Multi VRML::Field::SFRotation bM == 0");
			}
			
			{
		AV *a;
		SV **b;
		int i;
		if(!SvROK((*bM))) {
			die("Help! SFRotation without being ref");
		}
		if(SvTYPE(SvRV((*bM))) != SVt_PVAV) {
			die("Help! SFRotation without being arrayref");
		}
		a = (AV *) SvRV((*bM));
		for(i=0; i<4; i++) {
			b = av_fetch(a, i, 1); /* LVal for easiness */
			if(!b) {
				die("Help: SFColor b == 0");
			}
			((*ptr_).p[iM]).r[i] = SvNV(*b);
		}
	}
	
		}
	}
	


void 
alloc_offs_MFRotation(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Rotation *ptr_ = (struct Multi_Rotation *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFRotation(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Rotation *ptr_ = (struct Multi_Rotation *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;



void 
set_offs_SFVec3f(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct SFColor *ptr_ = (struct SFColor *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *a;
		SV **b;
		int i;
		if(!SvROK(sv_)) {
			die("Help! SFColor without being ref");
		}
		if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
			die("Help! SFColor without being arrayref");
		}
		a = (AV *) SvRV(sv_);
		for(i=0; i<3; i++) {
			b = av_fetch(a, i, 1); /* LVal for easiness */
			if(!b) {
				die("Help: SFColor b == 0");
			}
			(*ptr_).c[i] = SvNV(*b);
		}
	}
	


void 
alloc_offs_SFVec3f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFColor *ptr_ = (struct SFColor *)(((char *)ptr)+offs);
	

void
free_offs_SFVec3f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFColor *ptr_ = (struct SFColor *)(((char *)ptr)+offs);
	



void 
set_offs_MFVec3f(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_Vec3f *ptr_ = (struct Multi_Vec3f *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			die("Help! Multi without being ref");
		}
		if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
			die("Help! Multi without being arrayref");
		}
		aM = (AV *) SvRV(sv_);
		lM = av_len(aM)+1;
		/* XXX Free previous p */
		(*ptr_).n = lM;
		(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
		/* XXX ALLOC */
		for(iM=0; iM<lM; iM++) {
			bM = av_fetch(aM, iM, 1); /* LVal for easiness */
			if(!bM) {
				die("Help: Multi VRML::Field::SFVec3f bM == 0");
			}
			
			{
		AV *a;
		SV **b;
		int i;
		if(!SvROK((*bM))) {
			die("Help! SFColor without being ref");
		}
		if(SvTYPE(SvRV((*bM))) != SVt_PVAV) {
			die("Help! SFColor without being arrayref");
		}
		a = (AV *) SvRV((*bM));
		for(i=0; i<3; i++) {
			b = av_fetch(a, i, 1); /* LVal for easiness */
			if(!b) {
				die("Help: SFColor b == 0");
			}
			((*ptr_).p[iM]).c[i] = SvNV(*b);
		}
	}
	
		}
	}
	


void 
alloc_offs_MFVec3f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Vec3f *ptr_ = (struct Multi_Vec3f *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFVec3f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Vec3f *ptr_ = (struct Multi_Vec3f *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;



void 
set_offs_SFBool(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	int *ptr_ = (int *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	(*ptr_) = SvIV(sv_);



void 
alloc_offs_SFBool(ptr,offs)
	void *ptr
	int offs
CODE:
	int *ptr_ = (int *)(((char *)ptr)+offs);
	

void
free_offs_SFBool(ptr,offs)
	void *ptr
	int offs
CODE:
	int *ptr_ = (int *)(((char *)ptr)+offs);
	



void 
set_offs_SFInt32(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	int *ptr_ = (int *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	(*ptr_) = SvIV(sv_);



void 
alloc_offs_SFInt32(ptr,offs)
	void *ptr
	int offs
CODE:
	int *ptr_ = (int *)(((char *)ptr)+offs);
	

void
free_offs_SFInt32(ptr,offs)
	void *ptr
	int offs
CODE:
	int *ptr_ = (int *)(((char *)ptr)+offs);
	



void 
set_offs_MFInt32(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_Int32 *ptr_ = (struct Multi_Int32 *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			die("Help! Multi without being ref");
		}
		if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
			die("Help! Multi without being arrayref");
		}
		aM = (AV *) SvRV(sv_);
		lM = av_len(aM)+1;
		/* XXX Free previous p */
		(*ptr_).n = lM;
		(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
		/* XXX ALLOC */
		for(iM=0; iM<lM; iM++) {
			bM = av_fetch(aM, iM, 1); /* LVal for easiness */
			if(!bM) {
				die("Help: Multi VRML::Field::SFInt32 bM == 0");
			}
			
			((*ptr_).p[iM]) = SvIV((*bM));

		}
	}
	


void 
alloc_offs_MFInt32(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Int32 *ptr_ = (struct Multi_Int32 *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFInt32(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Int32 *ptr_ = (struct Multi_Int32 *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;



void 
set_offs_SFNode(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	void **ptr_ = (void **)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	(*ptr_) = (void *)SvIV(sv_);


void 
alloc_offs_SFNode(ptr,offs)
	void *ptr
	int offs
CODE:
	void **ptr_ = (void **)(((char *)ptr)+offs);
	(*ptr_) = 0;

void
free_offs_SFNode(ptr,offs)
	void *ptr
	int offs
CODE:
	void **ptr_ = (void **)(((char *)ptr)+offs);
	(*ptr_) = 0;



void 
set_offs_MFNode(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_Node *ptr_ = (struct Multi_Node *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			die("Help! Multi without being ref");
		}
		if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
			die("Help! Multi without being arrayref");
		}
		aM = (AV *) SvRV(sv_);
		lM = av_len(aM)+1;
		/* XXX Free previous p */
		(*ptr_).n = lM;
		(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
		/* XXX ALLOC */
		for(iM=0; iM<lM; iM++) {
			bM = av_fetch(aM, iM, 1); /* LVal for easiness */
			if(!bM) {
				die("Help: Multi VRML::Field::SFNode bM == 0");
			}
			(*ptr_).p[iM] = 0;
			((*ptr_).p[iM]) = (void *)SvIV((*bM));
		}
	}
	


void 
alloc_offs_MFNode(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Node *ptr_ = (struct Multi_Node *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFNode(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Node *ptr_ = (struct Multi_Node *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;



void 
set_offs_SFColor(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct SFColor *ptr_ = (struct SFColor *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *a;
		SV **b;
		int i;
		if(!SvROK(sv_)) {
			die("Help! SFColor without being ref");
		}
		if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
			die("Help! SFColor without being arrayref");
		}
		a = (AV *) SvRV(sv_);
		for(i=0; i<3; i++) {
			b = av_fetch(a, i, 1); /* LVal for easiness */
			if(!b) {
				die("Help: SFColor b == 0");
			}
			(*ptr_).c[i] = SvNV(*b);
		}
	}
	


void 
alloc_offs_SFColor(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFColor *ptr_ = (struct SFColor *)(((char *)ptr)+offs);
	

void
free_offs_SFColor(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFColor *ptr_ = (struct SFColor *)(((char *)ptr)+offs);
	



void 
set_offs_MFColor(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_Color *ptr_ = (struct Multi_Color *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			die("Help! Multi without being ref");
		}
		if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
			die("Help! Multi without being arrayref");
		}
		aM = (AV *) SvRV(sv_);
		lM = av_len(aM)+1;
		/* XXX Free previous p */
		(*ptr_).n = lM;
		(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
		/* XXX ALLOC */
		for(iM=0; iM<lM; iM++) {
			bM = av_fetch(aM, iM, 1); /* LVal for easiness */
			if(!bM) {
				die("Help: Multi VRML::Field::SFColor bM == 0");
			}
			
			{
		AV *a;
		SV **b;
		int i;
		if(!SvROK((*bM))) {
			die("Help! SFColor without being ref");
		}
		if(SvTYPE(SvRV((*bM))) != SVt_PVAV) {
			die("Help! SFColor without being arrayref");
		}
		a = (AV *) SvRV((*bM));
		for(i=0; i<3; i++) {
			b = av_fetch(a, i, 1); /* LVal for easiness */
			if(!b) {
				die("Help: SFColor b == 0");
			}
			((*ptr_).p[iM]).c[i] = SvNV(*b);
		}
	}
	
		}
	}
	


void 
alloc_offs_MFColor(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Color *ptr_ = (struct Multi_Color *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFColor(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Color *ptr_ = (struct Multi_Color *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;



void 
set_offs_SFTime(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	float *ptr_ = (float *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	(*ptr_) = SvNV(sv_);



void 
alloc_offs_SFTime(ptr,offs)
	void *ptr
	int offs
CODE:
	float *ptr_ = (float *)(((char *)ptr)+offs);
	

void
free_offs_SFTime(ptr,offs)
	void *ptr
	int offs
CODE:
	float *ptr_ = (float *)(((char *)ptr)+offs);
	



void 
set_offs_SFString(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	SV **ptr_ = (SV **)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	sv_setsv((*ptr_),sv_);


void 
alloc_offs_SFString(ptr,offs)
	void *ptr
	int offs
CODE:
	SV **ptr_ = (SV **)(((char *)ptr)+offs);
	(*ptr_) = newSVpv("",0);

void
free_offs_SFString(ptr,offs)
	void *ptr
	int offs
CODE:
	SV **ptr_ = (SV **)(((char *)ptr)+offs);
	SvREFCNT_dec((*ptr_));



void 
set_offs_MFString(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_String *ptr_ = (struct Multi_String *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			die("Help! Multi without being ref");
		}
		if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
			die("Help! Multi without being arrayref");
		}
		aM = (AV *) SvRV(sv_);
		lM = av_len(aM)+1;
		/* XXX Free previous p */
		(*ptr_).n = lM;
		(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
		/* XXX ALLOC */
		for(iM=0; iM<lM; iM++) {
			bM = av_fetch(aM, iM, 1); /* LVal for easiness */
			if(!bM) {
				die("Help: Multi VRML::Field::SFString bM == 0");
			}
			(*ptr_).p[iM] = newSVpv("",0);
			sv_setsv(((*ptr_).p[iM]),(*bM));
		}
	}
	


void 
alloc_offs_MFString(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_String *ptr_ = (struct Multi_String *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFString(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_String *ptr_ = (struct Multi_String *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;



void 
set_offs_SFVec2f(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct SFVec2f *ptr_ = (struct SFVec2f *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *a;
		SV **b;
		int i;
		if(!SvROK(sv_)) {
			die("Help! SFVec2f without being ref");
		}
		if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
			die("Help! SFVec2f without being arrayref");
		}
		a = (AV *) SvRV(sv_);
		for(i=0; i<2; i++) {
			b = av_fetch(a, i, 1); /* LVal for easiness */
			if(!b) {
				die("Help: SFColor b == 0");
			}
			(*ptr_).c[i] = SvNV(*b);
		}
	}
	


void 
alloc_offs_SFVec2f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFVec2f *ptr_ = (struct SFVec2f *)(((char *)ptr)+offs);
	

void
free_offs_SFVec2f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFVec2f *ptr_ = (struct SFVec2f *)(((char *)ptr)+offs);
	



void 
set_offs_MFVec2f(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_Vec2f *ptr_ = (struct Multi_Vec2f *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			die("Help! Multi without being ref");
		}
		if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
			die("Help! Multi without being arrayref");
		}
		aM = (AV *) SvRV(sv_);
		lM = av_len(aM)+1;
		/* XXX Free previous p */
		(*ptr_).n = lM;
		(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
		/* XXX ALLOC */
		for(iM=0; iM<lM; iM++) {
			bM = av_fetch(aM, iM, 1); /* LVal for easiness */
			if(!bM) {
				die("Help: Multi VRML::Field::SFVec2f bM == 0");
			}
			
			{
		AV *a;
		SV **b;
		int i;
		if(!SvROK((*bM))) {
			die("Help! SFVec2f without being ref");
		}
		if(SvTYPE(SvRV((*bM))) != SVt_PVAV) {
			die("Help! SFVec2f without being arrayref");
		}
		a = (AV *) SvRV((*bM));
		for(i=0; i<2; i++) {
			b = av_fetch(a, i, 1); /* LVal for easiness */
			if(!b) {
				die("Help: SFColor b == 0");
			}
			((*ptr_).p[iM]).c[i] = SvNV(*b);
		}
	}
	
		}
	}
	


void 
alloc_offs_MFVec2f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Vec2f *ptr_ = (struct Multi_Vec2f *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFVec2f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Vec2f *ptr_ = (struct Multi_Vec2f *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;


void *
get_Background_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(37+1)*sizeof(int));
	SvCUR_set(p,(37+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Background, __y_left);
	*ptr_++ = offsetof(struct VRML_Background, __data_left);
	*ptr_++ = offsetof(struct VRML_Background, __depth_back);
	*ptr_++ = offsetof(struct VRML_Background, backUrl);
	*ptr_++ = offsetof(struct VRML_Background, __depth_top);
	*ptr_++ = offsetof(struct VRML_Background, topUrl);
	*ptr_++ = offsetof(struct VRML_Background, __y_back);
	*ptr_++ = offsetof(struct VRML_Background, __depth_bottom);
	*ptr_++ = offsetof(struct VRML_Background, __data_back);
	*ptr_++ = offsetof(struct VRML_Background, __x_top);
	*ptr_++ = offsetof(struct VRML_Background, bottomUrl);
	*ptr_++ = offsetof(struct VRML_Background, __y_top);
	*ptr_++ = offsetof(struct VRML_Background, __y_bottom);
	*ptr_++ = offsetof(struct VRML_Background, bindTime);
	*ptr_++ = offsetof(struct VRML_Background, __data_bottom);
	*ptr_++ = offsetof(struct VRML_Background, __depth_right);
	*ptr_++ = offsetof(struct VRML_Background, __x_right);
	*ptr_++ = offsetof(struct VRML_Background, isBound);
	*ptr_++ = offsetof(struct VRML_Background, __y_right);
	*ptr_++ = offsetof(struct VRML_Background, groundAngle);
	*ptr_++ = offsetof(struct VRML_Background, skyColor);
	*ptr_++ = offsetof(struct VRML_Background, __data_front);
	*ptr_++ = offsetof(struct VRML_Background, __x_left);
	*ptr_++ = offsetof(struct VRML_Background, __x_back);
	*ptr_++ = offsetof(struct VRML_Background, set_bind);
	*ptr_++ = offsetof(struct VRML_Background, __data_top);
	*ptr_++ = offsetof(struct VRML_Background, __x_bottom);
	*ptr_++ = offsetof(struct VRML_Background, groundColor);
	*ptr_++ = offsetof(struct VRML_Background, rightUrl);
	*ptr_++ = offsetof(struct VRML_Background, __data_right);
	*ptr_++ = offsetof(struct VRML_Background, __depth_front);
	*ptr_++ = offsetof(struct VRML_Background, frontUrl);
	*ptr_++ = offsetof(struct VRML_Background, __depth_left);
	*ptr_++ = offsetof(struct VRML_Background, leftUrl);
	*ptr_++ = offsetof(struct VRML_Background, skyAngle);
	*ptr_++ = offsetof(struct VRML_Background, __x_front);
	*ptr_++ = offsetof(struct VRML_Background, __y_front);
	*ptr_++ = sizeof(struct VRML_Background);
RETVAL=&(virt_Background);
	printf("Background virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Viewpoint_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(8+1)*sizeof(int));
	SvCUR_set(p,(8+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Viewpoint, fieldOfView);
	*ptr_++ = offsetof(struct VRML_Viewpoint, description);
	*ptr_++ = offsetof(struct VRML_Viewpoint, isBound);
	*ptr_++ = offsetof(struct VRML_Viewpoint, position);
	*ptr_++ = offsetof(struct VRML_Viewpoint, set_bind);
	*ptr_++ = offsetof(struct VRML_Viewpoint, bindTime);
	*ptr_++ = offsetof(struct VRML_Viewpoint, jump);
	*ptr_++ = offsetof(struct VRML_Viewpoint, orientation);
	*ptr_++ = sizeof(struct VRML_Viewpoint);
RETVAL=&(virt_Viewpoint);
	printf("Viewpoint virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Cone_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(4+1)*sizeof(int));
	SvCUR_set(p,(4+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Cone, height);
	*ptr_++ = offsetof(struct VRML_Cone, bottomRadius);
	*ptr_++ = offsetof(struct VRML_Cone, side);
	*ptr_++ = offsetof(struct VRML_Cone, bottom);
	*ptr_++ = sizeof(struct VRML_Cone);
RETVAL=&(virt_Cone);
	printf("Cone virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Text_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(5+1)*sizeof(int));
	SvCUR_set(p,(5+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Text, fontStyle);
	*ptr_++ = offsetof(struct VRML_Text, __rendersub);
	*ptr_++ = offsetof(struct VRML_Text, length);
	*ptr_++ = offsetof(struct VRML_Text, maxExtent);
	*ptr_++ = offsetof(struct VRML_Text, string);
	*ptr_++ = sizeof(struct VRML_Text);
RETVAL=&(virt_Text);
	printf("Text virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_DirectionalLight_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(5+1)*sizeof(int));
	SvCUR_set(p,(5+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_DirectionalLight, direction);
	*ptr_++ = offsetof(struct VRML_DirectionalLight, on);
	*ptr_++ = offsetof(struct VRML_DirectionalLight, ambientIntensity);
	*ptr_++ = offsetof(struct VRML_DirectionalLight, color);
	*ptr_++ = offsetof(struct VRML_DirectionalLight, intensity);
	*ptr_++ = sizeof(struct VRML_DirectionalLight);
RETVAL=&(virt_DirectionalLight);
	printf("DirectionalLight virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Sphere_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(1+1)*sizeof(int));
	SvCUR_set(p,(1+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Sphere, radius);
	*ptr_++ = sizeof(struct VRML_Sphere);
RETVAL=&(virt_Sphere);
	printf("Sphere virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Coordinate_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(1+1)*sizeof(int));
	SvCUR_set(p,(1+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Coordinate, point);
	*ptr_++ = sizeof(struct VRML_Coordinate);
RETVAL=&(virt_Coordinate);
	printf("Coordinate virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_FontStyle_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(9+1)*sizeof(int));
	SvCUR_set(p,(9+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_FontStyle, style);
	*ptr_++ = offsetof(struct VRML_FontStyle, family);
	*ptr_++ = offsetof(struct VRML_FontStyle, language);
	*ptr_++ = offsetof(struct VRML_FontStyle, spacing);
	*ptr_++ = offsetof(struct VRML_FontStyle, horizontal);
	*ptr_++ = offsetof(struct VRML_FontStyle, topToBottom);
	*ptr_++ = offsetof(struct VRML_FontStyle, size);
	*ptr_++ = offsetof(struct VRML_FontStyle, leftToRight);
	*ptr_++ = offsetof(struct VRML_FontStyle, justify);
	*ptr_++ = sizeof(struct VRML_FontStyle);
RETVAL=&(virt_FontStyle);
	printf("FontStyle virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Normal_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(1+1)*sizeof(int));
	SvCUR_set(p,(1+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Normal, vector);
	*ptr_++ = sizeof(struct VRML_Normal);
RETVAL=&(virt_Normal);
	printf("Normal virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Box_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(1+1)*sizeof(int));
	SvCUR_set(p,(1+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Box, size);
	*ptr_++ = sizeof(struct VRML_Box);
RETVAL=&(virt_Box);
	printf("Box virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Billboard_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(4+1)*sizeof(int));
	SvCUR_set(p,(4+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Billboard, children);
	*ptr_++ = offsetof(struct VRML_Billboard, axisOfRotation);
	*ptr_++ = offsetof(struct VRML_Billboard, bboxCenter);
	*ptr_++ = offsetof(struct VRML_Billboard, bboxSize);
	*ptr_++ = sizeof(struct VRML_Billboard);
RETVAL=&(virt_Billboard);
	printf("Billboard virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Group_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(3+1)*sizeof(int));
	SvCUR_set(p,(3+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Group, children);
	*ptr_++ = offsetof(struct VRML_Group, bboxCenter);
	*ptr_++ = offsetof(struct VRML_Group, bboxSize);
	*ptr_++ = sizeof(struct VRML_Group);
RETVAL=&(virt_Group);
	printf("Group virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_ElevationGrid_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(9+1)*sizeof(int));
	SvCUR_set(p,(9+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, zDimension);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, normal);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, height);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, creaseAngle);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, solid);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, xSpacing);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, xDimension);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, zSpacing);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, color);
	*ptr_++ = sizeof(struct VRML_ElevationGrid);
RETVAL=&(virt_ElevationGrid);
	printf("ElevationGrid virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Material_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(6+1)*sizeof(int));
	SvCUR_set(p,(6+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Material, transparency);
	*ptr_++ = offsetof(struct VRML_Material, emissiveColor);
	*ptr_++ = offsetof(struct VRML_Material, shininess);
	*ptr_++ = offsetof(struct VRML_Material, diffuseColor);
	*ptr_++ = offsetof(struct VRML_Material, specularColor);
	*ptr_++ = offsetof(struct VRML_Material, ambientIntensity);
	*ptr_++ = sizeof(struct VRML_Material);
RETVAL=&(virt_Material);
	printf("Material virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Appearance_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(2+1)*sizeof(int));
	SvCUR_set(p,(2+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Appearance, texture);
	*ptr_++ = offsetof(struct VRML_Appearance, material);
	*ptr_++ = sizeof(struct VRML_Appearance);
RETVAL=&(virt_Appearance);
	printf("Appearance virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Extrusion_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(10+1)*sizeof(int));
	SvCUR_set(p,(10+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Extrusion, convex);
	*ptr_++ = offsetof(struct VRML_Extrusion, scale);
	*ptr_++ = offsetof(struct VRML_Extrusion, beginCap);
	*ptr_++ = offsetof(struct VRML_Extrusion, creaseAngle);
	*ptr_++ = offsetof(struct VRML_Extrusion, solid);
	*ptr_++ = offsetof(struct VRML_Extrusion, endCap);
	*ptr_++ = offsetof(struct VRML_Extrusion, orientation);
	*ptr_++ = offsetof(struct VRML_Extrusion, ccw);
	*ptr_++ = offsetof(struct VRML_Extrusion, crossSection);
	*ptr_++ = offsetof(struct VRML_Extrusion, spine);
	*ptr_++ = sizeof(struct VRML_Extrusion);
RETVAL=&(virt_Extrusion);
	printf("Extrusion virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Shape_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(2+1)*sizeof(int));
	SvCUR_set(p,(2+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Shape, appearance);
	*ptr_++ = offsetof(struct VRML_Shape, geometry);
	*ptr_++ = sizeof(struct VRML_Shape);
RETVAL=&(virt_Shape);
	printf("Shape virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Switch_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(2+1)*sizeof(int));
	SvCUR_set(p,(2+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Switch, choice);
	*ptr_++ = offsetof(struct VRML_Switch, whichChoice);
	*ptr_++ = sizeof(struct VRML_Switch);
RETVAL=&(virt_Switch);
	printf("Switch virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_ImageTexture_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(7+1)*sizeof(int));
	SvCUR_set(p,(7+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_ImageTexture, __data);
	*ptr_++ = offsetof(struct VRML_ImageTexture, url);
	*ptr_++ = offsetof(struct VRML_ImageTexture, __depth);
	*ptr_++ = offsetof(struct VRML_ImageTexture, repeatS);
	*ptr_++ = offsetof(struct VRML_ImageTexture, repeatT);
	*ptr_++ = offsetof(struct VRML_ImageTexture, __x);
	*ptr_++ = offsetof(struct VRML_ImageTexture, __y);
	*ptr_++ = sizeof(struct VRML_ImageTexture);
RETVAL=&(virt_ImageTexture);
	printf("ImageTexture virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_IndexedLineSet_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(5+1)*sizeof(int));
	SvCUR_set(p,(5+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_IndexedLineSet, colorPerVertex);
	*ptr_++ = offsetof(struct VRML_IndexedLineSet, coord);
	*ptr_++ = offsetof(struct VRML_IndexedLineSet, color);
	*ptr_++ = offsetof(struct VRML_IndexedLineSet, colorIndex);
	*ptr_++ = offsetof(struct VRML_IndexedLineSet, coordIndex);
	*ptr_++ = sizeof(struct VRML_IndexedLineSet);
RETVAL=&(virt_IndexedLineSet);
	printf("IndexedLineSet virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_PointSet_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(2+1)*sizeof(int));
	SvCUR_set(p,(2+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_PointSet, color);
	*ptr_++ = offsetof(struct VRML_PointSet, coord);
	*ptr_++ = sizeof(struct VRML_PointSet);
RETVAL=&(virt_PointSet);
	printf("PointSet virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Cylinder_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(5+1)*sizeof(int));
	SvCUR_set(p,(5+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Cylinder, radius);
	*ptr_++ = offsetof(struct VRML_Cylinder, height);
	*ptr_++ = offsetof(struct VRML_Cylinder, top);
	*ptr_++ = offsetof(struct VRML_Cylinder, side);
	*ptr_++ = offsetof(struct VRML_Cylinder, bottom);
	*ptr_++ = sizeof(struct VRML_Cylinder);
RETVAL=&(virt_Cylinder);
	printf("Cylinder virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Anchor_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(6+1)*sizeof(int));
	SvCUR_set(p,(6+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Anchor, children);
	*ptr_++ = offsetof(struct VRML_Anchor, parameter);
	*ptr_++ = offsetof(struct VRML_Anchor, url);
	*ptr_++ = offsetof(struct VRML_Anchor, description);
	*ptr_++ = offsetof(struct VRML_Anchor, bboxCenter);
	*ptr_++ = offsetof(struct VRML_Anchor, bboxSize);
	*ptr_++ = sizeof(struct VRML_Anchor);
RETVAL=&(virt_Anchor);
	printf("Anchor virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_IndexedFaceSet_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(13+1)*sizeof(int));
	SvCUR_set(p,(13+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, texCoordIndex);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, normalIndex);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, convex);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, colorPerVertex);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, coord);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, colorIndex);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, texCoord);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, normal);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, creaseAngle);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, solid);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, ccw);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, coordIndex);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, color);
	*ptr_++ = sizeof(struct VRML_IndexedFaceSet);
RETVAL=&(virt_IndexedFaceSet);
	printf("IndexedFaceSet virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Transform_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(8+1)*sizeof(int));
	SvCUR_set(p,(8+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Transform, rotation);
	*ptr_++ = offsetof(struct VRML_Transform, center);
	*ptr_++ = offsetof(struct VRML_Transform, scaleOrientation);
	*ptr_++ = offsetof(struct VRML_Transform, bboxSize);
	*ptr_++ = offsetof(struct VRML_Transform, scale);
	*ptr_++ = offsetof(struct VRML_Transform, children);
	*ptr_++ = offsetof(struct VRML_Transform, bboxCenter);
	*ptr_++ = offsetof(struct VRML_Transform, translation);
	*ptr_++ = sizeof(struct VRML_Transform);
RETVAL=&(virt_Transform);
	printf("Transform virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Color_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(1+1)*sizeof(int));
	SvCUR_set(p,(1+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Color, color);
	*ptr_++ = sizeof(struct VRML_Color);
RETVAL=&(virt_Color);
	printf("Color virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_LOD_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(3+1)*sizeof(int));
	SvCUR_set(p,(3+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_LOD, level);
	*ptr_++ = offsetof(struct VRML_LOD, center);
	*ptr_++ = offsetof(struct VRML_LOD, range);
	*ptr_++ = sizeof(struct VRML_LOD);
RETVAL=&(virt_LOD);
	printf("LOD virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL


BOOT:
	I_OPENGL;

